/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.gui.DiskData;
import org.eclipse.aperi.TStorm.gui.DiskTreeNode;
import org.eclipse.aperi.gui.AlertableTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskDDI
extends DataDisplayInfo {
    private int diskID;
    int logicalDiskID = -1;
    private String path;
    private int computerID;
    private DiskData ddPanel;
    protected int tabDisplayed;
    boolean inDiskArray;
    short diskArrayType = (short)-1;
    String enclosure;
    private boolean changesPending = false;
    private byte newAWRE = (byte)-1;
    private byte newARRE = (byte)-1;
    private byte newNER = (byte)-1;

    public DiskDDI(DiskTreeNode diskTreeNode, int n, String string, int n2, String string2, boolean bl, short s) {
        super(MessageLog.getMessageNoID("STG1293T", new Object[]{string, string2}));
        this.treeNode = diskTreeNode;
        this.diskID = n;
        this.computerID = n2;
        this.path = string;
        this.enclosure = string2;
        this.inDiskArray = bl;
        if (this.inDiskArray) {
            this.diskArrayType = s;
        }
        this.tabDisplayed = 0;
        this.reDisplay();
    }

    public DiskDDI(DiskTreeNode diskTreeNode, int n, String string, int n2) {
        this(diskTreeNode, n, string, n2, GuiUtil.getComputer((int)n2).gcTSName, false, -1);
    }

    public void reDisplay() {
        if (this.panel == null) {
            this.tabDisplayed = 0;
            this.ddPanel = new DiskData(this.diskID, this.path, this.computerID, this.newAWRE, this.newARRE, this.newNER, this);
            JPanel jPanel = new JPanel(new BorderLayout());
            if (this.treeNode instanceof AlertableTreeNode) {
                JPopupMenu jPopupMenu = this.treeNode.getPopupMenuForButtons();
                JPanel jPanel2 = this.getButtonPanel(jPopupMenu);
                if (this.getActionButtonCount() > 0) {
                    jPanel.add((Component)jPanel2, "North");
                }
            }
            jPanel.add((Component)this.ddPanel, "Center");
            this.panel = jPanel;
        }
        this.show();
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        if (this.ddPanel != null) {
            return this.ddPanel.applyButton.isEnabled();
        }
        return this.changesPending;
    }

    public void panelToBeNulled() {
        this.newAWRE = this.ddPanel.newAWRE;
        this.newARRE = this.ddPanel.newARRE;
        this.newNER = this.ddPanel.newNER;
        this.changesPending = this.ddPanel.applyButton.isEnabled();
        this.ddPanel = null;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == 0) {
            this.pf = pageFormat;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Component component = this.ddPanel.getComponentAt(this.tabDisplayed);
            Color color = component.getBackground();
            component.setBackground(Color.white);
            this.panel.paint(graphics2D);
            component.setBackground(color);
            return 0;
        }
        return 1;
    }

    public String getHelpID() {
        if (this.inDiskArray) {
            switch (this.tabDisplayed) {
                case 0: {
                    return "reascomp5";
                }
                case 1: {
                    return "reasss15";
                }
                case 2: {
                    return "reascomp10";
                }
                case 3: {
                    return "reascomp15";
                }
                case 4: {
                    return "reasss30";
                }
            }
            return null;
        }
        switch (this.tabDisplayed) {
            case 0: {
                return "reasss10";
            }
            case 1: {
                return "reasss15";
            }
            case 2: {
                return "reasss20";
            }
            case 3: {
                return "reasss25";
            }
            case 4: {
                return "reasss30";
            }
        }
        return null;
    }
}

