/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.scheduler.SchHistoryJobNode;
import org.eclipse.aperi.scheduler.SchHistoryNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectHistoryJobTable
extends JPanel {
    MegaTable jobTable = new MegaTable();
    SchHistoryNameList element;
    BaseTreeNode node;
    SchHistoryJobNode[] jobNodeArray;
    DateFormat df = DateFormat.getDateTimeInstance();
    Date date = new Date();
    String statusText;
    TJCTableMouseInterface selectListener;
    static final String COMPUTER = MessageLog.getMessageNoID("JSS0039L");
    static final String START_TIME = MessageLog.getMessageNoID("JSS0029L");
    static final String FINISH_TIME = MessageLog.getMessageNoID("JSS0031L");
    static final String PROCESS_ID = MessageLog.getMessageNoID("JSS0042L");
    static final String LOG_FILE_NAME = MessageLog.getMessageNoID("JSS0043L");
    static final String DEVICE = MessageLog.getMessageNoID("JSS0083L");
    static final String RUN = MessageLog.getMessageNoID("JSS0028L");
    static final String STATUS = MessageLog.getMessageNoID("JSS0030L");
    static final String NUMBER_JOBS = MessageLog.getMessageNoID("JSS0032L");
    static final String NUMBER_FAILED = MessageLog.getMessageNoID("JSS0033L");
    static final String SUCCESS = MessageLog.getMessageNoID("JSS0034L");
    static final String FAILED = MessageLog.getMessageNoID("JSS0035L");
    static final String RUNNING = MessageLog.getMessageNoID("JSS0036L");
    static final String WARNINGS = MessageLog.getMessageNoID("JSS0037L");
    static final String WAITING = MessageLog.getMessageNoID("JSS0080L");
    static final String SUBMITTED = MessageLog.getMessageNoID("JSS0047L");
    static final String SUCCESSFUL = MessageLog.getMessageNoID("JSS0048L");
    static final String JOB_WARNING = MessageLog.getMessageNoID("JSS0049L");
    static final String JOB_ERROR = MessageLog.getMessageNoID("JSS0050L");
    static final String SYSTEM_ERROR = MessageLog.getMessageNoID("JSS0051L");
    static final String AGENT_DOWN = MessageLog.getMessageNoID("JSS0052L");
    static final String EXCEEDED_LIMIT = MessageLog.getMessageNoID("JSS0053L");
    static final String NEVER_RETURNED = MessageLog.getMessageNoID("JSS0054L");
    static final String AGENT_UPGRADING = MessageLog.getMessageNoID("JSS0067L");
    static final String AGENT_NOT_FOUND = MessageLog.getMessageNoID("JSS0069L");
    static final String AGENT_NOT_LICENSED = MessageLog.getMessageNoID("JSS0068L");
    static final String AGENT_UNREACHABLE = MessageLog.getMessageNoID("JSS0070L");
    static final String HOST_RECYCLED = MessageLog.getMessageNoID("JSS0079L");
    static final String JOB_RUNNING_WARNING = MessageLog.getMessageNoID("JSS0081L");
    static final String JOB_RUNNING_OK = MessageLog.getMessageNoID("JSS0082L");
    static final String[] colNames = new String[]{COMPUTER, STATUS, START_TIME, FINISH_TIME, LOG_FILE_NAME};
    static final String[] perfMonitorColNames = new String[]{DEVICE, STATUS, START_TIME, FINISH_TIME, LOG_FILE_NAME};
    static final int COMPUTER_COL = 0;
    static final int STATUS_COL = 1;
    static final int START_TIME_COL = 2;
    static final int FINISH_TIME_COL = 3;
    static final int LOG_FILE_NAME_COL = 4;

    public EditableObjectHistoryJobTable(NameList nameList, SchHistoryJobNode[] schHistoryJobNodeArray) {
        this.element = (SchHistoryNameList)nameList;
        this.jobNodeArray = schHistoryJobNodeArray;
        this.buildPanel();
    }

    public void buildPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRunPanel(), "North");
        int n = this.jobNodeArray == null ? 0 : this.jobNodeArray.length;
        if (n == 0) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(MessageLog.getMessageNoID("JSS0045L")));
            this.add((Component)jPanel, "Center");
        } else {
            int n2 = 0;
            while (n2 < n) {
                SchHistoryJobNode schHistoryJobNode = this.jobNodeArray[n2];
                if (schHistoryJobNode.computerID == -999999999 || schHistoryJobNode.computerID == -999999998 || schHistoryJobNode.computerID == -999999997) {
                    schHistoryJobNode.computer = GuiClient.serverStatusResp.serverName;
                } else if (schHistoryJobNode.computerID <= 0) {
                    schHistoryJobNode.computer = MessageLog.getMessageNoID("STG0019T");
                } else if (schHistoryJobNode.deviceRunNumber < 1) {
                    schHistoryJobNode.computer = GuiUtil.getComputer((int)schHistoryJobNode.computerID).gcTSName;
                }
                ++n2;
            }
            this.selectListener = new SelectListener();
            this.jobTable.setFrozenColumns(1);
            this.jobTable.setMouseListener(this.selectListener);
            this.jobTable.iconChanger = (AskForRowIconInterface)((Object)this.selectListener);
            this.jobTable.setCellRenderer(Integer.class, TableCellRenderers.number);
            this.jobTable.setCellRenderer(Date.class, TableCellRenderers.date);
            this.jobTable.setRowIcon(10, true);
            this.jobTable.setBaseTableModel(new JobTableModel());
            this.add((Component)this.jobTable, "Center");
        }
    }

    public static String runStateToStatusText(NameList nameList) {
        String string;
        switch (nameList.nlState) {
            case 1: {
                string = SUCCESS;
                break;
            }
            case 2: {
                string = RUNNING;
                break;
            }
            case 3: {
                string = WARNINGS;
                break;
            }
            default: {
                string = FAILED;
            }
        }
        return string;
    }

    private JPanel getRunPanel() {
        JLabel jLabel;
        JLabel jLabel2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        Insets insets = new Insets(0, 20, 10, 15);
        Insets insets2 = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = insets2;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.insets = insets2;
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.insets = insets2;
        JLabel jLabel3 = new JLabel(" ");
        JLabel jLabel4 = new JLabel(" ");
        JLabel jLabel5 = new JLabel(" ");
        JLabel jLabel6 = new JLabel(" ");
        JLabel jLabel7 = new JLabel(" ");
        JLabel jLabel8 = new JLabel(" ");
        JPanel jPanel = GuiUtil.getPanel();
        JLabel jLabel9 = new JLabel(RUN);
        jLabel9.setFont(BaseTree.boldFont);
        JLabel jLabel10 = new JLabel(Integer.toString(this.element.nlID2));
        JLabel jLabel11 = new JLabel(STATUS);
        jLabel11.setFont(BaseTree.boldFont);
        this.statusText = EditableObjectHistoryJobTable.runStateToStatusText(this.element);
        JLabel jLabel12 = new JLabel(this.statusText);
        JLabel jLabel13 = new JLabel(START_TIME);
        jLabel13.setFont(BaseTree.boldFont);
        if (this.element.startTime < 1L) {
            jLabel2 = new JLabel("-");
        } else {
            this.date.setTime(this.element.startTime);
            jLabel2 = new JLabel(this.df.format(this.date));
        }
        JLabel jLabel14 = new JLabel(FINISH_TIME);
        jLabel14.setFont(BaseTree.boldFont);
        if (this.element.finishTime < 1L) {
            jLabel = new JLabel("-");
        } else {
            this.date.setTime(this.element.finishTime);
            jLabel = new JLabel(this.df.format(this.date));
        }
        JLabel jLabel15 = new JLabel(NUMBER_JOBS);
        jLabel15.setFont(BaseTree.boldFont);
        JLabel jLabel16 = new JLabel(Integer.toString(this.element.numberJobs));
        JLabel jLabel17 = new JLabel(NUMBER_FAILED);
        jLabel17.setFont(BaseTree.boldFont);
        int n = this.element.successfulJobs < 0 ? 0 : this.element.numberJobs - this.element.successfulJobs;
        JLabel jLabel18 = new JLabel(Integer.toString(n));
        jPanel.add((Component)jLabel9, gridBagConstraints);
        jPanel.add((Component)jLabel10, gridBagConstraints2);
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        jPanel.add((Component)jLabel11, gridBagConstraints);
        jPanel.add((Component)jLabel12, gridBagConstraints2);
        jPanel.add((Component)jLabel4, gridBagConstraints4);
        jPanel.add((Component)jLabel13, gridBagConstraints);
        jPanel.add((Component)jLabel2, gridBagConstraints3);
        jPanel.add((Component)jLabel5, gridBagConstraints4);
        jPanel.add((Component)jLabel14, gridBagConstraints);
        jPanel.add((Component)jLabel, gridBagConstraints3);
        jPanel.add((Component)jLabel6, gridBagConstraints4);
        jPanel.add((Component)jLabel15, gridBagConstraints);
        jPanel.add((Component)jLabel16, gridBagConstraints2);
        jPanel.add((Component)jLabel7, gridBagConstraints2);
        jPanel.add((Component)jLabel17, gridBagConstraints);
        jPanel.add((Component)jLabel18, gridBagConstraints2);
        jPanel.add((Component)jLabel8, gridBagConstraints4);
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    public class JobTableModel
    extends BaseTableModel {
        JobTableModel() {
            this.columnNames = colNames;
            this.rowCount = EditableObjectHistoryJobTable.this.jobNodeArray.length;
        }

        public Object getTableDataItem(int n, int n2) {
            switch (n2) {
                case 0: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[n].computer;
                }
                case 1: {
                    switch (EditableObjectHistoryJobTable.this.jobNodeArray[n].returnCode) {
                        case -2: {
                            return WAITING;
                        }
                        case -1: {
                            return SUBMITTED;
                        }
                        case 0: {
                            return SUCCESSFUL;
                        }
                        case 4: {
                            return JOB_WARNING;
                        }
                        case 8: {
                            return JOB_ERROR;
                        }
                        case 12: {
                            return SYSTEM_ERROR;
                        }
                        case 16: {
                            return AGENT_DOWN;
                        }
                        case 28: {
                            return AGENT_UPGRADING;
                        }
                        case 32: {
                            return AGENT_NOT_LICENSED;
                        }
                        case 34: {
                            return AGENT_NOT_FOUND;
                        }
                        case 36: {
                            return AGENT_UNREACHABLE;
                        }
                        case 20: {
                            return EXCEEDED_LIMIT;
                        }
                        case 24: {
                            return NEVER_RETURNED;
                        }
                        case 40: {
                            return HOST_RECYCLED;
                        }
                    }
                }
                case 2: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[n].startTimeString;
                }
                case 3: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[n].finishTimeString;
                }
                case 4: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[n].logFileName;
                }
            }
            return null;
        }
    }

    private class SelectListener
    extends TJCTableMouseAdapter
    implements AskForRowIconInterface {
        private SelectListener() {
        }

        public boolean select(int n, int n2) {
            return true;
        }

        public void doubleClick(int n, int n2) {
            if (this.haveLogFile(n)) {
                new LogViewer(EditableObjectHistoryJobTable.this.jobNodeArray[n].computerID, EditableObjectHistoryJobTable.this.node, EditableObjectHistoryJobTable.this.jobNodeArray[n].logFileName, 0, EditableObjectHistoryJobTable.this.jobNodeArray[n].deviceRunNumber);
            }
        }

        public boolean changeIcon(int n) {
            return !this.haveLogFile(n);
        }

        private boolean haveLogFile(int n) {
            return EditableObjectHistoryJobTable.this.jobNodeArray[n].logFileName != null && EditableObjectHistoryJobTable.this.jobNodeArray[n].logFileName.charAt(0) != ' ';
        }
    }
}

