/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.HistoryHelper;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiDelete;
import org.eclipse.aperi.gui.GuiRename;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.JobChangeListener;
import org.eclipse.aperi.gui.JobChangeManager;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectNode
extends BaseTreeNode
implements ActionListener,
GuiRequestor,
PopupMenuListener,
JobChangeListener {
    public NameList element;
    public JPopupMenu menu;
    private EditableObjectLabel folder;
    private boolean hasKids;
    private HistoryHelper historyHelper;
    private static final String EDIT = "E";
    private static final String DELETE = "D";
    private static final String RENAME = "R";
    protected static final String HISTORY = "H";
    private static final String REFRESH = "F";
    private static final String UPDATE = "U";
    private static final String EXECUTE = "X";
    private int adminType = 5;

    public EditableObjectNode(NameList nameList, EditableObjectLabel editableObjectLabel, boolean bl) {
        this(nameList, editableObjectLabel, bl, 1);
    }

    public EditableObjectNode(NameList nameList, EditableObjectLabel editableObjectLabel, boolean bl, int n) {
        this.adminType = n;
        this.element = nameList;
        this.folder = editableObjectLabel;
        this.hasKids = bl;
        super.setUserObject(this.element);
        this.setAllowsChildren(bl);
        this.historyHelper = new HistoryHelper(this, this.describeObject(), this.element.nlID);
        if (GuiUtil.isJobDefintionNode(this.folder.objectType)) {
            JobChangeManager.addListener(this, this.folder.objectType);
        }
    }

    public void setUserObject(Object object) {
        if (object instanceof NameList) {
            this.element = (NameList)object;
            this.element.nlName = Util.getTranslatedName(this.element.nlName);
            this.historyHelper.description = this.describeObject();
        }
        super.setUserObject(object);
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        defaultTreeCellRenderer.setIcon(NameListTreeCellRenderer.iconForObject(this.element));
        defaultTreeCellRenderer.setFont(BaseTree.plainFont);
    }

    public String describeObject() {
        Object[] objectArray = new Object[]{this.folder.objectLabel, this.element.nlName};
        return MessageLog.getMessageNoID("GUI0049L", objectArray);
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        CreateOrEditDDI.showEditor(this.folder.editorClass, this.element.nlName, this.element.nlID, this.folder.objectType, this.folder.resourceType, this.folder.qualifier, this);
    }

    protected void addMenuItem(JPopupMenu jPopupMenu, String string, String string2, boolean bl, String string3) {
        String string4 = string3 == null ? Util.getString(string) : Util.getString(string3);
        JMenuItem jMenuItem = new JMenuItem(string4);
        jMenuItem.setName(string4);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(bl);
        jPopupMenu.add(jMenuItem);
    }

    public JPopupMenu getPopupMenuForButtons() {
        return this.getPopupMenu();
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(this);
        boolean bl = false;
        switch (this.adminType) {
            case 4: {
                bl = this.capabilities.isAnyAdmin();
                break;
            }
            case 1: {
                bl = this.capabilities.isDataAdmin();
                break;
            }
            case 2: {
                bl = this.capabilities.isDiskAdmin();
                break;
            }
            case 3: {
                bl = this.capabilities.isFabricAdmin();
                break;
            }
            case 5: {
                bl = this.capabilities.isAperiAdmin();
                break;
            }
            case 6: {
                bl = this.capabilities.isTapeAdmin();
            }
        }
        this.addMenuItem(this.menu, "GUI0106L", DELETE, this.element.nlID > 299 && bl, null);
        this.addMenuItem(this.menu, "GUI0047L", RENAME, this.element.nlID > 299 && bl, null);
        if (this.hasKids) {
            this.addMenuItem(this.menu, "", REFRESH, true, "REFRESH_JOB_LIST");
            this.addMenuItem(this.menu, "GUI0165L", UPDATE, true, "UPDATE_JOB_STATUS");
            this.addMenuItem(this.menu, "GUI0052L", HISTORY, true, null);
            this.addMenuItem(this.menu, "JSS1002L", EXECUTE, bl, null);
        }
        return this.menu;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.menu = this.getPopupMenu();
        this.showPopupMenu(this.menu, mouseEvent);
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0 || GuiUtil.isJobDefintionNode(this.folder.objectType) && (treeExpansionEvent != null || BaseTree.pBaseTree.isExpanded(new TreePath(this.getPath())))) {
            this.historyHelper.sendRequest();
        }
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.element.nlName;
            Object[] objectArray2 = objectArray;
            JSgcScheduleCreateWhenData.displayJobSubmittedMessage(objectArray2);
            this.expand(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == EDIT) {
            this.select(null);
        } else if (string == DELETE) {
            String string2;
            String string3 = (String)this.folder.getUserObject();
            if (string3.equals(string2 = Util.getString("NAG0033L"))) {
                String string4 = MessageLog.getMessageNoID("NAS0022E");
                JOptionPane.showMessageDialog(guiMain.getFrame(), string4, "NAS0022E", 0);
                return;
            }
            if (!GuiUtil.confirmDelete(BaseTree.pBaseTree, this.describeObject())) {
                return;
            }
            if (this.ddi != null) {
                this.ddi.remove();
            }
            GuiDelete guiDelete = new GuiDelete();
            guiDelete.delete(this.element);
        } else if (string == RENAME) {
            GuiRename guiRename = new GuiRename(this.element, this.describeObject());
            guiRename.rename();
        } else if (string == REFRESH) {
            this.historyHelper.sendRequest();
        } else if (string == UPDATE) {
            this.historyHelper.sendUpdateRequest();
        } else if (string == HISTORY) {
            this.historyHelper.makeRunDDI();
        } else if (string == EXECUTE) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
            request.requestData = this.element;
            GuiClient.doRequest(this, request);
        }
        guiMain.getBaseTree().requestFocus();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void jobChangeOccurred(int n, NameList nameList) {
        if (this.element.compareTo(nameList) == 0) {
            this.expand(null);
        }
    }
}

