/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.ExportsAdjuster;
import org.eclipse.aperi.TStorm.gui.ExportsDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class ExportsTable
extends JPanel
implements GuiRequestor {
    private MegaTable eTable = new MegaTable();
    private Export[] exports;
    private GuiReportReq grr;
    private ExportsAdjuster adjuster;

    public ExportsTable(GuiReportReq guiReportReq) {
        this.grr = guiReportReq;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new ExportsAdjuster(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        this.setLayout(new BorderLayout());
        this.exports = s <= 4 ? (Export[])response.responseData : null;
        int n = this.exports != null ? this.exports.length : 0;
        if (n == 0) {
            this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            return;
        }
        this.adjuster.adjust(this.exports, false);
        this.eTable.setMouseListener(new selectListener());
        this.eTable.setRowIcon(10, true);
        this.eTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.eTable.setBaseTableModel(new ExportsTableModel());
        this.add((Component)this.eTable, "Center");
    }

    private class ExportsTableModel
    extends BaseTableModel {
        ExportsTableModel() {
            this.rowCount = ExportsTable.this.exports.length;
            this.columnNames = ((ExportsTable)ExportsTable.this).adjuster.columnNameList;
            this.commonAdjuster = ExportsTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return ExportsTable.this.adjuster.getCellData(n, ExportsTable.this.adjuster.translateColumn(n2));
        }
    }

    public class selectListener
    extends TJCTableMouseAdapter {
        public boolean select(int n, int n2) {
            return true;
        }

        public void doubleClick(int n, int n2) {
            new ExportsDDI(null, ExportsTable.this.exports[n]);
        }
    }
}

