/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IPScanElementEditor;
import org.eclipse.aperi.xmsg.MessageLog;

class IPScanListEditor
extends EditableList
implements DocumentListener {
    private JComponent panel;
    private NameList ips;
    private String desc;
    private static IPScanElementEditor ipEditor = new IPScanElementEditor();
    private static String invalidFormatTitle = MessageLog.getMessageNoID("GUI8214T");
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public IPScanListEditor(NameList nameList, String string) {
        super(" ", ipEditor, null, 5);
        this.ips = nameList;
        this.desc = string;
        Document document = ipEditor.getIpDocumentOne();
        Document document2 = ipEditor.getIpDocumentTwo();
        Document document3 = ipEditor.getIpDocumentThree();
        if (document != null) {
            document.addDocumentListener(this);
        }
        if (document2 != null) {
            document2.addDocumentListener(this);
        }
        if (document3 != null) {
            document3.addDocumentListener(this);
        }
    }

    public JComponent getComponent() {
        while (this.ips != null) {
            this.addObject(this.ips.nlName);
            this.ips = this.ips.nlNext;
        }
        if (ipEditor != null && ipEditor.allIpFieldsFull()) {
            this.setAddEnabled(true);
        }
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.desc);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.panel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.panel.add(Box.createHorizontalStrut(100), gridBagConstraints);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)this, gridBagConstraints);
        return this.panel;
    }

    public void addObject(Object object) {
        String string = object.toString().trim();
        int n = this.listModel.size();
        boolean bl = true;
        while (bl && n > 0) {
            String string2;
            if (!(string2 = this.listModel.get(--n).toString()).equals(string)) continue;
            bl = false;
        }
        if (bl) {
            super.addObject(string);
        }
    }

    private static NameList makeNameList(Object object) {
        NameList nameList = new NameList();
        nameList.nlName = object.toString();
        return nameList;
    }

    public NameList getData() {
        NameList nameList = null;
        Object[] objectArray = this.getElements();
        if (objectArray != null && objectArray.length > 0) {
            NameList nameList2 = nameList = IPScanListEditor.makeNameList(objectArray[0]);
            int n = 1;
            while (n < objectArray.length) {
                NameList nameList3;
                nameList2.nlNext = nameList3 = IPScanListEditor.makeNameList(objectArray[n]);
                nameList2 = nameList3;
                ++n;
            }
        }
        return nameList;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (ipEditor != null && ipEditor.allIpFieldsFull()) {
            this.setAddEnabled(true);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (ipEditor != null && ipEditor.allIpFieldsFull()) {
            this.setAddEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (ipEditor != null && ipEditor.allIpFieldsEmpty()) {
            this.setAddEnabled(false);
        }
    }

    protected void actionAdd() {
        String string = String.valueOf(ipEditor.getObject());
        if (this.simpleNumericIPValidator(string)) {
            this.addObject(string);
            ipEditor.emptyAllIpFields();
        }
    }

    private boolean simpleNumericIPValidator(String string) {
        String string2 = "^[\\d]+\\.[\\d]+\\.[\\d]+\\.[\\d]";
        if (!string.matches(string2)) {
            String string3 = MessageLog.getMessageNoID("GUI8215E", string);
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), string3, invalidFormatTitle, 0);
            return false;
        }
        return true;
    }
}

