/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.LogicalVolumeAdjuster;
import org.eclipse.aperi.TStorm.common.LogicalVolumeGrapher;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeTable
extends JPanel
implements ActionListener,
AskForRowIconInterface,
DisplaysChartPopupInterface,
GuiRequestor,
HistoryChoiceInterface,
TJCTableMouseInterface {
    private MegaTable lvTable = new MegaTable();
    private Share[] shArray;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private LogicalVolumeAdjuster adjuster;
    private LogicalVolumeGrapher grapher;

    public LogicalVolumeTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new LogicalVolumeAdjuster(guiReportReq);
        this.grapher = new LogicalVolumeGrapher();
    }

    public void handleResponse(short s, Response response) {
        this.setLayout(new BorderLayout());
        this.shArray = s <= 4 ? (Share[])response.responseData : null;
        int n = this.shArray != null ? this.shArray.length : 0;
        if (n == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.shArray, false);
        this.shArray = (Share[])this.adjuster.getArray();
        this.lvTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.lvTable.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.lvTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.lvTable.setRowIcon(this.grr.reportSubtype == 21 ? 10 : 11, true);
        this.lvTable.setMouseListener(this);
        if (this.adjuster.frozenRows > 0) {
            this.lvTable.setFrozenRows(this.adjuster.frozenRows);
        }
        this.lvTable.setBaseTableModel(new LogicalDiskTableModel());
        this.lvTable.setAsFirstColumn(this.adjuster.getFirstColumn());
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.lvTable, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public boolean changeIcon(int n) {
        return this.shArray[n].shFilesystem.fsID < 0;
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this;
    }

    public void showJumpChart() {
        int[] nArray = new int[this.shArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.lvTable.getDataRow(n);
            ++n;
        }
        int[] nArray2 = this.getGraphID("STG1276T");
        this.grr.chartSubtype = (byte)nArray2[0];
        this.grapher.createChart(this.grr, this.shArray, nArray, this.adjuster, this.ddi, null);
    }

    public boolean select(int n, int n2) {
        return this.shArray[this.lvTable.getDataRow((int)n)].shFilesystem.fsID > 0;
    }

    public void doubleClick(int n, int n2) {
        if (!this.adjuster.hasTotalsRow() || n != 0) {
            String string = this.shArray[n].shFilesystem.fsMountPoint != " " ? this.shArray[n].shFilesystem.fsMountPoint : this.shArray[n].shPath;
            NameList nameList = new NameList();
            nameList.nlID = this.shArray[n].shComputerID;
            nameList.nlName = GuiUtil.getComputer((int)nameList.nlID).gcTSName;
            nameList.nlInfo = 1;
            new LogicalVolumeDDI(null, this.shArray[n].shLogicalDisk.ldID, this.shArray[n].shFilesystem.fsID, nameList, string);
        }
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (this.grr.reportSubtype != 21) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            boolean bl = this.lvTable.rowsSelected();
            boolean bl2 = this.shArray != null && this.shArray.length > 0;
            JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG1251T"));
            jMenuItem.setActionCommand("STG1251T");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG1276T"));
            jMenuItem.setEnabled(bl2);
            jMenuItem.setActionCommand("STG1276T");
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5105L"));
            jMenuItem.setActionCommand("STG5105L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5106L"));
            jMenuItem.setActionCommand("STG5106L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5107L"));
            jMenuItem.setActionCommand("STG5107L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5108L"));
            jMenuItem.setActionCommand("STG5108L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }
    }

    public void selectionChanged(boolean bl) {
    }

    public void showDefaultChart(int n) {
        int[] nArray = new int[]{n};
        int[] nArray2 = this.getGraphID("STG1251T");
        this.grr.chartSubtype = (byte)nArray2[0];
        this.grapher.createChart(this.grr, this.shArray, nArray, this.adjuster, this.ddi, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray;
        String string = actionEvent.getActionCommand();
        if (string == "STG1276T") {
            nArray = new int[this.shArray.length];
            int n = 0;
            while (n < this.shArray.length) {
                nArray[n] = this.lvTable.getDataRow(n);
                ++n;
            }
        } else {
            nArray = this.lvTable.getSelectedRows();
        }
        if (nArray != null && nArray.length > 0) {
            if (string == "STG1251T" || string == "STG1276T") {
                int[] nArray2 = this.getGraphID(string);
                this.grr.chartSubtype = (byte)nArray2[0];
                this.grapher.createChart(this.grr, this.shArray, nArray, this.adjuster, this.ddi, null);
            } else {
                GuiReportReq guiReportReq = this.grapher.createHistory(this.grr, this.shArray, nArray, string);
                this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", guiReportReq, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(guiReportReq.historyTitle), this);
            }
        }
    }

    public LogicalVolumeTable(String string, String string2, String string3, String string4) {
    }

    public Object[] getChoices(int n, int n2) {
        Object[] objectArray = null;
        if (n2 != 21) {
            objectArray = new Object[3];
            String[] stringArray = new String[]{"STG7530L", "STG7531L", "STG7537L", "STG7538L"};
            byte[] byArray = new byte[]{1, 8, 1, 8};
            byte[] byArray2 = new byte[]{1, 2, 3, 4};
            objectArray[0] = stringArray;
            objectArray[1] = byArray;
            objectArray[2] = byArray2;
        }
        return objectArray;
    }

    public Object[] getCharts(int n, int n2) {
        Object[] objectArray = null;
        if (n2 != 21) {
            objectArray = new Object[2];
            String[] stringArray = new String[]{"STG7528L"};
            byte[] byArray = new byte[]{101};
            objectArray[0] = stringArray;
            objectArray[1] = byArray;
        }
        return objectArray;
    }

    public int[] getGraphID(String string) {
        int[] nArray = new int[2];
        nArray[0] = string == "STG1251T" ? 101 : (string == "STG1276T" ? 102 : (string == "STG5105L" ? 1 : (string == "STG5106L" ? 2 : (string == "STG5107L" ? 3 : 4))));
        return nArray;
    }

    private class LogicalDiskTableModel
    extends BaseTableModel {
        LogicalDiskTableModel() {
            this.columnNames = ((LogicalVolumeTable)LogicalVolumeTable.this).adjuster.colNames;
            this.rowCount = LogicalVolumeTable.this.shArray.length;
            this.commonAdjuster = LogicalVolumeTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return LogicalVolumeTable.this.adjuster.getCellData(n, LogicalVolumeTable.this.adjuster.translateColumn(n2));
        }
    }
}

