/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.Report;
import org.eclipse.aperi.TStorm.gui.JobAlertEditor;
import org.eclipse.aperi.TStorm.gui.ReportOptions;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.gui.ReportSelector;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor {
    public CreateOrEditDDI ddi;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    private ReportSelector reportEditor;
    private ReportingSelectionDriver selectionEditor;
    private ReportOptions optionsEditor;
    private JSgcScheduleCreateWhenData scheduleEditor;
    private JobAlertEditor alertEditor;
    public Report report;
    private Object[] objectName = new Object[1];
    private GeneralException exception;
    private int prevReportType = 0;
    private int prevReportSubtype = 0;
    private byte prevDbmsType;
    private int boxReportType = 0;
    private int boxReportSubtype = 0;
    static final int REPORT_TAB = 0;
    static final int SELECTION_TAB = 1;
    static final int OPTIONS_TAB = 2;
    static final int SCHEDULE_TAB = 3;
    static final int ALERT_TAB = 4;
    static final String REPORT_TAB_TITLE = MessageLog.getMessageNoID("STG4153L");
    static final String SELECTION_TAB_TITLE = MessageLog.getMessageNoID("STG5049L");
    static final String OPTIONS_TAB_TITLE = MessageLog.getMessageNoID("STG3175L");
    static final String ALERT_TAB_TITLE = MessageLog.getMessageNoID("STG4036L");
    static final String NO_REPORT_LABEL = MessageLog.getMessageNoID("STG5156L");
    static final String NO_SELECTION_LABEL = MessageLog.getMessageNoID("STG5170L");
    private short devType;

    public ReportCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.ddi = createOrEditDDI;
        createOrEditDDI.showEnabled = true;
        createOrEditDDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        createOrEditDDI.subType = "org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr";
    }

    public void build(int n) {
        if (n > 0) {
            this.submitRetrieve(n);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.report = (Report)createHeader;
        this.create();
    }

    public CreateHeader getData() {
        this.exception = null;
        this.createHeaderPanel.getData();
        if (this.reportEditor.getData() && this.report.batchReport.grr.reportType > 0) {
            if (this.selectionEditor == null || this.report.batchReport.grr.reportType != this.prevReportType || this.report.batchReport.grr.reportSubtype != this.prevReportSubtype || this.report.batchReport.grr.dbmsType != this.prevDbmsType) {
                this.setPrefs(this.report.batchReport.grr);
            } else {
                try {
                    this.selectionEditor.getData();
                }
                catch (GeneralException generalException) {
                    this.exception = generalException;
                }
            }
        }
        this.optionsEditor.getData();
        this.scheduleEditor.getData();
        this.report.alert = this.alertEditor.getData();
        this.report.batchReport.spaceUnits = Variables.spaceUnits;
        return this.report;
    }

    private void setPrefs(GuiReportReq guiReportReq) {
        ReportPrefs reportPrefs = ReportPrefsManager.getOne(guiReportReq.reportType);
        guiReportReq.profile = reportPrefs.rpProfileID;
        switch (guiReportReq.reportSubtype) {
            case 8: {
                guiReportReq.rowsToReturn = reportPrefs.rpDirMaxRows;
                break;
            }
            case 9: {
                guiReportReq.rowsToReturn = reportPrefs.rpDirGrpMaxRows;
                break;
            }
            case 10: {
                guiReportReq.rowsToReturn = reportPrefs.rpFSMaxRows;
                break;
            }
            case 11: {
                guiReportReq.rowsToReturn = reportPrefs.rpFSGrpMaxRows;
                break;
            }
            case 12: {
                guiReportReq.rowsToReturn = reportPrefs.rpComputerMaxRows;
                break;
            }
            case 13: 
            case 82: {
                guiReportReq.rowsToReturn = reportPrefs.rpCompGrpMaxRows;
                break;
            }
            case 14: {
                guiReportReq.rowsToReturn = reportPrefs.rpDomMaxRows;
                break;
            }
            case 15: {
                guiReportReq.rowsToReturn = reportPrefs.rpNetMaxRows;
                break;
            }
            case 16: {
                guiReportReq.rowsToReturn = reportPrefs.rpQuotaMaxRows;
            }
        }
        this.clearGrrSelectionData(guiReportReq);
    }

    public void clearGrrSelectionData(GuiReportReq guiReportReq) {
        guiReportReq.selectedResources = null;
        guiReportReq.selectedUsers = null;
        guiReportReq.selectedColumns = null;
        guiReportReq.columnFilters = null;
        guiReportReq.filtersIgnoreCase = false;
        guiReportReq.orFilters = false;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        Report report = (Report)createHeader;
        if (report.batchReport.grr.reportType == 0) {
            this.ddi.exceptionTabIndex = 0;
            throw new GeneralException(MessageLog.getMessageNoTS("STG5156L"));
        }
        if (this.exception != null) {
            this.ddi.exceptionTabIndex = 1;
            throw this.exception;
        }
        this.ddi.exceptionTabIndex = 2;
        if (report.batchReport.grr.reportType != this.boxReportType || report.batchReport.grr.reportSubtype != this.boxReportSubtype) {
            this.optionsEditor.validateData(true);
            report.batchReport.saveChartSettingsReq = null;
        } else {
            this.optionsEditor.validateData(false);
        }
        this.ddi.exceptionTabIndex = 3;
        this.scheduleEditor.validate(report);
        this.ddi.exceptionTabIndex = 4;
        this.alertEditor.validateData();
    }

    private void submitRetrieve(int n) {
        Report report = new Report(this.ddi.nlInfo);
        report.ID = n;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr", report);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        this.report = new Report(this.ddi.nlInfo);
        this.report.batchReport = new BatchReport();
        this.report.batchReport.grr = new GuiReportReq();
        this.create();
    }

    public void setOldCreateHeader() {
        this.ddi.oldCreateHeader = (Report)this.report.clone();
    }

    private void create() {
        Object object;
        JPanel jPanel;
        this.createHeaderPanel = new CreateHeaderPanel(this.report, this, this.ddi);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        this.reportEditor = new ReportSelector(this.report.batchReport.grr, this.ddi.nlInfo);
        JPanel jPanel2 = this.reportEditor.build();
        this.tabs.addTab(REPORT_TAB_TITLE, jPanel2);
        if (this.reportEditor.getData() && this.report.batchReport.grr.reportType > 0) {
            this.setObjectType();
            this.selectionEditor = new ReportingSelectionDriver(null, this.report.batchReport.grr, ReportingTreeLabel.selectionServiceArray[this.report.batchReport.grr.reportType], this.objectName);
            this.tabs.addTab(SELECTION_TAB_TITLE, this.selectionEditor);
            this.prevReportType = this.report.batchReport.grr.reportType;
            this.prevReportSubtype = this.report.batchReport.grr.reportSubtype;
            this.prevDbmsType = this.report.batchReport.grr.dbmsType;
        } else {
            this.selectionEditor = null;
            jPanel = new JPanel(new BorderLayout());
            object = this.report.batchReport.grr.reportType > 0 ? new JLabel(NO_SELECTION_LABEL) : new JLabel(NO_REPORT_LABEL);
            jPanel.add((Component)object, "Center");
            this.tabs.addTab(SELECTION_TAB_TITLE, jPanel);
            this.prevReportType = 0;
            this.prevReportSubtype = 0;
            this.prevDbmsType = 0;
        }
        this.optionsEditor = new ReportOptions(this.report, this);
        this.tabs.addTab(OPTIONS_TAB_TITLE, this.optionsEditor);
        this.boxReportType = 0;
        this.boxReportSubtype = 0;
        if (this.report.batchReport.grr.reportType == 0) {
            this.optionsEditor.disableHistory();
        } else {
            this.setHistoryBox(true);
        }
        this.scheduleEditor = new JSgcScheduleCreateWhenData(this.ddi.nlInfo, this.ddi);
        jPanel = this.scheduleEditor.build(this.report);
        object = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab((String)object, jPanel);
        short s = 10;
        this.alertEditor = this.report.alert == null ? new JobAlertEditor(s) : new JobAlertEditor(s, this.report.alert);
        this.tabs.addTab(ALERT_TAB_TITLE, this.alertEditor.getComponent());
        this.tabs.setSelectedIndex(this.ddi.tabIndex);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        this.ddi.panel = this.createHeaderPanel;
        this.ddi.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader createHeader) {
        Report report = (Report)createHeader;
        report.batchReport.grr = this.report.batchReport.grr;
        this.report = report;
        this.createHeaderPanel.replace(this.report);
        this.optionsEditor.replace(this.report);
        this.scheduleEditor.replace(this.report);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
        this.tabs.setSelectedIndex(n);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            Serializable serializable = response.responseData;
            if (serializable instanceof GuiChartSettingsReq) {
                return;
            }
            this.report = (Report)response.responseData;
            this.ddi.oldCreateHeader = (Report)this.report.clone();
            this.create();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.ddi.tabIndex = this.tabs.getSelectedIndex();
        if (this.ddi.tabIndex == 1) {
            boolean bl = this.reportEditor.getData();
            if (this.report.batchReport.grr.reportType != this.prevReportType || this.report.batchReport.grr.reportSubtype != this.prevReportSubtype || this.report.batchReport.grr.dbmsType != this.prevDbmsType) {
                this.tabs.removeTabAt(1);
                this.report.batchReport.grr.profile = 0;
                this.report.batchReport.grr.rowsToReturn = 0;
                this.clearGrrSelectionData(this.report.batchReport.grr);
                if (bl && this.report.batchReport.grr.reportType > 0) {
                    this.setObjectType();
                    this.selectionEditor = new ReportingSelectionDriver(null, this.report.batchReport.grr, ReportingTreeLabel.selectionServiceArray[this.report.batchReport.grr.reportType], this.objectName);
                    this.tabs.insertTab(SELECTION_TAB_TITLE, null, this.selectionEditor, null, 1);
                    this.prevReportType = this.report.batchReport.grr.reportType;
                    this.prevReportSubtype = this.report.batchReport.grr.reportSubtype;
                    this.prevDbmsType = this.report.batchReport.grr.dbmsType;
                } else {
                    this.selectionEditor = null;
                    JPanel jPanel = new JPanel(new BorderLayout());
                    JLabel jLabel = this.report.batchReport.grr.reportType > 0 ? new JLabel(NO_SELECTION_LABEL) : new JLabel(NO_REPORT_LABEL);
                    jPanel.add((Component)jLabel, "Center");
                    this.tabs.insertTab(SELECTION_TAB_TITLE, null, jPanel, null, 1);
                    this.prevReportType = 0;
                    this.prevReportSubtype = 0;
                    this.prevDbmsType = 0;
                }
            }
        } else if (this.ddi.tabIndex == 2) {
            this.report.batchReport.grr.histSubtype = 0;
            this.setHistoryBox(false);
        }
    }

    private void setHistoryBox(boolean bl) {
        this.reportEditor.getData();
        GuiReportReq guiReportReq = this.report.batchReport.grr;
        if (guiReportReq.reportType != this.boxReportType || guiReportReq.reportSubtype != this.boxReportSubtype) {
            this.report.batchReport.saveChartSettingsReq = null;
            this.boxReportType = guiReportReq.reportType;
            this.boxReportSubtype = guiReportReq.reportSubtype;
            if (this.boxReportType == 0) {
                this.optionsEditor.disableHistory();
            } else {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(GuiReportReq.guiClasses[this.boxReportType][0]);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    exception.printStackTrace();
                    return;
                }
                boolean bl2 = false;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    String string = classArray[n].getName();
                    if (string.equals("org.eclipse.aperi.gui.HistoryChoiceInterface")) {
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl2) {
                    this.optionsEditor.disableHistory();
                } else {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3;
                    HistoryChoiceInterface historyChoiceInterface = null;
                    try {
                        objectArray3 = new Class[]{String.class, String.class, String.class, String.class};
                        objectArray2 = clazz.getConstructor((Class<?>[])objectArray3);
                        objectArray = new Object[]{"x", "x", "x", "x"};
                        historyChoiceInterface = (HistoryChoiceInterface)objectArray2.newInstance(objectArray);
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                        exception.printStackTrace();
                        return;
                    }
                    objectArray3 = historyChoiceInterface.getChoices(this.boxReportType, this.boxReportSubtype);
                    objectArray2 = historyChoiceInterface.getCharts(this.boxReportType, this.boxReportSubtype);
                    if (objectArray3 == null && objectArray2 == null) {
                        this.optionsEditor.disableHistory();
                    } else {
                        int n2;
                        objectArray = null;
                        byte[] byArray = null;
                        byte[] byArray2 = null;
                        String[] stringArray = null;
                        byte[] byArray3 = null;
                        String[] stringArray2 = null;
                        byte[] byArray4 = null;
                        if (objectArray3 != null) {
                            objectArray = (String[])objectArray3[0];
                            byArray = (byte[])objectArray3[1];
                            byArray2 = (byte[])objectArray3[2];
                            if (objectArray3.length > 3) {
                                stringArray = (String[])objectArray3[3];
                                byArray3 = (byte[])objectArray3[4];
                            }
                            n2 = 0;
                            while (n2 < objectArray.length) {
                                objectArray[n2] = ReportCreateOrEdit.adjustHistoryName((String)objectArray[n2]);
                                ++n2;
                            }
                            if (stringArray != null) {
                                n2 = 0;
                                while (n2 < stringArray.length) {
                                    stringArray[n2] = MessageLog.getMessageNoID(stringArray[n2]);
                                    ++n2;
                                }
                            }
                        }
                        if (objectArray2 != null) {
                            stringArray2 = (String[])objectArray2[0];
                            byArray4 = (byte[])objectArray2[1];
                            n2 = 0;
                            while (n2 < stringArray2.length) {
                                stringArray2[n2] = ReportCreateOrEdit.adjustHistoryName(stringArray2[n2]);
                                ++n2;
                            }
                        }
                        this.optionsEditor.replaceHistoryArrays((String[])objectArray, byArray, byArray2, stringArray, byArray3, bl, stringArray2, byArray4);
                    }
                }
            }
        }
    }

    public static String adjustHistoryName(String string) {
        String string2 = string;
        if (string.length() == 8) {
            string2 = MessageLog.getMessageNoID(string);
        }
        return string2;
    }

    private void setObjectType() {
        switch (this.report.batchReport.grr.reportSubtype) {
            case 8: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3143L");
                break;
            }
            case 9: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3116T");
                break;
            }
            case 10: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3135T");
                break;
            }
            case 11: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3124T");
                break;
            }
            case 12: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 13: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3125T");
                break;
            }
            case 14: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1104L");
                break;
            }
            case 15: {
                this.objectName[0] = MessageLog.getMessageNoID("STG2038L");
                break;
            }
            case 27: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                break;
            }
            case 16: {
                this.objectName[0] = MessageLog.getMessageNoID("STG0022T");
                break;
            }
            case 6: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3122T");
                break;
            }
            case 74: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4201L");
                break;
            }
            case 75: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4202L");
                break;
            }
            case 76: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                break;
            }
            case 73: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4203L");
                break;
            }
            default: {
                this.objectName[0] = MessageLog.getMessageNoID("STG5057L");
            }
        }
    }

    public String getHelpID(int n) {
        switch (n) {
            case 0: {
                return "mr20";
            }
            case 1: {
                return "mr25";
            }
            case 2: {
                return "mr30";
            }
            case 3: {
                return "mr35";
            }
            case 4: {
                return "mr40";
            }
        }
        return null;
    }

    public boolean isChartCustPending() {
        return this.report.batchReport.saveChartSettingsReq != null;
    }

    public void saveChartCust(int n) {
        ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).batchId = n;
        Request request = this.report.batchReport.saveChartSettingsReq;
        this.report.batchReport.saveChartSettingsReq = null;
        AperiChartCustomizationManager aperiChartCustomizationManager = AperiChartCustomizationManager.getManager();
        if (aperiChartCustomizationManager != null) {
            aperiChartCustomizationManager.saveChartCustomization(request);
        }
    }
}

