/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.gui.SettingsDDI;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class ResourceSettingsEditor
implements ChangeListener {
    protected SettingsDDI ddi;
    protected JCheckBox[] checkBoxes;
    protected JTextField[] fields;
    protected JLabel[] leadingLabels;
    protected JLabel[] trailingLabels;
    protected short[] values;

    protected abstract void fillSettingsFromValues(Settings var1);

    protected abstract void fillValuesFromSettings(Settings var1);

    protected void pullValuesFromPanel() {
        int n = 0;
        while (n < this.values.length) {
            int n2;
            if (!this.checkBoxes[n].isSelected()) {
                n2 = 0;
            } else {
                String string = this.fields[n].getText();
                if (string == null || string.trim().equals("")) {
                    n2 = -1;
                } else {
                    try {
                        n2 = Short.parseShort(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = -2;
                    }
                }
            }
            this.values[n] = n2;
            ++n;
        }
    }

    protected void pushValuesOntoPanel() {
        int n = 0;
        while (n < this.values.length) {
            short s = this.values[n];
            JCheckBox jCheckBox = this.checkBoxes[n];
            if (s == 0) {
                jCheckBox.setSelected(false);
            } else {
                jCheckBox.setSelected(true);
                String string = s < 0 ? "" : Short.toString(s);
                this.fields[n].setText(string);
            }
            ++n;
        }
    }

    protected void pushSettingsOntoPanel(Settings settings) {
        this.fillValuesFromSettings(settings);
        this.pushValuesOntoPanel();
    }

    public void getData(Settings settings) {
        this.pullValuesFromPanel();
        this.fillSettingsFromValues(settings);
    }

    public void selectField(boolean bl) {
        this.fields[this.ddi.badField].requestFocus();
    }

    public void validate(Settings settings) throws GeneralException {
        int n = 0;
        while (n < this.values.length) {
            if (this.values[n] == -1) {
                this.ddi.badField = n;
                String string = MessageLog.getMessageNoTS("STG3128E", null);
                throw new GeneralException(string);
            }
            if (this.values[n] == -2) {
                this.ddi.badField = n;
                String string = MessageLog.getMessageNoTS("STG7740E", null);
                throw new GeneralException(string);
            }
            ++n;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JCheckBox jCheckBox = (JCheckBox)changeEvent.getSource();
        int n = 0;
        while (n < this.checkBoxes.length && this.checkBoxes[n] != jCheckBox) {
            ++n;
        }
        boolean bl = jCheckBox.isSelected();
        this.leadingLabels[n].setEnabled(bl);
        this.fields[n].setEnabled(bl);
    }
}

