/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.File;
import java.io.Serializable;
import org.eclipse.aperi.backend.LogFileReader;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class DaemonLogFileReader
extends LogFileReader {
    private String logFileDirectory;

    public DaemonLogFileReader(String string) {
        this.logFileDirectory = string;
    }

    private String extend(String string, LogFilePos logFilePos) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "extend", "prefix, position");
        }
        String string2 = String.valueOf(string) + CurtailedWriter.extension.format(logFilePos.fileSeqNo);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "extend", string2);
        }
        return string2;
    }

    private String generateName(String string, LogFilePos logFilePos) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "generateName", "prefix, position");
        }
        String string2 = String.valueOf(this.logFileDirectory) + File.separatorChar + this.extend(string, logFilePos);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "generateName", string2);
        }
        return string2;
    }

    private String generateHeader(String string, LogFilePos logFilePos) {
        String string2;
        int n;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "generateHeader", "prefix, position");
        }
        if ((n = 77 - (string2 = this.extend(string, logFilePos)).length()) < 2) {
            String string3 = String.valueOf(string2) + '\n';
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "generateHeader", string3);
            }
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        int n2 = n >> 1;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append('-');
            ++n3;
        }
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        n2 = n - n2;
        n3 = 0;
        while (n3 < n2) {
            stringBuffer.append('-');
            ++n3;
        }
        stringBuffer.append('\n');
        String string4 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "generateHeader", string4);
        }
        return string4;
    }

    protected MutableInteger open(ReadLogRequest readLogRequest, Response response) {
        Object object;
        Object object2;
        Serializable serializable;
        int n;
        int n2;
        LogFilePos logFilePos;
        block27: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(DaemonLogFileReader.class.getName(), "open", "requestData, response");
            }
            byte by = readLogRequest.direction;
            logFilePos = readLogRequest.position;
            if (logFilePos.offset < 0L && by == 1) {
                logFilePos.offset = 0L;
            }
            String string = String.valueOf(readLogRequest.name) + "_";
            n2 = logFilePos.fileSeqNo;
            if (n2 < 0) {
                n = string.length();
                serializable = new File(this.logFileDirectory);
                object2 = ((File)serializable).list();
                int n3 = Integer.MIN_VALUE;
                int n4 = Integer.MAX_VALUE;
                if (object2 != null) {
                    int n5 = 0;
                    while (n5 < ((String[])object2).length) {
                        block26: {
                            object = object2[n5];
                            if (((String)object).startsWith(string) && ((String)object).endsWith(".log")) {
                                int n6;
                                object = ((String)object).substring(n, ((String)object).length() - 4);
                                try {
                                    n6 = Integer.parseInt((String)object);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (TraceLogger.enableTrace) {
                                        TraceLogger.exception(DaemonLogFileReader.class.getName(), "open", numberFormatException);
                                    }
                                    break block26;
                                }
                                if (n6 >= 0) {
                                    if (n6 < n4) {
                                        n4 = n6;
                                    }
                                    if (n6 > n3) {
                                        n3 = n6;
                                    }
                                }
                            }
                        }
                        ++n5;
                    }
                }
                if (n3 == Integer.MIN_VALUE) {
                    Object[] objectArray = new Object[]{readLogRequest.name};
                    response.errorMessage = MessageLog.getMessage("GEN0049E", objectArray);
                    MutableInteger mutableInteger = null;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit(DaemonLogFileReader.class.getName(), "open", mutableInteger);
                    }
                    return mutableInteger;
                }
                logFilePos.fileSeqNo = by == 1 ? n4 : n3;
            }
            object = this.generateName(string, logFilePos);
            n = -1;
            serializable = null;
            try {
                n = this.openFile((String)object, (int)logFilePos.offset);
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(DaemonLogFileReader.class.getName(), "open", localizableException);
                }
                serializable = localizableException;
            }
            if (n < 0 && n2 < 0 && by == 1) {
                ++logFilePos.fileSeqNo;
                object2 = this.generateName(string, logFilePos);
                try {
                    n = this.openFile((String)object2, (int)logFilePos.offset);
                }
                catch (LocalizableException localizableException) {
                    if (!TraceLogger.enableTrace) break block27;
                    TraceLogger.exception(DaemonLogFileReader.class.getName(), "open", localizableException);
                }
            }
        }
        if (n < 0) {
            if (n2 < 0) {
                object2 = ((LocalizableException)serializable).getParameters();
                object2[((Object[])object2).length - 1] = object;
                response.errorMessage = ((LocalizableException)serializable).getMessage();
            } else {
                response.status = 0;
                object2 = new ReadLogResponse();
                object2.status = (byte)2;
                response.responseData = object2;
            }
            object2 = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "open", object2);
            }
            return object2;
        }
        if (logFilePos.offset < 0L) {
            logFilePos.offset = this.getFilePosition(n);
        }
        object2 = new MutableInteger(n);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "open", object2);
        }
        return object2;
    }

    protected int read(MutableInteger mutableInteger, LogFilePos logFilePos, ReadLogRequest readLogRequest, ReadLogResponse readLogResponse, Response response) {
        int n;
        int n2;
        boolean bl;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "read", "handle, pos, requestData, rd, response");
        }
        String[] stringArray = readLogResponse.lineArray;
        int n3 = 0;
        byte by = readLogRequest.direction;
        String string = readLogRequest.name;
        String string2 = String.valueOf(string) + '_';
        do {
            int n4;
            LogFilePos logFilePos2;
            block12: {
                bl = false;
                if (logFilePos.offset == 0L && by == 1) {
                    stringArray[n3] = this.generateHeader(string2, logFilePos);
                    if (++n3 >= stringArray.length) {
                        readLogResponse.lineArray = new String[n3 + 1];
                        System.arraycopy(stringArray, 0, readLogResponse.lineArray, 0, n3);
                        stringArray = readLogResponse.lineArray;
                    }
                }
                readLogRequest.name = this.generateName(string2, logFilePos);
                n2 = mutableInteger.value;
                n = this.basicRead(n2, logFilePos, readLogRequest, stringArray, n3, response);
                readLogRequest.name = string;
                if (n < 0) continue;
                n3 += n;
                if (logFilePos.offset == 0L && by == -1 && n > 0) {
                    if (n3 >= stringArray.length) {
                        readLogResponse.lineArray = new String[n3 + 1];
                        System.arraycopy(stringArray, 0, readLogResponse.lineArray, 1, n3);
                        stringArray = readLogResponse.lineArray;
                    }
                    stringArray[stringArray.length - ++n3] = this.generateHeader(string2, logFilePos);
                }
                if (n3 >= stringArray.length) continue;
                logFilePos2 = new LogFilePos();
                logFilePos2.fileSeqNo = logFilePos.fileSeqNo + by;
                logFilePos2.offset = by - 1 >> 1;
                n4 = -1;
                String string3 = this.generateName(string2, logFilePos2);
                try {
                    n4 = this.openFile(string3, (int)logFilePos2.offset);
                }
                catch (LocalizableException localizableException) {
                    if (!TraceLogger.enableTrace) break block12;
                    TraceLogger.exception(DaemonLogFileReader.class.getName(), "read", localizableException);
                }
            }
            if (n4 < 0) continue;
            this.closeFile(n2);
            mutableInteger.value = n4;
            if (logFilePos2.offset < 0L) {
                logFilePos2.offset = this.getFilePosition(n4);
            }
            logFilePos2.copy(logFilePos);
            bl = true;
        } while (bl);
        if (n >= 0) {
            n2 = n3;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "read", n2);
            }
            return n2;
        }
        n2 = n;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "read", n2);
        }
        return n2;
    }

    protected boolean setPosition(MutableInteger mutableInteger, ReadLogRequest readLogRequest, LogFilePos logFilePos) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DaemonLogFileReader.class.getName(), "setPosition", "handle, rq, newPos");
        }
        if (logFilePos.fileSeqNo == readLogRequest.position.fileSeqNo) {
            this.setFilePosition(mutableInteger.value, (int)logFilePos.offset);
            boolean bl2 = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(DaemonLogFileReader.class.getName(), "setPosition", bl2);
            }
            return bl2;
        }
        this.closeFile(mutableInteger.value);
        String string = this.generateName(String.valueOf(readLogRequest.name) + '_', logFilePos);
        mutableInteger.value = -1;
        try {
            mutableInteger.value = this.openFile(string, (int)logFilePos.offset);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(DaemonLogFileReader.class.getName(), "setPosition", localizableException);
            }
            Object[] objectArray = localizableException.getParameters();
            objectArray[objectArray.length - 1] = string;
            localizableException.print();
        }
        boolean bl3 = bl = mutableInteger.value != -1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DaemonLogFileReader.class.getName(), "setPosition", bl);
        }
        return bl;
    }
}

