/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.xmsg.MessageLog;

public class TableCellStrings {
    private static final int SEC_PER_DAY = 86400;
    private static final int SEC_PER_HR = 3600;
    private static final String DAY = MessageLog.getMessageNoID("STG4061L");
    private static final String HRS = MessageLog.getMessageNoID("STG4062L");
    private static final String MIN = MessageLog.getMessageNoID("STG4063L");
    private static final String SEC = MessageLog.getMessageNoID("STG4087L");
    private static final String KB = MessageLog.getMessageNoID("GEN0188T");
    private static final String MB = MessageLog.getMessageNoID("GEN0189T");
    private static final String GB = MessageLog.getMessageNoID("GEN0190T");
    private static final String TB = MessageLog.getMessageNoID("GEN0191T");
    private static final String NA = MessageLog.getMessageNoID("STG0019T");
    private static final DecimalFormat d0Fmt = new DecimalFormat();
    private static final DecimalFormat d2Fmt = new DecimalFormat("###,###,###,##0.00");
    public static final int DATE_RENDERER = 1;
    public static final int DECIMAL_RENDERER = 2;
    public static final int DURATION_RENDERER = 3;
    public static final int MEGABYTE_RENDERER = 4;
    public static final int NUMBER_RENDERER = 5;
    public static final int PERCENT_RENDERER = 6;
    public static final int SPACE_RENDERER = 7;
    public static final int SPACEINT_RENDERER = 8;
    public static final int HERTZ_RENDERER = 9;
    public static final int METRIC_RENDERER = 10;

    public static String DecimalRenderer(int n, String string, Object object, StringBuffer stringBuffer) {
        String string2;
        Number number = (Number)object;
        if (number == null) {
            string2 = "";
        } else if (number.intValue() < 0) {
            string2 = NA;
        } else {
            stringBuffer.setLength(0);
            stringBuffer.append(number.intValue() / n);
            stringBuffer.append('.');
            stringBuffer.append(number.intValue() % n);
            double d = Double.parseDouble(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.setLength(0);
            stringBuffer.append(d0Fmt.format(d));
            if (string != null) {
                stringBuffer.append(string);
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String DateRenderer(Object object, DateFormat dateFormat) {
        String string = object instanceof Date ? (object == null || ((Date)object).compareTo(Constants.NULL_DATE_DATE) < 1 ? "" : dateFormat.format((Date)object)) : object.toString();
        return string;
    }

    public static String NumberRenderer(int n) {
        String string = n == -2 ? "" : (n < 0 ? NA : d0Fmt.format(n));
        return string;
    }

    public static String NumberRenderer(Object object, DecimalFormat decimalFormat) {
        String string = object == null || ((Number)object).longValue() == -2L ? "" : (((Number)object).longValue() < 0L ? NA : decimalFormat.format((Number)object));
        return string;
    }

    public static String NumberRenderer2(Object object, DecimalFormat decimalFormat) {
        String string = object == null || ((Number)object).longValue() < 0L ? "" : decimalFormat.format((Number)object);
        return string;
    }

    public static String MegabyteRenderer(Object object, DecimalFormat decimalFormat) {
        String string = object == null || ((Number)object).longValue() == -2L ? "" : (((Number)object).longValue() < 0L ? NA : String.valueOf(decimalFormat.format((Number)object)) + " " + MB);
        return string;
    }

    public static String SpaceRenderer(Object object) {
        long l;
        String string = "";
        if (object != null && (l = ((Number)object).longValue()) != -2L && l != -1024L) {
            string = l < 0L ? NA : (Variables.spaceUnits == 0 ? Util.formatBytes(((Number)object).longValue(), true) : (Variables.spaceUnits == 1 ? String.valueOf(d2Fmt.format((double)l / 1024.0)) + " " + KB : (Variables.spaceUnits == 2 ? String.valueOf(d2Fmt.format((double)l / 1048576.0)) + " " + MB : (Variables.spaceUnits == 3 ? String.valueOf(d2Fmt.format((double)l / 1.073741824E9)) + " " + GB : String.valueOf(d2Fmt.format((double)(l /= 0x100000L) / 1048576.0)) + " " + TB))));
        }
        return string;
    }

    public static String SpaceNoDecimalRenderer(Object object) {
        String string = object == null || ((Number)object).longValue() == -2L || ((Number)object).longValue() == -1024L ? "" : (((Number)object).longValue() < 0L ? NA : Util.formatBytes(((Number)object).longValue(), false));
        return string;
    }

    public static String PercentRenderer(Object object, DecimalFormat decimalFormat) {
        String string;
        if (object == null || ((Number)object).longValue() == -2L) {
            string = "";
        } else if (((Number)object).longValue() < 0L) {
            string = NA;
        } else {
            double d = ((Number)object).doubleValue() / 100.0;
            string = DecimalFormat.getPercentInstance().format(d);
        }
        return string;
    }

    public static String DurationRenderer(Object object, StringBuffer stringBuffer) {
        String string;
        if (object == null || ((Number)object).longValue() == -2L) {
            string = "";
        } else if (((Number)object).intValue() == -1) {
            string = NA;
        } else {
            int n = ((Number)object).intValue();
            string = TableCellStrings.formatDuration(n, stringBuffer);
        }
        return string;
    }

    public static String formatDuration(int n, StringBuffer stringBuffer) {
        int n2 = n / 86400;
        int n3 = (n %= 86400) / 3600;
        int n4 = (n %= 3600) / 60;
        int n5 = n % 60;
        stringBuffer.setLength(0);
        boolean bl = TableCellStrings.appendValue(n2, DAY, false, stringBuffer);
        bl = TableCellStrings.appendValue(n3, HRS, bl, stringBuffer);
        TableCellStrings.appendValue(n4, MIN, bl, stringBuffer);
        TableCellStrings.appendValue(n5, SEC, true, stringBuffer);
        return stringBuffer.toString();
    }

    private static boolean appendValue(int n, String string, boolean bl, StringBuffer stringBuffer) {
        if (n > 0 || bl) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(' ');
            stringBuffer.append(n);
            bl = true;
        }
        return bl;
    }

    public static String NumberWithSuffixRenderer(Object object, DecimalFormat decimalFormat, String string) {
        String string2;
        if (object == null || ((Number)object).longValue() == -2L) {
            string2 = "";
        } else if (((Number)object).longValue() < 0L) {
            string2 = NA;
        } else {
            string2 = decimalFormat.format((Number)object);
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
        }
        return string2;
    }
}

