/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.ClientSettingData;
import org.eclipse.aperi.infrastructure.database.objects.Model;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Vendor;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResModelTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorTable;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

public class ExternalKeyManager {
    private static String cClassName = "ExternalKeyManager";

    public static StoragePool getStoragePool(String string, int n, DBConnection dBConnection) throws IDParseException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getStoragePool", new Object[]{string, String.valueOf(n), dBConnection});
        TResStoragePoolTable tResStoragePoolTable = null;
        StoragePool.StoragePoolCursor storagePoolCursor = null;
        try {
            try {
                String[] stringArray = ExternalKeyConverter.obtainStoragePoolKeyParts(string, logTraceHelper);
                if (stringArray != null) {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(StoragePool.getColumnInfo("INSTANCE_ID"), stringArray[0]);
                    hashtable.put(StoragePool.getColumnInfo("SUBSYSTEM_ID"), "" + n);
                    hashtable.put(StoragePool.getColumnInfo("PRIMORDIAL"), "0");
                    storagePoolCursor = StoragePool.getCursor(dBConnection, hashtable, null);
                    if (!storagePoolCursor.next()) {
                        storagePoolCursor.close();
                        throw new EntityNotFoundException(null, string);
                    }
                    tResStoragePoolTable = storagePoolCursor.getObject();
                    storagePoolCursor.close();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError(sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(tResStoragePoolTable == null ? null : new Integer(tResStoragePoolTable.getPoolId()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(tResStoragePoolTable == null ? null : new Integer(tResStoragePoolTable.getPoolId()));
        ExternalKeyManager.commit(dBConnection);
        return tResStoragePoolTable;
    }

    public static StorageExtent getStorageExtent(String string, int n, DBConnection dBConnection) throws IDParseException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getStorageExtent", new Object[]{string, String.valueOf(n), dBConnection});
        TResStorageExtentTable tResStorageExtentTable = null;
        try {
            try {
                String[] stringArray = ExternalKeyConverter.obtainStorageExtentKeyParts(string, logTraceHelper);
                if (stringArray != null) {
                    tResStorageExtentTable = new StorageExtent();
                    tResStorageExtentTable.setDeviceId(stringArray[0]);
                    tResStorageExtentTable.setSubsystemId(n);
                    boolean bl = ((StorageExtent)tResStorageExtentTable).retrieve(dBConnection);
                    if (!bl) {
                        throw new EntityNotFoundException(null, string);
                    }
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError(sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(tResStorageExtentTable == null ? null : new Integer(tResStorageExtentTable.getStorageExtentId()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(tResStorageExtentTable == null ? null : new Integer(tResStorageExtentTable.getStorageExtentId()));
        ExternalKeyManager.commit(dBConnection);
        return tResStorageExtentTable;
    }

    public static StorageVolume getStorageVolume(String string, int n, DBConnection dBConnection) throws IDParseException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getStorageVolume", new Object[]{string, String.valueOf(n), dBConnection});
        TResStorageVolumeTable tResStorageVolumeTable = null;
        try {
            try {
                String[] stringArray = ExternalKeyConverter.obtainStorageVolumeKeyParts(string, logTraceHelper);
                if (stringArray != null) {
                    tResStorageVolumeTable = new StorageVolume();
                    tResStorageVolumeTable.setName(stringArray[0]);
                    tResStorageVolumeTable.setNameFormat(Short.parseShort(stringArray[1]));
                    tResStorageVolumeTable.setSubsystemId(n);
                    boolean bl = ((StorageVolume)tResStorageVolumeTable).retrieve(dBConnection);
                    if (!bl) {
                        throw new EntityNotFoundException(null, string);
                    }
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError(sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(tResStorageVolumeTable == null ? null : new Integer(tResStorageVolumeTable.getSvid()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(tResStorageVolumeTable == null ? null : new Integer(tResStorageVolumeTable.getSvid()));
        ExternalKeyManager.commit(dBConnection);
        return tResStorageVolumeTable;
    }

    public static StorageSubsystem getStorageSubsystem(String string, DBConnection dBConnection) throws IDParseException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getStorageSubsystem", new Object[]{string, dBConnection});
        TResStorageSubsystemTable tResStorageSubsystemTable = null;
        try {
            try {
                String[] stringArray = ExternalKeyConverter.obtainStorageSubsystemKeyParts(string, logTraceHelper);
                if (stringArray != null) {
                    tResStorageSubsystemTable = new StorageSubsystem();
                    tResStorageSubsystemTable.setName(stringArray[0]);
                    tResStorageSubsystemTable.setNameFormat(Short.parseShort(stringArray[1]));
                    boolean bl = ((StorageSubsystem)tResStorageSubsystemTable).retrieve(dBConnection);
                    if (!bl) {
                        throw new EntityNotFoundException(null, string);
                    }
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError(sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(tResStorageSubsystemTable == null ? null : new Integer(tResStorageSubsystemTable.getSubsystemId()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(tResStorageSubsystemTable == null ? null : new Integer(tResStorageSubsystemTable.getSubsystemId()));
        ExternalKeyManager.commit(dBConnection);
        return tResStorageSubsystemTable;
    }

    public static Port getPort(String string, int n, DBConnection dBConnection) throws EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getPort", new Object[]{string, dBConnection});
        TResPortTable tResPortTable = null;
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(Port.class, "NAME", logTraceHelper);
                hashtable.put(columnInfo, string);
                Port.PortCursor portCursor = Port.getCursor(dBConnection, hashtable, null);
                if (!portCursor.next()) {
                    portCursor.close();
                    throw new EntityNotFoundException(null, string);
                }
                tResPortTable = portCursor.getObject();
                portCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResPortTable == null ? null : new Integer(tResPortTable.getPortId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResPortTable == null ? null : new Integer(tResPortTable.getPortId()));
        return tResPortTable;
    }

    public static Port getPort(String string, DBConnection dBConnection) throws EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getPort", new Object[]{string, dBConnection});
        TResPortTable tResPortTable = null;
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(Port.class, "PORT_ID", logTraceHelper);
                hashtable.put(columnInfo, string);
                Port.PortCursor portCursor = Port.getCursor(dBConnection, hashtable, null);
                if (!portCursor.next()) {
                    portCursor.close();
                    throw new EntityNotFoundException(null, string);
                }
                tResPortTable = portCursor.getObject();
                portCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResPortTable == null ? null : new Integer(tResPortTable.getPortId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResPortTable == null ? null : new Integer(tResPortTable.getPortId()));
        return tResPortTable;
    }

    public static Vendor getVendor(String string, DBConnection dBConnection) throws EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getVendor", new Object[]{string, dBConnection});
        TResVendorTable tResVendorTable = null;
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(Vendor.class, "VENDOR_ID", logTraceHelper);
                hashtable.put(columnInfo, string);
                Vendor.VendorCursor vendorCursor = Vendor.getCursor(dBConnection, hashtable, null);
                if (!vendorCursor.next()) {
                    vendorCursor.close();
                    throw new EntityNotFoundException(null, string);
                }
                tResVendorTable = vendorCursor.getObject();
                vendorCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResVendorTable == null ? null : new Integer(tResVendorTable.getVendorId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResVendorTable == null ? null : new Integer(tResVendorTable.getVendorId()));
        return tResVendorTable;
    }

    public static Model getModel(String string, DBConnection dBConnection) throws EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getModel", new Object[]{string, dBConnection});
        TResModelTable tResModelTable = null;
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(Model.class, "MODEL_ID", logTraceHelper);
                hashtable.put(columnInfo, string);
                Model.ModelCursor modelCursor = Model.getCursor(dBConnection, hashtable, null);
                if (!modelCursor.next()) {
                    modelCursor.close();
                    throw new EntityNotFoundException(null, string);
                }
                tResModelTable = modelCursor.getObject();
                modelCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResModelTable == null ? null : new Integer(tResModelTable.getModelId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResModelTable == null ? null : new Integer(tResModelTable.getModelId()));
        return tResModelTable;
    }

    public static Node getNode(String string, DBConnection dBConnection) throws EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getNode", new Object[]{string, dBConnection});
        TResNodeTable tResNodeTable = null;
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(Node.class, "NODE_ID", logTraceHelper);
                hashtable.put(columnInfo, string);
                Node.NodeCursor nodeCursor = Node.getCursor(dBConnection, hashtable, null);
                if (!nodeCursor.next()) {
                    nodeCursor.close();
                    throw new EntityNotFoundException(null, string);
                }
                tResNodeTable = nodeCursor.getObject();
                nodeCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResNodeTable == null ? null : new Integer(tResNodeTable.getNodeId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResNodeTable == null ? null : new Integer(tResNodeTable.getNodeId()));
        return tResNodeTable;
    }

    public static RegisteredCimom getCIMOM(String string, DBConnection dBConnection) throws EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getCIMOM", new Object[]{string, dBConnection});
        RegisteredCimom registeredCimom = new RegisteredCimom();
        try {
            try {
                registeredCimom.setServiceUrl(string);
                if (!registeredCimom.retrieve(dBConnection)) {
                    throw new EntityNotFoundException(null, string);
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError(sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(registeredCimom == null ? null : new Integer(registeredCimom.getRegCimomId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(registeredCimom == null ? null : new Integer(registeredCimom.getRegCimomId()));
        return registeredCimom;
    }

    public static Cimom2namespace[] getCimom2namespace(int n, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getCimom2namespace", new Object[]{new Integer(n), dBConnection});
        TResCimom2namespaceTable tResCimom2namespaceTable = null;
        ArrayList<Cimom2namespace> arrayList = new ArrayList<Cimom2namespace>();
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(Cimom2namespace.class, "CIMOM_ID", logTraceHelper);
                hashtable.put(columnInfo, String.valueOf(n));
                Cimom2namespace.Cimom2namespaceCursor cimom2namespaceCursor = Cimom2namespace.getCursor(dBConnection, hashtable, null);
                if (cimom2namespaceCursor.next()) {
                    arrayList.add(cimom2namespaceCursor.getObject());
                } else {
                    cimom2namespaceCursor.close();
                }
                while (cimom2namespaceCursor.next()) {
                    arrayList.add(cimom2namespaceCursor.getObject());
                }
                cimom2namespaceCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResCimom2namespaceTable == null ? null : new Integer(tResCimom2namespaceTable.getCimNamespaceId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResCimom2namespaceTable == null ? null : new Integer(tResCimom2namespaceTable.getCimNamespaceId()));
        return arrayList.toArray(new Cimom2namespace[0]);
    }

    public static ArrayList getCimKeySubsystem(int n, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getCimKeySubsystem", new Object[]{new Integer(n), dBConnection});
        TResCimkeySubsystemTable tResCimkeySubsystemTable = null;
        ArrayList<CimkeySubsystem> arrayList = new ArrayList<CimkeySubsystem>();
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(CimkeySubsystem.class, "CIM_NAMESPACE_ID", logTraceHelper);
                hashtable.put(columnInfo, String.valueOf(n));
                CimkeySubsystem.CimkeySubsystemCursor cimkeySubsystemCursor = CimkeySubsystem.getCursor(dBConnection, hashtable, null);
                while (cimkeySubsystemCursor.next()) {
                    arrayList.add(cimkeySubsystemCursor.getObject());
                }
                cimkeySubsystemCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResCimkeySubsystemTable == null ? null : new Integer(tResCimkeySubsystemTable.getCimkeySubsystemId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResCimkeySubsystemTable == null ? null : new Integer(tResCimkeySubsystemTable.getCimkeySubsystemId()));
        return arrayList;
    }

    public static ArrayList getCimkeySwitch(int n, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getCimkeySwitch", new Object[]{new Integer(n), dBConnection});
        TResCimkeySwitchTable tResCimkeySwitchTable = null;
        ArrayList<CimkeySwitch> arrayList = new ArrayList<CimkeySwitch>();
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(CimkeySwitch.class, "CIM_NAMESPACE_ID", logTraceHelper);
                hashtable.put(columnInfo, String.valueOf(n));
                CimkeySwitch.CimkeySwitchCursor cimkeySwitchCursor = CimkeySwitch.getCursor(dBConnection, hashtable, null);
                while (cimkeySwitchCursor.next()) {
                    arrayList.add(cimkeySwitchCursor.getObject());
                }
                cimkeySwitchCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResCimkeySwitchTable == null ? null : new Integer(tResCimkeySwitchTable.getCimkeySwitchId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResCimkeySwitchTable == null ? null : new Integer(tResCimkeySwitchTable.getCimkeySwitchId()));
        return arrayList;
    }

    public static ArrayList getCimkeyTapeLibrary(int n, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getCimkeyTapeLibrary", new Object[]{new Integer(n), dBConnection});
        TResCimkeyTapeLibraryTable tResCimkeyTapeLibraryTable = null;
        ArrayList<CimkeyTapeLibrary> arrayList = new ArrayList<CimkeyTapeLibrary>();
        try {
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(CimkeyTapeLibrary.class, "CIM_NAMESPACE_ID", logTraceHelper);
                hashtable.put(columnInfo, String.valueOf(n));
                CimkeyTapeLibrary.CimkeyTapeLibraryCursor cimkeyTapeLibraryCursor = CimkeyTapeLibrary.getCursor(dBConnection, hashtable, null);
                while (cimkeyTapeLibraryCursor.next()) {
                    arrayList.add(cimkeyTapeLibraryCursor.getObject());
                }
                cimkeyTapeLibraryCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            ExternalKeyManager.commit(dBConnection);
            logTraceHelper.exit(tResCimkeyTapeLibraryTable == null ? null : new Integer(tResCimkeyTapeLibraryTable.getCimkeyTapeLibraryId()));
            throw throwable;
        }
        ExternalKeyManager.commit(dBConnection);
        logTraceHelper.exit(tResCimkeyTapeLibraryTable == null ? null : new Integer(tResCimkeyTapeLibraryTable.getCimkeyTapeLibraryId()));
        return arrayList;
    }

    public static CapabilityData getCapabilityData(int n, DBConnection dBConnection) throws ServerException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getCapabilityData", new Object[]{new Integer(n), dBConnection});
        CapabilityData capabilityData = null;
        try {
            try {
                capabilityData = new CapabilityData();
                capabilityData.setCapabilityDataId(n);
                boolean bl = capabilityData.retrieve(dBConnection);
                if (!bl) {
                    throw new EntityNotFoundException(null, Integer.toString(n));
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(capabilityData == null ? null : new Integer(capabilityData.getCapabilityDataId()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(capabilityData == null ? null : new Integer(capabilityData.getCapabilityDataId()));
        ExternalKeyManager.commit(dBConnection);
        return capabilityData;
    }

    public static Cimom2namespace getNamespace(int n, DBConnection dBConnection) throws ServerException, EntityNotFoundException {
        Cimom2namespace cimom2namespace = null;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getStorageSubsystemCIM", new Object[]{new Integer(n), dBConnection});
        try {
            try {
                cimom2namespace = new Cimom2namespace();
                cimom2namespace.setCimNamespaceId(n);
                if (!cimom2namespace.retrieve(dBConnection)) {
                    throw new EntityNotFoundException(null, Integer.toString(n));
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(cimom2namespace == null ? null : new Integer(cimom2namespace.getCimNamespaceId()));
            throw throwable;
        }
        logTraceHelper.exit(cimom2namespace == null ? null : new Integer(cimom2namespace.getCimNamespaceId()));
        return cimom2namespace;
    }

    public static CimkeySubsystem getStorageSubsystemCIM(int n, int n2, DBConnection dBConnection) throws ServerException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getStorageSubsystemCIM", new Object[]{String.valueOf(n), String.valueOf(n2), dBConnection});
        CimkeySubsystem cimkeySubsystem = null;
        try {
            try {
                cimkeySubsystem = new CimkeySubsystem();
                cimkeySubsystem.setSubsystemId(n);
                cimkeySubsystem.setCimNamespaceId(n2);
                boolean bl = cimkeySubsystem.retrieve(dBConnection);
                if (!bl) {
                    throw new EntityNotFoundException(null, Integer.toString(n2));
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021503E", sQLException.getMessage(), logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(cimkeySubsystem == null ? null : new Integer(cimkeySubsystem.getCimkeySubsystemId()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(cimkeySubsystem == null ? null : new Integer(cimkeySubsystem.getCimkeySubsystemId()));
        ExternalKeyManager.commit(dBConnection);
        return cimkeySubsystem;
    }

    public static CimkeyVolume getStorageVolumeCIM(int n, int n2, DBConnection dBConnection) throws ServerException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getStorageVolumeCIM", new Object[]{String.valueOf(n), String.valueOf(n2), dBConnection});
        TResCimkeyVolumeTable tResCimkeyVolumeTable = null;
        try {
            try {
                CimkeyVolume.CimkeyVolumeCursor cimkeyVolumeCursor = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), String.valueOf(n));
                cimkeyVolumeCursor = CimkeyVolume.getCursor(dBConnection, hashtable, null);
                if (!cimkeyVolumeCursor.next()) {
                    cimkeyVolumeCursor.close();
                    throw new EntityNotFoundException(null, String.valueOf(n));
                }
                tResCimkeyVolumeTable = cimkeyVolumeCursor.getObject();
                cimkeyVolumeCursor.close();
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021503E", sQLException.getMessage(), logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(tResCimkeyVolumeTable == null ? null : new Integer(tResCimkeyVolumeTable.getVolumeId()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(tResCimkeyVolumeTable == null ? null : new Integer(tResCimkeyVolumeTable.getVolumeId()));
        ExternalKeyManager.commit(dBConnection);
        return tResCimkeyVolumeTable;
    }

    public static CimkeyPort getPortCIM(int n, int n2, DBConnection dBConnection) throws ServerException, EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(cClassName, "getPortCIM", new Object[]{new Integer(n), new Integer(n2), dBConnection});
        TResCimkeyPortTable tResCimkeyPortTable = null;
        try {
            try {
                CimkeyPort.CimkeyPortCursor cimkeyPortCursor = null;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(CimkeyPort.getColumnInfo("PORT_ID"), String.valueOf(n));
                cimkeyPortCursor = CimkeyPort.getCursor(dBConnection, hashtable, null);
                if (!cimkeyPortCursor.next()) {
                    cimkeyPortCursor.close();
                    throw new EntityNotFoundException(null, String.valueOf(n));
                }
                tResCimkeyPortTable = cimkeyPortCursor.getObject();
                cimkeyPortCursor.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            logTraceHelper.exit(tResCimkeyPortTable == null ? null : new Integer(tResCimkeyPortTable.getCimkeyPortId()));
            ExternalKeyManager.commit(dBConnection);
            throw throwable;
        }
        logTraceHelper.exit(tResCimkeyPortTable == null ? null : new Integer(tResCimkeyPortTable.getCimkeyPortId()));
        ExternalKeyManager.commit(dBConnection);
        return tResCimkeyPortTable;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeySubsystem cimkeySubsystem, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cimkeySubsystem.getCreationClassName(), string);
        CIMProperty cIMProperty = new CIMProperty("Name", new CIMValue((Object)cimkeySubsystem.getName(), CIMDataType.getPredefinedType((int)8)));
        cIMObjectPath.addKey(cIMProperty);
        CIMProperty cIMProperty2 = new CIMProperty("CreationClassName", new CIMValue((Object)cimkeySubsystem.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        cIMObjectPath.addKey(cIMProperty2);
        return cIMObjectPath;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeyTapeLibrary cimkeyTapeLibrary, String string) {
        cimkeyTapeLibrary.getName();
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath(cimkeyTapeLibrary.getCreationClassName(), string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Name", new CIMValue((Object)cimkeyTapeLibrary.getName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        CIMProperty cIMProperty2 = new CIMProperty("CreationClassName", new CIMValue((Object)cimkeyTapeLibrary.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty2);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeySwitch cimkeySwitch, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cimkeySwitch.getCreationClassName(), string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Name", new CIMValue((Object)cimkeySwitch.getName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        CIMProperty cIMProperty2 = new CIMProperty("CreationClassName", new CIMValue((Object)cimkeySwitch.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty2);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static CIMObjectPath getCIMObjectPath(StoragePool storagePool, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(storagePool.getClassName(), string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("InstanceID", new CIMValue((Object)storagePool.getInstanceId(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static CIMObjectPath getCIMObjectPath(ClientSettingData clientSettingData, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(clientSettingData.getCreationClassName(), string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("InstanceID", new CIMValue((Object)clientSettingData.getInstanceId(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        cIMObjectPath.setKeys(vector);
        cIMObjectPath.setNameSpace(string);
        return cIMObjectPath;
    }

    public static CIMObjectPath getCIMObjectPath(StorageExtent storageExtent, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(storageExtent.getCreationClassName(), string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("DeviceID", new CIMValue((Object)storageExtent.getDeviceId(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        CIMProperty cIMProperty2 = new CIMProperty("CreationClassName", new CIMValue((Object)storageExtent.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty2);
        CIMProperty cIMProperty3 = new CIMProperty("SystemCreationClassName", new CIMValue((Object)storageExtent.getSystemCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty3);
        CIMProperty cIMProperty4 = new CIMProperty("SystemName", new CIMValue((Object)storageExtent.getSystemNames(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty4);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeyVolume cimkeyVolume, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cimkeyVolume.getCreationClassName(), string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("DeviceID", new CIMValue((Object)cimkeyVolume.getDeviceId(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        CIMProperty cIMProperty2 = new CIMProperty("SystemName", new CIMValue((Object)cimkeyVolume.getSystemNames(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty2);
        CIMProperty cIMProperty3 = new CIMProperty("CreationClassName", new CIMValue((Object)cimkeyVolume.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty3);
        CIMProperty cIMProperty4 = new CIMProperty("SystemCreationClassName", new CIMValue((Object)cimkeyVolume.getSystemCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty4);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static CIMObjectPath getCIMObjectPath(CimkeyPort cimkeyPort, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cimkeyPort.getCreationClassName(), string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("DeviceID", new CIMValue((Object)cimkeyPort.getDeviceId(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        CIMProperty cIMProperty2 = new CIMProperty("SystemName", new CIMValue((Object)cimkeyPort.getSystemNames(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty2);
        CIMProperty cIMProperty3 = new CIMProperty("CreationClassName", new CIMValue((Object)cimkeyPort.getCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty3);
        CIMProperty cIMProperty4 = new CIMProperty("SystemCreationClassName", new CIMValue((Object)cimkeyPort.getSystemCreationClassName(), CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty4);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    public static CIMObjectPath getIOGroupCIMObjectPath(String string, String string2, String string3, String string4) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string3, string4);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        String string5 = String.valueOf(string) + ":" + string2;
        CIMProperty cIMProperty = new CIMProperty("Name", new CIMValue((Object)string5, CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty);
        CIMProperty cIMProperty2 = new CIMProperty("CreationClassName", new CIMValue((Object)string3, CIMDataType.getPredefinedType((int)8)));
        vector.add(cIMProperty2);
        cIMObjectPath.setKeys(vector);
        return cIMObjectPath;
    }

    protected static void commit(DBConnection dBConnection) {
        if (dBConnection != null) {
            LogTraceHelper logTraceHelper = null;
            try {
                try {
                    dBConnection.commit();
                }
                catch (SQLException sQLException) {
                    logTraceHelper = LogTraceHelper.entry("ExternalKeyManager", "commit", new Object[]{dBConnection});
                    logTraceHelper.traceError("Internal error: SQLException", sQLException);
                    throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
                }
            }
            finally {
                if (logTraceHelper != null) {
                    logTraceHelper.exit(null);
                }
            }
        }
    }
}

