/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.aperi.disk.common.util.Reusable;

public abstract class InstancePool {
    private int cUnusedThreshold = 500;
    private Stack cInstanceStack = new Stack();
    private static int cReturnCount = 0;
    private List cOutOfPoolInstances = new LinkedList();

    protected InstancePool() {
    }

    protected InstancePool(int n) {
        this();
        this.cUnusedThreshold = n;
    }

    protected final synchronized Reusable getClearInstance() {
        if (!this.cInstanceStack.isEmpty()) {
            Reusable reusable = (Reusable)this.cInstanceStack.pop();
            if (reusable == null) {
                return null;
            }
            reusable.clearInstance();
            reusable.setIsInPool(false);
            this.cOutOfPoolInstances.add(reusable);
            return reusable;
        }
        return null;
    }

    protected final synchronized boolean returnInst(Reusable reusable) {
        this.cOutOfPoolInstances.remove(reusable);
        if (this.cInstanceStack.size() < this.cUnusedThreshold) {
            reusable.clearInstance();
            reusable.setIsInPool(true);
            this.cInstanceStack.push(reusable);
            return true;
        }
        return false;
    }

    protected final synchronized boolean removeInst(Reusable reusable) {
        return this.cOutOfPoolInstances.remove(reusable);
    }

    public final synchronized void clear() {
        Reusable reusable;
        Iterator iterator = this.cInstanceStack.iterator();
        while (iterator.hasNext()) {
            reusable = (Reusable)iterator.next();
            reusable.releaseInstance();
            iterator.remove();
        }
        iterator = this.cOutOfPoolInstances.iterator();
        while (iterator.hasNext()) {
            reusable = (Reusable)iterator.next();
            reusable.releaseInstance();
            iterator.remove();
        }
    }
}

