/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.xmsg.MessageLog;

public class CreateHeaderPanel
extends JPanel
implements ActionListener,
ChangeListener {
    JPanel panel;
    JLabel creatorLabel = new JLabel(MessageLog.getMessageNoID("GUI5000L"));
    JLabel nameLabel = new JLabel(MessageLog.getMessageNoID("GUI5001L"));
    JLabel descriptionLabel = new JLabel(MessageLog.getMessageNoID("GUI5003L"));
    JLabel creator = new JLabel();
    JLabel name = new JLabel();
    private String enabledText;
    JCheckBox enabled = new JCheckBox();
    JTextField description = new JTextField(36);
    SizeLimitedDocument doc64 = new SizeLimitedDocument(64, false);
    GridBagConstraints gbcLabel = new GridBagConstraints();
    GridBagConstraints gbcLast = new GridBagConstraints();
    Insets inset1 = new Insets(0, 0, 0, 12);
    Insets inset2 = new Insets(0, 0, 0, 74);
    CreateHeader createHeader;
    CreateOrEdit caller;
    CreateOrEditDDI DDI;
    private boolean disableSaveOnly;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public CreateHeaderPanel(CreateHeader createHeader, CreateOrEdit createOrEdit, CreateOrEditDDI createOrEditDDI, boolean bl) {
        this.createHeader = createHeader;
        this.caller = createOrEdit;
        this.DDI = createOrEditDDI;
        this.disableSaveOnly = bl;
        if (createHeader.creator == null) {
            createHeader.creator = GuiUtil.getUserName();
        }
        this.setLayout(new BorderLayout());
        this.gbcLabel.anchor = 17;
        this.gbcLabel.insets = this.inset1;
        this.gbcLast.anchor = 13;
        this.gbcLast.gridwidth = 0;
        this.panel = GuiUtil.getPanel();
        this.panel.add((Component)this.creatorLabel, this.gbcLabel);
        this.gbcLabel.insets = this.inset2;
        this.panel.add((Component)this.creator, this.gbcLabel);
        this.gbcLabel.insets = this.inset1;
        this.panel.add((Component)this.nameLabel, this.gbcLabel);
        if (createOrEditDDI.showEnabled) {
            this.panel.add((Component)this.name, this.gbcLabel);
            this.panel.add((Component)this.enabled, this.gbcLast);
            this.enabledText = MessageLog.getMessageNoID("GUI0201L");
            this.enabled.addChangeListener(this);
            this.gbcLast.anchor = 17;
        } else {
            this.gbcLast.anchor = 17;
            this.panel.add((Component)this.name, this.gbcLast);
        }
        GuiUtil.setAccessibleLabel(this.descriptionLabel, this.description, "MNEMONIC_DESCRIPTION", "LABEL_DESCRIPTIOM", "DESCRIPTION_DESCRIPTIOM");
        GuiUtil.setAccessible(this.enabled, MessageLog.getMessageNoID("GUI0201L"), MessageLog.getMessageNoID("GUI0201L"));
        this.panel.add((Component)this.descriptionLabel, this.gbcLabel);
        this.description.setDocument(this.doc64);
        this.panel.add((Component)this.description, this.gbcLast);
        this.setFields();
        GuiUtil.completePanel(this.panel);
        this.add((Component)this.panel, "North");
    }

    public CreateHeaderPanel(CreateHeader createHeader, CreateOrEdit createOrEdit, CreateOrEditDDI createOrEditDDI) {
        this(createHeader, createOrEdit, createOrEditDDI, false);
    }

    public void setFields() {
        this.panel.setBorder(GuiUtil.getBorder(this.DDI.getDescription()));
        this.creator.setText(this.createHeader.creator);
        String string = this.createHeader.getName();
        if (string == null || string.equals("") || string.equals(" ")) {
            this.name.setText(MessageLog.getMessageNoID("GUI5004L"));
        } else {
            this.name.setText(string);
        }
        this.enabled.setSelected(this.createHeader.enabled);
        this.enabled.setText(this.enabledText);
        String string2 = this.createHeader.getDescription();
        if (string2 != null && string2.equals(" ")) {
            string2 = "";
        }
        this.description.setText(string2);
    }

    public void gettingFocus() {
        this.guiMain.setSaveActionEnabled(!this.disableSaveOnly, false);
        this.guiMain.setSaveAsActionEnabled(true, false);
        this.guiMain.setSaveActionToolTip(MessageLog.getMessageNoID("GUI5012T", this.DDI.msgParm));
        this.guiMain.setSaveAsActionToolTip(MessageLog.getMessageNoID("GUI5013T", this.DDI.msgParm));
        this.guiMain.addSaveActionListener(this);
        this.guiMain.addSaveAsActionListener(this);
    }

    public void losingFocus() {
        this.guiMain.setSaveActionEnabled(false, false);
        this.guiMain.setSaveAsActionEnabled(false, false);
        this.guiMain.setSaveActionToolTip(null);
        this.guiMain.setSaveAsActionToolTip(null);
        this.guiMain.removeSaveActionListener(this);
        this.guiMain.removeSaveAsActionListener(this);
    }

    public CreateHeader getData() {
        this.createHeader.enabled = this.enabled.isSelected();
        if (!this.createHeader.getDescription().equals(this.description.getText())) {
            this.createHeader.setDescription(this.description.getText());
        }
        return this.createHeader;
    }

    public void replace(CreateHeader createHeader) {
        this.createHeader = createHeader;
        this.setFields();
        if (this.disableSaveOnly) {
            this.guiMain.setSaveActionEnabled(true, false);
        }
    }

    public void setEnabled(boolean bl) {
        GuiUtil.setAllEnabled(this.panel, bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Save") {
            this.DDI.save(false);
        } else if (string == "SaveAs") {
            this.DDI.save(true);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void setEnabledCheckbox(boolean bl) {
        this.enabled.setSelected(bl);
    }

    public boolean getEnabledCheckbox() {
        return this.enabled.isEnabled();
    }
}

