/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.UilDateFieldBean;

public class DateSelector
extends JPanel
implements ActionListener {
    private JButton calendarButton;
    private JButton okButton;
    private JButton cancelButton;
    private int maxYear;
    private static final int MIN_YEAR = 2000;
    private UilDateFieldBean dateField = new UilDateFieldBean();
    private Calendar calendar = Calendar.getInstance();

    public DateSelector() {
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateSelector(long l) {
        this.calendar.setTime(new Date(l));
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateSelector(short s, short s2, short s3) {
        if (s == 0) {
            this.initFromCalendar(this.calendar);
        } else {
            this.initFromShorts(s, s2, s3);
        }
        this.buildPanel();
    }

    private void initFromCalendar(Calendar calendar) {
        this.dateField.setTime(calendar.getTime());
    }

    private void initFromShorts(short s, short s2, short s3) {
        this.calendar.set(1, s);
        this.calendar.set(2, s2);
        this.calendar.set(5, s3);
    }

    public void setDate(short s, short s2, short s3) {
        this.initFromShorts(s, s2, s3);
        this.setDate();
    }

    public void setDate(long l) {
        this.calendar.setTime(new Date(l));
        this.initFromCalendar(this.calendar);
        this.setDate();
    }

    public short[] getDate() {
        this.getSelection();
        short[] sArray = new short[]{(short)this.calendar.get(1), (short)this.calendar.get(2), (short)this.calendar.get(5)};
        return sArray;
    }

    public long getLongDate() {
        this.getSelection();
        return this.calendar.getTime().getTime();
    }

    public long getStartOfDay() {
        this.getSelection();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.calendar.get(1));
        calendar.set(2, this.calendar.get(2));
        calendar.set(5, this.calendar.get(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getEndOfDay() {
        this.getSelection();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.calendar.get(1));
        calendar.set(2, this.calendar.get(2));
        calendar.set(5, this.calendar.get(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public void setEnabled(boolean bl) {
        this.dateField.setEnabled(bl);
    }

    private void buildPanel() {
        this.dateField.setYearRange(2000, Calendar.getInstance().get(1) + 2);
        this.dateField.setOpaque(false);
        this.maxYear = Calendar.getInstance().get(1) + 2;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.dateField, gridBagConstraints);
        this.add(Box.createHorizontalStrut(3), gridBagConstraints);
    }

    private void setDate() {
        this.dateField.setTime(this.calendar.getTime());
    }

    private void getSelection() {
        this.calendar.setTime(this.dateField.getTime());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
    }
}

