/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.DateSelector;
import org.eclipse.aperi.gui.TimeSelector;

public class DateTimeSelector
extends JPanel
implements ActionListener {
    private int maxYear;
    private boolean bValidate = true;
    private int minYear = 2000;
    private Calendar calendar = Calendar.getInstance();
    private DateSelector dateBox = new DateSelector();
    private TimeSelector timeBox = new TimeSelector();

    public DateTimeSelector() {
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateTimeSelector(short s) {
        if (s > 2000) {
            this.minYear = s;
        }
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateTimeSelector(long l) {
        this.calendar.setTime(new Date(l));
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateTimeSelector(short s, short s2, short s3, short s4, short s5) {
        if (s == 0) {
            this.initFromCalendar(this.calendar);
        } else {
            this.initFromShorts(s, s2, s3, s4, s5);
        }
        this.buildPanel();
    }

    private void initFromCalendar(Calendar calendar) {
        if (calendar.get(1) < 2000) {
            calendar.set(1, 2000);
        }
        this.timeBox.setTime(calendar.getTime().getTime());
        this.dateBox.setDate(calendar.getTime().getTime());
    }

    private void initFromShorts(short s, short s2, short s3, short s4, short s5) {
        if (s < (short)this.minYear) {
            s = (short)this.minYear;
        }
        this.calendar.set(s, s2 - 1, s3, s4, s5);
        this.timeBox.setTime(this.calendar.getTime().getTime());
        this.dateBox.setDate(this.calendar.getTime().getTime());
    }

    public void setDateTime(short s, short s2, short s3, short s4, short s5) {
        this.initFromShorts(s, s2, s3, s4, s5);
        this.setDateTime();
    }

    public void setDateTime(long l) {
        this.calendar.setTime(new Date(l));
        this.initFromCalendar(this.calendar);
        this.setDateTime();
    }

    public short[] getDateTime() {
        this.getSelection();
        short[] sArray = new short[]{(short)this.calendar.get(1), (short)this.calendar.get(2), (short)this.calendar.get(5), (short)this.calendar.get(11), (short)this.calendar.get(12)};
        return sArray;
    }

    public long getMilliseconds() {
        this.getSelection();
        Calendar calendar = this.calendar;
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public void setEnabled(boolean bl) {
        this.dateBox.setEnabled(bl);
        this.timeBox.setEnabled(bl);
    }

    private void buildPanel() {
        this.setDateTime();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.dateBox, gridBagConstraints);
        this.add(Box.createHorizontalStrut(18), gridBagConstraints);
        this.add((Component)this.timeBox, gridBagConstraints);
    }

    private void setDateTime() {
        this.bValidate = false;
        this.timeBox.setTime(this.calendar.getTime().getTime());
        this.dateBox.setDate(this.calendar.getTime().getTime());
        this.bValidate = true;
    }

    private void getSelection() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.dateBox.getLongDate()));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date(this.timeBox.getLongTime()));
        this.calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar2.get(11), calendar2.get(12));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.bValidate) {
            return;
        }
        actionEvent.getSource();
    }
}

