/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.gui.DefaultListEditor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.ListElementEditor;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableList
extends JPanel
implements ActionListener,
ListSelectionListener {
    public JButton addButton;
    protected JButton remButton;
    public JList editList;
    protected DefaultListModel listModel;
    protected ListElementEditor editor;
    protected JLabel lTitle;
    private JScrollPane scrollPane;

    public EditableList(String string, Object object, int n) {
        this(string, null, null, object, n, 50);
    }

    public EditableList(JLabel jLabel, Object object, int n) {
        this(null, jLabel, null, object, n, 50);
    }

    public EditableList(String string, Object object, int n, int n2) {
        this(string, null, null, object, n, n2);
    }

    public EditableList(String string, ListElementEditor listElementEditor, Object object, int n) {
        this(string, null, listElementEditor, object, n, -1);
    }

    private EditableList(String string, JLabel jLabel, ListElementEditor listElementEditor, Object object, int n, int n2) {
        this.lTitle = jLabel != null ? jLabel : new JLabel(string);
        if (listElementEditor != null) {
            this.editor = listElementEditor;
        } else {
            this.editor = new DefaultListEditor(n2, this);
            GuiUtil.setAccessibleDescription((DefaultListEditor)this.editor, this.lTitle.getText());
        }
        this.listModel = new DefaultListModel();
        this.editList = new JList(this.listModel);
        this.editList.setSelectionMode(0);
        this.editList.addMouseListener(new EditListMouseListener());
        this.editList.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.editList);
        if (object != null) {
            this.editList.setPrototypeCellValue(object);
        }
        if (n > 0) {
            this.editList.setVisibleRowCount(n);
        }
        this.addButton = new JButton(MessageLog.getMessageNoID("GUI0043L"));
        this.remButton = new JButton(MessageLog.getMessageNoID("GUI0044L"));
        GuiUtil.setAccessible(this.addButton, this.addButton.getText(), this.addButton.getText());
        GuiUtil.setAccessible(this.remButton, this.remButton.getText(), this.remButton.getText());
        this.addButton.setEnabled(false);
        this.remButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.remButton.addActionListener(this);
        this.buildPanel();
    }

    public void addObject(Object object) {
        if (object != null) {
            int n = this.editList.getSelectedIndex();
            n = n == -1 ? this.listModel.size() : ++n;
            this.listModel.add(n, object);
        }
    }

    public void removeAllObjects() {
        int n = this.listModel.getSize() - 1;
        while (n >= 0) {
            Object e = this.listModel.remove(n);
            this.editor.objectRemoved(e);
            --n;
        }
        this.remButton.setEnabled(false);
    }

    public Object[] getElements() {
        return this.listModel.toArray();
    }

    public void setAddEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
    }

    public void setEnabled(boolean bl, boolean bl2) {
        super.setEnabled(bl);
        this.editor.setEnabled(bl);
        this.editList.setEnabled(bl);
        this.lTitle.setEnabled(bl);
        if (bl) {
            if (this.editList.getSelectedIndex() >= 0) {
                this.remButton.setEnabled(true);
            }
        } else {
            if (bl2) {
                this.listModel.clear();
                this.editor.getObject();
            }
            this.remButton.setEnabled(false);
        }
    }

    public void setEnabled(boolean bl) {
        this.setEnabled(bl, true);
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 8;
        this.add((Component)this.lTitle, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 0;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.remButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add(this.editor.getComponent(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.actionAdd();
        } else if (object == this.remButton) {
            int n = this.editList.getSelectedIndex();
            if (n != -1) {
                Object e = this.listModel.remove(n);
                int n2 = this.listModel.getSize();
                if (n >= n2) {
                    --n;
                }
                this.editor.objectRemoved(e);
            }
            if (n >= 0) {
                this.editList.setSelectedIndex(n);
            } else {
                this.remButton.setEnabled(false);
            }
        }
    }

    protected void actionAdd() {
        this.addObject(this.editor.getObject());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.editList.getSelectedValue() == null) {
            this.remButton.setEnabled(false);
        } else {
            this.remButton.setEnabled(true);
        }
    }

    private class EditListMouseListener
    extends MouseAdapter {
        private EditListMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object e;
            if (mouseEvent.getClickCount() == 2 && (e = EditableList.this.editList.getSelectedValue()) != null) {
                EditableList.this.editor.setObject(e);
            }
        }
    }
}

