/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Rename;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiRename
implements GuiRequestor {
    private Rename obj;
    private String description;

    public GuiRename(NameList nameList, String string) {
        this.description = string;
        this.obj = new Rename();
        this.obj.rnID = nameList.nlID;
        this.obj.rnObjectType = nameList.nlInfo;
        int n = nameList.nlName.indexOf(46);
        this.obj.rnCreator = n > 0 ? nameList.nlName.substring(0, n) : " ";
        this.obj.rnOldName = nameList.nlName.substring(n + 1);
        this.obj.rnModifyingUser = GuiUtil.getUserName();
    }

    public void rename() {
        Object[] objectArray = new Object[]{this.description};
        String string = MessageLog.getMessageNoID("GUI0054L", objectArray);
        String string2 = Util.getString("RENAME_PROMPT", this.description);
        this.obj.rnNewName = CreateOrEditDDI.promptForName(string, string2);
        if (this.obj.rnNewName == null) {
            return;
        }
        Request request = new Request();
        ServerRequest.serverRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.server.RenameHndlr";
        request.userName = this.obj.rnModifyingUser;
        request.flags = (byte)5;
        request.requestData = this.obj;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        NameList nameList = (NameList)response.responseData;
        nameList.nlInfo = this.obj.rnObjectType;
        ChangeManager.signalChange(0, nameList);
    }
}

