/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class Selector
extends JPanel
implements ActionListener {
    private boolean groupByCluster = false;
    protected JButton addButton;
    protected JButton delButton;
    protected JPanel leftPane;
    protected JPanel rightPane;
    protected JPanel middlePane;
    protected JLabel leftTitle;
    protected JLabel rightTitle;
    protected JCheckBox groupByClusterButton;
    protected JButton upButton;
    protected JButton downButton;
    protected JPanel upDownPane;
    protected JList sourceJList;
    protected JList selectedJList;

    public Selector(ArrayList arrayList, ArrayList arrayList2, boolean bl, boolean bl2) {
        this.sourceJList = this.list2JList(arrayList);
        this.selectedJList = this.list2JList(arrayList2);
        this.layoutUpDownPanel(this.sourceJList, this.selectedJList, bl, bl2);
    }

    public Selector(JComponent jComponent, JComponent jComponent2, boolean bl, boolean bl2) {
        this.layoutUpDownPanel(jComponent, jComponent2, bl, bl2);
    }

    public Selector(JComponent jComponent, JComponent jComponent2, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        if (bl) {
            gridBagConstraints.insets.left = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            this.groupByClusterButton = new JCheckBox(Util.getString("LABEL_GROUP_BY_CLUSTER"));
            this.add((Component)this.groupByClusterButton, gridBagConstraints);
        }
        this.addButton = new JButton(">>");
        Font font = this.addButton.getFont().deriveFont(1);
        this.addButton.setFont(font);
        this.delButton = new JButton("<<");
        this.delButton.setFont(font);
        this.leftTitle = new JLabel(MessageLog.getMessageNoID("STG4029L"));
        this.leftTitle.setFont(font);
        this.rightTitle = new JLabel(MessageLog.getMessageNoID("STG4030L"));
        this.rightTitle.setFont(font);
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_AVAILABLE"));
        this.leftTitle.setLabelFor(jComponent);
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_SELECTED"));
        this.rightTitle.setLabelFor(jComponent2);
        this.leftPane = this.getLeftPane(jComponent, this.leftTitle);
        this.rightPane = this.getRightPane(jComponent2, this.rightTitle);
        this.middlePane = new JPanel(new GridBagLayout());
        GuiUtil.setAccessible(this.leftTitle, MessageLog.getMessageNoID("STG4029L"), MessageLog.getMessageNoID("STG4029L"));
        GuiUtil.setAccessible(this.rightTitle, MessageLog.getMessageNoID("STG4030L"), MessageLog.getMessageNoID("STG4030L"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets.bottom = 10;
        this.middlePane.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        this.middlePane.add((Component)this.delButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.leftPane, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.middlePane, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.rightPane, gridBagConstraints);
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
    }

    protected JPanel getLeftPane(JComponent jComponent, JLabel jLabel) {
        return this.getPane(jComponent, jLabel);
    }

    protected JPanel getRightPane(JComponent jComponent, JLabel jLabel) {
        return this.getPane(jComponent, jLabel);
    }

    private JPanel getPane(JComponent jComponent, JLabel jLabel) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jComponent);
        jScrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void layoutUpDownPanel(JComponent jComponent, JComponent jComponent2, boolean bl, boolean bl2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        if (bl) {
            gridBagConstraints.insets.left = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            this.groupByClusterButton = new JCheckBox(Util.getString("LABEL_GROUP_BY_CLUSTER"));
            this.add((Component)this.groupByClusterButton, gridBagConstraints);
        }
        this.addButton = new JButton(">>");
        Font font = this.addButton.getFont().deriveFont(1);
        this.addButton.setFont(font);
        this.delButton = new JButton("<<");
        this.delButton.setFont(font);
        this.leftTitle = new JLabel(MessageLog.getMessageNoID("STG4029L"));
        this.leftTitle.setFont(font);
        this.rightTitle = new JLabel(MessageLog.getMessageNoID("STG4030L"));
        this.rightTitle.setFont(font);
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_AVAILABLE"));
        this.leftTitle.setLabelFor(jComponent);
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_SELECTED"));
        this.rightTitle.setLabelFor(jComponent2);
        this.leftPane = this.getLeftPane(jComponent, this.leftTitle);
        this.rightPane = this.getRightPane(jComponent2, this.rightTitle);
        this.middlePane = new JPanel(new GridBagLayout());
        GuiUtil.setAccessible(this.leftTitle, MessageLog.getMessageNoID("STG4029L"), MessageLog.getMessageNoID("STG4029L"));
        GuiUtil.setAccessible(this.rightTitle, MessageLog.getMessageNoID("STG4030L"), MessageLog.getMessageNoID("STG4030L"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets.bottom = 10;
        this.middlePane.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        this.middlePane.add((Component)this.delButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.leftPane, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.middlePane, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = bl2 ? 1 : 0;
        this.add((Component)this.rightPane, gridBagConstraints);
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
        if (bl2) {
            this.upDownPane = new JPanel(new GridBagLayout());
            ImageIcon imageIcon = IconFactory.getUpIcon();
            this.upButton = new JButton(imageIcon);
            this.upButton.setFont(font);
            imageIcon = IconFactory.getDownIcon();
            this.downButton = new JButton(imageIcon);
            this.downButton.setFont(font);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 20, 0);
            this.upDownPane.add((Component)this.upButton, gridBagConstraints2);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.upDownPane.add((Component)this.downButton, gridBagConstraints2);
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.weightx = 0.0;
            this.add((Component)this.upDownPane, gridBagConstraints2);
            this.upButton.addActionListener(this);
            this.downButton.addActionListener(this);
        }
    }

    public abstract void actionPerformed(ActionEvent var1);

    public void setGroupByClusterButtonActionListener(ActionListener actionListener) {
        this.groupByClusterButton.addActionListener(actionListener);
    }

    public JList list2JList(ArrayList arrayList) {
        DefaultListModel defaultListModel = new DefaultListModel();
        int n = 0;
        while (n < arrayList.size()) {
            defaultListModel.addElement(arrayList.get(n));
            ++n;
        }
        return new JList(defaultListModel);
    }
}

