/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;

public abstract class WizardPage
extends JPanel {
    public static final int ALL = 31;
    public static final int CANCEL = 8;
    public static final int FINISH = 4;
    public static final int HELP = 16;
    public static final int NEXT = 2;
    public static final int NO_BUTTONS = 0;
    public static final int PREVIOUS = 1;
    protected static final int SPACING = 5;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton finishButton;
    protected JButton helpButton;
    protected JButton cancelButton;
    protected JPanel buttonPanel = new JPanel();

    public WizardPage() {
        this(31);
    }

    public WizardPage(int n) {
        this.createButtonBox(n);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "South");
    }

    public Container getContentPane() {
        return this;
    }

    public abstract Object next();

    protected void createButtonBox(int n) {
        this.buttonPanel = new JPanel();
        JSeparator jSeparator = new JSeparator();
        Box box = new Box(0);
        this.backButton = new JButton(Util.getString("LABEL_PREVIOUS"));
        this.backButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PREVIOUS"));
        GuiUtil.setAccessibleDescription(this.backButton, "DESC_PREVIOUS");
        this.nextButton = new JButton(Util.getString("LABEL_NEXT"));
        this.nextButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_NEXT"));
        GuiUtil.setAccessibleDescription(this.nextButton, "DESC_NEXT");
        this.finishButton = new JButton(Util.getString("LABEL_FINISH"));
        this.finishButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_FINISH"));
        GuiUtil.setAccessibleDescription(this.finishButton, "DESCRIPTION_FINISH");
        this.helpButton = new JButton(Util.getString("LABEL_HELP_MENU"));
        this.helpButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        GuiUtil.setAccessibleDescription(this.cancelButton, "DESCRIPTION_CANCEL");
        box.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        if ((n & 1) == 1) {
            box.add(this.backButton);
            box.add(Box.createHorizontalStrut(5));
        }
        if ((n & 2) == 2) {
            box.add(this.nextButton);
            box.add(Box.createHorizontalStrut(5));
        }
        if ((n & 4) == 4) {
            box.add(this.finishButton);
            box.add(Box.createHorizontalStrut(5));
        }
        if ((n & 8) == 8) {
            box.add(this.cancelButton);
            box.add(Box.createHorizontalStrut(5));
        }
        if ((n & 0x10) == 16) {
            box.add(this.helpButton);
            box.add(Box.createHorizontalStrut(5));
        }
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)jSeparator, "North");
        this.buttonPanel.add((Component)box, "East");
    }

    protected JButton getPreviousButton() {
        return this.backButton;
    }

    protected JButton getNextButton() {
        return this.nextButton;
    }

    protected JButton getFinishButton() {
        return this.finishButton;
    }

    protected JButton getHelpButton() {
        return this.helpButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setUpHelp(String string) {
        Help.setHelpID(this, string);
        this.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        this.getHelpButton().addActionListener(Help.getDisplayHelpFromSource());
        Help.setHelpID(this.getHelpButton(), string);
    }

    public boolean nextBegin() {
        return true;
    }

    public boolean nextComplete() {
        return true;
    }

    public boolean previousBegin() {
        return true;
    }

    public boolean previousComplete() {
        return true;
    }

    public boolean finished() {
        return true;
    }

    public boolean canceled() {
        return true;
    }

    public boolean help() {
        return true;
    }
}

