/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.IListTableModel;
import org.eclipse.aperi.gui.admin.agent.UtilsTableModel;
import org.eclipse.aperi.gui.common.CIMOMMgmtDetailsPanel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.config.service.ServiceConfigTab;
import org.eclipse.aperi.request.Response;

public class CimomAgentTableModel
extends BaseTableModel
implements IListTableModel {
    private Hashtable agentsHash;
    public final String[] COL_NAMES = new String[]{Util.getString("CONFIG_CIMAGENT_TABLE_COL_URL"), Util.getString("CONFIG_CIMAGENT_TABLE_COL_STATUS"), Util.getString("CONFIG_CIMAGENT_TABLE_COL_NS"), Util.getString("CONFIG_CIMAGENT_TABLE_COL_DISPNAME"), Util.getString("CONFIG_CIMAGENT_TABLE_COL_DESC")};
    public static final int DS_URL = 0;
    public static final int DS_STATUS = 1;
    public static final int DS_NS = 2;
    public static final int DS_DISPNAME = 3;
    public static final int DS_DESC = 4;
    public ArrayList cimoms = null;

    public CimomAgentTableModel(ArrayList arrayList) {
        this.cimoms = arrayList;
        this.columnNames = this.COL_NAMES;
        this.rowCount = arrayList != null ? arrayList.size() : 0;
        this.agentsHash = new Hashtable();
        int n = 0;
        while (n < this.rowCount) {
            this.agentsHash.put(((CIMOM)arrayList.get(n)).getServiceUrl(), n);
            ++n;
        }
    }

    public CimomAgentTableModel() {
        this(new ArrayList());
    }

    public Object getTableDataItem(int n, int n2) {
        try {
            CIMOM cIMOM = (CIMOM)this.cimoms.get(n);
            switch (n2) {
                case 0: {
                    return GUIEntityUtil.getDisplayText(cIMOM.getServiceUrl());
                }
                case 2: {
                    return GUIEntityUtil.getDisplayText(cIMOM.getInteropSchemaNamespace());
                }
                case 3: {
                    return GUIEntityUtil.getDisplayText(cIMOM.getDisplayName());
                }
                case 1: {
                    String string = CIMOMMgmtDetailsPanel.getStatus(cIMOM);
                    ImageIcon imageIcon = null;
                    imageIcon = cIMOM.getStatus() == CIMOMConnectionStatus.SUCCESS ? ServiceConfigTab.ICON_UP : (cIMOM.getStatus() == CIMOMConnectionStatus.UNKNOWN ? ServiceConfigTab.ICON_UNKNOWN : ServiceConfigTab.ICON_FAILED);
                    return new JLabel(string, imageIcon, 10);
                }
                case 4: {
                    return GUIEntityUtil.getDisplayText(cIMOM.getDescription());
                }
            }
            return "";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    void refreshCimom(CIMOM cIMOM) {
        Integer n = (Integer)this.agentsHash.get(cIMOM.getServiceUrl());
        if (n != null) {
            this.cimoms.set(n, cIMOM);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void refreshCimoms(short s, Response response, boolean bl, AgentListDDI agentListDDI) {
        int n = 0;
        ArrayList<CIMOM> arrayList = new ArrayList<CIMOM>();
        ArrayList arrayList2 = new ArrayList();
        if (s <= 4) {
            int n2 = this.cimoms.size();
            boolean[] blArray = new boolean[n2];
            CIMOM[] cIMOMArray = (CIMOM[])response.responseData;
            int n3 = 0;
            while (n3 < cIMOMArray.length) {
                Integer n4 = (Integer)this.agentsHash.get(cIMOMArray[n3].getServiceUrl());
                if (n4 != null) {
                    n = n4;
                    blArray[n] = true;
                    this.cimoms.set(n, cIMOMArray[n3]);
                } else {
                    arrayList.add(cIMOMArray[n3]);
                }
                ++n3;
            }
            n = 0;
            while (n < blArray.length) {
                if (!blArray[n]) {
                    arrayList2.add(this.cimoms.get(n));
                }
                ++n;
            }
            if (arrayList2.size() > 0 || arrayList.size() > 0) {
                UtilsTableModel.removeAndAddAgents(arrayList2, arrayList, null, false, this);
            }
            this.fireTableDataChanged();
            if (agentListDDI != null) {
                agentListDDI.setLastRefreshTime(true);
            }
        } else if (agentListDDI != null) {
            agentListDDI.setLastRefreshTime(false);
        }
    }

    public int getNumRows() {
        return this.cimoms.size();
    }

    public int getRowCount() {
        return this.cimoms.size();
    }

    public Object elementAt(int n) {
        return this.cimoms.get(n);
    }

    public Integer getPosForAgent(Object object) {
        if (object == null) {
            return null;
        }
        return (Integer)this.agentsHash.get(((CIMOM)object).getServiceUrl());
    }

    public Object getAgentInfoAt(int n) {
        return null;
    }

    public void removeAgentAt(int n) {
        CIMOM cIMOM = (CIMOM)this.cimoms.get(n);
        this.cimoms.remove(n);
        this.agentsHash.remove(cIMOM.getServiceUrl());
    }

    public void addAgents(int n, Collection collection, Collection collection2) {
        if (collection == null) {
            return;
        }
        this.cimoms.addAll(n, collection);
    }

    public void rehashAgent(Object object, Integer n) {
        if (object == null || n == null) {
            return;
        }
        this.agentsHash.put(((CIMOM)object).getServiceUrl(), n);
    }

    public void clear(boolean bl) {
        this.cimoms.clear();
        if (!bl) {
            this.agentsHash.clear();
        }
    }

    public void fireTableRowsInserted(int n, int n2) {
        super.fireTableRowsInserted(n, n2);
    }

    public void fireTableRowsDeleted(int n, int n2) {
        super.fireTableRowsDeleted(n, n2);
    }
}

