/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.service;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.admin.agent.AgentTreeNodesStore;
import org.eclipse.aperi.gui.admin.agent.DataAgentTableModel;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataAgentSection
extends ConfigSection
implements ActionListener,
TJCTableMouseInterface {
    private MegaTable table = null;
    private DataAgentTableModel tableModel = null;
    private JButton link2detail = null;
    private JButton checkBtn = null;
    private JButton enableBtn = null;
    private JLabel noData = null;
    private ArrayList dataagtNodePath = null;
    private int countTotal = 0;
    private int countUp = 0;
    private int countDown = 0;
    private int countUpgrading = 0;
    private int countUpgradeNeeded = 0;
    private int countDefected = 0;
    private int countUnreachable = 0;

    public DataAgentSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        this.dataagtNodePath = new ArrayList();
        this.dataagtNodePath.add(AdminTreeLabel.class);
        this.dataagtNodePath.add(MessageLog.getMessageNoID("ADG0200L", null));
        this.dataagtNodePath.add(GuiUtil.getString("DATA"));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_DATAAGENT_TITLE_EXPANDED");
        if (!this.isExpanded()) {
            string = Util.getString("CONFIG_DATAAGENT_TITLE_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countUp), String.valueOf(this.countDown), String.valueOf(this.countUnreachable)});
        }
        return string;
    }

    private void getAgents() {
        Request request = new Request();
        ServerRequest.guiInfo(request, 2, -2);
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    NameList nameList = (NameList)response.responseData;
                    ArrayList<NameList> arrayList = new ArrayList<NameList>();
                    ArrayList<GComputer> arrayList2 = new ArrayList<GComputer>();
                    DataAgentSection.this.resetStateCount();
                    while (nameList != null) {
                        GComputer gComputer = GuiUtil.getComputer(nameList.nlID);
                        arrayList2.add(gComputer);
                        arrayList.add(nameList);
                        DataAgentSection.this.setStateCount(nameList.nlState);
                        nameList = nameList.nlNext;
                    }
                    DataAgentSection.this.tableModel = new DataAgentTableModel(arrayList2, arrayList);
                    if (arrayList.size() != 0 && DataAgentSection.this.tableModel != null) {
                        if (DataAgentSection.this.table != null) {
                            DataAgentSection.this.remove(DataAgentSection.this.table);
                        }
                        if (DataAgentSection.this.noData != null) {
                            DataAgentSection.this.remove(DataAgentSection.this.noData);
                        }
                        DataAgentSection.this.table = new MegaTable();
                        DataAgentSection.this.table.setVisibleRows(10);
                        DataAgentSection.this.table.setMouseListener(DataAgentSection.this);
                        DataAgentSection.this.table.setBaseTableModel(DataAgentSection.this.tableModel);
                        DataAgentSection.this.table.setCellRenderer(Number.class, new NumberRenderer());
                        DataAgentSection.this.table.setCellRenderer(JLabel.class, new LabelRenderer());
                        DataAgentSection.this.table.setSelectionPolicy(0);
                        DataAgentSection.this.table.sortByColumn(2, 1);
                        DataAgentSection.this.selectionChanged(true);
                        DataAgentSection.this.table.updateUI();
                        DataAgentSection.this.add((Component)DataAgentSection.this.table, "Center");
                    } else {
                        if (DataAgentSection.this.table != null) {
                            DataAgentSection.this.remove(DataAgentSection.this.table);
                        }
                        DataAgentSection.this.noData = new JLabel(GuiUtil.getString("CONFIG_NO_DATA_AGENTS"));
                        DataAgentSection.this.add((Component)DataAgentSection.this.noData, "Center");
                    }
                    if (DataAgentSection.this.getContainer() != null) {
                        DataAgentSection.this.getContainer().updateSectionTitle();
                    }
                    DataAgentSection.this.selectionChanged(false);
                    DataAgentSection.this.revalidate();
                    DataAgentSection.this.repaint();
                }
            }
        }, request);
    }

    private void resetStateCount() {
        this.countUp = 0;
        this.countDown = 0;
        this.countUpgrading = 0;
        this.countUpgradeNeeded = 0;
        this.countDefected = 0;
        this.countUnreachable = 0;
        this.countTotal = 0;
    }

    private void setStateCount(int n) {
        switch (n) {
            case 2: {
                ++this.countDefected;
                break;
            }
            case 1: {
                ++this.countUp;
                break;
            }
            case 0: {
                ++this.countDown;
                break;
            }
            case 3: {
                ++this.countUpgrading;
                break;
            }
            case 4: {
                ++this.countUnreachable;
                break;
            }
            case 5: {
                ++this.countUpgradeNeeded;
            }
        }
        ++this.countTotal;
    }

    public void refresh(boolean bl) {
        if (this.checkBtn == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_DATAAGENT_BUTTON_DETAILS"));
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            this.link2detail.addActionListener(this);
            jPanel2.add(this.link2detail);
            this.checkBtn = new JButton(MessageLog.getMessageNoID("ADG0288L"));
            GuiUtil.setAccessible(this.checkBtn, this.checkBtn.getText(), this.checkBtn.getText());
            this.checkBtn.addActionListener(this);
            jPanel2.add(this.checkBtn);
            this.enableBtn = new JButton(MessageLog.getMessageNoID("ADG0289L"));
            GuiUtil.setAccessible(this.enableBtn, this.enableBtn.getText(), this.enableBtn.getText());
            this.enableBtn.addActionListener(this);
            jPanel2.add(this.enableBtn);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_DATAAGENT_NOTE"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
        }
        if (bl || this.tableModel == null) {
            this.getAgents();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            Object object;
            GComputer gComputer = null;
            NameList nameList = null;
            if (this.tableModel != null && this.tableModel.getNumRows() != 0 && this.table.getSelectedRows()[0] != -1 && (object = this.table.getSelectedRows()) != null && ((int[])object).length > 0) {
                int n = object[0];
                gComputer = (GComputer)this.tableModel.computers.get(n);
                nameList = (NameList)this.tableModel.agents.get(n);
            }
            if (actionEvent.getSource() == this.link2detail && gComputer != null) {
                AgentTreeNodesStore.getTreeNode(nameList, 2, null, true, false);
            } else if (actionEvent.getSource() == this.checkBtn && nameList != null) {
                object = new Request();
                ServerRequest.agentStatus((Request)object, nameList.nlID);
                GuiClient.doRequest(new AgentCheckRequestor(gComputer, nameList), (Request)object);
            } else if (actionEvent.getSource() == this.enableBtn && nameList != null) {
                object = new Request();
                ServerRequest.agentState((Request)object, new ComputerID(nameList.nlID), (byte)1);
                GuiClient.doRequest(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        if (s <= 4) {
                            DataAgentSection.this.refresh(true);
                        }
                    }
                }, (Request)object);
            }
        }
    }

    public void selectionChanged(boolean bl) {
        if (this.tableModel != null && this.tableModel.getNumRows() != 0) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                int n = nArray[0];
                GComputer cfr_ignored_0 = (GComputer)this.tableModel.computers.get(n);
                NameList nameList = (NameList)this.tableModel.agents.get(n);
                this.link2detail.setEnabled(true);
                this.checkBtn.setEnabled(true);
                if (nameList.nlState == 0) {
                    this.enableBtn.setEnabled(true);
                }
            } else {
                this.link2detail.setEnabled(false);
                this.checkBtn.setEnabled(false);
                this.enableBtn.setEnabled(false);
            }
        } else {
            this.link2detail.setEnabled(false);
            this.checkBtn.setEnabled(false);
            this.enableBtn.setEnabled(false);
        }
        if (!DataAgentSection.guiMain.getUserPrefs().administrator) {
            this.enableBtn.setEnabled(DataAgentSection.guiMain.getUserPrefs().administrator);
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    static /* synthetic */ IGuiMain access$0() {
        return ConfigSection.guiMain;
    }

    public class AgentCheckRequestor
    implements GuiRequestor {
        GComputer computer = null;
        NameList agent = null;

        public AgentCheckRequestor(GComputer gComputer, NameList nameList) {
            this.computer = gComputer;
            this.agent = nameList;
        }

        public void handleResponse(short s, Response response) {
            DataAgentSection.this.refresh(true);
            if (s <= 4) {
                String string = MessageLog.getMessageNoID("ADG0294M", this.computer.gcTSName);
                JOptionPane.showMessageDialog(DataAgentSection.access$0().getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
            }
        }
    }
}

