/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherGroup2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewSwitchL2Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2SwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibraryGroup2TapeLibrary;

public class GraphModelSwitchL2
extends GraphModel {
    private static final long serialVersionUID = 5031164395906604505L;
    public static final GraphScopedType COMPUTERGROUP = new GraphScopedType(GraphComputerGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType SUBSYSTEMGROUP = new GraphScopedType(GraphSubsystemGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType TAPELIBRARYGROUP = new GraphScopedType(GraphTapeLibraryGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType OTHERGROUP = new GraphScopedType(GraphOtherGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    private int portPerRow = 16;

    public GraphModelSwitchL2(ID iD) {
        super(iD);
    }

    protected void initGroupByCapabilities() {
        int n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_COMPUTERBYOS;
        Integer n2 = new Integer(n);
        this.groupByCapabilitiesH.put(COMPUTERGROUP, n2);
        n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        n2 = new Integer(n);
        this.groupByCapabilitiesH.put(SWGROUP, n2);
        n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SUBSYSTEMBYMODEL;
        n2 = new Integer(n);
        this.groupByCapabilitiesH.put(SUBSYSTEMGROUP, n2);
        n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        n2 = new Integer(n);
        this.groupByCapabilitiesH.put(TAPELIBRARYGROUP, n2);
        n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3;
        n2 = new Integer(n);
        this.groupByCapabilitiesH.put(OTHERGROUP, n2);
    }

    public void applyScope() {
        Object object = (GraphSwitch.ID)this.modelID.getFocusEntityID();
        GraphSwitch graphSwitch = (GraphSwitch)this.get((GraphEntity.ID)object);
        if (graphSwitch != null) {
            graphSwitch.addScope("Focus");
        }
        object = this.enumerate(GraphSwitch.TYPE);
        while (object.hasMoreElements()) {
            graphSwitch = (GraphSwitch)object.nextElement();
            GraphSwitch.ID iD = (GraphSwitch.ID)graphSwitch.getEntityID();
            if (!graphSwitch.containScope("Focus")) continue;
            Enumeration enumeration = this.associator(GraphSwitch2FCPort.TYPE, iD);
            while (enumeration.hasMoreElements()) {
                GraphFCPort graphFCPort = (GraphFCPort)enumeration.nextElement();
                graphFCPort.addScope("Focus");
            }
        }
    }

    public void applyPerfStatus() {
        Object object;
        Object object2;
        Comparable comparable;
        Object object3;
        Enumeration enumeration = this.enumerate(GraphSwitch.TYPE);
        while (enumeration.hasMoreElements()) {
            object3 = (GraphSwitch)enumeration.nextElement();
            comparable = (GraphSwitch.ID)((GraphEntity)object3).getEntityID();
            if (!((GraphEntity)object3).containScope("Focus") || !(object2 = this.associator(GraphSwitch2SwitchPerf.TYPE, (GraphEntity.ID)comparable)).hasMoreElements()) continue;
            object = (GraphSwitchPerf)object2.nextElement();
            ((GraphEntity)object3).setPerfStatus(((GraphEntity)object).getHealthStatus());
        }
        object3 = this.enumerate(GraphFCPort.TYPE);
        while (object3.hasMoreElements()) {
            comparable = (GraphFCPort)object3.nextElement();
            object2 = (GraphFCPort.ID)((GraphEntity)comparable).getEntityID();
            if (!((GraphEntity)comparable).containScope("Focus") || !(object = this.associator(GraphFCPort2SwitchFCPortPerf.TYPE, (GraphEntity.ID)object2)).hasMoreElements()) continue;
            GraphSwitchFCPortPerf graphSwitchFCPortPerf = (GraphSwitchFCPortPerf)object.nextElement();
            ((GraphEntity)comparable).setPerfStatus(graphSwitchFCPortPerf.getHealthStatus());
        }
    }

    public void applyGrouping(Hashtable hashtable) {
        this.groupFocus();
        this.groupSubviewConnectivityFCPortByPortNumber();
        this.groupSubviewConnectivityComputer(hashtable);
        this.groupSubviewConnectivitySwitch(hashtable);
        this.groupSubviewConnectivitySubsystem(hashtable);
        this.groupSubviewConnectivityTapeLibrary(hashtable);
        this.groupSubviewConnectivityOther(hashtable);
        this.groupSubviewConnectivity();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        GraphSwitch.ID iD = (GraphSwitch.ID)((ID)this.modelID).getFocusEntityID();
        String string = "Focus";
        GraphSwitchGroup graphSwitchGroup = new GraphSwitchGroup(string);
        GraphSwitchGroup.ID iD2 = (GraphSwitchGroup.ID)graphSwitchGroup.getEntityID();
        graphSwitchGroup.addScope("Focus");
        graphSwitchGroup.setIsHelper(Boolean.TRUE);
        this.put(graphSwitchGroup);
        GraphSwitchGroup2Switch graphSwitchGroup2Switch = new GraphSwitchGroup2Switch(iD2.getID() + "+" + iD.getID());
        graphSwitchGroup2Switch.setSwitchGroupID(iD2);
        graphSwitchGroup2Switch.setSwitchID(iD);
        this.put(graphSwitchGroup2Switch);
    }

    private void groupSubviewConnectivityFCPortByPortNumber() {
        Comparable comparable;
        Comparable<StringBuffer> comparable2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        this.removeAll(GraphFCPortGroup.TYPE);
        this.removeAll(GraphFCPortGroup2FCPort.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphFCPort.TYPE);
        while (enumeration.hasMoreElements()) {
            serializable = (GraphFCPort)enumeration.nextElement();
            if (!((GraphEntity)serializable).containScope("Focus")) continue;
            vector.add(serializable);
            object4 = null;
            try {
                object3 = ((GraphFCPort)serializable).getPortNumber();
                if (object3 != null) {
                    object4 = new Integer(Integer.parseInt((String)object3));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (object4 == null) continue;
            ((GraphEntity)serializable).setSortingValue((Comparable)object4);
        }
        Collections.sort(vector, GraphModelUtilities.DEFAULT_COMPARATOR);
        serializable = new Hashtable();
        object4 = new Vector();
        object3 = null;
        int n = 0;
        while (n < vector.size()) {
            if (object3 == null) {
                object3 = new Vector();
                ((Vector)object4).add(object3);
            }
            ((Vector)object3).add(vector.elementAt(n));
            if (((Vector)object3).size() == this.portPerRow) {
                object3 = null;
            }
            ++n;
        }
        n = 0;
        while (n < ((Vector)object4).size()) {
            object3 = (Vector)((Vector)object4).elementAt(n);
            object2 = (GraphFCPort)((Vector)object3).elementAt(0);
            object = (GraphFCPort)((Vector)object3).elementAt(((Vector)object3).size() - 1);
            comparable2 = new StringBuffer();
            ((StringBuffer)comparable2).append(((GraphFCPort)object2).getPortNumber() != null ? ((GraphFCPort)object2).getPortNumber() : ((GraphEntity)object2).getDisplayName());
            ((StringBuffer)comparable2).append("-");
            ((StringBuffer)comparable2).append(((GraphFCPort)object).getPortNumber() != null ? ((GraphFCPort)object).getPortNumber() : ((GraphEntity)object).getDisplayName());
            comparable = new GraphGroupKey();
            ((GraphGroupKey)comparable).addKey(new GraphGroupKey.Key(GuiUtil.getString("TOPO_LABEL_ATTR_FCPORT_PORTNUMBER"), new Integer(n), ((StringBuffer)comparable2).toString()));
            ((Hashtable)serializable).put(comparable, object3);
            ++n;
        }
        object4 = ((Hashtable)serializable).keys();
        while (object4.hasMoreElements()) {
            object3 = (GraphGroupKey)object4.nextElement();
            vector = (Vector)((Hashtable)serializable).get(object3);
            String string = ((GraphGroupKey)object3).getID();
            object2 = new GraphFCPortGroup(string);
            object = (GraphFCPortGroup.ID)((GraphEntity)object2).getEntityID();
            ((GraphEntity)object2).setDisplayName(((GraphGroupKey)object3).getLabel());
            ((GraphEntity)object2).setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            ((GraphFCPortGroup)object2).setPerfStatus(GraphModelUtilities.aggregatePerfStatus(vector));
            ((GraphEntity)object2).setSortingValue((Comparable)object3);
            ((GraphEntity)object2).setGroupKey((GraphGroupKey)object3);
            this.put((GraphEntity)object2);
            int n2 = 0;
            while (n2 < vector.size()) {
                comparable = (GraphFCPort)vector.elementAt(n2);
                GraphFCPort.ID iD = (GraphFCPort.ID)((GraphEntity)comparable).getEntityID();
                GraphFCPortGroup2FCPort graphFCPortGroup2FCPort = new GraphFCPortGroup2FCPort(((GraphEntity.ID)object).getID() + "+" + iD.getID());
                graphFCPortGroup2FCPort.setFCPortGroupID((GraphFCPortGroup.ID)object);
                graphFCPortGroup2FCPort.setFCPortID(iD);
                this.put(graphFCPortGroup2FCPort);
                ++n2;
            }
        }
        object3 = null;
        Integer n3 = null;
        object2 = this.enumerate(GraphFCPortGroup.TYPE);
        while (object2.hasMoreElements()) {
            object = (GraphFCPortGroup)object2.nextElement();
            GraphFCPortGroup.ID cfr_ignored_0 = (GraphFCPortGroup.ID)((GraphEntity)object).getEntityID();
            object3 = GraphModelUtilities.aggregateStatus((Integer)object3, ((GraphEntity)object).getHealthStatus());
            n3 = GraphModelUtilities.aggregateStatus(n3, ((GraphFCPortGroup)object).getPerfStatus());
        }
        object = "Root";
        comparable2 = new GraphFCPortGroup((String)object);
        GraphFCPortGroup.ID cfr_ignored_1 = (GraphFCPortGroup.ID)((GraphEntity)comparable2).getEntityID();
        ((GraphEntity)comparable2).addScope("Root");
        ((GraphEntity)comparable2).setDisplayName(GuiUtil.getString("TOPO_LABEL_GROUPING_ALL"));
        ((GraphEntity)comparable2).setHealthStatus((Integer)object3);
        ((GraphFCPortGroup)comparable2).setPerfStatus(n3);
        this.put((GraphEntity)comparable2);
    }

    private void groupSubviewConnectivityComputer(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphComputerGroup.TYPE);
        this.removeAll(GraphComputerGroup2Computer.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphComputer.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphComputer)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(COMPUTERGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphComputerGroup graphComputerGroup = new GraphComputerGroup(string);
            GraphComputerGroup.ID iD = (GraphComputerGroup.ID)graphComputerGroup.getEntityID();
            graphComputerGroup.setDisplayName(graphGroupKey.getLabel());
            graphComputerGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphComputerGroup.setSortingValue(graphGroupKey);
            graphComputerGroup.setGroupKey(graphGroupKey);
            this.put(graphComputerGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphComputer graphComputer = (GraphComputer)vector.elementAt(n);
                GraphComputer.ID iD2 = (GraphComputer.ID)graphComputer.getEntityID();
                GraphComputerGroup2Computer graphComputerGroup2Computer = new GraphComputerGroup2Computer(iD.getID() + "+" + iD2.getID());
                graphComputerGroup2Computer.setComputerGroupID(iD);
                graphComputerGroup2Computer.setComputerID(iD2);
                this.put(graphComputerGroup2Computer);
                ++n;
            }
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable hashtable) {
        Object object;
        Comparable comparable;
        Comparable comparable2;
        Object object2;
        Vector vector = new Vector();
        Object object3 = new Vector<GraphSwitchGroup2Switch.ID>();
        Object object4 = this.enumerate(GraphSwitchGroup.TYPE);
        while (object4.hasMoreElements()) {
            object2 = (GraphSwitchGroup)object4.nextElement();
            if (((GraphEntity)object2).containScope("Focus")) continue;
            comparable2 = (GraphSwitchGroup.ID)((GraphEntity)object2).getEntityID();
            vector.add(comparable2);
        }
        object2 = this.enumerate(GraphSwitchGroup2Switch.TYPE);
        while (object2.hasMoreElements()) {
            comparable2 = (GraphSwitchGroup2Switch)object2.nextElement();
            comparable = ((GraphSwitchGroup2Switch)comparable2).getSwitchGroupID();
            if (!vector.contains(comparable)) continue;
            object = (GraphSwitchGroup2Switch.ID)((GraphEntity)comparable2).getEntityID();
            ((Vector)object3).add(object);
        }
        int n = 0;
        while (n < vector.size()) {
            comparable = (GraphSwitchGroup.ID)vector.elementAt(n);
            this.remove((GraphEntity.ID)comparable);
            ++n;
        }
        n = 0;
        while (n < ((Vector)object3).size()) {
            comparable = (GraphSwitchGroup2Switch.ID)((Vector)object3).elementAt(n);
            this.remove((GraphEntity.ID)comparable);
            ++n;
        }
        vector = new Vector();
        object3 = this.enumerate(GraphSwitch.TYPE);
        while (object3.hasMoreElements()) {
            object4 = (GraphSwitch)object3.nextElement();
            if (((GraphEntity)object4).containScope("Focus")) continue;
            vector.add(object4);
        }
        object4 = (Integer)hashtable.get(SWGROUP);
        object2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)object4, this);
        Enumeration enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            comparable = (GraphGroupKey)enumeration.nextElement();
            vector = (Vector)((Hashtable)object2).get(comparable);
            object = ((GraphGroupKey)comparable).getID();
            GraphSwitchGroup graphSwitchGroup = new GraphSwitchGroup((String)object);
            GraphSwitchGroup.ID iD = (GraphSwitchGroup.ID)graphSwitchGroup.getEntityID();
            graphSwitchGroup.setDisplayName(((GraphGroupKey)comparable).getLabel());
            graphSwitchGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphSwitchGroup.setSortingValue(comparable);
            graphSwitchGroup.setGroupKey((GraphGroupKey)comparable);
            this.put(graphSwitchGroup);
            int n2 = 0;
            while (n2 < vector.size()) {
                GraphSwitch graphSwitch = (GraphSwitch)vector.elementAt(n2);
                GraphSwitch.ID iD2 = (GraphSwitch.ID)graphSwitch.getEntityID();
                GraphSwitchGroup2Switch graphSwitchGroup2Switch = new GraphSwitchGroup2Switch(iD.getID() + "+" + iD2.getID());
                graphSwitchGroup2Switch.setSwitchGroupID(iD);
                graphSwitchGroup2Switch.setSwitchID(iD2);
                this.put(graphSwitchGroup2Switch);
                ++n2;
            }
        }
    }

    private void groupSubviewConnectivitySubsystem(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphSubsystemGroup.TYPE);
        this.removeAll(GraphSubsystemGroup2Subsystem.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphSubsystem.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphSubsystem)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(SUBSYSTEMGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphSubsystemGroup graphSubsystemGroup = new GraphSubsystemGroup(string);
            GraphSubsystemGroup.ID iD = (GraphSubsystemGroup.ID)graphSubsystemGroup.getEntityID();
            graphSubsystemGroup.setDisplayName(graphGroupKey.getLabel());
            graphSubsystemGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphSubsystemGroup.setSortingValue(graphGroupKey);
            graphSubsystemGroup.setGroupKey(graphGroupKey);
            this.put(graphSubsystemGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphSubsystem graphSubsystem = (GraphSubsystem)vector.elementAt(n);
                GraphSubsystem.ID iD2 = (GraphSubsystem.ID)graphSubsystem.getEntityID();
                GraphSubsystemGroup2Subsystem graphSubsystemGroup2Subsystem = new GraphSubsystemGroup2Subsystem(iD.getID() + "+" + iD2.getID());
                graphSubsystemGroup2Subsystem.setSubsystemGroupID(iD);
                graphSubsystemGroup2Subsystem.setSubsystemID(iD2);
                this.put(graphSubsystemGroup2Subsystem);
                ++n;
            }
        }
    }

    private void groupSubviewConnectivityTapeLibrary(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphTapeLibraryGroup.TYPE);
        this.removeAll(GraphTapeLibraryGroup2TapeLibrary.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphTapeLibrary.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphTapeLibrary)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(TAPELIBRARYGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphTapeLibraryGroup graphTapeLibraryGroup = new GraphTapeLibraryGroup(string);
            GraphTapeLibraryGroup.ID iD = (GraphTapeLibraryGroup.ID)graphTapeLibraryGroup.getEntityID();
            graphTapeLibraryGroup.setDisplayName(graphGroupKey.getLabel());
            graphTapeLibraryGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphTapeLibraryGroup.setSortingValue(graphGroupKey);
            graphTapeLibraryGroup.setGroupKey(graphGroupKey);
            this.put(graphTapeLibraryGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)vector.elementAt(n);
                GraphTapeLibrary.ID iD2 = (GraphTapeLibrary.ID)graphTapeLibrary.getEntityID();
                GraphTapeLibraryGroup2TapeLibrary graphTapeLibraryGroup2TapeLibrary = new GraphTapeLibraryGroup2TapeLibrary(iD.getID() + "+" + iD2.getID());
                graphTapeLibraryGroup2TapeLibrary.setTapeLibraryGroupID(iD);
                graphTapeLibraryGroup2TapeLibrary.setTapeLibraryID(iD2);
                this.put(graphTapeLibraryGroup2TapeLibrary);
                ++n;
            }
        }
    }

    private void groupSubviewConnectivityOther(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphOtherGroup.TYPE);
        this.removeAll(GraphOtherGroup2Other.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphOther.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphOther)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(OTHERGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphOtherGroup graphOtherGroup = new GraphOtherGroup(string);
            GraphOtherGroup.ID iD = (GraphOtherGroup.ID)graphOtherGroup.getEntityID();
            graphOtherGroup.setDisplayName(graphGroupKey.getLabel());
            graphOtherGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphOtherGroup.setSortingValue(graphGroupKey);
            graphOtherGroup.setGroupKey(graphGroupKey);
            this.put(graphOtherGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphOther graphOther = (GraphOther)vector.elementAt(n);
                GraphOther.ID iD2 = (GraphOther.ID)graphOther.getEntityID();
                GraphOtherGroup2Other graphOtherGroup2Other = new GraphOtherGroup2Other(iD.getID() + "+" + iD2.getID());
                graphOtherGroup2Other.setOtherGroupID(iD);
                graphOtherGroup2Other.setOtherID(iD2);
                this.put(graphOtherGroup2Other);
                ++n;
            }
        }
    }

    private void groupSubviewConnectivity() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        GraphSubviewSwitchL2Connectivity graphSubviewSwitchL2Connectivity = new GraphSubviewSwitchL2Connectivity("Connectivity");
        GraphSubviewSwitchL2Connectivity.ID cfr_ignored_0 = (GraphSubviewSwitchL2Connectivity.ID)graphSubviewSwitchL2Connectivity.getEntityID();
        graphSubviewSwitchL2Connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(graphSubviewSwitchL2Connectivity);
        Enumeration enumeration = this.enumerate(GraphFCPortGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            object5 = (GraphFCPortGroup)enumeration.nextElement();
            if (!((GraphEntity)object5).containScope("Root")) continue;
            graphSubviewSwitchL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewSwitchL2Connectivity.getHealthStatus(), ((GraphEntity)object5).getHealthStatus()));
        }
        object5 = this.enumerate(GraphComputerGroup.TYPE);
        while (object5.hasMoreElements()) {
            object4 = (GraphComputerGroup)object5.nextElement();
            graphSubviewSwitchL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewSwitchL2Connectivity.getHealthStatus(), ((GraphEntity)object4).getHealthStatus()));
        }
        object4 = this.enumerate(GraphSwitchGroup.TYPE);
        while (object4.hasMoreElements()) {
            object3 = (GraphSwitchGroup)object4.nextElement();
            if (((GraphEntity)object3).containScope("Focus")) continue;
            graphSubviewSwitchL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewSwitchL2Connectivity.getHealthStatus(), ((GraphEntity)object3).getHealthStatus()));
        }
        object3 = this.enumerate(GraphSubsystemGroup.TYPE);
        while (object3.hasMoreElements()) {
            object2 = (GraphSubsystemGroup)object3.nextElement();
            graphSubviewSwitchL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewSwitchL2Connectivity.getHealthStatus(), ((GraphEntity)object2).getHealthStatus()));
        }
        object2 = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (object2.hasMoreElements()) {
            object = (GraphTapeLibraryGroup)object2.nextElement();
            graphSubviewSwitchL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewSwitchL2Connectivity.getHealthStatus(), ((GraphEntity)object).getHealthStatus()));
        }
        object = this.enumerate(GraphOtherGroup.TYPE);
        while (object.hasMoreElements()) {
            GraphOtherGroup graphOtherGroup = (GraphOtherGroup)object.nextElement();
            graphSubviewSwitchL2Connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(graphSubviewSwitchL2Connectivity.getHealthStatus(), graphOtherGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int n) {
        Object object;
        GraphFCPort.ID iD;
        GraphFCPort2FCPort graphFCPort2FCPort;
        Comparable<Boolean> comparable;
        Enumeration enumeration;
        Object object2;
        Comparable comparable2;
        Object object3;
        int n2;
        Object object4;
        GraphEntity.ID iD2;
        GraphEntity graphEntity;
        Enumeration enumeration2 = this.enumerate(GraphSwitchGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphSwitchGroup)enumeration2.nextElement();
            iD2 = (GraphSwitchGroup.ID)graphEntity.getEntityID();
            if (!graphEntity.containScope("Focus")) continue;
            Enumeration enumeration3 = this.associator(GraphSwitchGroup2Switch.TYPE, iD2);
            while (enumeration3.hasMoreElements()) {
                object4 = (GraphSwitch)enumeration3.nextElement();
                ((GraphEntity)object4).setIsFilterable(Boolean.FALSE);
            }
            graphEntity.setIsFilterable(Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphFCPortGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphFCPortGroup)enumeration2.nextElement();
            iD2 = (GraphFCPortGroup.ID)graphEntity.getEntityID();
            if (graphEntity.containScope("Root")) continue;
            int n3 = 0;
            int n4 = 0;
            n2 = 0;
            int n5 = 0;
            object3 = this.associator(GraphFCPortGroup2FCPort.TYPE, iD2);
            while (object3.hasMoreElements()) {
                comparable2 = (GraphFCPort)object3.nextElement();
                object2 = (GraphFCPort.ID)((GraphEntity)comparable2).getEntityID();
                enumeration = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object2);
                if (enumeration.hasMoreElements()) {
                    ++n3;
                    if (n == 0) {
                        comparable = Boolean.FALSE;
                    } else if (GraphModelUtilities.isAbnormal((GraphEntity)comparable2)) {
                        comparable = Boolean.FALSE;
                    } else {
                        comparable = Boolean.TRUE;
                        if (n == 1) {
                            Object object5;
                            Object object6;
                            Object object7;
                            Object object8;
                            graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphFCPort2FCPort)) {
                                comparable = Boolean.FALSE;
                            }
                            if ((iD = graphFCPort2FCPort.getFCPort1ID()).equals(object2)) {
                                iD = graphFCPort2FCPort.getFCPort2ID();
                            }
                            if ((object = this.associator(GraphSwitch2FCPort.TYPE, iD)).hasMoreElements() && GraphModelUtilities.isAbnormal((GraphEntity)(object8 = (GraphSwitch)object.nextElement()))) {
                                comparable = Boolean.FALSE;
                            }
                            if ((object8 = this.associator(GraphComputer2FCPort.TYPE, iD)).hasMoreElements() && GraphModelUtilities.isAbnormal((GraphEntity)(object7 = (GraphComputer)object8.nextElement()))) {
                                comparable = Boolean.FALSE;
                            }
                            if ((object7 = this.associator(GraphSubsystem2FCPort.TYPE, iD)).hasMoreElements() && GraphModelUtilities.isAbnormal((GraphEntity)(object6 = (GraphSubsystem)object7.nextElement()))) {
                                comparable = Boolean.FALSE;
                            }
                            if ((object6 = this.associator(GraphTapeLibrary2FCPort.TYPE, iD)).hasMoreElements() && GraphModelUtilities.isAbnormal((GraphEntity)(object5 = (GraphTapeLibrary)object6.nextElement()))) {
                                comparable = Boolean.FALSE;
                            }
                            object5 = this.associator(GraphOther2FCPort.TYPE, iD);
                            while (object5.hasMoreElements()) {
                                GraphOther graphOther = (GraphOther)object5.nextElement();
                                if (!GraphModelUtilities.isAbnormal(graphOther)) continue;
                                comparable = Boolean.FALSE;
                            }
                        }
                    }
                    if (!comparable.booleanValue()) {
                        ++n4;
                    }
                } else {
                    ++n2;
                    comparable = n == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal((GraphEntity)comparable2) ? Boolean.FALSE : Boolean.TRUE);
                    if (!comparable.booleanValue()) {
                        ++n5;
                    }
                }
                ((GraphEntity)comparable2).setIsFilterable((Boolean)comparable);
            }
            ((GraphFCPortGroup)graphEntity).setNumOfFCPortsInUse(new Integer(n3));
            ((GraphFCPortGroup)graphEntity).setNumOfAbnormalFCPortsInUse(new Integer(n4));
            ((GraphFCPortGroup)graphEntity).setNumOfFCPortsEmpty(new Integer(n2));
            ((GraphFCPortGroup)graphEntity).setNumOfAbnormalFCPortsEmpty(new Integer(n5));
            graphEntity.setIsFilterable(n4 + n5 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphFCPortGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphFCPortGroup)enumeration2.nextElement();
            GraphFCPortGroup.ID cfr_ignored_0 = (GraphFCPortGroup.ID)graphEntity.getEntityID();
            if (!graphEntity.containScope("Root")) continue;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            n2 = 0;
            Enumeration enumeration4 = this.enumerate(GraphFCPortGroup.TYPE);
            while (enumeration4.hasMoreElements()) {
                object3 = (GraphFCPortGroup)enumeration4.nextElement();
                GraphFCPortGroup.ID cfr_ignored_1 = (GraphFCPortGroup.ID)((GraphEntity)object3).getEntityID();
                if (((GraphEntity)object3).containScope("Root")) continue;
                n6 += ((GraphFCPortGroup)object3).getNumOfFCPortsInUse().intValue();
                n7 += ((GraphFCPortGroup)object3).getNumOfAbnormalFCPortsInUse().intValue();
                n8 += ((GraphFCPortGroup)object3).getNumOfFCPortsEmpty().intValue();
                n2 += ((GraphFCPortGroup)object3).getNumOfAbnormalFCPortsEmpty().intValue();
            }
            ((GraphFCPortGroup)graphEntity).setNumOfFCPortsInUse(new Integer(n6));
            ((GraphFCPortGroup)graphEntity).setNumOfAbnormalFCPortsInUse(new Integer(n7));
            ((GraphFCPortGroup)graphEntity).setNumOfFCPortsEmpty(new Integer(n8));
            ((GraphFCPortGroup)graphEntity).setNumOfAbnormalFCPortsEmpty(new Integer(n2));
            graphEntity.setIsFilterable(n7 + n2 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphSwitchGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphSwitchGroup)enumeration2.nextElement();
            GraphSwitchGroup.ID iD3 = (GraphSwitchGroup.ID)graphEntity.getEntityID();
            if (graphEntity.containScope("Focus")) continue;
            int n9 = 0;
            int n10 = 0;
            Enumeration enumeration5 = this.associator(GraphSwitchGroup2Switch.TYPE, iD3);
            while (enumeration5.hasMoreElements()) {
                GraphSwitch graphSwitch = (GraphSwitch)enumeration5.nextElement();
                object3 = (GraphSwitch.ID)graphSwitch.getEntityID();
                ++n9;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphSwitch)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object2 = this.associatorID(GraphSwitch2FCPort.TYPE, (GraphEntity.ID)object3);
                        while (object2.hasMoreElements()) {
                            comparable = (GraphFCPort.ID)object2.nextElement();
                            enumeration = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)comparable);
                            if (!enumeration.hasMoreElements()) continue;
                            graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphFCPort2FCPort)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            iD = graphFCPort2FCPort.getFCPort1ID();
                            if (iD.equals(comparable)) {
                                iD = graphFCPort2FCPort.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal((GraphEntity)(object = (GraphFCPort)this.get(iD)))) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphSwitch.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n10;
            }
            ((GraphSwitchGroup)graphEntity).setNumOfSwitches(new Integer(n9));
            ((GraphSwitchGroup)graphEntity).setNumOfAbnormalSwitches(new Integer(n10));
            graphEntity.setIsFilterable(n10 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphComputerGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphComputerGroup)enumeration2.nextElement();
            GraphComputerGroup.ID iD4 = (GraphComputerGroup.ID)graphEntity.getEntityID();
            int n11 = 0;
            int n12 = 0;
            Enumeration enumeration6 = this.associator(GraphComputerGroup2Computer.TYPE, iD4);
            while (enumeration6.hasMoreElements()) {
                GraphComputer graphComputer = (GraphComputer)enumeration6.nextElement();
                object3 = (GraphComputer.ID)graphComputer.getEntityID();
                ++n11;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphComputer)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object2 = this.associatorID(GraphComputer2FCPort.TYPE, (GraphEntity.ID)object3);
                        while (object2.hasMoreElements()) {
                            comparable = (GraphFCPort.ID)object2.nextElement();
                            enumeration = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)comparable);
                            if (!enumeration.hasMoreElements()) continue;
                            graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphFCPort2FCPort)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            iD = graphFCPort2FCPort.getFCPort1ID();
                            if (iD.equals(comparable)) {
                                iD = graphFCPort2FCPort.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal((GraphEntity)(object = (GraphFCPort)this.get(iD)))) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphComputer.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n12;
            }
            ((GraphComputerGroup)graphEntity).setNumOfComputers(new Integer(n11));
            ((GraphComputerGroup)graphEntity).setNumOfAbnormalComputers(new Integer(n12));
            graphEntity.setIsFilterable(n12 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphSubsystemGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphSubsystemGroup)enumeration2.nextElement();
            GraphSubsystemGroup.ID iD5 = (GraphSubsystemGroup.ID)graphEntity.getEntityID();
            int n13 = 0;
            int n14 = 0;
            Enumeration enumeration7 = this.associator(GraphSubsystemGroup2Subsystem.TYPE, iD5);
            while (enumeration7.hasMoreElements()) {
                GraphSubsystem graphSubsystem = (GraphSubsystem)enumeration7.nextElement();
                object3 = (GraphSubsystem.ID)graphSubsystem.getEntityID();
                ++n13;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphSubsystem)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object2 = this.associatorID(GraphSubsystem2FCPort.TYPE, (GraphEntity.ID)object3);
                        while (object2.hasMoreElements()) {
                            comparable = (GraphFCPort.ID)object2.nextElement();
                            enumeration = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)comparable);
                            if (!enumeration.hasMoreElements()) continue;
                            graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphFCPort2FCPort)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            iD = graphFCPort2FCPort.getFCPort1ID();
                            if (iD.equals(comparable)) {
                                iD = graphFCPort2FCPort.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal((GraphEntity)(object = (GraphFCPort)this.get(iD)))) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphSubsystem.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n14;
            }
            ((GraphSubsystemGroup)graphEntity).setNumOfSubsystems(new Integer(n13));
            ((GraphSubsystemGroup)graphEntity).setNumOfAbnormalSubsystems(new Integer(n14));
            graphEntity.setIsFilterable(n14 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphTapeLibraryGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphTapeLibraryGroup)enumeration2.nextElement();
            GraphTapeLibraryGroup.ID iD6 = (GraphTapeLibraryGroup.ID)graphEntity.getEntityID();
            int n15 = 0;
            int n16 = 0;
            Enumeration enumeration8 = this.associator(GraphTapeLibraryGroup2TapeLibrary.TYPE, iD6);
            while (enumeration8.hasMoreElements()) {
                GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)enumeration8.nextElement();
                object3 = (GraphTapeLibrary.ID)graphTapeLibrary.getEntityID();
                ++n15;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphTapeLibrary)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object2 = this.associatorID(GraphTapeLibrary2FCPort.TYPE, (GraphEntity.ID)object3);
                        while (object2.hasMoreElements()) {
                            comparable = (GraphFCPort.ID)object2.nextElement();
                            enumeration = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)comparable);
                            if (!enumeration.hasMoreElements()) continue;
                            graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphFCPort2FCPort)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            iD = graphFCPort2FCPort.getFCPort1ID();
                            if (iD.equals(comparable)) {
                                iD = graphFCPort2FCPort.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal((GraphEntity)(object = (GraphFCPort)this.get(iD)))) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphTapeLibrary.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n16;
            }
            ((GraphTapeLibraryGroup)graphEntity).setNumOfTapeLibraries(new Integer(n15));
            ((GraphTapeLibraryGroup)graphEntity).setNumOfAbnormalTapeLibraries(new Integer(n16));
            graphEntity.setIsFilterable(n16 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphOtherGroup.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphOtherGroup)enumeration2.nextElement();
            GraphOtherGroup.ID iD7 = (GraphOtherGroup.ID)graphEntity.getEntityID();
            int n17 = 0;
            int n18 = 0;
            Enumeration enumeration9 = this.associator(GraphOtherGroup2Other.TYPE, iD7);
            while (enumeration9.hasMoreElements()) {
                GraphOther graphOther = (GraphOther)enumeration9.nextElement();
                object3 = (GraphOther.ID)graphOther.getEntityID();
                ++n17;
                if (n == 0) {
                    comparable2 = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(graphOther)) {
                    comparable2 = Boolean.FALSE;
                } else {
                    comparable2 = Boolean.TRUE;
                    if (n == 1) {
                        object2 = this.associatorID(GraphOther2FCPort.TYPE, (GraphEntity.ID)object3);
                        while (object2.hasMoreElements()) {
                            comparable = (GraphFCPort.ID)object2.nextElement();
                            enumeration = this.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)comparable);
                            if (!enumeration.hasMoreElements()) continue;
                            graphFCPort2FCPort = (GraphFCPort2FCPort)enumeration.nextElement();
                            if (GraphModelUtilities.isAbnormal(graphFCPort2FCPort)) {
                                comparable2 = Boolean.FALSE;
                                break;
                            }
                            iD = graphFCPort2FCPort.getFCPort1ID();
                            if (iD.equals(comparable)) {
                                iD = graphFCPort2FCPort.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal((GraphEntity)(object = (GraphFCPort)this.get(iD)))) continue;
                            comparable2 = Boolean.FALSE;
                            break;
                        }
                    }
                }
                graphOther.setIsFilterable((Boolean)comparable2);
                if (((Boolean)comparable2).booleanValue()) continue;
                ++n18;
            }
            ((GraphOtherGroup)graphEntity).setNumOfOthers(new Integer(n17));
            ((GraphOtherGroup)graphEntity).setNumOfAbnormalOthers(new Integer(n18));
            graphEntity.setIsFilterable(n18 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        enumeration2 = this.enumerate(GraphSubviewSwitchL2Connectivity.TYPE);
        while (enumeration2.hasMoreElements()) {
            graphEntity = (GraphSubviewSwitchL2Connectivity)enumeration2.nextElement();
            int n19 = 0;
            int n20 = 0;
            object4 = this.enumerate(GraphFCPortGroup.TYPE);
            while (object4.hasMoreElements()) {
                GraphFCPortGroup graphFCPortGroup = (GraphFCPortGroup)object4.nextElement();
                if (!graphFCPortGroup.containScope("Root")) continue;
                n19 += graphFCPortGroup.getNumOfFCPortsInUse() + graphFCPortGroup.getNumOfFCPortsEmpty();
                n20 += graphFCPortGroup.getNumOfAbnormalFCPortsInUse() + graphFCPortGroup.getNumOfAbnormalFCPortsEmpty();
            }
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfFCPorts(new Integer(n19));
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfAbnormalFCPorts(new Integer(n20));
            n19 = 0;
            n20 = 0;
            object4 = this.enumerate(GraphSwitchGroup.TYPE);
            while (object4.hasMoreElements()) {
                GraphSwitchGroup graphSwitchGroup = (GraphSwitchGroup)object4.nextElement();
                if (graphSwitchGroup.containScope("Focus")) continue;
                n19 += graphSwitchGroup.getNumOfSwitches().intValue();
                n20 += graphSwitchGroup.getNumOfAbnormalSwitches().intValue();
            }
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfSwitches(new Integer(n19));
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfAbnormalSwitches(new Integer(n20));
            n19 = 0;
            n20 = 0;
            object4 = this.enumerate(GraphComputerGroup.TYPE);
            while (object4.hasMoreElements()) {
                GraphComputerGroup graphComputerGroup = (GraphComputerGroup)object4.nextElement();
                n19 += graphComputerGroup.getNumOfComputers().intValue();
                n20 += graphComputerGroup.getNumOfAbnormalComputers().intValue();
            }
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfComputers(new Integer(n19));
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfAbnormalComputers(new Integer(n20));
            n19 = 0;
            n20 = 0;
            object4 = this.enumerate(GraphSubsystemGroup.TYPE);
            while (object4.hasMoreElements()) {
                GraphSubsystemGroup graphSubsystemGroup = (GraphSubsystemGroup)object4.nextElement();
                n19 += graphSubsystemGroup.getNumOfSubsystems().intValue();
                n20 += graphSubsystemGroup.getNumOfAbnormalSubsystems().intValue();
            }
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfSubsystems(new Integer(n19));
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfAbnormalSubsystems(new Integer(n20));
            n19 = 0;
            n20 = 0;
            object4 = this.enumerate(GraphTapeLibraryGroup.TYPE);
            while (object4.hasMoreElements()) {
                GraphTapeLibraryGroup graphTapeLibraryGroup = (GraphTapeLibraryGroup)object4.nextElement();
                n19 += graphTapeLibraryGroup.getNumOfTapeLibraries().intValue();
                n20 += graphTapeLibraryGroup.getNumOfAbnormalTapeLibraries().intValue();
            }
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfTapeLibraries(new Integer(n19));
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfAbnormalTapeLibraries(new Integer(n20));
            n19 = 0;
            n20 = 0;
            object4 = this.enumerate(GraphOtherGroup.TYPE);
            while (object4.hasMoreElements()) {
                GraphOtherGroup graphOtherGroup = (GraphOtherGroup)object4.nextElement();
                n19 += graphOtherGroup.getNumOfOthers().intValue();
                n20 += graphOtherGroup.getNumOfAbnormalOthers().intValue();
            }
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfOthers(new Integer(n19));
            ((GraphSubviewSwitchL2Connectivity)graphEntity).setNumOfAbnormalOthers(new Integer(n20));
            graphEntity.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        private static final long serialVersionUID = 1436420476148908415L;

        public ID(GraphSwitch graphSwitch) {
            super("SwitchL2", graphSwitch.getEntityID());
        }
    }
}

