/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class JTopoDialogGlobalSetting
extends JDialog {
    private JCheckBox healthCB;
    private JCheckBox perfCB;
    private JCheckBox policyCB;
    private JCheckBox filteringCB;
    private JCheckBox filteringCondCB;
    private JCheckBox connCB;
    private JCheckBox zoneCB;

    public JTopoDialogGlobalSetting(Frame frame, ControllerApp controllerApp) {
        super(frame, GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_TITLE"), true);
        TopoSetting topoSetting = controllerApp.getTopoSetting();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.setResizable(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        TopoLayoutUtilities.VerticalLayout verticalLayout = new TopoLayoutUtilities.VerticalLayout();
        jPanel2.setLayout(verticalLayout);
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY"));
        jLabel.setBorder(new EmptyBorder(10, 2, 2, 2));
        jPanel2.add(jLabel);
        this.healthCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY_HEALTH"), topoSetting.isOverlayHealthEnabled());
        this.healthCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.healthCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JTopoDialogGlobalSetting.this.healthCB.isSelected()) {
                    JTopoDialogGlobalSetting.this.filteringCB.setEnabled(true);
                    if (JTopoDialogGlobalSetting.this.filteringCB.isSelected()) {
                        JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(true);
                    } else {
                        JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(false);
                    }
                } else {
                    JTopoDialogGlobalSetting.this.filteringCB.setEnabled(false);
                    JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(false);
                }
            }
        });
        jPanel2.add(this.healthCB);
        this.perfCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY_PERF"), topoSetting.isOverlayPerfEnabled());
        this.perfCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.perfCB.setVisible(false);
        jPanel2.add(this.perfCB);
        this.policyCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_OVERLAY_POLICY"));
        this.policyCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.policyCB.setEnabled(false);
        JLabel jLabel2 = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_FILTERING"));
        jLabel2.setBorder(new EmptyBorder(10, 2, 2, 2));
        jPanel2.add(jLabel2);
        int n = topoSetting.getFilteringLevel();
        this.filteringCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_FILTERING_NORMAL"), n != 0);
        this.filteringCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        this.filteringCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JTopoDialogGlobalSetting.this.filteringCB.isSelected()) {
                    JTopoDialogGlobalSetting.this.healthCB.setEnabled(false);
                    JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(true);
                } else {
                    JTopoDialogGlobalSetting.this.healthCB.setEnabled(true);
                    JTopoDialogGlobalSetting.this.filteringCondCB.setEnabled(false);
                }
            }
        });
        jPanel2.add(this.filteringCB);
        this.filteringCondCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_FILTERING_NORMAL_LESS"), n == 1);
        this.filteringCondCB.setBorder(new EmptyBorder(2, 40, 2, 2));
        jPanel2.add(this.filteringCondCB);
        if (!this.healthCB.isSelected()) {
            this.filteringCB.setEnabled(false);
            this.filteringCondCB.setEnabled(false);
        }
        if (this.filteringCB.isSelected()) {
            this.healthCB.setEnabled(false);
        }
        if (!this.filteringCB.isSelected()) {
            this.filteringCondCB.setEnabled(false);
        }
        JLabel jLabel3 = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_CONN"));
        jLabel3.setBorder(new EmptyBorder(10, 2, 2, 2));
        jPanel2.add(jLabel3);
        this.connCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_CONN_SHOW"), topoSetting.isShowConnectionEnabled());
        this.connCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        jPanel2.add(this.connCB);
        JLabel jLabel4 = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_ZONE"));
        jLabel4.setBorder(new EmptyBorder(10, 2, 2, 2));
        jPanel2.add(jLabel4);
        this.zoneCB = new JCheckBox(GuiUtil.getString("TOPO_LABEL_DIALOG_SETTING_ZONE_SHOW"), topoSetting.isShowZoneEnabled());
        this.zoneCB.setBorder(new EmptyBorder(2, 20, 2, 2));
        jPanel2.add(this.zoneCB);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(10, 2, 2, 2));
        TopoLayoutUtilities.HorizontalLayout horizontalLayout = new TopoLayoutUtilities.HorizontalLayout();
        horizontalLayout.setHorizontalJustify(4);
        jPanel3.setLayout(horizontalLayout);
        jPanel.add((Component)jPanel3, "South");
        JButton jButton = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_OK"));
        jButton.addActionListener(new PostAction(controllerApp));
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTopoDialogGlobalSetting.this.dispose();
            }
        });
        jPanel3.add(jButton2);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private class PostAction
    implements ActionListener {
        private ControllerApp controllerApp;

        public PostAction(ControllerApp controllerApp) {
            this.controllerApp = controllerApp;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            TopoSetting topoSetting = this.controllerApp.getTopoSetting();
            boolean bl2 = JTopoDialogGlobalSetting.this.healthCB.isSelected();
            if (bl2 != topoSetting.isOverlayHealthEnabled()) {
                topoSetting.setOverlayHealthEnabled(bl2);
                this.controllerApp.setOverlayHealthEnabled(bl2);
                bl = true;
            }
            if ((bl2 = JTopoDialogGlobalSetting.this.perfCB.isSelected()) != topoSetting.isOverlayPerfEnabled()) {
                topoSetting.setOverlayPerfEnabled(bl2);
                this.controllerApp.setOverlayPerfEnabled(bl2);
                bl = true;
            }
            int n = JTopoDialogGlobalSetting.this.filteringCB.isSelected() ? (JTopoDialogGlobalSetting.this.filteringCondCB.isSelected() ? 1 : 2) : 0;
            if (n != topoSetting.getFilteringLevel()) {
                topoSetting.setFilteringLevel(n);
                this.controllerApp.setFilteringLevel(n);
                bl = true;
            }
            if ((bl2 = JTopoDialogGlobalSetting.this.connCB.isSelected()) != topoSetting.isShowConnectionEnabled()) {
                topoSetting.setShowConnectionEnabled(bl2);
                this.controllerApp.setShowConnectionEnabled(bl2);
                bl = true;
            }
            if ((bl2 = JTopoDialogGlobalSetting.this.zoneCB.isSelected()) != topoSetting.isShowZoneEnabled()) {
                topoSetting.setShowZoneEnabled(bl2);
                this.controllerApp.setShowZoneEnabled(bl2);
                bl = true;
            }
            JTopoDialogGlobalSetting.this.dispose();
            if (bl) {
                this.controllerApp.getBackend().persistTopoSettings(topoSetting);
            }
        }
    }
}

