/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewOtherL2Device;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxLunGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxVolumeGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewOtherL2Device
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewOtherL2Device graphSubviewOtherL2Device = (GraphSubviewOtherL2Device)this.focusEntity;
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.setType(graphSubviewOtherL2Device.getDisplayName());
        iTopoGroupModel.setLabel(graphSubviewOtherL2Device.getDisplayName());
        iTopoGroupModel.setHealth(graphSubviewOtherL2Device.getHealthStatus());
        iTopoGroupModel.setIconSelected(TopoResource.ICON_VOLUMEGROUP_16_SELECTED);
        iTopoGroupModel.setIconUnselected(TopoResource.ICON_VOLUMEGROUP_16_UNSELECTED);
        iTopoGroupModel.setIconMissing(TopoResource.ICON_VOLUMEGROUP_16_MISSING);
        iTopoGroupModel.removeAllSummaries();
        int n = graphSubviewOtherL2Device.getNumOfLuns();
        int n2 = graphSubviewOtherL2Device.getNumOfAbnormalLuns();
        iTopoGroupModel.addSummary(new ITopoGroupModel.Summary(n, n2, GuiUtil.getString("TOPO_LABEL_ENTITY_LUN"), GuiUtil.getString("TOPO_LABEL_ENTITY_LUNS")));
        int n3 = graphSubviewOtherL2Device.getNumOfVolumes();
        int n4 = graphSubviewOtherL2Device.getNumOfAbnormalVolumes();
        iTopoGroupModel.addSummary(new ITopoGroupModel.Summary(n3, n4, GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME"), GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUMES")));
        int n5 = n + n3;
        int n6 = n2 + n4;
        iTopoGroupModel.setTotalCount(n5);
        iTopoGroupModel.setUnfilteredCount(n6);
        iTopoGroupModel.setGroupKey(graphSubviewOtherL2Device.getGroupKey());
        iTopoGroupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel iTopoGroupModel) {
        return new ContainerPanel((ITopoUnitModel)iTopoGroupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel lunGroupPanel;
        protected JPanel volumeGroupPanel;

        public ContainerPanel(ITopoUnitModel iTopoUnitModel) {
            super(iTopoUnitModel);
            this.lunGroupPanel = new JPanel();
            this.lunGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.SquareGridLayout squareGridLayout = new TopoLayoutUtilities.SquareGridLayout();
            this.lunGroupPanel.setLayout(squareGridLayout);
            this.volumeGroupPanel = new JPanel();
            this.volumeGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            squareGridLayout = new TopoLayoutUtilities.SquareGridLayout();
            this.volumeGroupPanel.setLayout(squareGridLayout);
            this.initState();
        }

        private void initState() {
            this.add(this.lunGroupPanel);
            this.add(this.volumeGroupPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity abstractJTopoEntity) {
            this.entityV.add(abstractJTopoEntity);
            if (abstractJTopoEntity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.setVisible(true);
                this.lunGroupPanel.add(abstractJTopoEntity);
            } else if (abstractJTopoEntity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.setVisible(true);
                this.volumeGroupPanel.add(abstractJTopoEntity);
            }
        }

        public void removeEntity(AbstractJTopoEntity abstractJTopoEntity) {
            this.entityV.remove(abstractJTopoEntity);
            if (abstractJTopoEntity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.remove(abstractJTopoEntity);
                this.lunGroupPanel.setVisible(this.lunGroupPanel.getComponentCount() > 0);
            } else if (abstractJTopoEntity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.remove(abstractJTopoEntity);
                this.volumeGroupPanel.setVisible(this.volumeGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.lunGroupPanel.removeAll();
            this.lunGroupPanel.setVisible(false);
            this.volumeGroupPanel.removeAll();
            this.volumeGroupPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
            public DefaultLayout() {
                this.setMargin(15);
                this.setSpacing(10);
                this.setAlignment(0);
            }
        }
    }
}

