/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget.plaf.basic;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.eclipse.aperi.gui.topo.widget.JClosableTabbedPane;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class BasicClosableTabbedPaneUI
extends BasicTabbedPaneUI
implements ImageObserver {
    private ImageIcon closeIcon;
    private ImageIcon refreshIcon;
    private Rectangle[] closeIconRects = new Rectangle[0];
    private Rectangle[] refreshIconRects = new Rectangle[0];

    public BasicClosableTabbedPaneUI() {
        this.closeIcon = TopoResource.ICON_TAB_CLOSE;
        this.refreshIcon = TopoResource.ICON_TAB_REFRESH;
        this.refreshIcon.setImageObserver(this);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        while (bl < this.refreshIconRects.length) {
            this.tabPane.repaint(this.refreshIconRects[bl]);
            bl += 1;
        }
        if (n < 16) {
            return true;
        }
        bl = false;
        int n6 = 0;
        while (n6 < this.tabPane.getTabCount()) {
            JTopoView jTopoView = (JTopoView)this.tabPane.getComponentAt(n6);
            if (jTopoView.isRefreshInProgress()) {
                bl = true;
                break;
            }
            ++n6;
        }
        return bl;
    }

    protected void assureRectsCreated(int n) {
        int n2;
        Rectangle[] rectangleArray;
        super.assureRectsCreated(n);
        int n3 = this.refreshIconRects.length;
        if (n != n3) {
            rectangleArray = new Rectangle[n];
            System.arraycopy(this.refreshIconRects, 0, rectangleArray, 0, Math.min(n3, n));
            this.refreshIconRects = rectangleArray;
            n2 = n3;
            while (n2 < n) {
                this.refreshIconRects[n2] = new Rectangle();
                ++n2;
            }
        }
        if (n != (n3 = this.closeIconRects.length)) {
            rectangleArray = new Rectangle[n];
            System.arraycopy(this.closeIconRects, 0, rectangleArray, 0, Math.min(n3, n));
            this.closeIconRects = rectangleArray;
            n2 = n3;
            while (n2 < n) {
                this.closeIconRects[n2] = new Rectangle();
                ++n2;
            }
        }
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        boolean bl;
        int n3 = super.calculateTabWidth(n, n2, fontMetrics);
        JTopoView jTopoView = (JTopoView)this.tabPane.getComponentAt(n2);
        String string = jTopoView.getDtataModel().getModelID().getFocusLevel();
        if (!"Overview".equals(string)) {
            n3 += this.textIconGap + this.closeIcon.getIconWidth();
        }
        if (bl = jTopoView.isRefreshInProgress()) {
            n3 += this.textIconGap + this.refreshIcon.getIconWidth();
        }
        return n3;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = super.calculateTabHeight(n, n2, n3);
        Rectangle cfr_ignored_0 = this.refreshIconRects[n2];
        Rectangle cfr_ignored_1 = this.closeIconRects[n2];
        n4 = Math.max(n4, this.closeIcon.getIconHeight());
        JTopoView jTopoView = (JTopoView)this.tabPane.getComponentAt(n2);
        boolean bl = jTopoView.isRefreshInProgress();
        if (bl) {
            n4 = Math.max(n4, this.refreshIcon.getIconHeight());
        }
        return n4 += 4;
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        super.layoutLabel(n, fontMetrics, n2, string, icon, rectangle, rectangle2, rectangle3, bl);
        JTopoView jTopoView = (JTopoView)this.tabPane.getComponentAt(n2);
        String string2 = jTopoView.getDtataModel().getModelID().getFocusLevel();
        Rectangle rectangle4 = this.refreshIconRects[n2];
        Rectangle rectangle5 = this.closeIconRects[n2];
        boolean bl2 = jTopoView.isRefreshInProgress();
        if (!bl2 && !"Overview".equals(string2)) {
            n6 = this.textIconGap + this.closeIcon.getIconWidth();
            rectangle2.x -= n6 / 2;
            rectangle3.x -= n6 / 2;
        } else if (bl2 && "Overview".equals(string2)) {
            n6 = this.refreshIcon.getIconWidth() + this.textIconGap;
            rectangle2.x += n6 / 2;
            rectangle3.x += n6 / 2;
        }
        if (bl2) {
            n6 = this.refreshIcon.getIconWidth();
            n5 = this.refreshIcon.getIconHeight();
            n4 = rectangle2.x - this.textIconGap - n6;
            n3 = rectangle.y + (rectangle.height - n5) / 2;
            rectangle4.setBounds(n4, n3, n6, n5);
        }
        if (!"Overview".equals(string2)) {
            n6 = this.closeIcon.getIconWidth();
            n5 = this.closeIcon.getIconHeight();
            n4 = rectangle3.x + rectangle3.width + this.textIconGap;
            n3 = rectangle.y + (rectangle.height - n5) / 2;
            rectangle5.setBounds(n4, n3, n6, n5);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicClosableTabbedPaneUI();
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        String string;
        super.paintTab(graphics, n, rectangleArray, n2, rectangle, rectangle2);
        JTopoView jTopoView = (JTopoView)this.tabPane.getComponentAt(n2);
        Rectangle rectangle3 = this.refreshIconRects[n2];
        Rectangle rectangle4 = this.closeIconRects[n2];
        boolean bl = jTopoView.isRefreshInProgress();
        if (bl) {
            this.refreshIcon.paintIcon(this.tabPane, graphics, rectangle3.x, rectangle3.y);
        }
        if (!"Overview".equals(string = jTopoView.getDtataModel().getModelID().getFocusLevel())) {
            this.closeIcon.paintIcon(this.tabPane, graphics, rectangle4.x, rectangle4.y);
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected class MouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        protected MouseHandler() {
            super(BasicClosableTabbedPaneUI.this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Rectangle rectangle;
            super.mouseClicked(mouseEvent);
            Point point = mouseEvent.getPoint();
            int n = -1;
            int n2 = 0;
            while (n2 < BasicClosableTabbedPaneUI.this.tabPane.getTabCount()) {
                if (BasicClosableTabbedPaneUI.this.rects[n2].contains(point.x, point.y)) {
                    n = n2;
                }
                ++n2;
            }
            if (n != -1 && (rectangle = BasicClosableTabbedPaneUI.this.closeIconRects[n]).contains(point)) {
                BasicClosableTabbedPaneUI.this.tabPane.firePropertyChange(JClosableTabbedPane.PCL_TABREMOVEICONCLICKED, n, -1);
            }
        }
    }
}

