/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;

public class CimkeySubsystem
extends TResCimkeySubsystemTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static CimkeySubsystemCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new CimkeySubsystemCursor(dBConnection, hashtable, vector);
    }

    public CimkeySubsystem() {
        this.clear();
    }

    public CimkeySubsystem(int n, int n2, int n3, String string, short s, short s2, int n4, short s3) {
        this.clear();
        this.m_CimkeySubsystemId = n;
        this.m_SubsystemId = n2;
        this.m_CimNamespaceId = n3;
        this.m_Name = string;
        this.m_NameFormat = s;
        this.m_CreationClassNameId = s2;
        this.m_CapabilityDataId = n4;
        this.m_Active = s3;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_CimkeySubsystemId != Integer.MIN_VALUE) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CIMKEY_SUBSYSTEM_ID"), String.valueOf(this.m_CimkeySubsystemId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(CimkeySubsystem.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            hashtable.put(CimkeySubsystem.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_CapabilityDataId != Integer.MIN_VALUE) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CAPABILITY_DATA_ID"), String.valueOf(this.m_CapabilityDataId));
        }
        if (this.m_Active != Short.MIN_VALUE) {
            hashtable.put(CimkeySubsystem.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htColsAndValues.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_SUBSYSTEM", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_SUBSYSTEM", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SUBSYSTEM", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SUBSYSTEM", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SUBSYSTEM", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SUBSYSTEM", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_SUBSYSTEM", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static CimkeySubsystem retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        CimkeySubsystem cimkeySubsystem = null;
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        hashtable2.put(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_SUBSYSTEM", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                cimkeySubsystem = new CimkeySubsystem();
                cimkeySubsystem.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return cimkeySubsystem;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_SUBSYSTEM", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_SUBSYSTEM", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setCimkeySubsystemId(dBResultSet.getInt("CIMKEY_SUBSYSTEM_ID"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setCimNamespaceId(dBResultSet.getInt("CIM_NAMESPACE_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setNameFormat(dBResultSet.getShort("NAME_FORMAT"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setCapabilityDataId(dBResultSet.getInt("CAPABILITY_DATA_ID"));
        this.setActive(dBResultSet.getShort("ACTIVE"));
    }

    public static class CimkeySubsystemCursor
    extends DBCursor {
        private CimkeySubsystem element = new CimkeySubsystem();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public CimkeySubsystemCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_CIMKEY_SUBSYSTEM", dBConnection, CimkeySubsystemCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public CimkeySubsystem getObject() throws SQLException {
            CimkeySubsystem cimkeySubsystem = null;
            if (this.DBrs != null) {
                cimkeySubsystem = new CimkeySubsystem();
                cimkeySubsystem.setFields(this.con, this.DBrs);
            }
            return cimkeySubsystem;
        }

        public CimkeySubsystem getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

