/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResFabricAttributeSnapshotTable;

public class FabricAttributeSnapshot
extends TResFabricAttributeSnapshotTable {
    public static FabricAttributeSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new FabricAttributeSnapshotCursor(dBConnection, hashtable, vector);
    }

    public FabricAttributeSnapshot() {
        this.clear();
    }

    public FabricAttributeSnapshot(String string, short s, short s2, int n) {
        this.clear();
        this.m_FabricWwn = string;
        this.m_Active = s;
        this.m_Detectable = s2;
        this.m_OperationalStatus = n;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Active != Short.MIN_VALUE) {
            hashtable.put(FabricAttributeSnapshot.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(FabricAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(FabricAttributeSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htColsAndValues.put(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        return DBQueryAssistant.performInsert("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN"), hashtable.get(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN"), hashtable.get(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static FabricAttributeSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        FabricAttributeSnapshot fabricAttributeSnapshot = null;
        if (hashtable.get(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        hashtable2.put(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN"), hashtable.get(FabricAttributeSnapshot.getColumnInfo("FABRIC_WWN")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                fabricAttributeSnapshot = new FabricAttributeSnapshot();
                fabricAttributeSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return fabricAttributeSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setFabricWwn(dBResultSet.getString("FABRIC_WWN"));
        this.setActive(dBResultSet.getShort("ACTIVE"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
    }

    public static class FabricAttributeSnapshotCursor
    extends DBCursor {
        private FabricAttributeSnapshot element = new FabricAttributeSnapshot();
        private DBConnection con;

        public FabricAttributeSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_FABRIC_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public FabricAttributeSnapshot getObject() throws SQLException {
            FabricAttributeSnapshot fabricAttributeSnapshot = null;
            if (this.DBrs != null) {
                fabricAttributeSnapshot = new FabricAttributeSnapshot();
                fabricAttributeSnapshot.setFields(this.con, this.DBrs);
            }
            return fabricAttributeSnapshot;
        }

        public FabricAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

