/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResModelSnapshotTable;

public class ModelSnapshot
extends TResModelSnapshotTable {
    private String m_ModelId_str;

    public void setModel(String string) {
        this.m_ModelId_str = string;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static ModelSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new ModelSnapshotCursor(dBConnection, hashtable, vector);
    }

    public ModelSnapshot() {
        this.clear();
    }

    public ModelSnapshot(int n, short s, String string, String string2) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_ModelId = s;
        this.m_ModelName = string;
        this.m_ModelDescription = string2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ModelDescription != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_DESCRIPTION"), this.m_ModelDescription);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htColsAndValues.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_MODEL_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_MODEL_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), hashtable.get(ModelSnapshot.getColumnInfo("MODEL_NAME")));
        if (hashtable.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), hashtable.get(ModelSnapshot.getColumnInfo("MODEL_NAME")));
        if (hashtable.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_MODEL_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static ModelSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        ModelSnapshot modelSnapshot = null;
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        hashtable2.put(ModelSnapshot.getColumnInfo("MODEL_NAME"), hashtable.get(ModelSnapshot.getColumnInfo("MODEL_NAME")));
        if (hashtable.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(ModelSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(ModelSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_MODEL_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                modelSnapshot = new ModelSnapshot();
                modelSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return modelSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable2.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            hashtable2.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable2.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(dBConnection, this.m_ModelId));
        this.setModelName(dBResultSet.getString("MODEL_NAME"));
        this.setModelDescription(dBResultSet.getString("MODEL_DESCRIPTION"));
    }

    public static class ModelSnapshotCursor
    extends DBCursor {
        private ModelSnapshot element = new ModelSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")) != null) {
                hashtable.put(ModelSnapshot.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(ModelSnapshot.getColumnInfo("MODEL_ID")))));
            }
            return hashtable;
        }

        public ModelSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_MODEL_SNAPSHOT", dBConnection, ModelSnapshotCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public ModelSnapshot getObject() throws SQLException {
            ModelSnapshot modelSnapshot = null;
            if (this.DBrs != null) {
                modelSnapshot = new ModelSnapshot();
                modelSnapshot.setFields(this.con, this.DBrs);
            }
            return modelSnapshot;
        }

        public ModelSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

