/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResRedundancyTable;

public class Redundancy
extends TResRedundancyTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static RedundancyCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new RedundancyCursor(dBConnection, hashtable, vector);
    }

    public Redundancy() {
        this.clear();
    }

    public Redundancy(int n, int n2, String string, String string2, int n3, Timestamp timestamp, short s, String string3, short s2, int n4, String string4, String string5, int n5) {
        this.clear();
        this.m_RedundancyId = n;
        this.m_SubsystemId = n2;
        this.m_ComponentId = string;
        this.m_IpAddress = string2;
        this.m_NodeId = n3;
        this.m_UpdateTimestamp = timestamp;
        this.m_CreationClassNameId = s;
        this.m_Name = string3;
        this.m_NameFormat = s2;
        this.m_OperationalStatus = n4;
        this.m_Wwn = string4;
        this.m_DisplayName = string5;
        this.m_IoGroupId = n5;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_RedundancyId != Integer.MIN_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("REDUNDANCY_ID"), String.valueOf(this.m_RedundancyId));
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_NodeId != Integer.MIN_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_NameFormat != Short.MIN_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("NAME_FORMAT"), String.valueOf(this.m_NameFormat));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_Wwn != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("WWN"), this.m_Wwn);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_IoGroupId != Integer.MIN_VALUE) {
            hashtable.put(Redundancy.getColumnInfo("IO_GROUP_ID"), String.valueOf(this.m_IoGroupId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htColsAndValues.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (hashtable.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_REDUNDANCY", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), hashtable.get(Redundancy.getColumnInfo("COMPONENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), hashtable.get(Redundancy.getColumnInfo("COMPONENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_ComponentId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key COMPONENT_ID not found");
        }
        this.htWhereClause.put(Redundancy.getColumnInfo("COMPONENT_ID"), this.m_ComponentId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Redundancy retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Redundancy redundancy = null;
        if (hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(Redundancy.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(Redundancy.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(Redundancy.getColumnInfo("COMPONENT_ID")) == null) {
            throw new SQLException(" ERROR: key COMPONENT_ID not found");
        }
        hashtable2.put(Redundancy.getColumnInfo("COMPONENT_ID"), hashtable.get(Redundancy.getColumnInfo("COMPONENT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_REDUNDANCY", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                redundancy = new Redundancy();
                redundancy.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return redundancy;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_REDUNDANCY", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_REDUNDANCY", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setRedundancyId(dBResultSet.getInt("REDUNDANCY_ID"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setComponentId(dBResultSet.getString("COMPONENT_ID"));
        this.setIpAddress(dBResultSet.getString("IP_ADDRESS"));
        this.setNodeId(dBResultSet.getInt("NODE_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setName(dBResultSet.getString("NAME"));
        this.setNameFormat(dBResultSet.getShort("NAME_FORMAT"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setWwn(dBResultSet.getString("WWN"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setIoGroupId(dBResultSet.getInt("IO_GROUP_ID"));
    }

    public static class RedundancyCursor
    extends DBCursor {
        private Redundancy element = new Redundancy();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public RedundancyCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_REDUNDANCY", dBConnection, RedundancyCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public Redundancy getObject() throws SQLException {
            Redundancy redundancy = null;
            if (this.DBrs != null) {
                redundancy = new Redundancy();
                redundancy.setFields(this.con, this.DBrs);
            }
            return redundancy;
        }

        public Redundancy getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

