/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentSnapshotTable;

public class StorageExtentSnapshot
extends TResStorageExtentSnapshotTable {
    private String m_CreationClassNameId_str;
    private String m_SystemCreationClassNameId_str;
    private String m_SystemNamesId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemCreationClassName(String string) {
        this.m_SystemCreationClassNameId_str = string;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setSystemNames(String string) {
        this.m_SystemNamesId_str = string;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static StorageExtentSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new StorageExtentSnapshotCursor(dBConnection, hashtable, vector);
    }

    public StorageExtentSnapshot() {
        this.clear();
    }

    public StorageExtentSnapshot(int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, String string, String string2, String string3, String string4, String string5, int n7, String string6, String string7, short s, short s2, short s3, int n8, int n9, double d3, double d4, int n10, short s4, int n11, String string8, Timestamp timestamp, int n12, String string9, String string10, int n13) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_StorageExtentId = n2;
        this.m_NumExtents = n3;
        this.m_ExtentType = n4;
        this.m_PoolId = n5;
        this.m_TotalCapacity = d;
        this.m_FreeSpace = d2;
        this.m_VolsInStorageExtent = n6;
        this.m_Name = string;
        this.m_ElementName = string2;
        this.m_OtherName = string3;
        this.m_RankId = string4;
        this.m_Config = string5;
        this.m_VolGroupId = n7;
        this.m_GroupId = string6;
        this.m_DeviceId = string7;
        this.m_CreationClassNameId = s;
        this.m_SystemCreationClassNameId = s2;
        this.m_SystemNamesId = s3;
        this.m_SubsystemId = n8;
        this.m_BlockSize = n9;
        this.m_NumOfBlocks = d3;
        this.m_ConsumableBlocks = d4;
        this.m_OperationalStatus = n10;
        this.m_NativeStatus = s4;
        this.m_Mode = n11;
        this.m_DisplayName = string8;
        this.m_UpdateTimestamp = timestamp;
        this.m_BackendControllerId = n12;
        this.m_SerialNumber = string9;
        this.m_ArrayIds = string10;
        this.m_Redundancy = n13;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_StorageExtentId != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        }
        if (this.m_NumExtents != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("NUM_EXTENTS"), String.valueOf(this.m_NumExtents));
        }
        if (this.m_ExtentType != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("EXTENT_TYPE"), String.valueOf(this.m_ExtentType));
        }
        if (this.m_PoolId != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("POOL_ID"), String.valueOf(this.m_PoolId));
        }
        if (this.m_TotalCapacity != Double.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("TOTAL_CAPACITY"), String.valueOf(this.m_TotalCapacity));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_VolsInStorageExtent != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("VOLS_IN_STORAGE_EXTENT"), String.valueOf(this.m_VolsInStorageExtent));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_OtherName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("OTHER_NAME"), this.m_OtherName);
        }
        if (this.m_RankId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("RANK_ID"), this.m_RankId);
        }
        if (this.m_Config != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CONFIG"), this.m_Config);
        }
        if (this.m_VolGroupId != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("VOL_GROUP_ID"), String.valueOf(this.m_VolGroupId));
        }
        if (this.m_GroupId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("GROUP_ID"), this.m_GroupId);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
        if (this.m_BlockSize != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("BLOCK_SIZE"), String.valueOf(this.m_BlockSize));
        }
        if (this.m_NumOfBlocks != Double.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("NUM_OF_BLOCKS"), String.valueOf(this.m_NumOfBlocks));
        }
        if (this.m_ConsumableBlocks != Double.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CONSUMABLE_BLOCKS"), String.valueOf(this.m_ConsumableBlocks));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_NativeStatus != Short.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("NATIVE_STATUS"), String.valueOf(this.m_NativeStatus));
        }
        if (this.m_Mode != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("MODE"), String.valueOf(this.m_Mode));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_BackendControllerId != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("BACKEND_CONTROLLER_ID"), String.valueOf(this.m_BackendControllerId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_ArrayIds != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("ARRAY_IDS"), this.m_ArrayIds);
        }
        if (this.m_Redundancy != Integer.MIN_VALUE) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("REDUNDANCY"), String.valueOf(this.m_Redundancy));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(StorageExtentSnapshot.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("DEVICE_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("DEVICE_ID")));
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("DEVICE_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("DEVICE_ID")));
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static StorageExtentSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        StorageExtentSnapshot storageExtentSnapshot = null;
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        hashtable2.put(StorageExtentSnapshot.getColumnInfo("DEVICE_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("DEVICE_ID")));
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(StorageExtentSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                storageExtentSnapshot = new StorageExtentSnapshot();
                storageExtentSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return storageExtentSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable2.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable2.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable2.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable2.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setStorageExtentId(dBResultSet.getInt("STORAGE_EXTENT_ID"));
        this.setNumExtents(dBResultSet.getInt("NUM_EXTENTS"));
        this.setExtentType(dBResultSet.getInt("EXTENT_TYPE"));
        this.setPoolId(dBResultSet.getInt("POOL_ID"));
        this.setTotalCapacity(dBResultSet.getDouble("TOTAL_CAPACITY"));
        this.setFreeSpace(dBResultSet.getDouble("FREE_SPACE"));
        this.setVolsInStorageExtent(dBResultSet.getInt("VOLS_IN_STORAGE_EXTENT"));
        this.setName(dBResultSet.getString("NAME"));
        this.setElementName(dBResultSet.getString("ELEMENT_NAME"));
        this.setOtherName(dBResultSet.getString("OTHER_NAME"));
        this.setRankId(dBResultSet.getString("RANK_ID"));
        this.setConfig(dBResultSet.getString("CONFIG"));
        this.setVolGroupId(dBResultSet.getInt("VOL_GROUP_ID"));
        this.setGroupId(dBResultSet.getString("GROUP_ID"));
        this.setDeviceId(dBResultSet.getString("DEVICE_ID"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setSystemCreationClassNameId(dBResultSet.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(dBConnection, this.m_SystemCreationClassNameId));
        this.setSystemNamesId(dBResultSet.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(dBConnection, this.m_SystemNamesId));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setBlockSize(dBResultSet.getInt("BLOCK_SIZE"));
        this.setNumOfBlocks(dBResultSet.getDouble("NUM_OF_BLOCKS"));
        this.setConsumableBlocks(dBResultSet.getDouble("CONSUMABLE_BLOCKS"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setNativeStatus(dBResultSet.getShort("NATIVE_STATUS"));
        this.setMode(dBResultSet.getInt("MODE"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setBackendControllerId(dBResultSet.getInt("BACKEND_CONTROLLER_ID"));
        this.setSerialNumber(dBResultSet.getString("SERIAL_NUMBER"));
        this.setArrayIds(dBResultSet.getString("ARRAY_IDS"));
        this.setRedundancy(dBResultSet.getInt("REDUNDANCY"));
    }

    public static class StorageExtentSnapshotCursor
    extends DBCursor {
        private StorageExtentSnapshot element = new StorageExtentSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                hashtable.put(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(StorageExtentSnapshot.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return hashtable;
        }

        public StorageExtentSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_STORAGE_EXTENT_SNAPSHOT", dBConnection, StorageExtentSnapshotCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public StorageExtentSnapshot getObject() throws SQLException {
            StorageExtentSnapshot storageExtentSnapshot = null;
            if (this.DBrs != null) {
                storageExtentSnapshot = new StorageExtentSnapshot();
                storageExtentSnapshot.setFields(this.con, this.DBrs);
            }
            return storageExtentSnapshot;
        }

        public StorageExtentSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

