/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolSnapshotTable;

public class StoragePoolSnapshot
extends TResStoragePoolSnapshotTable {
    private String m_ClassNameId_str;

    public void setClassName(String string) {
        this.m_ClassNameId_str = string;
    }

    public String getClassName() {
        return this.m_ClassNameId_str;
    }

    public static StoragePoolSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new StoragePoolSnapshotCursor(dBConnection, hashtable, vector);
    }

    public StoragePoolSnapshot() {
        this.clear();
    }

    public StoragePoolSnapshot(int n, int n2, long l, long l2, short s, double d, int n3, short s2, int n4, int n5, long l3, short s3, String string, String string2, int n6, short s4, int n7, short s5, int n8, short s6, long l4, long l5, Timestamp timestamp, Timestamp timestamp2, short s7, int n9, short s8, short s9, String string3, String string4, String string5, Timestamp timestamp3, String string6, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, String string7, short s10, short s11) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_PoolId = n2;
        this.m_TotalManagedSpace = l;
        this.m_RemainingManagedSpace = l2;
        this.m_Primordial = s;
        this.m_Capacity = d;
        this.m_ExtentSize = n3;
        this.m_NativeStatus = s2;
        this.m_NumberOfBackendVolumes = n4;
        this.m_NumberOfStorageVolumes = n5;
        this.m_TotalAvailableSpace = l3;
        this.m_ElementType = s3;
        this.m_RaidLevel = string;
        this.m_InstanceId = string2;
        this.m_SubsystemId = n6;
        this.m_VolGroupType = s4;
        this.m_Lss = n7;
        this.m_Config = s5;
        this.m_DiskGroupId = n8;
        this.m_Format = s6;
        this.m_SurfacedLunCap = l4;
        this.m_UnsurfacedLunCap = l5;
        this.m_DiscoveredTime = timestamp;
        this.m_LastProbeTime = timestamp2;
        this.m_Detectable = s7;
        this.m_OperationalStatus = n9;
        this.m_ConsolidatedStatus = s8;
        this.m_PropagatedStatus = s9;
        this.m_UserAttrib1 = string3;
        this.m_UserAttrib2 = string4;
        this.m_UserAttrib3 = string5;
        this.m_UpdateTimestamp = timestamp3;
        this.m_Name = string6;
        this.m_DataRedundancyMin = n10;
        this.m_DataRedundancyMax = n11;
        this.m_DataRedundancyDef = n12;
        this.m_PckRedundancyMin = n13;
        this.m_PckRedundancyMax = n14;
        this.m_PckRedundancyDef = n15;
        this.m_DeltaResMin = n16;
        this.m_DeltaResMax = n17;
        this.m_DeltaResDef = n18;
        this.m_DisplayName = string7;
        this.m_RankGroup = s10;
        this.m_ClassNameId = s11;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_PoolId != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("POOL_ID"), String.valueOf(this.m_PoolId));
        }
        if (this.m_TotalManagedSpace != Long.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("TOTAL_MANAGED_SPACE"), String.valueOf(this.m_TotalManagedSpace));
        }
        if (this.m_RemainingManagedSpace != Long.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("REMAINING_MANAGED_SPACE"), String.valueOf(this.m_RemainingManagedSpace));
        }
        if (this.m_Primordial != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("PRIMORDIAL"), String.valueOf(this.m_Primordial));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_ExtentSize != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("EXTENT_SIZE"), String.valueOf(this.m_ExtentSize));
        }
        if (this.m_NativeStatus != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("NATIVE_STATUS"), String.valueOf(this.m_NativeStatus));
        }
        if (this.m_NumberOfBackendVolumes != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("NUMBER_OF_BACKEND_VOLUMES"), String.valueOf(this.m_NumberOfBackendVolumes));
        }
        if (this.m_NumberOfStorageVolumes != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("NUMBER_OF_STORAGE_VOLUMES"), String.valueOf(this.m_NumberOfStorageVolumes));
        }
        if (this.m_TotalAvailableSpace != Long.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("TOTAL_AVAILABLE_SPACE"), String.valueOf(this.m_TotalAvailableSpace));
        }
        if (this.m_ElementType != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("ELEMENT_TYPE"), String.valueOf(this.m_ElementType));
        }
        if (this.m_RaidLevel != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("RAID_LEVEL"), this.m_RaidLevel);
        }
        if (this.m_VolGroupType != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("VOL_GROUP_TYPE"), String.valueOf(this.m_VolGroupType));
        }
        if (this.m_Lss != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("LSS"), String.valueOf(this.m_Lss));
        }
        if (this.m_Config != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CONFIG"), String.valueOf(this.m_Config));
        }
        if (this.m_DiskGroupId != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DISK_GROUP_ID"), String.valueOf(this.m_DiskGroupId));
        }
        if (this.m_Format != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("FORMAT"), String.valueOf(this.m_Format));
        }
        if (this.m_SurfacedLunCap != Long.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("SURFACED_LUN_CAP"), String.valueOf(this.m_SurfacedLunCap));
        }
        if (this.m_UnsurfacedLunCap != Long.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("UNSURFACED_LUN_CAP"), String.valueOf(this.m_UnsurfacedLunCap));
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_LastProbeTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("LAST_PROBE_TIME"), this.m_LastProbeTime);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_DataRedundancyMin != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DATA_REDUNDANCY_MIN"), String.valueOf(this.m_DataRedundancyMin));
        }
        if (this.m_DataRedundancyMax != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DATA_REDUNDANCY_MAX"), String.valueOf(this.m_DataRedundancyMax));
        }
        if (this.m_DataRedundancyDef != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DATA_REDUNDANCY_DEF"), String.valueOf(this.m_DataRedundancyDef));
        }
        if (this.m_PckRedundancyMin != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("PCK_REDUNDANCY_MIN"), String.valueOf(this.m_PckRedundancyMin));
        }
        if (this.m_PckRedundancyMax != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("PCK_REDUNDANCY_MAX"), String.valueOf(this.m_PckRedundancyMax));
        }
        if (this.m_PckRedundancyDef != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("PCK_REDUNDANCY_DEF"), String.valueOf(this.m_PckRedundancyDef));
        }
        if (this.m_DeltaResMin != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DELTA_RES_MIN"), String.valueOf(this.m_DeltaResMin));
        }
        if (this.m_DeltaResMax != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DELTA_RES_MAX"), String.valueOf(this.m_DeltaResMax));
        }
        if (this.m_DeltaResDef != Integer.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DELTA_RES_DEF"), String.valueOf(this.m_DeltaResDef));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_RankGroup != Short.MIN_VALUE) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("RANK_GROUP"), String.valueOf(this.m_RankGroup));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(dBConnection, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htColsAndValues.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(dBConnection, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(dBConnection, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(dBConnection, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static StoragePoolSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        StoragePoolSnapshot storagePoolSnapshot = null;
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        hashtable2.put(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        hashtable2.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                storagePoolSnapshot = new StoragePoolSnapshot();
                storagePoolSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return storagePoolSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable2.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable2.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable2.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setPoolId(dBResultSet.getInt("POOL_ID"));
        this.setTotalManagedSpace(dBResultSet.getLong("TOTAL_MANAGED_SPACE"));
        this.setRemainingManagedSpace(dBResultSet.getLong("REMAINING_MANAGED_SPACE"));
        this.setPrimordial(dBResultSet.getShort("PRIMORDIAL"));
        this.setCapacity(dBResultSet.getDouble("CAPACITY"));
        this.setExtentSize(dBResultSet.getInt("EXTENT_SIZE"));
        this.setNativeStatus(dBResultSet.getShort("NATIVE_STATUS"));
        this.setNumberOfBackendVolumes(dBResultSet.getInt("NUMBER_OF_BACKEND_VOLUMES"));
        this.setNumberOfStorageVolumes(dBResultSet.getInt("NUMBER_OF_STORAGE_VOLUMES"));
        this.setTotalAvailableSpace(dBResultSet.getLong("TOTAL_AVAILABLE_SPACE"));
        this.setElementType(dBResultSet.getShort("ELEMENT_TYPE"));
        this.setRaidLevel(dBResultSet.getString("RAID_LEVEL"));
        this.setInstanceId(dBResultSet.getString("INSTANCE_ID"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setVolGroupType(dBResultSet.getShort("VOL_GROUP_TYPE"));
        this.setLss(dBResultSet.getInt("LSS"));
        this.setConfig(dBResultSet.getShort("CONFIG"));
        this.setDiskGroupId(dBResultSet.getInt("DISK_GROUP_ID"));
        this.setFormat(dBResultSet.getShort("FORMAT"));
        this.setSurfacedLunCap(dBResultSet.getLong("SURFACED_LUN_CAP"));
        this.setUnsurfacedLunCap(dBResultSet.getLong("UNSURFACED_LUN_CAP"));
        this.setDiscoveredTime(dBResultSet.getTimestamp("DISCOVERED_TIME"));
        this.setLastProbeTime(dBResultSet.getTimestamp("LAST_PROBE_TIME"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
        this.setUserAttrib1(dBResultSet.getString("USER_ATTRIB1"));
        this.setUserAttrib2(dBResultSet.getString("USER_ATTRIB2"));
        this.setUserAttrib3(dBResultSet.getString("USER_ATTRIB3"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setName(dBResultSet.getString("NAME"));
        this.setDataRedundancyMin(dBResultSet.getInt("DATA_REDUNDANCY_MIN"));
        this.setDataRedundancyMax(dBResultSet.getInt("DATA_REDUNDANCY_MAX"));
        this.setDataRedundancyDef(dBResultSet.getInt("DATA_REDUNDANCY_DEF"));
        this.setPckRedundancyMin(dBResultSet.getInt("PCK_REDUNDANCY_MIN"));
        this.setPckRedundancyMax(dBResultSet.getInt("PCK_REDUNDANCY_MAX"));
        this.setPckRedundancyDef(dBResultSet.getInt("PCK_REDUNDANCY_DEF"));
        this.setDeltaResMin(dBResultSet.getInt("DELTA_RES_MIN"));
        this.setDeltaResMax(dBResultSet.getInt("DELTA_RES_MAX"));
        this.setDeltaResDef(dBResultSet.getInt("DELTA_RES_DEF"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setRankGroup(dBResultSet.getShort("RANK_GROUP"));
        this.setClassNameId(dBResultSet.getShort("CLASS_NAME_ID"));
        this.setClassName(Normalizer.ClassNameGetName(dBConnection, this.m_ClassNameId));
    }

    public static class StoragePoolSnapshotCursor
    extends DBCursor {
        private StoragePoolSnapshot element = new StoragePoolSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")) != null) {
                hashtable.put(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePoolSnapshot.getColumnInfo("CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public StoragePoolSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_STORAGE_POOL_SNAPSHOT", dBConnection, StoragePoolSnapshotCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public StoragePoolSnapshot getObject() throws SQLException {
            StoragePoolSnapshot storagePoolSnapshot = null;
            if (this.DBrs != null) {
                storagePoolSnapshot = new StoragePoolSnapshot();
                storagePoolSnapshot.setFields(this.con, this.DBrs);
            }
            return storagePoolSnapshot;
        }

        public StoragePoolSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

