/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystemSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroupSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.IoGroupSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.ModelSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.NodeSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.PortSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtentSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StoragePoolSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystemSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolumeSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.VendorSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extentSnapshot;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolumeSnapshot;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResModelSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentSnapshotTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotStorageSubsystem {
    private static String STORAGE_SUBSYSTEM_TABLE = "T_RES_STORAGE_SUBSYSTEM";
    private static String STORAGE_POOL_TABLE = "T_RES_STORAGE_POOL";
    private static String STORAGE_EXTENT_TABLE = "T_RES_STORAGE_EXTENT";
    private static String DISK_GROUP_TABLE = "T_RES_DISK_GROUP";
    private static String STORAGE_VOLUME_TABLE = "T_RES_STORAGE_VOLUME";
    private static String VOLUME2EXTENT_TABLE = "T_RES_VOLUME2EXTENT";
    private static String PORT_TABLE = "T_RES_PORT";
    private static String NODE_TABLE = "T_RES_NODE";
    private static String CIMKEY_SUBSYSTEM_TABLE = "T_RES_CIMKEY_SUBSYSTEM";
    private static String VENDOR_TABLE = "T_RES_VENDOR";
    private static String MODEL_TABLE = "T_RES_MODEL";
    private static String CIMKEY_PORT_TABLE = "T_RES_CIMKEY_PORT";
    private static String CIMKEY_VOLUME_TABLE = "T_RES_CIMKEY_VOLUME";
    private static String IO_GROUP_TABLE = "T_RES_IO_GROUP";
    private static ILogger traceLogger = null;
    private static String className = SnapshotStorageSubsystem.class.getName();
    private static boolean TRACE = false;

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }

    static int create(DBConnection dBConnection, int n) throws Exception {
        String string = "create(" + n + ")";
        int n2 = -1;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        StorageSubsystem storageSubsystem = null;
        DBCursor dBCursor = null;
        DBCursor dBCursor2 = null;
        Vector<String> vector = new Vector<String>();
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        SnapshotMetadata snapshotMetadata = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            hashtable.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(n));
            dBCursor = StorageSubsystem.getCursor(dBConnection, hashtable, null);
            if (dBCursor.next()) {
                storageSubsystem = ((StorageSubsystem.StorageSubsystemCursor)dBCursor).getAttributes();
            }
            if (storageSubsystem == null) {
                Exception exception = new Exception("Bad system ID: " + n);
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
            n2 = AutoIdentifier.getIdentifier(9, 1);
            Timestamp timestamp = CurrentTime.getTimestamp(dBConnection);
            snapshotMetadata = SnapshotUtil.createSnapshotMetadata(dBConnection, n2, timestamp, n, 1, false);
            SnapshotStorageSubsystem.createStorageSubsystemSnapshot(dBConnection, storageSubsystem, n2, STORAGE_SUBSYSTEM_TABLE);
            SnapshotStorageSubsystem.createStoragePoolSnapshot(dBConnection, storageSubsystem, n2, STORAGE_POOL_TABLE);
            SnapshotStorageSubsystem.createStorageExtentSnapshot(dBConnection, storageSubsystem, n2, STORAGE_EXTENT_TABLE);
            SnapshotStorageSubsystem.createDiskGroupSnapshot(dBConnection, storageSubsystem, n2, DISK_GROUP_TABLE);
            SnapshotStorageSubsystem.createPortSnapshot(dBConnection, storageSubsystem, n2, PORT_TABLE);
            SnapshotStorageSubsystem.createNodeSnapshot(dBConnection, storageSubsystem, n2, NODE_TABLE);
            SnapshotStorageSubsystem.createCimkeySubsystemSnapshot(dBConnection, storageSubsystem, n2, CIMKEY_SUBSYSTEM_TABLE);
            SnapshotStorageSubsystem.createVendorSnapshot(dBConnection, storageSubsystem, n2, VENDOR_TABLE);
            SnapshotStorageSubsystem.createModelSnapshot(dBConnection, storageSubsystem, n2, MODEL_TABLE);
            SnapshotStorageSubsystem.createCimkeyPortSnapshot(dBConnection, storageSubsystem, n2, CIMKEY_PORT_TABLE);
            SnapshotStorageSubsystem.createIoGroupSnapshot(dBConnection, storageSubsystem, n2, IO_GROUP_TABLE);
            dBConnection.commit();
            hashtable.clear();
            hashtable.put(TResStoragePoolTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(n));
            vector.add("POOL_ID");
            dBCursor2 = StoragePool.getCursor(dBConnection, hashtable, vector);
            while (dBCursor2.next()) {
                Integer n3 = (Integer)dBCursor2.getAttribute(vector)[0];
                linkedHashSet.add(n3);
            }
            dBConnection.commit();
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                SnapshotStorageSubsystem.createStorageVolumeSnapshot(dBConnection, storageSubsystem, n2, (Integer)iterator.next(), STORAGE_VOLUME_TABLE);
                dBConnection.commit();
            }
            for (Integer n4 : linkedHashSet) {
                SnapshotStorageSubsystem.createCimkeyVolumeSnapshot(dBConnection, storageSubsystem, n2, n4, CIMKEY_VOLUME_TABLE);
                dBConnection.commit();
            }
            iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                SnapshotStorageSubsystem.createVolume2extentSnapshot(dBConnection, storageSubsystem, n2, (Integer)iterator.next(), VOLUME2EXTENT_TABLE);
                if (!iterator.hasNext()) {
                    snapshotMetadata.setSnapshotConsistent((short)1);
                    snapshotMetadata.update(dBConnection);
                }
                dBConnection.commit();
            }
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
            }
            int n5 = n2;
            return n5;
        }
        catch (SQLException sQLException) {
            try {
                dBConnection.rollback();
            }
            catch (SQLException sQLException2) {}
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, sQLException);
            }
            throw sQLException;
        }
        finally {
            if (dBCursor != null) {
                dBCursor.close();
            }
            if (dBCursor2 != null) {
                dBCursor2.close();
            }
        }
    }

    static void delete(DBConnection dBConnection, int n) throws SQLException {
        String string = "delete(" + n + ")";
        Hashtable hashtable = new Hashtable();
        DBCursor dBCursor = null;
        DBCursor dBCursor2 = null;
        Vector<String> vector = new Vector<String>();
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> linkedHashSet2 = new LinkedHashSet<Integer>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            try {
                hashtable.clear();
                hashtable.put(TResStoragePoolSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                vector.clear();
                vector.add("POOL_ID");
                dBCursor = StoragePoolSnapshot.getCursor(dBConnection, hashtable, vector);
                while (dBCursor.next()) {
                    Integer n2 = (Integer)dBCursor.getAttribute(vector)[0];
                    linkedHashSet.add(n2);
                }
                hashtable.clear();
                hashtable.put(TResStorageExtentSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                vector.clear();
                vector.add("STORAGE_EXTENT_ID");
                dBCursor2 = StorageExtentSnapshot.getCursor(dBConnection, hashtable, vector);
                while (dBCursor2.next()) {
                    Integer n3 = (Integer)dBCursor2.getAttribute(vector)[0];
                    linkedHashSet2.add(n3);
                }
                Iterator iterator = linkedHashSet2.iterator();
                while (iterator.hasNext()) {
                    hashtable.clear();
                    hashtable.put(TResVolume2extentSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                    hashtable.put(TResVolume2extentSnapshotTable.getColumnInfo("STORAGE_EXTENT_ID"), ((Integer)iterator.next()).toString());
                    Volume2extentSnapshot.deletes(dBConnection, hashtable);
                    dBConnection.commit();
                }
                iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>();
                    Vector<String> vector3 = new Vector<String>();
                    vector2.add(TResCimkeyVolumeSnapshotTable.getColumnInfo("SNAPSHOT_ID"));
                    vector3.add(String.valueOf(n));
                    vector2.add(TResStorageVolumeSnapshotTable.getColumnInfo("SNAPSHOT_ID"));
                    vector3.add(String.valueOf(n));
                    vector2.add(TResStorageVolumeSnapshotTable.getColumnInfo("POOL_ID"));
                    vector3.add(((Integer)iterator.next()).toString());
                    hashtable = ComplexQuery.generateHashtable(vector2, vector3);
                    SqlCimkeyVolumeSnapshot.sqlUpdate(dBConnection, 0, hashtable);
                    dBConnection.commit();
                }
                iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    hashtable.clear();
                    hashtable.put(TResStorageVolumeSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                    hashtable.put(TResStorageVolumeSnapshotTable.getColumnInfo("POOL_ID"), ((Integer)iterator.next()).toString());
                    StorageVolumeSnapshot.deletes(dBConnection, hashtable);
                    dBConnection.commit();
                }
                hashtable.clear();
                hashtable.put(TResModelSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                ModelSnapshot.deletes(dBConnection, hashtable);
                hashtable.clear();
                hashtable.put(TResVendorSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                VendorSnapshot.deletes(dBConnection, hashtable);
                hashtable.clear();
                hashtable.put(TResCimkeyPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                CimkeyPortSnapshot.deletes(dBConnection, hashtable);
                hashtable.clear();
                hashtable.put(TResCimkeySubsystemSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                CimkeySubsystemSnapshot.deletes(dBConnection, hashtable);
                hashtable.clear();
                hashtable.put(TResNodeSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                NodeSnapshot.deletes(dBConnection, hashtable);
                hashtable.clear();
                hashtable.put(TResPortSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                PortSnapshot.deletes(dBConnection, hashtable);
                hashtable.put(TResDiskGroupSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                DiskGroupSnapshot.deletes(dBConnection, hashtable);
                hashtable.put(TResStorageExtentSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                StorageExtentSnapshot.deletes(dBConnection, hashtable);
                hashtable.put(TResStoragePoolSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                StoragePoolSnapshot.deletes(dBConnection, hashtable);
                hashtable.put(TResIoGroupSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                IoGroupSnapshot.deletes(dBConnection, hashtable);
                hashtable.put(TResStorageSubsystemSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                StorageSubsystemSnapshot.deletes(dBConnection, hashtable);
                hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
                SnapshotMetadata.deletes(dBConnection, hashtable);
                dBConnection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    dBConnection.rollback();
                }
                catch (SQLException sQLException2) {}
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, sQLException);
                }
                throw sQLException;
            }
        }
        finally {
            if (dBCursor != null) {
                dBCursor.close();
            }
            if (dBCursor2 != null) {
                dBCursor2.close();
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    private static void createStorageSubsystemSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createStorageSubsystemSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createStoragePoolSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createStoragePoolSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStoragePoolTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createStorageExtentSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createStorageExtentSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageExtentTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createDiskGroupSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createDiskGroupSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageExtentTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createStorageVolumeSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, Integer n2, String string) throws SQLException {
        String string2 = "createStorageVolumeSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageVolumeTable.getColumnInfo("POOL_ID"), n2.toString());
                hashtable2.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createVolume2extentSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, Integer n2, String string) throws SQLException {
        String string2 = "createVolume2extentSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageVolumeTable.getColumnInfo("POOL_ID"), n2.toString());
                hashtable2.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createPortSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createPortSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createNodeSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createNodeSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResNodeTable.getColumnInfo("SYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createCimkeySubsystemSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createCimkeySubsystemSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createVendorSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createVendorSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createModelSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createModelSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createCimkeyPortSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createCimkeyPortSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createCimkeyVolumeSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, Integer n2, String string) throws SQLException {
        String string2 = "createCimkeyVolumeSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResStorageVolumeTable.getColumnInfo("POOL_ID"), n2.toString());
                hashtable2.put(TResStorageVolumeTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createIoGroupSnapshot(DBConnection dBConnection, StorageSubsystem storageSubsystem, int n, String string) throws SQLException {
        String string2 = "createIoGroupSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(1, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResPortTable.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(storageSubsystem.getSubsystemId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }
}

