/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.Serializable;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.request.ReusableObjectPool;
import org.eclipse.aperi.xmsg.MessageLog;

public class Response
implements Serializable {
    static final long serialVersionUID = -6242209580917123979L;
    private static ReusableObjectPool pool = new ReusableObjectPool(40);
    public byte flags;
    public static final byte COMPLETE = 2;
    public short status;
    public Serializable responseData;
    public String errorMessage;
    private StorageException exception;
    public static final short SUCCESS = 0;
    public static final short WARNING = 4;
    public static final short TRY_LATER = 8;
    public static final short ERROR = 12;
    public static final short WRONG_SERVER = 16;
    public static final short AGENT_BACKLOGGED = 20;
    public static final short SVP_DOWN = 24;
    public static final short AGENT_UPGRADING = 28;
    public static final short AGENT_NOT_LICENSED = 32;
    public static final short AGENT_NOT_FOUND = 34;
    public static final short AGENT_UNREACHABLE = 36;
    public static final short DEPENDENTS_GONE = 76;
    public static final short DB_CONNECT_ERROR = 80;
    public static final short KEY_DELETED = 84;
    public static final short NOT_ENUFF = 88;
    public static final short SQL_ERROR = 92;
    public static final short AUTHENTICATE = 96;
    public static final short PRODUCT_VERSION_MISMATCH = 97;
    public static final short NOT_REGISTERED = 98;
    public static final short AGENT_MANAGER_UNREACHABLE = 99;
    public static final short HOST_HAS_AGENT_INSTALLED = 100;
    public static final short DO_NOT_CLOSE_SOCKET = -99;

    public Response(short s, Serializable serializable, byte by) {
        this.init(s, serializable, by);
    }

    public Response(short s, Serializable serializable) {
        this(s, serializable, 2);
    }

    public void init(short s, Serializable serializable, byte by) {
        this.status = s;
        this.responseData = serializable;
        this.flags = by;
    }

    public void setException(StorageException storageException) {
        this.exception = storageException;
        this.errorMessage = storageException == null ? null : storageException.getMessage(MessageLog.messageFormatter);
    }

    public StorageException getException() {
        return this.exception;
    }

    public String getErrorMessage() {
        return this.exception == null ? this.errorMessage : this.exception.getMessage(MessageLog.messageFormatter);
    }

    public static Response getResponse(short s, Serializable serializable, byte by) {
        Response response = (Response)pool.getObject();
        if (response == null) {
            return new Response(s, serializable, by);
        }
        response.init(s, serializable, by);
        return response;
    }

    public static Response getResponse(short s, Serializable serializable) {
        return Response.getResponse(s, serializable, (byte)2);
    }

    public void returnResponse() {
        this.errorMessage = null;
        this.responseData = null;
        this.exception = null;
        pool.returnObject(this);
    }
}

