/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ReadObjectException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.common.WriteObjectException;
import org.eclipse.aperi.common.WriteObjectIOException;
import org.eclipse.aperi.request.Mogrifier;
import org.eclipse.aperi.request.NameListPacker;
import org.eclipse.aperi.request.NameListUnpacker;
import org.eclipse.aperi.request.Pack;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.ReusableObjectPool;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class SocketTransceiver
extends Transceiver {
    protected static final int SENDER_TIMEOUT = 60;
    protected static final int RECEIVER_TIMEOUT = 60;
    private static final int POOLSIZE = 10;
    private static ReusableObjectPool pool = new ReusableObjectPool(10);
    private static String requestMachineName;
    private String hostName;
    private Socket socket;
    private int timeoutInSeconds;
    private InputStream inputStream = null;
    private ObjectInputStream objectInputStream;
    private OutputStream outputStream = null;
    private ObjectOutputStream objectOutputStream;
    private static Mogrifier nameListPacker;
    private static Mogrifier nameListUnpacker;

    static {
        try {
            requestMachineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            requestMachineName = "unknown";
        }
        nameListPacker = new NameListPacker();
        nameListUnpacker = new NameListUnpacker();
    }

    private static boolean shouldTransform(Object object) {
        return object instanceof CreateHeader || object instanceof Pack;
    }

    private static void transformSerializable(Object object, Mogrifier mogrifier) {
        Field[] fieldArray = object.getClass().getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if ((fieldArray[n].getModifiers() & 8) == 0) {
                try {
                    Object object2 = fieldArray[n].get(object);
                    if (mogrifier.transformable(object2)) {
                        object2 = mogrifier.transform(object2);
                        fieldArray[n].set(object, object2);
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
    }

    private static void packSerializable(Object object) {
        if (object instanceof CreateHeader) {
            SocketTransceiver.transformSerializable(object, nameListPacker);
        }
        if (object instanceof Pack) {
            ((Pack)object).pack();
        }
    }

    private static void unpackSerializable(Object object) {
        if (object instanceof CreateHeader) {
            SocketTransceiver.transformSerializable(object, nameListUnpacker);
        }
        if (object instanceof Pack) {
            ((Pack)object).unpack();
        }
    }

    private String getPeerHostName() {
        String string = this.hostName;
        if (string == null && this.socket != null) {
            string = this.socket.getInetAddress().getHostAddress();
        }
        return string;
    }

    private void logError(String string) {
        MessageLog.logMessage(string, this.getPeerHostName());
    }

    private void logError(String string, Throwable throwable) {
        this.logError(string);
        if (!(throwable instanceof LocalizableException)) {
            MessageLog.getThreadLog().println("                         " + throwable.getMessage());
        } else {
            LocalizableException localizableException = (LocalizableException)throwable;
            localizableException.print();
        }
    }

    private void logError(String string, String string2) {
        this.logError(string);
        MessageLog.getThreadLog().println("                         " + string2);
    }

    public SocketTransceiver(Socket socket, String string, int n) {
        this.init(socket, string, n);
    }

    public SocketTransceiver(Socket socket, String string) {
        this.init(socket, string, 60);
    }

    public SocketTransceiver(Socket socket) {
        this.init(socket, null, 60);
    }

    protected void init(Socket socket, String string, int n) {
        this.socket = socket;
        this.hostName = string;
        this.timeoutInSeconds = n;
        if (this.timeoutInSeconds > 0) {
            try {
                this.socket.setSoTimeout(this.timeoutInSeconds * 1000);
            }
            catch (SocketException socketException) {
                this.logError("GEN0033W", socketException);
            }
        }
    }

    public static SocketTransceiver getSocketTransceiver(Socket socket, String string, int n) {
        SocketTransceiver socketTransceiver = (SocketTransceiver)pool.getObject();
        if (socketTransceiver == null) {
            return new SocketTransceiver(socket, string, n);
        }
        socketTransceiver.init(socket, string, n);
        return socketTransceiver;
    }

    public static SocketTransceiver getSocketTransceiver(Socket socket, String string) {
        return SocketTransceiver.getSocketTransceiver(socket, string, 60);
    }

    public static SocketTransceiver getSocketTransceiver(Socket socket) {
        return SocketTransceiver.getSocketTransceiver(socket, null, 60);
    }

    public void returnTransceiver() {
        pool.returnObject(this);
    }

    protected void clear() {
        this.socket = null;
        this.hostName = null;
        this.objectInputStream = null;
        this.objectOutputStream = null;
        this.timeoutInSeconds = -1;
        this.outputStream = null;
        this.inputStream = null;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    private void obtainInputStream() {
        if (this.inputStream != null) {
            return;
        }
        try {
            this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (IOException iOException) {
            this.logError("GEN0005E", iOException);
        }
    }

    private void obtainObjectInputStream(InputStream inputStream) throws ObjectStreamException, IOException {
        if (this.objectInputStream == null) {
            this.objectInputStream = new ObjectInputStream(inputStream);
        }
    }

    private void obtainOutputStream() {
        if (this.outputStream != null) {
            return;
        }
        try {
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.logError("GEN0006E", iOException);
        }
    }

    private void obtainObjectOutputStream(OutputStream outputStream) throws IOException {
        if (this.objectOutputStream == null && outputStream != null) {
            this.objectOutputStream = new ObjectOutputStream(outputStream);
        }
    }

    private Object readObject(Request request) throws ReadObjectException {
        Object object = null;
        if (this.inputStream == null) {
            this.obtainInputStream();
        }
        try {
            if (this.objectInputStream == null) {
                this.obtainObjectInputStream(this.inputStream);
            }
            object = this.objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{this.getPeerHostName()};
            throw new ReadObjectException("GEN0015E", objectArray, classNotFoundException.toString());
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{this.getPeerHostName()};
            throw new ReadObjectException("GEN0008E", objectArray, iOException.toString());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{this.getPeerHostName()};
            exception.printStackTrace();
            throw new ReadObjectException("GEN0008E", objectArray, exception.toString());
        }
        return object;
    }

    public Request receiveRequest() {
        Request request = null;
        this.obtainInputStream();
        Object object = null;
        try {
            object = this.readObject(null);
        }
        catch (ReadObjectException readObjectException) {
            MessageLog.logException(readObjectException);
        }
        if (object == null) {
            return null;
        }
        try {
            request = (Request)object;
        }
        catch (ClassCastException classCastException) {
            request = null;
        }
        if (request == null) {
            return null;
        }
        this.hostName = request.machineName;
        if (SocketTransceiver.shouldTransform(request.requestData)) {
            SocketTransceiver.unpackSerializable(request.requestData);
        }
        return request;
    }

    public Object receiveData(Request request) {
        Object object = null;
        try {
            this.checkTwoPhase(request);
            object = this.readObject(request);
        }
        catch (ReadObjectException readObjectException) {
            Object[] objectArray = new String[]{this.getPeerHostName()};
            StorageException storageException = new StorageException("GEN0323E", objectArray);
            storageException.addException(readObjectException);
            MessageLog.logException(storageException);
        }
        catch (LocalizableException localizableException) {
            this.logError("GEN0024I", localizableException);
            return null;
        }
        catch (Error error) {
            MessageLog.logMessage("GEN0173E", request.getClass());
            this.logRequestInfo(request);
            throw error;
        }
        if (object == null) {
            MessageLog.logMessage("GEN7070I", request.toString());
        } else if (SocketTransceiver.shouldTransform(object)) {
            SocketTransceiver.unpackSerializable(object);
        }
        return object;
    }

    public boolean writeObject(Object object, int n) {
        boolean bl = false;
        try {
            this.obtainOutputStream();
            bl = this.writeObject(object, null);
        }
        catch (WriteObjectException writeObjectException) {
            Object[] objectArray = new Object[]{this.getPeerHostName()};
            StorageException storageException = new StorageException("GEN0325E", objectArray);
            storageException.addException(writeObjectException);
            MessageLog.logException(storageException);
        }
        return bl;
    }

    public boolean writeObject(Object object, Request request) throws WriteObjectException {
        boolean bl = false;
        try {
            this.obtainOutputStream();
            this.obtainObjectOutputStream(this.outputStream);
            if (this.objectOutputStream == null) {
                String string = this.getPeerHostName();
                throw new IOException("Cannot get output stream to host " + string);
            }
            this.objectOutputStream.writeObject(object);
            this.objectOutputStream.flush();
            bl = true;
        }
        catch (ObjectStreamException objectStreamException) {
            Object[] objectArray = new Object[]{this.getPeerHostName()};
            throw new WriteObjectException("GEN0009E", objectArray, null, objectStreamException);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{this.getPeerHostName()};
            throw new WriteObjectIOException("GEN0010E", objectArray, null, iOException);
        }
        catch (Error error) {
            MessageLog.logMessage("GEN0177E", error.getClass());
            if (object instanceof Request) {
                this.logRequestInfo((Request)object);
            }
            MessageLog.logMessage("GEN0175E", object.getClass());
            if (object instanceof Response && (object = ((Response)object).responseData) != null) {
                MessageLog.logMessage("GEN0176E", object.getClass());
            }
            throw error;
        }
        return bl;
    }

    private void logTransmitExplanation(Request request, int n) {
        if (n == 0) {
            MessageLog.logMessage("GEN7071I", request.toString());
        } else {
            MessageLog.logMessage("GEN7072I", request.toString(), new Integer(n));
        }
    }

    private Response doPhase(Request request, Object object, int n) throws StorageException {
        Object object2 = null;
        try {
            this.writeObject(object, request);
        }
        catch (StorageException storageException) {
            try {
                this.readObject(request);
            }
            catch (StorageException storageException2) {}
            throw storageException;
        }
        object2 = this.readObject(request);
        if (object2 == null) {
            this.logTransmitExplanation(request, n);
            return null;
        }
        Response response = null;
        try {
            response = (Response)object2;
        }
        catch (ClassCastException classCastException) {
            this.logError("GEN0014E", classCastException);
            this.logTransmitExplanation(request, n);
        }
        if (response == null) {
            return response;
        }
        if (response.status != 0 && response.status != 96) {
            this.logError("GEN0018I");
            this.logReceivedResponse(response);
            this.logTransmitExplanation(request, n);
        }
        if (response.status <= 4) {
            try {
                this.checkReceivedResponse(request, n, response);
                if (SocketTransceiver.shouldTransform(response.responseData)) {
                    SocketTransceiver.unpackSerializable(response.responseData);
                }
            }
            catch (LocalizableException localizableException) {
                this.logError("GEN0024I", localizableException);
                response.status = (short)12;
            }
        }
        return response;
    }

    public Response transmitRequest(Request request, Object object) {
        Object object2;
        int n;
        this.obtainOutputStream();
        if (request.machineName == null) {
            request.machineName = requestMachineName;
        }
        if (object == null) {
            n = 0;
            object2 = request.requestData;
        } else {
            n = 1;
            object2 = object;
        }
        boolean bl = SocketTransceiver.shouldTransform(object2);
        if (bl) {
            SocketTransceiver.packSerializable(object2);
        }
        Response response = null;
        try {
            response = this.doPhase(request, request, n);
            if (object != null && response != null && response.status != 96 && response.status <= 4) {
                n = 2;
                response = this.doPhase(request, object, n);
            }
        }
        catch (StorageException storageException) {
            String string = this.getPeerHostName();
            MessageLog.logMessage("GEN7073E", request.toString(), string);
            MessageLog.logException(storageException);
            response = null;
        }
        catch (Error error) {
            MessageLog.logMessage("GEN0173E", request.getClass());
            this.logRequestInfo(request);
            throw error;
        }
        if (bl) {
            SocketTransceiver.unpackSerializable(object2);
        }
        return response;
    }

    public boolean transmitResponse(Request request, Response response) {
        if (response.status != 0) {
            this.logResponse(request, response);
        }
        try {
            this.checkResponseToSend(request, response);
        }
        catch (LocalizableException localizableException) {
            this.logError("GEN0024I", localizableException);
            return false;
        }
        if (response.responseData instanceof NameList) {
            response.responseData = NameList.packList((NameList)response.responseData);
        }
        if (SocketTransceiver.shouldTransform(response.responseData)) {
            SocketTransceiver.packSerializable(response.responseData);
        }
        boolean bl = false;
        try {
            bl = this.writeObject((Object)response, request);
        }
        catch (WriteObjectException writeObjectException) {
            MessageLog.logException(writeObjectException);
        }
        catch (Error error) {
            MessageLog.logMessage("GEN0177E", error.getClass());
            this.logRequestInfo(request);
            MessageLog.logMessage("GEN0175E", request.getClass());
            throw error;
        }
        if (!bl) {
            MessageLog.logMessage("GEN7074I", request.toString());
        }
        return bl;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean close() {
        boolean bl;
        IOException iOException;
        block9: {
            iOException = null;
            if (this.objectOutputStream != null) {
                try {
                    this.objectOutputStream.close();
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            if (this.socket != null) {
                try {
                    if (Variables.whoAmI == 2) {
                        SocketRegistry.close(this.socket);
                    } else {
                        this.socket.close();
                    }
                }
                catch (IOException iOException3) {
                    if (iOException != null) break block9;
                    iOException = iOException3;
                }
            }
        }
        boolean bl2 = bl = iOException == null;
        if (!bl) {
            this.logError("GEN0021E", MessageLog.getMessageNoID("AGT0017E"));
        }
        this.clear();
        return bl;
    }

    private void logRequestInfo(Request request) {
        if (request == null) {
            return;
        }
        MessageLog.logMessage("GEN7075E", request.toString());
        if (request.requestData == null) {
            return;
        }
        MessageLog.logMessage("GEN0174E", request.requestData.getClass());
        if (request.requestData instanceof GuiReportReq) {
            GuiReportReq guiReportReq = (GuiReportReq)request.requestData;
            MessageLog.logMessage("GEN0178E", Integer.toString(guiReportReq.reportType), Integer.toString(guiReportReq.reportSubtype));
        } else if (request.requestData instanceof GuiListReq) {
            GuiListReq guiListReq = (GuiListReq)request.requestData;
            MessageLog.logMessage("GEN0179E", Integer.toString(guiListReq.listRequested));
        }
    }
}

