/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.dbconnparms;

import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.aperi.common.ReqHandler;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.sanmgmt.dbconnparms.ConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.SRMServerInfo;

public class DBAccess {
    private static ILogger traceLogger = null;
    private static ILogger messageLogger = null;

    public DBAccess() {
        traceLogger = ConfigService.traceLogger;
        messageLogger = ConfigService.messageLogger;
    }

    public void closeDS() {
        block2: {
            try {
                DBConnPoolDataSource.closeInstance();
            }
            catch (SQLException sQLException) {
                messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDS", sQLException);
                if (!traceLogger.isLogging()) break block2;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDS", sQLException);
            }
        }
    }

    private DBConnection connectToDB() throws SQLException {
        String string = "connectDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string, "entered");
        }
        DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string, "exited");
        }
        return dBConnection;
    }

    private void closeDBConn(DBConnection dBConnection) {
        block3: {
            if (dBConnection != null) {
                try {
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDBConn", sQLException);
                    if (!traceLogger.isLogging()) break block3;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "closeDBConn", sQLException);
                }
            }
        }
    }

    public Properties getProperties(String string, Properties properties) {
        block18: {
            if (properties == null) {
                properties = new Properties();
            }
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            if (string == null || string.trim().length() == 0) {
                hashtable = null;
            } else {
                hashtable.put(ConfigData.getColumnInfo("CONTEXT"), string);
            }
            DBConnection dBConnection = null;
            DBCursor dBCursor = null;
            try {
                try {
                    dBConnection = this.connectToDB();
                    dBCursor = ConfigData.getCursor(dBConnection, hashtable, null);
                    while (dBCursor.next()) {
                        ConfigData configData = ((ConfigData.ConfigDataCursor)dBCursor).getAttributes();
                        properties.put(configData.getAttribute(), configData.getValue());
                    }
                }
                catch (SQLException sQLException) {
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, "getProperties", sQLException);
                    if (dBCursor != null) {
                        try {
                            dBCursor.close();
                        }
                        catch (SQLException sQLException2) {}
                    }
                    this.closeDBConn(dBConnection);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (dBCursor != null) {
                    try {
                        dBCursor.close();
                    }
                    catch (SQLException sQLException) {}
                }
                this.closeDBConn(dBConnection);
                throw throwable;
            }
            if (dBCursor != null) {
                try {
                    dBCursor.close();
                }
                catch (SQLException sQLException) {}
            }
            this.closeDBConn(dBConnection);
        }
        return properties;
    }

    public String readDB(String string) {
        String string2;
        String string3;
        block8: {
            string3 = "readDB";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string3, "entered");
            }
            string2 = null;
            DBConnection dBConnection = null;
            try {
                try {
                    dBConnection = this.connectToDB();
                    ConfigData configData = new ConfigData();
                    configData.setAttribute(string);
                    configData.retrieve(dBConnection);
                    string2 = configData.getValue();
                }
                catch (SQLException sQLException) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, string3, sQLException);
                    }
                    this.closeDBConn(dBConnection);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.closeDBConn(dBConnection);
                throw throwable;
            }
            this.closeDBConn(dBConnection);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string3, "exited");
        }
        return string2;
    }

    public void updateDB(String string, String string2, String string3) throws SQLException {
        String string4 = "updateDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string4, "entered");
        }
        DBConnection dBConnection = null;
        try {
            dBConnection = this.connectToDB();
            boolean bl = false;
            ConfigData configData = new ConfigData();
            configData.setAttribute(string);
            configData.setValue(string2);
            if (string3 != null && string3.trim().length() > 0) {
                configData.setContext(string3.trim());
            }
            try {
                bl = configData.insert(dBConnection);
            }
            catch (SQLException sQLException) {
                String string5 = sQLException.getSQLState();
                if (string5.equals("23505") || string5.equals("23500") || string5.equals("23L01") || string5.equals("23L02")) {
                    if (traceLogger.isLogging()) {
                        String string6 = "T_RES_CONFIG_DATA row already exist for key = " + string + "updaing value only!";
                        traceLogger.text(IRecordType.TYPE_WARNING, this, string4, string6);
                    }
                    bl = false;
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, string4, sQLException);
                }
                throw sQLException;
            }
            if (!bl) {
                configData.update(dBConnection);
            }
        }
        finally {
            this.closeDBConn(dBConnection);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string4, "exited");
        }
    }

    public void removeDB(String string) throws SQLException {
        String string2 = "removeDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string2, "entered");
        }
        DBConnection dBConnection = null;
        try {
            dBConnection = this.connectToDB();
            ConfigData configData = new ConfigData();
            configData.setAttribute(string);
            configData.delete(dBConnection);
        }
        finally {
            this.closeDBConn(dBConnection);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string2, "exited");
        }
    }

    public void syncInstallPassword(String string, String string2) {
        String string3;
        block11: {
            string3 = "syncInstallPassword";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string3, "entered");
            }
            DBConnection dBConnection = null;
            try {
                try {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (RuntimeException runtimeException) {
                        traceLogger.text(IRecordType.TYPE_WARNING, this, string3, "The serverId, " + string + ", was not an integer; using 0 as default.");
                    }
                    Server server = new Server();
                    server.setServerId(n);
                    server.setPassword(string2);
                    dBConnection = this.connectToDB();
                    server.update(dBConnection);
                    dBConnection.commit();
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(Server.getColumnInfo("SERVER_TYPE"), "0");
                    Server.ServerCursor serverCursor = Server.getCursor(dBConnection, hashtable, null);
                    if (serverCursor.next()) {
                        Server server2 = serverCursor.getAttributes();
                        String string4 = server2.getServerName();
                        int n2 = server2.getPortNumber();
                        this.notifyDataServer(string4, n2);
                    }
                    serverCursor.close();
                }
                catch (Exception exception) {
                    messageLogger.exception(IRecordType.TYPE_ERROR_EXC, this, string3, exception);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, this, string3, exception);
                    }
                    this.closeDBConn(dBConnection);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.closeDBConn(dBConnection);
                throw throwable;
            }
            this.closeDBConn(dBConnection);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string3, "exited");
        }
    }

    private void notifyDataServer(String string, int n) throws UnknownHostException {
        Socket socket;
        String string2 = "notifyDataServer";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, string2, "entered");
        }
        if ((socket = SocketRegistry.connect(string, n)) == null) {
            traceLogger.text(IRecordType.TYPE_WARN, this, string2, "Data Server request to refresh failed! Data Server seems down!");
            return;
        }
        ReqHandler reqHandler = new ReqHandler();
        Object object = reqHandler.getSocketTransceiverObject(socket, string);
        Object object2 = reqHandler.getRequestObject();
        reqHandler.setRequestTypeCode(object2, "org.eclipse.aperi.server.svp.ServerSvp");
        reqHandler.setRequestServiceName(object2, RequestTypeManager.getInternalName("org.eclipse.aperi.server.svp.ServerSvp"));
        reqHandler.setRequestSubType(object2, "org.eclipse.aperi.server.handler.server.DeviceServerRegHndlr");
        reqHandler.setRequestMachineName(object2, string);
        reqHandler.setRequestFlags(object2, (byte)5);
        SRMServerInfo sRMServerInfo = new SRMServerInfo();
        sRMServerInfo.setType(SRMServerInfo.REFRESH);
        Request request = (Request)object2;
        request.requestData = sRMServerInfo;
        Response response = (Response)reqHandler.transmitRequestObject(object, object2, null);
        if (response != null && response.status == 0) {
            traceLogger.text(IRecordType.TYPE_INFO, this, string2, "DataServer request to refresh successful");
        } else {
            traceLogger.text(IRecordType.TYPE_WARN, this, string2, "DataServer request to refresh failed");
        }
        reqHandler.transceiverClose(object);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, string2, "exited");
        }
    }
}

