/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestHandler;

public class TopoSettingHandler {
    public static final String SETTING_SHOW_HEALTH = "show_health";
    public static final String SETTING_SHOW_PERF = "show_perf";
    public static final String SETTING_SHOW_ZONE = "show_zone";
    public static final String SETTING_SHOW_CONN = "show_conn";
    public static final String SETTING_FILTERING_LEVEL = "filtering_level";
    public static final String SET_GLOBAL_SETTING_FOR_USER = "INSERT INTO   T_RES_TOPO_GLOBAL_SETTINGS (USERNAME, SETTING, VAL) VALUES (?,?,?)";
    public static final String UPDATE_GLOBAL_SETTING_FOR_USER = "UPDATE    T_RES_TOPO_GLOBAL_SETTINGS SET \tT_RES_TOPO_GLOBAL_SETTINGS.VAL = ? WHERE    T_RES_TOPO_GLOBAL_SETTINGS.USERNAME = ? and    T_RES_TOPO_GLOBAL_SETTINGS.SETTING = ?";
    public static final String GET_GLOBAL_SETTINGS_FOR_USER = "SELECT \tSETTINGS.SETTING SETTING, \tSETTINGS.VAL VAL FROM \tT_RES_TOPO_GLOBAL_SETTINGS SETTINGS WHERE    SETTINGS.USERNAME = ?";

    public static TopoSetting readSettings(Connection connection, String string) throws SQLException {
        TopoSetting topoSetting = new TopoSetting();
        TopoSettingHandler.readGlobalSettings(connection, string, topoSetting);
        return topoSetting;
    }

    public static void writeSettings(Connection connection, String string, TopoSetting topoSetting) throws SQLException {
        TopoSettingHandler.writeGlobalSettings(connection, string, topoSetting);
    }

    private static void readGlobalSettings(Connection connection, String string, TopoSetting topoSetting) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(GET_GLOBAL_SETTINGS_FOR_USER);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("SETTING");
                Integer n = (Integer)resultSet.getObject("VAL");
                int n2 = n;
                if (string2.equals(SETTING_SHOW_HEALTH)) {
                    if (n2 == 0) {
                        topoSetting.setOverlayHealthEnabled(false);
                        continue;
                    }
                    if (n2 != 1) continue;
                    topoSetting.setOverlayHealthEnabled(true);
                    continue;
                }
                if (string2.equals(SETTING_SHOW_PERF)) {
                    if (n2 == 0) {
                        topoSetting.setOverlayPerfEnabled(false);
                        continue;
                    }
                    if (n2 != 1) continue;
                    topoSetting.setOverlayPerfEnabled(true);
                    continue;
                }
                if (string2.equals(SETTING_SHOW_ZONE)) {
                    if (n2 == 0) {
                        topoSetting.setShowZoneEnabled(false);
                        continue;
                    }
                    if (n2 != 1) continue;
                    topoSetting.setShowZoneEnabled(true);
                    continue;
                }
                if (string2.equals(SETTING_SHOW_CONN)) {
                    if (n2 == 0) {
                        topoSetting.setShowConnectionEnabled(false);
                        continue;
                    }
                    if (n2 != 1) continue;
                    topoSetting.setShowConnectionEnabled(true);
                    continue;
                }
                if (!string2.equals(SETTING_FILTERING_LEVEL) || n2 != 0 && n2 != 2 && n2 != 1) continue;
                topoSetting.setFilteringLevel(n2);
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "readGlobalSettings", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerRequestHandler.class.getName(), "readGlobalSettings", sQLException);
                }
            }
        }
    }

    private static void writeGlobalSettings(Connection connection, String string, TopoSetting topoSetting) throws SQLException {
        int n = 0;
        if (topoSetting.isOverlayHealthEnabled()) {
            n = 1;
        }
        int n2 = 0;
        if (topoSetting.isOverlayPerfEnabled()) {
            n2 = 1;
        }
        int n3 = 0;
        if (topoSetting.isShowZoneEnabled()) {
            n3 = 1;
        }
        int n4 = 0;
        if (topoSetting.isShowConnectionEnabled()) {
            n4 = 1;
        }
        int n5 = topoSetting.getFilteringLevel();
        TopoSettingHandler.writeSetting(connection, string, SETTING_SHOW_HEALTH, n);
        TopoSettingHandler.writeSetting(connection, string, SETTING_SHOW_PERF, n2);
        TopoSettingHandler.writeSetting(connection, string, SETTING_SHOW_ZONE, n3);
        TopoSettingHandler.writeSetting(connection, string, SETTING_SHOW_CONN, n4);
        TopoSettingHandler.writeSetting(connection, string, SETTING_FILTERING_LEVEL, n5);
        connection.commit();
    }

    private static void writeSetting(Connection connection, String string, String string2, int n) throws SQLException {
        block11: {
            PreparedStatement preparedStatement = null;
            try {
                block12: {
                    preparedStatement = connection.prepareStatement(UPDATE_GLOBAL_SETTING_FOR_USER);
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    preparedStatement.setString(3, string2);
                    int n2 = preparedStatement.executeUpdate();
                    if (n2 != 0) break block11;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block12;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "writeGlobalSettings", sQLException);
                    }
                }
                preparedStatement = connection.prepareStatement(SET_GLOBAL_SETTING_FOR_USER);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
            }
            finally {
                block13: {
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block13;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "writeGlobalSettings", sQLException);
                    }
                }
            }
        }
    }
}

