/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.awt.Container;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.TStorm.gui.RemoveMissing;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.fabric.details.DetailsClient;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ITopoBackend;
import org.eclipse.aperi.gui.topo.widget.ITopoFrontend;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequestImpl;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.request.handler.ThreadPool;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerAutoRefreshTimer;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerCache;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerException;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerGuiSendRequest;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestNode;

public abstract class ViewerRequestDispatcher
implements ITopoBackend {
    private ITopoFrontend topoViewer = null;
    protected ThreadPool pool = new ThreadPool(2, 4);
    private Hashtable pendingRefresh = new Hashtable();
    private ViewerRequestNode pendingRequests;
    ViewerAutoRefreshTimer timer;
    private ControllerApp controllerApp = null;
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object object) {
            GraphEntity graphEntity = (GraphEntity)object;
            String string = (String)graphEntity.getEntityID().getID();
            return string;
        }

        public String extractDefaultElementManager(Object object) {
            String string = null;
            if (object instanceof GraphSubsystem) {
                GraphSubsystem graphSubsystem = (GraphSubsystem)object;
                string = graphSubsystem.getDefaultElementManager();
            } else if (object instanceof GraphSwitch) {
                GraphSwitch graphSwitch = (GraphSwitch)object;
                string = graphSwitch.getDefaultElementManager();
            } else if (object instanceof GraphTapeLibrary) {
                GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)object;
                string = graphTapeLibrary.getDefaultElementManager();
            }
            return string;
        }

        public String extractDisplayName(Object object) {
            GraphEntity graphEntity = (GraphEntity)object;
            String string = graphEntity.getDisplayName();
            return string;
        }
    };

    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
            this.pool = null;
        }
        this.pendingRefresh.clear();
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer = null;
        }
    }

    public void print(Container container) {
        this.topoViewer.print();
    }

    public void setTimer(ViewerAutoRefreshTimer viewerAutoRefreshTimer) {
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(2);
                viewerRequestImpl.getRefreshRate();
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
        this.timer = viewerAutoRefreshTimer;
    }

    public ITopoFrontend getITopoFrontend() {
        return this.topoViewer;
    }

    public ViewerAutoRefreshTimer getTimer() {
        return this.timer;
    }

    public synchronized ViewerRequestNode addToPending(ViewerGuiSendRequest viewerGuiSendRequest) {
        ViewerRequestNode viewerRequestNode = new ViewerRequestNode();
        viewerRequestNode.requestor = viewerGuiSendRequest;
        viewerRequestNode.next = this.pendingRequests;
        this.pendingRequests = viewerRequestNode;
        this.setBusyState(true);
        return viewerRequestNode;
    }

    public synchronized boolean removeNode(ViewerRequestNode viewerRequestNode) {
        boolean bl;
        Object object;
        if (this.pendingRefresh == null) {
            return false;
        }
        if (viewerRequestNode != null && viewerRequestNode.request != null && viewerRequestNode.request.requestData instanceof ViewerRequest) {
            object = (ViewerRequest)viewerRequestNode.request.requestData;
            this.pendingRefresh.remove(object);
        }
        object = null;
        ViewerRequestNode viewerRequestNode2 = this.pendingRequests;
        while (viewerRequestNode2 != null && viewerRequestNode2 != viewerRequestNode) {
            object = viewerRequestNode2;
            viewerRequestNode2 = viewerRequestNode2.next;
        }
        if (viewerRequestNode2 == null) {
            bl = false;
        } else {
            if (object != null) {
                ((ViewerRequestNode)object).next = viewerRequestNode2.next;
            } else {
                this.pendingRequests = viewerRequestNode2.next;
            }
            bl = true;
        }
        this.setBusyState(this.pendingRequests != null);
        return bl;
    }

    public synchronized void cancelAll() {
        this.pendingRefresh.clear();
        ViewerRequestNode viewerRequestNode = this.pendingRequests;
        while (viewerRequestNode != null) {
            viewerRequestNode.requestor.cancel();
            viewerRequestNode = viewerRequestNode.next;
        }
        this.pendingRequests = null;
        this.setBusyState(false);
        if (this.topoViewer != null) {
            this.topoViewer.cancelAllRefresh();
        }
    }

    public synchronized boolean nonePending() {
        return this.pendingRequests == null;
    }

    protected abstract void dispatchRequest(ViewerRequest var1) throws ViewerException;

    protected abstract void setBusyState(boolean var1);

    public void addListener(ITopoFrontend iTopoFrontend) {
        this.topoViewer = iTopoFrontend;
    }

    public void removeListener(ITopoFrontend iTopoFrontend) {
        this.topoViewer = null;
    }

    /*
     * Unable to fully structure code
     */
    public void handleResponse(short var1_1, Request var2_2, Response var3_3) {
        block25: {
            try {
                if (var3_3 == null || var3_3.responseData == null) break block25;
                var4_4 = (ViewerResponse)var3_3.responseData;
                var5_5 = var4_4.getResponse();
                if (var4_4.getResponseType() == 0) {
                    if (var5_5 instanceof GraphModel) {
                        try {
                            var6_6 = (GraphModel)var5_5;
                            var7_10 = var6_6.enumerate(GraphSubsystem.TYPE);
                            while (var7_10.hasMoreElements()) {
                                var8_12 = (GraphSubsystem)var7_10.nextElement();
                                var9_13 = ElementManagerManager.getInstance().getElementManager(var8_12, ViewerRequestDispatcher.elementManagerHelper);
                                if (var9_13 != null) {
                                    var8_12.setElementManager(var9_13);
                                    continue;
                                }
                                var8_12.setElementManager(var8_12.getDefaultElementManager());
                            }
                            var7_10 = var6_6.enumerate(GraphSwitch.TYPE);
                            while (var7_10.hasMoreElements()) {
                                var8_12 = (GraphSwitch)var7_10.nextElement();
                                var9_13 = ElementManagerManager.getInstance().getElementManager(var8_12, ViewerRequestDispatcher.elementManagerHelper);
                                if (var9_13 != null) {
                                    var8_12.setElementManager(var9_13);
                                    continue;
                                }
                                var8_12.setElementManager(var8_12.getDefaultElementManager());
                            }
                            var7_10 = var6_6.enumerate(GraphTapeLibrary.TYPE);
                            while (var7_10.hasMoreElements()) {
                                var8_12 = (GraphTapeLibrary)var7_10.nextElement();
                                var9_13 = ElementManagerManager.getInstance().getElementManager(var8_12, ViewerRequestDispatcher.elementManagerHelper);
                                if (var9_13 != null) {
                                    var8_12.setElementManager(var9_13);
                                    continue;
                                }
                                var8_12.setElementManager(var8_12.getDefaultElementManager());
                            }
                            ViewerCache.updateCache(var4_4.getResponseCode(), var6_6.getModelID(), var6_6);
                            var6_6.getModelID();
                            if (this.topoViewer != null && var3_3 != null) {
                                this.topoViewer.updateView(var4_4.getResponseCode(), var6_6);
                            }
                        }
                        catch (Exception var6_7) {
                            GraphDebug.exception(var6_7);
                        }
                    }
                } else if (var4_4.getResponseType() == 2) {
                    if (this.timer != null) {
                        var6_8 = var4_4.getRefreshRate();
                        this.timer.setTimeout(var6_8);
                        if (this.controllerApp != null) {
                            this.controllerApp.getTopoSetting().setRefreshRate(var6_8 / 60);
                        }
                    }
                } else if (var4_4.getResponseType() == 4) {
                    if (this.controllerApp == null) {
                        return;
                    }
                    if ((var6_9 = var4_4.getTopoSettings()) == null) ** continue;
                    var7_11 = this.controllerApp.getTopoSetting().getRefreshRate();
                    var6_9.setRefreshRate(var7_11);
                    this.controllerApp.setTopoSetting(var6_9);
                }
                if (var5_5 instanceof Throwable) {
                    GraphDebug.trace("Exception at the backend Topology Viewer handler:");
                    GraphDebug.exception((Throwable)var5_5);
                }
            }
            finally {
                if (var2_2 != null && var2_2.requestData != null) {
                    this.finishRefresh(var2_2);
                }
            }
        }
    }

    public void finishRefresh(Request request) {
        ViewerRequest viewerRequest = (ViewerRequest)request.requestData;
        if (viewerRequest.getModelID() != null) {
            GraphModel.ID iD = viewerRequest.getModelID();
            this.topoViewer.finishRefreshView(iD);
        }
    }

    public void refreshView(final GraphModel.ID iD) {
        if (this.timer != null) {
            this.timer.startTimer();
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestDispatcher.this.refreshView(iD, true);
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
    }

    public void refreshView(GraphModel.ID iD, boolean bl) {
        GraphModel graphModel;
        Serializable serializable;
        if (this.topoViewer == null) {
            return;
        }
        if (iD instanceof GraphModel.MultiEntityID && (serializable = ((GraphModel.MultiEntityID)iD).getSrcGroupEntity()) != null) {
            ((GraphEntity)serializable).setCollationKey(null);
        }
        serializable = new ViewerRequestImpl();
        serializable.addRequest(iD, null);
        try {
            this.topoViewer.startRefreshView(iD);
        }
        catch (Exception exception) {
            GraphDebug.trace("Refreshing modelId:" + iD);
            GraphDebug.exception(exception);
        }
        if (bl && (graphModel = ViewerCache.getFromCache(iD, true)) != null) {
            this.topoViewer.updateView(0, graphModel);
            return;
        }
        try {
            if (this.pendingRefresh.get(serializable) == null) {
                this.pendingRefresh.put(serializable, serializable);
                this.dispatchRequest((ViewerRequest)serializable);
            } else {
                GraphDebug.trace("Request in progress...");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector getOpenedViews() {
        return this.topoViewer.getOpenedViews();
    }

    public void refreshAllViews() {
        Vector vector;
        if (this.timer != null) {
            this.timer.resetTimer();
        }
        if ((vector = this.topoViewer.getOpenedViews()) == null || vector.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                for (GraphModel.ID iD : vector) {
                    ViewerRequestDispatcher.this.refreshView(iD, false);
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, false, true);
        }
    }

    public void closeView(GraphModel.ID iD) {
        ViewerCache.markAsClosed(iD);
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    public void launchElementManager(GraphEntity graphEntity) {
        ElementManagerManager.getInstance().getElementManager(graphEntity, this.getElementManagerHelper());
        ElementManagerManager.getInstance().launchElementManager(graphEntity, this.getElementManagerHelper());
    }

    public void setTimeout(int n) {
        if (this.timer != null) {
            this.timer.setTimeout(n);
        }
        try {
            ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
            viewerRequestImpl.setRequestType(1);
            viewerRequestImpl.setRefreshRate(n);
            this.dispatchRequest(viewerRequestImpl);
        }
        catch (ViewerException viewerException) {
            viewerException.printStackTrace();
        }
    }

    public void launchDetailsPanel(GraphEntity.ID iD) {
        String string = (String)iD.getID();
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        if ("switch:".equals(string2) || "hba:".equals(string2) || "host:".equals(string2) || "server:".equals(string2) || "fabric:".equals(string2) || "Port:".equalsIgnoreCase(string2) || "pe:".equals(string2) || "node:".equals(string2) || "other:".equals(string2)) {
            if ("other:".equals(string2)) {
                n = string3.indexOf(58);
                string2 = string3.substring(0, n + 1);
                string3 = string3.substring(n + 1);
            }
            if ("host:".equals(string2)) {
                string2 = "server:";
            }
            string2 = string2.toLowerCase();
            string2 = string2.substring(0, string2.length() - 1);
            DetailsClient.showDetails(string2, string3);
        } else if ("subsystem:".equals(string2)) {
            SubsystemDDI subsystemDDI = new SubsystemDDI(Integer.parseInt(string3));
            ((DataDisplayInfo)subsystemDDI).reDisplay();
        } else if ("tapelibrary:".equals(string2)) {
            LibraryDDI libraryDDI = new LibraryDDI(Integer.parseInt(string3));
            ((DataDisplayInfo)libraryDDI).reDisplay();
        }
    }

    public int getTimeout() {
        if (this.timer != null) {
            return this.timer.getTimeout();
        }
        return 0;
    }

    public void removeEntity(Vector vector) {
        Object object2;
        RemoveMissing removeMissing = new RemoveMissing();
        Vector<String> vector2 = new Vector<String>();
        for (Object object2 : vector) {
            GraphEntity.ID iD = ((GraphEntity)object2).getEntityID();
            String string = (String)iD.getID();
            if (string != null && string.startsWith("other:")) {
                string = string.substring(6);
            }
            if (string.startsWith("server:")) {
                string = "host:" + string.substring(7);
            }
            if (string.startsWith("port2port:")) {
                string = "port2port:" + string.substring(string.lastIndexOf(44) + 1);
            }
            string = string.toLowerCase();
            vector2.add(string);
        }
        object2 = new String[vector.size()];
        vector2.toArray((T[])object2);
        removeMissing.remove((String[])object2);
    }

    public void refreshPinnedList(GraphModel.ID iD) {
    }

    public void probeAll(final Vector vector) {
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(3);
                viewerRequestImpl.setRequestObject(vector);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, false, true);
        }
    }

    public void requestTopoSettings(ControllerApp controllerApp) {
        this.controllerApp = controllerApp;
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(4);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
    }

    public void persistTopoSettings(final TopoSetting topoSetting) {
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(5);
                viewerRequestImpl.setTopoSettings(topoSetting);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
    }
}

