/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.xmsg.MessageLog;

public class ViewerEntityPopulator {
    static Random r = new Random();
    public static final Integer ZERO_INT = new Integer(0);
    HashMap dictionary = new HashMap();
    public static int ctr = 0;

    public Object getUpdateDictionary(Object object) {
        Object v = this.dictionary.get(object);
        if (v == null) {
            this.dictionary.put(object, object);
            return object;
        }
        return v;
    }

    public String getPortType(Integer n) {
        if (n != null) {
            String string = DBConstants.getKeyFromValue("Port_Types", n.toString());
            return string;
        }
        return null;
    }

    public String getOsType(Integer n) {
        String string;
        if (n != null && (string = DBConstants.getKeyFromValue("OS_Type", n.toString())) != null) {
            return MessageLog.getMessageNoID(string);
        }
        return null;
    }

    public String getOtherType(Integer n) {
        if (n == null) {
            return null;
        }
        String string = null;
        string = n >= 30 ? FabricGuiUtil.getPeTypeString(n) : FabricGuiUtil.getNodeTypeString(n);
        return string;
    }

    public Vector getOperationalStatus(Integer n) {
        if (n == null) {
            return null;
        }
        Vector vector = DBConstants.convertOperationalstatusBitValueToArray(n);
        Vector vector2 = new Vector();
        for (String string : vector) {
            DBConstants.getKeyFromValue("Operational_Status", string);
            vector2.add(vector2);
        }
        return vector2;
    }

    public Integer translateStatus(Integer n) {
        if (n != null) {
            n = n == 0 ? GraphModelConstant.STATUS_NORMAL : (n == 1 ? GraphModelConstant.STATUS_WARNING : (n == 2 ? GraphModelConstant.STATUS_CRITICAL : (n == 3 ? GraphModelConstant.STATUS_MISSING : GraphModelConstant.STATUS_UNKNOWN)));
            return n;
        }
        return GraphModelConstant.STATUS_UNKNOWN;
    }

    public void setStatus(GraphEntity graphEntity, Integer n, Integer n2) {
        if (n == null) {
            graphEntity.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        } else if (n == 0 || n == 3) {
            graphEntity.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        } else {
            graphEntity.setHealthStatus(this.translateStatus(n2));
        }
    }

    public void populateSan(ResultSet resultSet, GraphFabric graphFabric) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("FABRIC_WWN"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("PARENT_DISPLAY_NAME"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("ACTIVE"));
        Boolean bl = null;
        if (n != null && n == 1) {
            bl = Boolean.TRUE;
        } else if (n != null && n == 0) {
            bl = Boolean.FALSE;
        }
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("IS_PHYSICAL"));
        Boolean bl2 = null;
        bl2 = n2 != null && n2 == 0 ? Boolean.FALSE : Boolean.TRUE;
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string6 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string7 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer n4 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n5 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        graphFabric.setOperationalStatus(n5);
        graphFabric.setWWN(string);
        graphFabric.setName(string2);
        graphFabric.setParentLabel(string3);
        graphFabric.setActive(bl);
        graphFabric.setIsPhysical(bl2);
        graphFabric.setDisplayName(string4);
        graphFabric.setUDP1(string5);
        graphFabric.setUDP2(string6);
        graphFabric.setUDP3(string7);
        graphFabric.setNumOfSubsystems(ZERO_INT);
        graphFabric.setNumOfComputers(ZERO_INT);
        graphFabric.setNumOfSwitches(ZERO_INT);
        graphFabric.setNumOfOthers(ZERO_INT);
        graphFabric.setNumOfTapeLibraries(ZERO_INT);
        this.setStatus(graphFabric, n4, n3);
    }

    public void populateRDBMS(ResultSet resultSet, GraphDatabaseGroup graphDatabaseGroup) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("RDBMS_NAME"));
        graphDatabaseGroup.setDisplayName(string);
    }

    public void populateDatabase(ResultSet resultSet, GraphDatabase graphDatabase) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        graphDatabase.setDisplayName(string);
    }

    public void populateTableSpace(ResultSet resultSet, GraphTableSpace graphTableSpace) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        graphTableSpace.setDisplayName(string);
    }

    public void populateTableFile(ResultSet resultSet, GraphTableSpace graphTableSpace) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        graphTableSpace.setDisplayName(string);
    }

    public void populateFileSystem(ResultSet resultSet, GraphFilesystem graphFilesystem) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getUpdateDictionary(resultSet.getObject("PHYSICAL_SIZE"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("MOUNT_POINT"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("FILESYSTEM_TYPE"));
        graphFilesystem.setDisplayName(string);
        graphFilesystem.setMountPoint(string);
        graphFilesystem.setPhysicalSize(bigDecimal != null ? new Long(bigDecimal.longValue()) : null);
        graphFilesystem.setType(n);
    }

    public void populateLVM(ResultSet resultSet, GraphLogicalVolumeManager graphLogicalVolumeManager) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("VOLGROUP_TYPE"));
        BigDecimal bigDecimal = (BigDecimal)this.getUpdateDictionary(resultSet.getObject("CAPACITY"));
        BigDecimal bigDecimal2 = (BigDecimal)this.getUpdateDictionary(resultSet.getObject("FREESPACE"));
        graphLogicalVolumeManager.setDisplayName(string);
        graphLogicalVolumeManager.setFreeSpace(bigDecimal2 != null ? new Long(bigDecimal2.longValue()) : null);
        graphLogicalVolumeManager.setCapacity(bigDecimal != null ? new Long(bigDecimal.longValue()) : null);
        graphLogicalVolumeManager.setType(n);
    }

    public void populateLogicalVolume(ResultSet resultSet, GraphLogicalVolume graphLogicalVolume) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("PATH"));
        graphLogicalVolume.setDisplayName(string);
    }

    public void populateSubsystem(ResultSet resultSet, GraphSubsystem graphSubsystem) throws SQLException {
        Long l = (Long)this.getUpdateDictionary(resultSet.getObject("ALLOCATED_CAPACITY"));
        Long l2 = (Long)this.getUpdateDictionary(resultSet.getObject("AVAILABLE_CAPACITY"));
        Long l3 = (Long)this.getUpdateDictionary(resultSet.getObject("BACKEND_STORAGE_CAPACITY"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        Long l4 = (Long)this.getUpdateDictionary(resultSet.getObject("CACHE"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("DEFAULT_MANAGER"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("TYPE"));
        String string6 = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String string7 = (String)this.getUpdateDictionary(resultSet.getObject("IP_ADDRESS"));
        String string8 = (String)this.getUpdateDictionary(resultSet.getObject("CODE_LEVEL"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        String string9 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string10 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string11 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        graphSubsystem.setIsSVC("SVC".equals(string5) ? Boolean.TRUE : Boolean.FALSE);
        graphSubsystem.setAllocatedCapacity(l);
        graphSubsystem.setAvailableCapacity(l2);
        graphSubsystem.setBackendStorageCapacity(l3);
        graphSubsystem.setVendor(string);
        graphSubsystem.setModel(string2);
        graphSubsystem.setCache(l4);
        graphSubsystem.setType(string5);
        graphSubsystem.setCodeLevel(string8);
        graphSubsystem.setDisplayName(string3);
        graphSubsystem.setIPAddress(string7);
        graphSubsystem.setSerialNumber(string6);
        graphSubsystem.setOperationalStatus(n3);
        graphSubsystem.setDefaultElementManager(string4);
        graphSubsystem.setUDP1(string9);
        graphSubsystem.setUDP2(string10);
        graphSubsystem.setUDP3(string11);
        this.setStatus(graphSubsystem, n2, n);
    }

    public void populateTapeLibrary(ResultSet resultSet, GraphTapeLibrary graphTapeLibrary) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String string6 = (String)this.getUpdateDictionary(resultSet.getObject("DEFAULT_MANAGER"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("TOTAL_CARTRIDGES"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("TOTAL_DRIVES"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("MAX_CARTRIDGES"));
        Integer n4 = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n5 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n6 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        String string7 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string8 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string9 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        graphTapeLibrary.setFirmwareVersion(string);
        graphTapeLibrary.setVendor(string2);
        graphTapeLibrary.setModel(string3);
        graphTapeLibrary.setMaxNumOfCartridges(n3);
        graphTapeLibrary.setNumOfCartridges(n);
        graphTapeLibrary.setNumOfDrives(n2);
        graphTapeLibrary.setDisplayName(string5);
        graphTapeLibrary.setSerialNumber(string4);
        graphTapeLibrary.setDefaultElementManager(string6);
        graphTapeLibrary.setUDP1(string7);
        graphTapeLibrary.setUDP2(string8);
        graphTapeLibrary.setUDP3(string9);
        graphTapeLibrary.setOperationalStatus(n6);
        this.setStatus(graphTapeLibrary, n5, n4);
    }

    public void populateTapeDrive(ResultSet resultSet, GraphTapeDrive graphTapeDrive) throws SQLException {
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer n4 = (Integer)this.getUpdateDictionary(resultSet.getObject("NEEDS_CLEANING"));
        Long l = (Long)this.getUpdateDictionary(resultSet.getObject("MOUNT_COUNT"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("LOCATION"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        if (n4 != null && new Integer(1).equals(n4)) {
            graphTapeDrive.setNeedCleaning(Boolean.TRUE);
        } else {
            graphTapeDrive.setNeedCleaning(Boolean.FALSE);
        }
        graphTapeDrive.setFirmwareVersion(string2);
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string6 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        graphTapeDrive.setDisplayName(string3);
        graphTapeDrive.setOperationalStatus(n2);
        graphTapeDrive.setMountCount(l);
        graphTapeDrive.setLocation(string);
        graphTapeDrive.setUDP1(string4);
        graphTapeDrive.setUDP2(string5);
        graphTapeDrive.setUDP3(string6);
        this.setStatus(graphTapeDrive, n, n3);
    }

    public void populateTapeMediaChanger(ResultSet resultSet, GraphMediaChanger graphMediaChanger) throws SQLException {
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        graphMediaChanger.setFirmwareVersion(string);
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        graphMediaChanger.setDisplayName(string2);
        graphMediaChanger.setOperationalStatus(n2);
        graphMediaChanger.setUDP1(string3);
        graphMediaChanger.setUDP2(string4);
        graphMediaChanger.setUDP3(string5);
        this.setStatus(graphMediaChanger, n, n3);
    }

    public void populateSwitch(ResultSet resultSet, GraphSwitch graphSwitch, boolean bl) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("LOGICAL_NAME"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("SWITCH_WWN"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String string6 = (String)this.getUpdateDictionary(resultSet.getObject("DESCRIPTION"));
        String string7 = (String)this.getUpdateDictionary(resultSet.getObject("IP_ADDRESS"));
        String string8 = (String)this.getUpdateDictionary(resultSet.getObject("DOMAIN"));
        String string9 = (String)this.getUpdateDictionary(resultSet.getObject("VERSION"));
        String string10 = (String)this.getUpdateDictionary(resultSet.getObject("DEFAULT_MANAGER"));
        String string11 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String string12 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string13 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string14 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String string15 = (String)this.getUpdateDictionary(resultSet.getObject("PARENT_SWITCH_WWN"));
        graphSwitch.setVendor(string);
        graphSwitch.setModel(string2);
        graphSwitch.setLogicalName(string3);
        graphSwitch.setWWN(string4);
        graphSwitch.setSerialNumber(string5);
        graphSwitch.setDescription(string6);
        graphSwitch.setIPAddress(string7);
        graphSwitch.setDomain(string8);
        graphSwitch.setVersion(string9);
        graphSwitch.setDisplayName(string11);
        graphSwitch.setParentWWN(string15);
        graphSwitch.setUDP1(string12);
        graphSwitch.setUDP2(string13);
        graphSwitch.setUDP3(string14);
        graphSwitch.setDefaultElementManager(string10);
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        graphSwitch.setOperationalStatus(n3);
        this.setStatus(graphSwitch, n2, n);
    }

    public void populateHost(ResultSet resultSet, GraphComputer graphComputer) throws SQLException {
        boolean bl;
        String string = (String)this.getUpdateDictionary(resultSet.getObject("GUID"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("HOST_NAME"));
        String string3 = (String)this.getUpdateDictionary(this.getOsType((Integer)resultSet.getObject("OS_TYPE")));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("OS_VERSION"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("IP_ADDRESS"));
        String string6 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String string7 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string8 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string9 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String string10 = (String)this.getUpdateDictionary(resultSet.getObject("DAT_STATUS"));
        String string11 = (String)this.getUpdateDictionary(resultSet.getObject("DEV_STATUS"));
        graphComputer.setGUID(string);
        graphComputer.setOSType(string3);
        graphComputer.setOSVersion(string4);
        graphComputer.setHostname(string2);
        graphComputer.setIPAddress(string5);
        boolean bl2 = bl = string10 != null && string11 != null;
        if (string11 != null) {
            string11 = string11.trim();
        }
        String string12 = String.valueOf(string10 != null ? "data(" + string10 + ")" : "") + (bl ? "," : "") + (string11 != null ? "device(" + string11 + ")" : "");
        graphComputer.setAgentsInstalled((String)this.getUpdateDictionary(string12));
        graphComputer.setDisplayName(string6);
        graphComputer.setUDP1(string7);
        graphComputer.setUDP2(string8);
        graphComputer.setUDP3(string9);
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        graphComputer.setOperationalStatus(n3);
        this.setStatus(graphComputer, n2, n);
    }

    public void populateHBA(ResultSet resultSet, GraphHBA graphHBA, boolean bl) throws SQLException {
        String string = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("API_VERSION"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("HBA_WWN"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("FIRMWARE_VERSION"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        String string6 = (String)this.getUpdateDictionary(resultSet.getObject("DRIVER_VERSION"));
        String string7 = (String)this.getUpdateDictionary(resultSet.getObject("DRIVER_NAME"));
        String string8 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        graphHBA.setVendor(string);
        graphHBA.setModel(string2);
        graphHBA.setWWN(string3);
        graphHBA.setFirmwareVersion(string4);
        graphHBA.setSerialNumber(string5);
        graphHBA.setDriverVersion(string6);
        graphHBA.setDriverName(string7);
        graphHBA.setDisplayName(string8);
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        Integer cfr_ignored_1 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        graphHBA.setOperationalStatus(n3);
        this.setStatus(graphHBA, n2, n);
    }

    public void populateOther(ResultSet resultSet, GraphOther graphOther) throws SQLException {
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("DISPLAY_TYPE"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        graphOther.setDisplayName(string);
        graphOther.setType(n);
        graphOther.setVendor(string2);
        graphOther.setModel(string3);
        graphOther.setSerialNumber(string4);
        this.setStatus(graphOther, n2, n3);
    }

    public void populatePort(ResultSet resultSet, GraphFCPort graphFCPort) throws SQLException {
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("TYPE"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("PORT_NUMBER"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("NAME"));
        Long l = (Long)this.getUpdateDictionary(resultSet.getObject("PORT_SPEED"));
        graphFCPort.setName(string3);
        graphFCPort.setType((String)this.getUpdateDictionary(this.getPortType(n)));
        graphFCPort.setPortNumber(string2);
        graphFCPort.setDisplayName(string);
        graphFCPort.setPortSpeed(l);
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n4 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        graphFCPort.setOperationalStatus(n4);
        this.setStatus(graphFCPort, n3, n2);
    }

    public void populatePort2Port(ResultSet resultSet, GraphEntity graphEntity) throws SQLException {
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        if (n == null) {
            graphEntity.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
        } else if (n == 0) {
            graphEntity.setHealthStatus(GraphModelConstant.STATUS_MISSING);
        } else {
            graphEntity.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
        }
    }

    public void populateZone(ResultSet resultSet, GraphZone graphZone) throws SQLException {
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("ZONE_TYPE"));
        String string = null;
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("ACTIVE"));
        Boolean bl = null;
        bl = n != null && n == 1 ? Boolean.TRUE : Boolean.FALSE;
        String cfr_ignored_1 = (String)this.getUpdateDictionary(resultSet.getObject("FABRIC_WWN"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("ZONE_NAME"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("DESCRIPTION"));
        graphZone.setActive(bl);
        graphZone.setDescription(string3);
        graphZone.setZoneType(string);
        graphZone.setDisplayName(string2);
        graphZone.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
    }

    public void populateZoneSet(ResultSet resultSet, GraphZoneSet graphZoneSet) throws SQLException {
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("ACTIVE"));
        Boolean bl = null;
        bl = n != null && n == 1 ? Boolean.TRUE : Boolean.FALSE;
        String cfr_ignored_0 = (String)this.getUpdateDictionary(resultSet.getObject("FABRIC_WWN"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("ZSET_NAME"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("DESCRIPTION"));
        graphZoneSet.setActive(bl);
        graphZoneSet.setDescription(string2);
        graphZoneSet.setDisplayName(string);
        graphZoneSet.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
    }

    public void populateLUN(ResultSet resultSet, GraphLun graphLun) throws SQLException {
        Integer cfr_ignored_0 = (Integer)resultSet.getObject("VOLUME_ID");
        Integer cfr_ignored_1 = (Integer)resultSet.getObject("HOST_ID");
        Integer n = (Integer)resultSet.getObject("TARGET_ID");
        Integer n2 = (Integer)resultSet.getObject("DEVICE_LUN_ID");
        Integer cfr_ignored_2 = (Integer)resultSet.getObject("DEVICE_ID");
        String string = (String)resultSet.getObject("PATH");
        BigDecimal bigDecimal = (BigDecimal)resultSet.getObject("CAPACITY");
        BigDecimal bigDecimal2 = (BigDecimal)resultSet.getObject("FREE_SPACE");
        Integer n3 = (Integer)resultSet.getObject("CONSOLIDATED_STATUS");
        Integer n4 = (Integer)resultSet.getObject("OPERATIONAL_STATUS");
        graphLun.setLunID(n2);
        graphLun.setCapacity(bigDecimal == null ? null : new Long(bigDecimal.longValue()));
        graphLun.setFreeSpace(bigDecimal2 == null ? null : new Long(bigDecimal2.longValue()));
        graphLun.setOperationalStatus(n4);
        graphLun.setDisplayName(string);
        graphLun.setSCSITargetID(n);
        this.setStatus(graphLun, new Integer(1), n3);
    }

    public void populateStoragePool(ResultSet resultSet, GraphPool graphPool) throws SQLException {
        Long l = (Long)this.getUpdateDictionary(resultSet.getObject("TOTAL_MANAGED_SPACE"));
        Long l2 = (Long)this.getUpdateDictionary(resultSet.getObject("REMAINING_MANAGED_SPACE"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("RAID_LEVEL"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("PRIMORDIAL"));
        Boolean bl = null;
        bl = n != null && n == 1 ? Boolean.TRUE : Boolean.FALSE;
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("NUMBER_OF_STORAGE_VOLUMES"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("TOTAL_DISKS"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String string5 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        graphPool.setNumOfDisks(n3);
        graphPool.setTotalManagedSpace(l);
        graphPool.setRemainingManagedSpace(l2);
        graphPool.setRAIDLevel(string);
        graphPool.setPrimodial(bl);
        graphPool.setNumOfVolumes(n2);
        graphPool.setUDP1(string2);
        graphPool.setUDP2(string3);
        graphPool.setUDP3(string4);
        graphPool.setDisplayName(string5);
        Integer n4 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n5 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n6 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        graphPool.setOperationalStatus(n6);
        Integer cfr_ignored_0 = (Integer)this.getUpdateDictionary(resultSet.getObject("PROPAGATED_STATUS"));
        this.setStatus(graphPool, n5, n4);
    }

    public void populateStorageVolume(ResultSet resultSet, GraphVolume graphVolume) throws SQLException {
        Long l = (Long)this.getUpdateDictionary(resultSet.getObject("CAPACITY"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("IS_ASSIGNED"));
        Boolean bl = null;
        if (n != null) {
            if (n == 1) {
                bl = Boolean.TRUE;
            } else if (n == 0) {
                bl = Boolean.FALSE;
            }
        }
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("FORMAT"));
        Integer n3 = GraphVolume.FORMAT_FB;
        if (n2 != null) {
            if (n2 >= 1 && n2 <= 4) {
                n3 = GraphVolume.FORMAT_FB;
            } else if (n2 == 5) {
                n3 = GraphVolume.FORMAT_CKD_3380;
            } else if (n2 == 6) {
                n3 = GraphVolume.FORMAT_CKD_3390;
            }
        }
        String string = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB1"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB2"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("USER_ATTRIB3"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        graphVolume.setIsAssigned(bl);
        graphVolume.setCapacity(l);
        graphVolume.setUDP1(string);
        graphVolume.setUDP2(string2);
        graphVolume.setUDP3(string3);
        graphVolume.setDisplayName(string4);
        graphVolume.setFormat(n3);
        Integer n4 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        Integer n5 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n6 = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        graphVolume.setOperationalStatus(n6);
        this.setStatus(graphVolume, n5, n4);
    }

    public void populateStorageDisk(ResultSet resultSet, GraphDisk graphDisk) throws SQLException {
        Long l = (Long)this.getUpdateDictionary(resultSet.getObject("CAPACITY"));
        String string = (String)this.getUpdateDictionary(resultSet.getObject("DISPLAY_NAME"));
        String string2 = (String)this.getUpdateDictionary(resultSet.getObject("VENDOR"));
        String string3 = (String)this.getUpdateDictionary(resultSet.getObject("MODEL"));
        String string4 = (String)this.getUpdateDictionary(resultSet.getObject("SERIAL_NUMBER"));
        Integer n = (Integer)this.getUpdateDictionary(resultSet.getObject("OPERATIONAL_STATUS"));
        Integer n2 = (Integer)this.getUpdateDictionary(resultSet.getObject("DETECTABLE"));
        Integer n3 = (Integer)this.getUpdateDictionary(resultSet.getObject("CONSOLIDATED_STATUS"));
        graphDisk.setCapacity(l);
        graphDisk.setSerialNumber(string4);
        graphDisk.setDisplayName(string);
        graphDisk.setVendor(string2);
        graphDisk.setModel(string3);
        graphDisk.setOperationalStatus(n);
        this.setStatus(graphDisk, n2, n3);
    }

    public void populateVolumeGroup(ResultSet resultSet, GraphSwitch graphSwitch) throws SQLException {
    }
}

