/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL2;

public class ViewerPinnedList {
    public static boolean debug = false;
    public static String SELECT_SAN = "SELECT distinct \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 , \tPARENT.FABRIC_ID PARENT_FABRIC_ID from     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN ORDER by PARENT.FABRIC_ID DESC";
    public static String COUNT_OTHER_FROM_SAN = "select \tcount (OTHER2FABRIC.PREFIX_ID) TOTAL from T_VIEW_VOTHER2FABRIC OTHER2FABRIC where \tOTHER2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_ARRAY_FROM_SAN = "select \tCOUNT(SUBSYSTEM2FABRIC.SUBSYSTEM_ID) TOTAL FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC WHERE \tSUBSYSTEM2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_TAPE_FROM_SAN = "select \tCOUNT(TAPE2FABRIC.TAPE_LIBRARY_ID) TOTAL FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE     TAPE2FABRIC.FABRIC_ID = ?";
    public static String COUNT_HOST_FROM_SAN = "select \t\tcount(HOST2FABRIC.HOST_ID) TOTAL FROM T_VIEW_VHOST2FABRIC HOST2FABRIC WHERE    HOST2FABRIC.FABRIC_ID = ? ";
    public static String COUNT_SWITCH_FROM_SAN = "select  \tcount(distinct SWITCH.SWITCH_WWN) TOTAL from T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_VIEW_VSWITCH SWITCH where \tSWITCH2FABRIC.FABRIC_ID = ? and   SWITCH2FABRIC.PREFIX_ID = SWITCH.PREFIX_ID and \tSWITCH2FABRIC.SWITCH_ID = SWITCH.SWITCH_ID ";

    public static int getTotalSingle(Connection connection, String string, Integer n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerPinnedList.class.getName(), "getView", "");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = resultSet.getInt("TOTAL");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ViewerPinnedList.class.getName(), "getTotal", "result=" + n2);
                }
                int n3 = n2;
                return n3;
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerPinnedList.class.getName(), "getTotal", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerPinnedList.class.getName(), "getTotal", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerPinnedList.class.getName(), "getTotal", "result=0");
        }
        return 0;
    }

    public static int getTotal(Connection connection, String string, Integer n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerPinnedList.class.getName(), "getView", "");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    int n2 = resultSet.getInt("TOTAL");
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit(ViewerPinnedList.class.getName(), "getTotal", "result=" + n2);
                    }
                    int n3 = n2;
                    return n3;
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerPinnedList.class.getName(), "getTotal", exception);
                }
            }
        }
        finally {
            block26: {
                block25: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block25;
                        TraceLogger.exception(ViewerPinnedList.class.getName(), "getTotal", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block26;
                    TraceLogger.exception(ViewerPinnedList.class.getName(), "getTotal", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerPinnedList.class.getName(), "getTotal", "result=0");
        }
        return 0;
    }

    public static void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public static void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerPinnedList.class.getName(), "getView", "");
        }
        GraphModelPinList graphModelPinList = null;
        System.currentTimeMillis();
        GraphModel.MultiEntityID multiEntityID = (GraphModel.MultiEntityID)viewerRequest.getModelID();
        Vector vector = multiEntityID.getChildFocusEntityIDs();
        String string = null;
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            graphModelPinList = new GraphModelPinList((GraphModelPinList.ID)viewerRequest.getModelID());
            for (Object e : vector) {
                GraphEntity.ID iD = (GraphEntity.ID)e;
                string = (String)iD.getID();
                int n = string.indexOf(58);
                String string2 = string.substring(0, n + 1);
                string = string.substring(n + 1);
                int n2 = Integer.parseInt(string);
                if (iD instanceof GraphComputer.ID) {
                    new ViewerServerL2().getSansFromHost(connection, (GraphModel)graphModelPinList, hashMap, string2, n2);
                    new ViewerServerL2().getHost(connection, graphModelPinList, hashMap, string2, n2);
                } else if (iD instanceof GraphSwitch.ID) {
                    new ViewerSwitchL2().getSansFromSwitch(connection, (GraphModel)graphModelPinList, hashMap, string2, n2);
                    new ViewerSwitchL2().getSwitch(connection, graphModelPinList, hashMap, string2, n2, false);
                } else if (iD instanceof GraphSubsystem.ID) {
                    new ViewerSubsystemL2().getSansFromSubsystem(connection, (GraphModel)graphModelPinList, hashMap, string2, n2);
                    new ViewerSubsystemL2().getSubsystem(connection, graphModelPinList, hashMap, string2, n2, false);
                } else if (iD instanceof GraphTapeLibrary.ID) {
                    new ViewerTapeLibraryL2().getSansFromTape(connection, (GraphModel)graphModelPinList, hashMap, string2, n2);
                    new ViewerTapeLibraryL2().getTapeLibrary(connection, graphModelPinList, hashMap, string2, n2);
                } else if (iD instanceof GraphOther.ID) {
                    new ViewerOtherL2().getSansFromUnknown(connection, (GraphModel)graphModelPinList, hashMap, string2, n2);
                    new ViewerOtherL2().getOther(connection, graphModelPinList, hashMap, string2, n2);
                }
                ViewerPinnedList.commit(connection);
            }
            graphModelPinList.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
            viewerResponse.addResponse(0, graphModelPinList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerPinnedList.class.getName(), "getView", "");
        }
    }

    public static void main(String[] stringArray) {
    }
}

