/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2HBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase2TableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup2Database;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerServerL2
extends ViewerServerL1 {
    public static boolean debug = false;
    public static final String SELECT_HOST = "SELECT \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VHOST T_RES_HOST WHERE \tT_RES_HOST.PREFIX_ID = ? and \tT_RES_HOST.COMPUTER_ID = ?";
    public static final String SELECT_PORT_FROM_HOST = "SELECT     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL and RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME \t\t  ELSE T_RES_PORT.NAME \t END DISPLAY_NAME,     T_RES_PORT.NAME || '+' || CAST(T_RES_PORT.NAME_FORMAT as CHAR) NATURAL_KEY, \t T_RES_PORT.PORT_ID PORT_ID, \t T_RES_PORT.NAME NAME, \t T_RES_PORT.NAME_FORMAT NAME_FORMAT, \t T_RES_PORT.PORT_NUMBER PORT_NUMBER, \t T_RES_PORT.TYPE TYPE, \t T_RES_PORT.PORT_SPEED PORT_SPEED, \t T_RES_PORT.DETECTABLE DETECTABLE, \t T_RES_PORT.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_PORT.CONSOLIDATED_STATUS CONSOLIDATED_STATUS , HBA.HBA_ID HBA_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_RES_PORT left outer join T_RES_HBA HBA on T_RES_PORT.HBA_ID = HBA.HBA_ID WHERE     HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = T_RES_PORT.PORT_ID";
    public static final String SELECT_HBA_FROM_HOST = "SELECT \t\t(T_RES_HBA.HBA_WWN || CASE WHEN T_RES_HBA.NAME IS NOT NULL THEN '-' || T_RES_HBA.NAME ELSE '' END || CASE WHEN T_RES_HBA.SERIAL_NUMBER IS NOT NULL THEN '(' || T_RES_HBA.SERIAL_NUMBER || ')' ELSE '' END) DISPLAY_NAME, \t\tT_RES_HBA.HBA_ID HBA_ID, \t\tT_RES_HBA.API_VERSION API_VERSION, \t\tT_RES_HBA.HBA_WWN HBA_WWN, \t\tT_RES_HBA.DRIVER_VERSION DRIVER_VERSION, \t\tT_RES_HBA.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_HBA.DRIVER_NAME DRIVER_NAME, \t\tT_RES_HBA.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_HBA.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HBA.DETECTABLE DETECTABLE, \t\tT_RES_HBA.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HBA.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL FROM     T_RES_HOST HOST, T_RES_HBA left outer join T_RES_VENDOR VENDOR on \t T_RES_HBA.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \t T_RES_HBA.MODEL_ID = MODEL.MODEL_ID WHERE \t HOST.COMPUTER_ID = ? and     HOST.COMPUTER_ID = T_RES_HBA.HOST_ID";
    public static final String SELECT_PORT2PORT_FROM_HOST = "SELECT \tHOST2PORT2PORT.PORT1_ID PORT1_ID, \tHOST2PORT2PORT.PORT2_ID PORT2_ID, \tCASE \t\tWHEN PORT1.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT1.DISPLAY_NAME) != '' THEN PORT1.DISPLAY_NAME \t\tELSE PORT1.NAME \tEND PORT1_NAME, \tPORT1.PORT_NUMBER PORT_NUMBER1, \tCASE \t\tWHEN PORT2.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT2.DISPLAY_NAME) != '' THEN PORT2.DISPLAY_NAME \t\tELSE PORT2.NAME \tEND PORT2_NAME, \tPORT2.PORT_NUMBER PORT_NUMBER2,    HOST2PORT2PORT.PORT2PORT_ID PORT2PORT_ID,    HOST2PORT2PORT.DETECTABLE DETECTABLE, \tENTITY2PORT.PREFIX_ID, \tENTITY2PORT.ENTITY_ID FROM  \t T_RES_PORT PORT1, T_RES_PORT PORT2,  (SELECT     HOST2PORT.PREFIX_ID,     HOST2PORT.HOST_ID HOST_ID, \t PORT2PORT.PORT_ID2 PORT1_ID,     HOST2PORT.PORT_ID PORT2_ID,    PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\t PORT2PORT.DETECTABLE DETECTABLE FROM T_VIEW_VHOST2PORT HOST2PORT,     T_VIEW_PORT2PORT PORT2PORT WHERE     HOST2PORT.PORT_ID = PORT2PORT.PORT_ID1) HOST2PORT2PORT, T_VIEW_ENTITY2PORT ENTITY2PORT WHERE \tENTITY2PORT.PORT_ID = PORT1.PORT_ID and \tPORT1.PORT_ID = HOST2PORT2PORT.PORT1_ID and    PORT2.PORT_ID = HOST2PORT2PORT.PORT2_ID and \tHOST2PORT2PORT.PREFIX_ID = ? and \tHOST2PORT2PORT.HOST_ID = ?";
    public static final String SELECT_SWITCH_FROM_HOST = "SELECT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 ,\t SWITCH2HOST.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2HOST SWITCH2HOST,    T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on     T_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID WHERE \t SWITCH2HOST.HOST_PREFIX_ID = ?  and \t SWITCH2HOST.HOST_ID = ? and  \t SWITCH2HOST.SWITCH_PREFIX_ID = T_RES_SWITCH.PREFIX_ID and \t SWITCH2HOST.SWITCH_ID = T_RES_SWITCH.SWITCH_ID ";
    public static final String SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST = "SELECT \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\t HOST2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM,     T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on     T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE \t HOST2SUBSYSTEM.HOST_PREFIX_ID = ? and \t HOST2SUBSYSTEM.HOST_ID = ? and     HOST2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \t HOST2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static String SELECT_SANS_FOR_HOST = "SELECT\t\tHOST2FABRIC.PREFIX_ID PREFIX_ID,\t\tHOST2FABRIC.HOST_ID HOST_ID,\t    HOST2FABRIC.FABRIC_ID FABRIC_ID FROM T_VIEW_VHOST2FABRIC HOST2FABRIC WHERE \t\t? = HOST2FABRIC.PREFIX_ID and \t    ? = HOST2FABRIC.HOST_ID ";
    public static String SELECT_SANS_FROM_ARRAY_FROM_HOST = "SELECT     SUBSYSTEM2FABRIC.FABRIC_ID,     SUBSYSTEM2FABRIC.PREFIX_ID, \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC, T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM WHERE     SUBSYSTEM2FABRIC.PREFIX_ID = HOST2SUBSYSTEM.SUBSYSTEM_PREFIX_ID and \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID = HOST2SUBSYSTEM.SUBSYSTEM_ID and     HOST2SUBSYSTEM.PREFIX_ID = ? and \t HOST2SUBSYSTEM.HOST_ID = ?";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_HOST = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VHOST2PORT HOST2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE    HOST2PORT.PREFIX_ID = ? and    HOST2PORT.HOST_ID = ? and \tHOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_HOST = "SELECT DISTINCT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZONE, T_RES_FABRIC FABRIC WHERE \t HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_HOST = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     PORT2ZONE2.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID left outer join T_RES_PORT PORT on  \t PORT2ZONE2.PORT_ID = PORT.PORT_ID WHERE     HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID  ";
    public static final String SELECT_ZSET2ZONE_FROM_HOST = "SELECT DISTINCT     PORT2ZONE.ZONE_ID ZONE_ID,     ZSET2ZONE.ZSET_ID ZSET_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZONE PORT2ZONE, \tT_RES_ZSET2ZONE ZSET2ZONE WHERE \t HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_HOST = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZSET PORT2ZSET,     T_RES_ZSET, T_RES_FABRIC FABRIC WHERE \t HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_VOLGROUP_FROM_HOST = "SELECT distinct \tT_RES_VOLGROUP.VOLGROUP_ID, \tT_RES_VOLGROUP.NAME NAME, \tT_RES_VOLGROUP.FREESPACE, \tT_RES_VOLGROUP.CAPACITY, \tT_RES_VOLGROUP.VOLGROUP_TYPE   FROM \tT_RES_VOLGROUP WHERE \t\tT_RES_VOLGROUP.COMPUTER_ID = ? ";
    public static final String DISK2VOLGROUP = "(SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP ";
    public static final String SELECT_LVM2LOGICALS_FROM_HOST = "SELECT \tLOGICALDISKS.VOLGROUP_ID, \tLOGICALDISKS.LOGICAL_DISK_ID, \tLOGICALDISKS.MOUNT_POINT, \tLOGICALDISKS.FILESYSTEM_ID, \tLOGICALDISKS.NAME FROM (SELECT distinct \tf.computer_id, \tDISK2VOLGROUP.volgroup_id, \tf.logical_disk_id, \tf.mount_point, \tf.filesystem_id,  \t'' name FROM \tt_res_chunk c, t_res_filesystem f, (SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP WHERE    DISK2VOLGROUP.DEVICE_ID = c.disk_id and \tc.logical_disk_id = f.logical_disk_id UNION ALL SELECT distinct \tf.computer_id, \tDISK2VOLGROUP.volgroup_id, \tf.logical_disk_id, \tf.mount_point, \tf.filesystem_id,  \t'' name FROM \tt_res_chunk c, t_res_filesystem f, t_res_logical_disk l, (SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP WHERE    DISK2VOLGROUP.device_id = c.disk_id and \tc.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id > 0    and l.parent_logdisk_id = f.logical_disk_id UNION ALL SELECT distinct \ts.computer_id, \tDISK2VOLGROUP.volgroup_id, \tc.logical_disk_id, \ts.path mount_point, \tCAST(NULL AS INTEGER) filesystem_id, \ts.name FROM \tt_res_chunk c, t_res_share s, t_res_logical_disk l, (SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP WHERE    DISK2VOLGROUP.device_id = c.disk_id and \tc.logical_disk_id = s.resource_id    and c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id = -1    and l.logical_disk_id not in   (select logical_disk_id from t_res_filesystem) ) LOGICALDISKS WHERE \tLOGICALDISKS.COMPUTER_ID = ?";
    public static final String SELECT_LUN2LOGICAL_FROM_HOST = "SELECT \tLOGICALDISKS.DISK_ID, \tLOGICALDISKS.LOGICAL_DISK_ID FROM (SELECT distinct \tf.computer_id, \tc.disk_id  , \tf.logical_disk_id FROM \tt_res_chunk c, t_res_filesystem f WHERE    c.logical_disk_id = f.logical_disk_id UNION ALL SELECT distinct \tf.computer_id, \tc.disk_id , \tf.logical_disk_id FROM \tt_res_chunk c, t_res_filesystem f, t_res_logical_disk l WHERE    c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id > 0    and l.parent_logdisk_id = f.logical_disk_id UNION ALL SELECT distinct \ts.computer_id, \tc.disk_id, \tc.logical_disk_id FROM \tt_res_chunk c, t_res_share s, t_res_logical_disk l WHERE    c.logical_disk_id = s.resource_id    and c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id = -1    and l.logical_disk_id not in   (select logical_disk_id from t_res_filesystem) ) LOGICALDISKS WHERE \tLOGICALDISKS.COMPUTER_ID = ?";
    public static final String SELECT_LUN_FROM_HOST = "SELECT distinct     LUN2HOST.PREFIX_ID PREFIX_ID,    LUN2HOST.HOST_ID HOST_ID,     LUN2HOST.TARGET_ID, \tLUN2HOST.DEVICE_LUN_ID DEVICE_LUN_ID,    LUN2HOST.VOLUME_ID VOLUME_ID, \tLUN2HOST.PATH,   \tLUN2HOST.DEVICE_ID,\tLUN2HOST.CAPACITY, \tLUN2HOST.FREE_SPACE,\tLUN2HOST.CONSOLIDATED_STATUS,\tLUN2HOST.OPERATIONAL_STATUS  FROM  (SELECT DISTINCT   \t 'server:' PREFIX_ID,   \t COMPUTER.COMPUTER_ID HOST_ID,     ACCESS.TARGET TARGET_ID, \t ACCESS.LUN DEVICE_LUN_ID,   \t VOLUME.SVID VOLUME_ID,  \t ACCESS.PATH PATH,   \t ACCESS.DEVICE_ID,\t (DISK_HIST.CAPACITY * 512) CAPACITY, \t (DISK_HIST.FREE_SPACE * 512) FREE_SPACE,\t VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS,\t VOLUME.OPERATIONAL_STATUS  FROM   \tT_RES_HOST COMPUTER,     T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME   \tleft outer join T_RES_STORAGE_VOLUME VOLUME on      PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID,    T_RES_DEV_ACCESS ACCESS left outer join T_STAT_DISK_HIST DISK_HIST on \tACCESS.DEVICE_ID = DISK_HIST.DISK_ID and \tDISK_HIST.STATISTIC_TYPE = '3',     T_RES_CONTROLLER CONTROLLER WHERE       PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION (SELECT DISTINCT   \t HOST.PREFIX_ID,   \t HOST.COMPUTER_ID HOST_ID,   \t CAST(NULL AS INTEGER) TARGET_ID, \t DATA_PATH.DEVICE_LUN_ID DEVICE_LUN_ID,   \t DATA_PATH.VOLUME_ID VOLUME_ID,   \t RTRIM(CAST(DATA_PATH.DEVICE_LUN_ID as CHAR(10))) PATH,  \t CAST(NULL as INTEGER) DEVICE_ID,\t (VOLUME.CAPACITY*512) CAPACITY,\t CAST(NULL AS INTEGER) FREE_SPACE, \t VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS,\t VOLUME.OPERATIONAL_STATUS FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT, T_RES_STORAGE_VOLUME VOLUME, (SELECT DISTINCT   \tHOST.PREFIX_ID,  \tHOST.COMPUTER_ID HOST_ID,   \tDATA_PATH.VOLUME_ID VOLUME_ID FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE   \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID  EXCEPT SELECT DISTINCT       'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID, \t VOLUME.SVID VOLUME_ID FROM   \tT_RES_HOST COMPUTER,     T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME   \tleft outer join T_RES_STORAGE_VOLUME VOLUME on      PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID,    T_RES_DEV_ACCESS ACCESS,     T_RES_CONTROLLER CONTROLLER WHERE       PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND     CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID) HOST2DATAPATH_IN WHERE   \tHOST2DATAPATH_IN.PREFIX_ID = HOST.PREFIX_ID and \tHOST2DATAPATH_IN.HOST_ID = HOST.COMPUTER_ID and  \tHOST2DATAPATH_IN.VOLUME_ID = DATA_PATH.VOLUME_ID and \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and \tDATA_PATH.VOLUME_ID = VOLUME.SVID )) LUN2HOST WHERE  \t ? = LUN2HOST.PREFIX_ID and \t ? = LUN2HOST.HOST_ID";
    public static final String SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\tSUBSYSTEM2HOST.PREFIX_ID HOST_PREFIX_ID, \tSUBSYSTEM2HOST.HOST_ID, \tSUBSYSTEM2HOST.VOLUME_ID FROM (SELECT DISTINCT \t'server:' PREFIX_ID, \tCOMPUTER.COMPUTER_ID HOST_ID,  \tVOLUME.SVID VOLUME_ID, \tVOLUME.SUBSYSTEM_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME WHERE     PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID AND    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \t HOST2PORT.PREFIX_ID, \t HOST2PORT.HOST_ID HOST_ID, \t DATA_PATH.VOLUME_ID VOLUME_ID, \t DATA_PATH.SUBSYSTEM_ID FROM \tT_RES_DATA_PATH DATA_PATH,   \tT_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID )  SUBSYSTEM2HOST, T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE \t ? = SUBSYSTEM2HOST.PREFIX_ID and \t ? = SUBSYSTEM2HOST.HOST_ID and \t SUBSYSTEM2HOST.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and \t T_RES_STORAGE_SUBSYSTEM.PREFIX_ID = 'subsystem:' ";
    public static final String SELECT_VOLUMES_FROM_HOST = "SELECT distinct     VOLUMES2HOST.PREFIX_ID, \t VOLUMES2HOST.HOST_ID HOST_ID,     CASE WHEN T_RES_STORAGE_VOLUME.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_STORAGE_VOLUME.DISPLAY_NAME) != '' THEN T_RES_STORAGE_VOLUME.DISPLAY_NAME \t\t  WHEN T_RES_STORAGE_VOLUME.SVID IS NOT NULL THEN CAST(T_RES_STORAGE_VOLUME.SVID as CHAR) \t END DISPLAY_NAME, T_RES_STORAGE_VOLUME.SVID SVID, T_RES_STORAGE_VOLUME.NAME || '+' || CAST(T_RES_STORAGE_VOLUME.NAME_FORMAT as CHAR) NATURAL_KEY, (T_RES_STORAGE_VOLUME.CAPACITY*512) CAPACITY, T_RES_STORAGE_VOLUME.POOL_ID POOL_ID, T_RES_STORAGE_VOLUME.FORMAT FORMAT, T_RES_STORAGE_VOLUME.IS_ASSIGNED IS_ASSIGNED, T_RES_STORAGE_VOLUME.USER_ATTRIB1 USER_ATTRIB1, T_RES_STORAGE_VOLUME.USER_ATTRIB2 USER_ATTRIB2, T_RES_STORAGE_VOLUME.USER_ATTRIB3 USER_ATTRIB3, T_RES_STORAGE_VOLUME.DETECTABLE DETECTABLE, T_RES_STORAGE_VOLUME.OPERATIONAL_STATUS OPERATIONAL_STATUS, T_RES_STORAGE_VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS  FROM (SELECT DISTINCT \t 'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID,     VOLUME.SVID VOLUME_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME  WHERE     PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID AND    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \tHOST2PORT.PREFIX_ID, \tHOST2PORT.HOST_ID HOST_ID, \tDATA_PATH.VOLUME_ID VOLUME_ID FROM \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,  \tT_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID ) VOLUMES2HOST,     T_RES_STORAGE_VOLUME WHERE \t ? = VOLUMES2HOST.PREFIX_ID and \t ? = VOLUMES2HOST.HOST_ID and \t T_RES_STORAGE_VOLUME.SVID = VOLUMES2HOST.VOLUME_ID";
    public static final String SELECT_FILESYSTEM_FROM_HOST = "SELECT distinct   \tT_RES_FILESYSTEM.FILESYSTEM_ID, \tT_RES_FILESYSTEM.LOGICAL_DISK_ID, \tT_RES_FILESYSTEM.MOUNT_POINT,   \tT_RES_FILESYSTEM.CAPACITY,     \tT_RES_FILESYSTEM.FILESYSTEM_TYPE,    \tT_RES_FILESYSTEM.FREE_SPACE,   \tT_RES_FILESYSTEM.PHYSICAL_SIZE FROM   \tT_RES_HOST HOST, T_RES_FILESYSTEM WHERE  \t? = HOST.COMPUTER_ID AND \tHOST.COMPUTER_ID = T_RES_FILESYSTEM.COMPUTER_ID ";
    public static final String SELECT_LOGICAL_VOLUME_FROM_HOST = "select \tLOGICAL.logical_disk_id, \tSHARE.path  from \tT_RES_SHARE SHARE, T_RES_LOGICAL_DISK LOGICAL where \tSHARE.computer_id = ?   and \tSHARE.resource_type = 11   and \tSHARE.resource_id = LOGICAL.logical_disk_id ";
    public static final String SELECT_LOGICAL2LOGICAL_FROM_HOST = "select \tPLOGICAL.logical_disk_id PARENT_DISK_ID, \tCLOGICAL.LOGICAL_DISK_ID CHILD_DISK_ID  from \tT_RES_SHARE SHARE, T_RES_LOGICAL_DISK PLOGICAL, T_RES_LOGICAL_DISK CLOGICAL where \tSHARE.computer_id = ?   and \tSHARE.resource_type = 11   and \tSHARE.resource_id = PLOGICAL.logical_disk_id and \tPLOGICAL.LOGICAL_DISK_ID = CLOGICAL.PARENT_LOGDISK_ID";
    public static final String SELECT_FILESYSTEM_SIMPLE_FROM_LUN = "SELECT distinct   \tFS.FILESYSTEM_ID,\tDEVICE.DEVICE_ID FROM   \tT_RES_HOST HOST, T_RES_DEV_ACCESS DEVICE, T_STAT_DISK STATDISK,   \tT_RES_FILESYSTEM FS, T_RES_CHUNK CHUNK, T_RES_SHARE SHARE, T_RES_CONTROLLER CONTROLLER WHERE  \t? = HOST.COMPUTER_ID and \tHOST.COMPUTER_ID = CONTROLLER.COMPUTER_ID and\tCONTROLLER.CONTROLLER_ID = DEVICE.CONTROLLER_ID and   \tDEVICE.DEVICE_ID = STATDISK.DISK_ID and  \tSTATDISK.DISK_ID = CHUNK.DISK_ID and   \tHOST.COMPUTER_ID = FS.COMPUTER_ID and   \tFS.LOGICAL_DISK_ID = CHUNK.LOGICAL_DISK_ID and  \tSHARE.RESOURCE_ID = CHUNK.lOGICAL_DISK_ID ";
    private static final String SELECT_FILESYSTEM_COMPOUND_FROM_LUN_FROM_HOST = "SELECT distinct \tf.filesystem_id, \tf.logical_disk_id, \td.disk_id, \tf.mount_point, \tf.capacity, \tf.free_space, \tf.filesystem_id, \ta.path, \ts1.name, \ts1.path, \td.capacity FROM  t_res_filesystem f, t_res_host c2, t_res_share s1, t_res_logical_disk l2, t_res_logical_disk l, t_res_chunk h, t_stat_disk d, t_res_dev_access a  , t_res_vendor vendor  , (select   distinct c.computer_id     , pv.physical_volume_id      , pv.serial_number lun_id     , sv.svid  from     t_res_host c     , t_res_physical_volume pv left outer join t_res_storage_volume sv on    pv.lunssid = sv.unique_id     , t_res_dev_access da      , t_res_controller ctl where        pv.physical_volume_id = da.device_id      and da.controller_id = ctl.controller_id     and ctl.computer_id = c.computer_id) \t ssluncmp  where (l2.parent_logdisk_id <= 0) and (f.logical_disk_id = l2.logical_disk_id) and (l.parent_logdisk_id = l2.logical_disk_id) and (l.parent_logdisk_id = f.logical_disk_id) and (h.logical_disk_id = l.logical_disk_id) and (c2.computer_id = f.computer_id) and (d.disk_id = h.disk_id) and (a.device_id = d.disk_id) and (a.device_id = h.disk_id) and c2.computer_id = ?";
    public static final String SELECT_LVM_FROM_HOST = "SELECT \tT_RES_VOLGROUP.VOLGROUP_ID, \tT_RES_VOLGROUP.NAME NAME, \tT_RES_VOLGROUP.FREESPACE, \tT_RES_VOLGROUP.CAPACITY, \tT_RES_VOLGROUP.VOLGROUP_TYPE  FROM \tT_RES_VOLGROUP WHERE \tT_RES_VOLGROUP.COMPUTER_ID = ?";
    public static final String SELECT_LOGICALS_FROM_HOST = "SELECT \tT_RES_LOGICAL_DISK.LOGICAL_DISK_ID,\tT_RES_SHARE.PATH FROM \tT_RES_LOGICAL_DISK, t_res_chunk CHUNK, T_RES_SHARE  WHERE \tCHUNK.LOGICAL_DISK_ID = T_RES_SHARE.RESOURCE_ID and \tCHUNK.LOGICAL_DISK_ID = T_RES_LOGICAL_DISK.LOGICAL_DISK_ID and \tT_RES_SHARE.COMPUTER_ID = ?";
    public static final String SELECT_DISKS_FROM_LVM_FROM_HOST = "SELECT\tDEVICE.DEVICE_ID, DISK.volgroup_id  FROM \tT_RES_DEV_ACCESS DEVICE, T_RES_SHARE SHARE, T_RES_CONTROLLER CONTROLLER, \tT_STAT_DISK DISK WHERE \tSHARE.COMPUTER_ID = ? and \tSHARE.RESOURCE_TYPE = 10 and \tSHARE.RESOURCE_ID = DEVICE.DEVICE_ID and \tSHARE.COMPUTER_ID = CONTROLLER.computer_id and \tDEVICE.DEVICE_ID   = DISK.DISK_ID   and \tDEVICE.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID ";
    public static final String SELECT_RDBMS_FROM_HOST = "SELECT \tT_RES_RDBMS.RDBMS_ID,\tT_RES_RDBMS.RDBMS_NAME, \tT_RES_RDBMS.RDBMS_TYPE FROM \tT_RES_RDBMS  WHERE \tT_RES_RDBMS.COMPUTER_ID = ?";
    public static final String SELECT_DATABASES_FROM_HOST = "SELECT \tRDBMS.RDBMS_ID, \tT_RES_DATABASE.DATABASE_ID,\tT_RES_DATABASE.NAME FROM \tT_RES_DATABASE, T_RES_RDBMS RDBMS  WHERE \tT_RES_DATABASE.RDBMS_ID = RDBMS.RDBMS_ID and \tRDBMS.COMPUTER_ID = ?";
    public static final String SELECT_TABLESPACE_FROM_HOST = "SELECT \tDATABASE.DATABASE_ID, \tT_RES_TABLESPACE.TABLESPACE_ID,\tT_RES_TABLESPACE.NAME FROM \tT_RES_TABLESPACE, T_RES_DATABASE DATABASE, T_RES_RDBMS RDBMS  WHERE \tT_RES_TABLESPACE.DATABASE_ID = DATABASE.DATABASE_ID and \tDATABASE.RDBMS_ID = RDBMS.RDBMS_ID and \tRDBMS.COMPUTER_ID = ?";
    public static final String SELECT_TABLESPACE2LOGICAL_FROM_HOST = "SELECT \tTS2LOGICAL.TABLESPACE_ID, \tTS2LOGICAL.LOGICAL_DISK_ID, \tTS2LOGICAL.COMPUTER_ID FROM (SELECT \tTABLESPACE.TABLESPACE_ID, \tSHARE.RESOURCE_ID LOGICAL_DISK_ID, \tRDBMS.COMPUTER_ID FROM \tT_RES_DATABASE DATABASE, T_RES_RDBMS RDBMS, T_RES_TABLESPACE TABLESPACE, T_RES_DATAFILE DATAFILE,\tT_RES_SHARE SHARE  WHERE \t(DATAFILE.NAME = '\\.'|| SHARE.PATH  OR \tDATAFILE.NAME = SHARE.PATH \t) and \tSHARE.COMPUTER_ID = RDBMS.COMPUTER_ID and \tDATAFILE.FILESYSTEM_ID = -1 and \tDATAFILE.TABLESPACE_ID = TABLESPACE.TABLESPACE_ID and \tTABLESPACE.DATABASE_ID = DATABASE.DATABASE_ID and \tDATABASE.RDBMS_ID = RDBMS.RDBMS_ID  ) TS2LOGICAL WHERE \tTS2LOGICAL.COMPUTER_ID = ?";
    public static final String SELECT_TABLESPACE2FILESYSTEM_FROM_HOST = "SELECT \tTABLESPACE.TABLESPACE_ID, \tDATAFILE.FILESYSTEM_ID FROM \tT_RES_DATABASE DATABASE, T_RES_RDBMS RDBMS, T_RES_TABLESPACE TABLESPACE, T_RES_DATAFILE DATAFILE  WHERE \tDATAFILE.FILESYSTEM_ID != -1 and \tDATAFILE.TABLESPACE_ID = TABLESPACE.TABLESPACE_ID and \tTABLESPACE.DATABASE_ID = DATABASE.DATABASE_ID and \tDATABASE.RDBMS_ID = RDBMS.RDBMS_ID and \tRDBMS.COMPUTER_ID = ?";

    public GraphComputer getHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("host...");
        }
        GraphComputer graphComputer = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Host ID is NULL");
                    continue;
                }
                String string2 = String.valueOf(string) + n2;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphComputer = new GraphComputer(string2);
                    this.populator.populateHost(resultSet, graphComputer);
                    if (graphModel != null) {
                        graphModel.put(graphComputer);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphComputer);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Duplicated Host entry:" + string2);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("array totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        return graphComputer;
    }

    public void getHBAs(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("hba...");
        }
        GraphHBA graphHBA = null;
        String string = "server:" + n;
        GraphComputer graphComputer = (GraphComputer)hashMap.get(string);
        try {
            preparedStatement = connection.prepareStatement(SELECT_HBA_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("HBA_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHBAs", "HBA ID is NULL");
                    continue;
                }
                String string2 = "hba:" + n2;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphHBA = new GraphHBA(string2);
                    this.populator.populateHBA(resultSet, graphHBA, true);
                    if (graphModel != null) {
                        graphModel.put(graphHBA);
                    }
                    if (hashMap != null) {
                        hashMap.put(string2, graphHBA);
                    }
                    GraphComputer2HBA graphComputer2HBA = new GraphComputer2HBA(string2);
                    graphComputer2HBA.setHBAID((GraphHBA.ID)graphHBA.getEntityID());
                    graphComputer2HBA.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                    graphModel.put(graphComputer2HBA);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHBAs", "Duplicated HBA entry:subsystem:" + n);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHBAs", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHBAs", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("HBA totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    public void getPorts(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        Comparable<Integer> comparable;
        Object object;
        String string2;
        Object object2;
        Object object3;
        String string3;
        Integer n2;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("ports...");
        }
        String string4 = String.valueOf(string) + n;
        GraphComputer graphComputer = (GraphComputer)hashMap.get(string4);
        GraphFCPort graphFCPort = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_PORT_FROM_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = (Integer)resultSet.getObject("PORT_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "PORT_ID is NULL");
                    continue;
                }
                string3 = "Port:" + n2;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphFCPort = new GraphFCPort(string3);
                    this.populator.populatePort(resultSet, graphFCPort);
                    if (graphModel != null) {
                        graphModel.put(graphFCPort);
                    }
                    if (hashMap != null) {
                        hashMap.put(string3, graphFCPort);
                    }
                    object3 = "server2port:" + string4 + ',' + n2;
                    object2 = new GraphComputer2FCPort((String)object3);
                    ((GraphComputer2FCPort)object2).setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                    ((GraphComputer2FCPort)object2).setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                    graphModel.put((GraphEntity)object2);
                    hashMap.put(object3, object2);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Duplicated PORT entry:" + string3);
                }
                object3 = (Integer)resultSet.getObject("HBA_ID");
                if (object3 == null) continue;
                object2 = "hba2port:" + object3 + ',' + n2;
                if (hashMap.get(object2) == null) {
                    string2 = "hba:" + object3;
                    object = (GraphHBA)hashMap.get(string2);
                    if (object != null) {
                        comparable = new GraphHBA2FCPort((String)object2);
                        ((GraphHBA2FCPort)comparable).setHBAID((GraphHBA.ID)((GraphEntity)object).getEntityID());
                        ((GraphHBA2FCPort)comparable).setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                        graphModel.put((GraphEntity)comparable);
                        hashMap.put(object2, comparable);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Missing HBA entry:" + string2);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Duplicated HBA2PORT entry:" + (String)object2);
            }
        }
        finally {
            block46: {
                block45: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block45;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block46;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("Port totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        l = System.currentTimeMillis();
        try {
            preparedStatement = connection.prepareStatement(SELECT_PORT2PORT_FROM_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GraphFCPort graphFCPort2;
                n2 = (Integer)resultSet.getObject("PORT1_ID");
                string3 = (String)resultSet.getObject("PORT1_NAME");
                object3 = (Integer)resultSet.getObject("PORT2_ID");
                object2 = (String)resultSet.getObject("PORT_NUMBER1");
                string2 = (String)resultSet.getObject("PORT_NUMBER2");
                object = (String)resultSet.getObject("PORT2_NAME");
                comparable = (Integer)resultSet.getObject("PORT2PORT_ID");
                String string5 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("ENTITY_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "PORT_ID is NULL");
                    continue;
                }
                String string6 = "Port:" + n2;
                String string7 = "Port:" + object3;
                graphFCPort = (GraphFCPort)hashMap.get(string6);
                if (graphFCPort == null) {
                    graphFCPort = new GraphFCPort(string6);
                    graphFCPort.setDisplayName(string3);
                    graphFCPort.setPortNumber((String)object2);
                    graphModel.put(graphFCPort);
                    hashMap.put(string6, graphFCPort);
                }
                if ((graphFCPort2 = (GraphFCPort)hashMap.get(string7)) == null) {
                    graphFCPort2 = new GraphFCPort(string7);
                    graphFCPort2.setDisplayName((String)object);
                    graphFCPort2.setPortNumber(string2);
                    graphModel.put(graphFCPort2);
                    hashMap.put(string7, graphFCPort2);
                }
                if (graphFCPort2 == null || graphFCPort == null) continue;
                String string8 = "port2port:" + string + n + ',' + string5 + n3 + ',' + comparable;
                if (hashMap.get(string8) == null) {
                    GraphFCPort2FCPort graphFCPort2FCPort = new GraphFCPort2FCPort(string8);
                    graphFCPort2FCPort.setFCPort1ID((GraphFCPort.ID)graphFCPort.getEntityID());
                    graphFCPort2FCPort.setFCPort2ID((GraphFCPort.ID)graphFCPort2.getEntityID());
                    this.populator.populatePort2Port(resultSet, graphFCPort2FCPort);
                    graphModel.put(graphFCPort2FCPort);
                    hashMap.put(string8, graphFCPort2FCPort);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                if (graphFCPort2 == null) {
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Missing port entry:" + string6);
                    continue;
                }
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Missing port entry:" + string6);
            }
        }
        finally {
            block49: {
                block48: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block48;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block49;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("Port totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    public void getSwitchFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("Switch...");
        }
        GraphSwitch graphSwitch = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2;
                String string2;
                GraphFCPort graphFCPort;
                String string3 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                if (n3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitch", "SWITCH_WWN is NULL");
                    continue;
                }
                String string4 = String.valueOf(string3) + n3;
                if (hashMap == null || hashMap.get(string4) == null) {
                    graphSwitch = new GraphSwitch(string4);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    if (graphModel != null) {
                        graphModel.put(graphSwitch);
                    }
                    if (hashMap != null) {
                        hashMap.put(string4, graphSwitch);
                    }
                }
                if ((graphFCPort = (GraphFCPort)hashMap.get(string2 = "Port:" + (n2 = (Integer)resultSet.getObject("PORT_ID")))) == null) continue;
                String string5 = "switch2fcport:" + string4 + ',' + n2;
                GraphSwitch2FCPort graphSwitch2FCPort = new GraphSwitch2FCPort(string5);
                graphSwitch2FCPort.setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                graphSwitch2FCPort.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                graphModel.put(graphSwitch2FCPort);
                hashMap.put(string5, graphSwitch2FCPort);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("Switch totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    public void getSubsystemFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("subsystem...");
        }
        GraphSubsystem graphSubsystem = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2;
                String string2;
                GraphFCPort graphFCPort;
                String string3 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                if (n3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String string4 = String.valueOf(string3) + n3;
                if (hashMap == null || hashMap.get(string4) == null) {
                    graphSubsystem = new GraphSubsystem(string4);
                    this.populator.populateSubsystem(resultSet, graphSubsystem);
                    if (graphModel != null) {
                        graphModel.put(graphSubsystem);
                    }
                    if (hashMap != null) {
                        hashMap.put(string4, graphSubsystem);
                    }
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Duplicated Subsystem entry:subsystem:" + n);
                }
                if ((graphFCPort = (GraphFCPort)hashMap.get(string2 = "Port:" + (n2 = (Integer)resultSet.getObject("PORT_ID")))) == null) continue;
                String string5 = "subsystem2fcport:" + string4 + ',' + n2;
                GraphSubsystem2FCPort graphSubsystem2FCPort = new GraphSubsystem2FCPort(string5);
                graphSubsystem2FCPort.setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                graphSubsystem2FCPort.setSubsystemID((GraphSubsystem.ID)graphSubsystem.getEntityID());
                graphModel.put(graphSubsystem2FCPort);
                hashMap.put(string5, graphSubsystem2FCPort);
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("subsystem totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    public void getZonesFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(connection, graphModel, hashMap, new Object[]{string, new Integer(n)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_HOST, SELECT_ZONES_FROM_HOST, SELECT_ZSET_FROM_HOST, SELECT_ZSET2ZONE_FROM_HOST, SELECT_ZONE2MEMBER_FROM_HOST});
    }

    public void getZonesFromEntitiesConnectedToHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getHost2VolumeFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        GraphEntity graphEntity;
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Integer n2;
        Integer n3;
        String string3;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("host2volume ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_VOLUMES_FROM_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string3 = (String)resultSet.getObject("PREFIX_ID");
                n3 = (Integer)resultSet.getObject("HOST_ID");
                n2 = (Integer)resultSet.getObject("SVID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                object4 = String.valueOf(string3) + n3;
                object3 = (GraphComputer)hashMap.get(object4);
                if (object3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + (String)object4);
                    continue;
                }
                object2 = "volume:" + n2;
                object = (GraphVolume)hashMap.get(object2);
                if (object == null) {
                    object = new GraphVolume((String)object2);
                    this.populator.populateStorageVolume(resultSet, (GraphVolume)object);
                    hashMap.put(object2, object);
                    graphModel.put((GraphEntity)object);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + (String)object2);
                }
                string2 = "server2volume:" + n3 + ',' + n2;
                if (hashMap.get(string2) == null) {
                    graphEntity = new GraphComputer2Volume(string2);
                    ((GraphComputer2Volume)graphEntity).setComputerID((GraphComputer.ID)((GraphEntity)object3).getEntityID());
                    ((GraphComputer2Volume)graphEntity).setVolumeID((GraphVolume.ID)((GraphEntity)object).getEntityID());
                    graphModel.put(graphEntity);
                    hashMap.put(string2, graphEntity);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + string2);
            }
        }
        finally {
            block49: {
                block48: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block48;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block49;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("host2volume totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (debug) {
            System.out.println("host2volume ...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GraphAssociation graphAssociation;
                String string4;
                GraphVolume graphVolume;
                string3 = (String)resultSet.getObject("HOST_PREFIX_ID");
                n3 = (Integer)resultSet.getObject("HOST_ID");
                n2 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                object4 = (Integer)resultSet.getObject("VOLUME_ID");
                object3 = String.valueOf(string3.toString()) + n3;
                object2 = (GraphComputer)hashMap.get(object3);
                if (object2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + (String)object3);
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                object = "subsystem:" + n2;
                string2 = "volume:" + object4;
                graphEntity = (GraphSubsystem)hashMap.get(object);
                if (graphEntity == null) {
                    graphEntity = new GraphSubsystem((String)object);
                    this.populator.populateSubsystem(resultSet, (GraphSubsystem)graphEntity);
                    hashMap.put(object, graphEntity);
                    graphModel.put(graphEntity);
                }
                if ((graphVolume = (GraphVolume)hashMap.get(string2)) != null) {
                    string4 = "subsystem2volume:" + n2 + ',' + object4;
                    graphAssociation = new GraphSubsystem2Volume(string4);
                    ((GraphSubsystem2Volume)graphAssociation).setSubsystemID((GraphSubsystem.ID)graphEntity.getEntityID());
                    ((GraphSubsystem2Volume)graphAssociation).setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                    hashMap.put(string4, graphAssociation);
                    graphModel.put(graphAssociation);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + (String)object);
                }
                string4 = "server2volume:" + n3 + ',' + n2;
                if (hashMap.get(string4) == null) {
                    graphAssociation = new GraphComputer2Volume(string4);
                    ((GraphComputer2Volume)graphAssociation).setComputerID((GraphComputer.ID)((GraphEntity)object2).getEntityID());
                    ((GraphComputer2Volume)graphAssociation).setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                    graphModel.put(graphAssociation);
                    hashMap.put(string4, graphAssociation);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + string4);
            }
        }
        finally {
            block52: {
                block51: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block51;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block52;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("host2volume totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
    }

    public void getLUN(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("subsystem...");
        }
        if (debug) {
            System.out.println("Pools...");
        }
        System.currentTimeMillis();
        if (debug) {
            System.out.println("lun...");
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_LUN_FROM_HOST);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("VOLUME_ID");
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("HOST_ID");
                Integer n4 = (Integer)resultSet.getObject("DEVICE_LUN_ID");
                Integer n5 = (Integer)resultSet.getObject("DEVICE_ID");
                String string3 = String.valueOf(string2) + n3;
                String string4 = "(" + n2 + ',' + string3 + ',' + n5 + ',' + n4 + ")";
                String string5 = "lun:" + string4;
                GraphLun graphLun = new GraphLun(string5);
                this.populator.populateLUN(resultSet, graphLun);
                GraphComputer graphComputer = (GraphComputer)hashMap.get(string3);
                if (graphComputer == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "Host not found: server:" + n3);
                    continue;
                }
                GraphVolume graphVolume = (GraphVolume)hashMap.get("volume:" + n2);
                graphModel.put(graphLun);
                hashMap.put(string5, graphLun);
                String string6 = "server2lun:" + string3 + ',' + string4;
                GraphComputer2Lun graphComputer2Lun = new GraphComputer2Lun(string6);
                graphComputer2Lun.setLunID((GraphLun.ID)graphLun.getEntityID());
                graphComputer2Lun.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                graphModel.put(graphComputer2Lun);
                hashMap.put(string6, graphComputer2Lun);
                if (graphVolume == null) continue;
                String string7 = "lun2volume:" + n2 + ',' + string4;
                GraphVolume2Lun graphVolume2Lun = new GraphVolume2Lun(string7);
                graphVolume2Lun.setLunID((GraphLun.ID)graphLun.getEntityID());
                graphVolume2Lun.setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                graphModel.put(graphVolume2Lun);
                hashMap.put(string7, graphVolume2Lun);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                }
            }
        }
    }

    public void getLVM(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        GraphAssociation graphAssociation;
        Object object;
        Object object2;
        String string2;
        String string3;
        Object object3;
        Object object4;
        Comparable<Integer> comparable;
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("lvm...");
        }
        if (debug) {
            System.out.println("logical...");
        }
        GraphLogicalVolumeManager graphLogicalVolumeManager = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_LVM_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                comparable = (Integer)resultSet.getObject("VOLGROUP_ID");
                object4 = "lvm:" + comparable;
                if (hashMap != null && hashMap.get(object4) != null) continue;
                graphLogicalVolumeManager = new GraphLogicalVolumeManager((String)object4);
                this.populator.populateLVM(resultSet, graphLogicalVolumeManager);
                if (graphModel != null) {
                    graphModel.put(graphLogicalVolumeManager);
                }
                if (hashMap == null) continue;
                hashMap.put(object4, graphLogicalVolumeManager);
            }
        }
        finally {
            block87: {
                block86: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block86;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block87;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        comparable = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_LOGICALS_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object4 = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                object3 = "logvol:" + object4;
                if (hashMap != null && hashMap.get(object3) != null) continue;
                comparable = new GraphLogicalVolume((String)object3);
                this.populator.populateLogicalVolume(resultSet, (GraphLogicalVolume)comparable);
                if (graphModel != null) {
                    graphModel.put((GraphEntity)comparable);
                }
                if (hashMap == null) continue;
                hashMap.put(object3, comparable);
            }
        }
        finally {
            block90: {
                block89: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block89;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block90;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_LVM2LOGICALS_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object4 = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                object3 = (Integer)resultSet.getObject("VOLGROUP_ID");
                string3 = "logvol:" + object4;
                string2 = "lvm:" + object3;
                comparable = (GraphLogicalVolume)hashMap.get(string3);
                if (comparable == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "logical volume not found: server:" + n);
                    continue;
                }
                graphLogicalVolumeManager = (GraphLogicalVolumeManager)hashMap.get(string2);
                if (graphLogicalVolumeManager == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "volumeManager not found: server:" + n);
                    continue;
                }
                object2 = "lvm2lv:" + object3 + ',' + object4;
                object = new GraphLogicalVolumeManager2LogicalVolume((String)object2);
                ((GraphLogicalVolumeManager2LogicalVolume)object).setLogicalVolumeManagerID(graphLogicalVolumeManager);
                ((GraphLogicalVolumeManager2LogicalVolume)object).setLogicalVolumeID((GraphLogicalVolume)comparable);
                graphModel.put((GraphEntity)object);
                hashMap.put(object2, object);
            }
        }
        finally {
            block93: {
                block92: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block92;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block93;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_DISKS_FROM_LVM_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object4 = (Integer)resultSet.getObject("DEVICE_ID");
                object3 = (Integer)resultSet.getObject("VOLGROUP_ID");
                string3 = "lun:" + object4;
                string2 = "lvm:" + object3;
                object2 = (GraphLun)hashMap.get(string3);
                if (object2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "LUN volume not found: server:" + n);
                    continue;
                }
                graphLogicalVolumeManager = (GraphLogicalVolumeManager)hashMap.get(string2);
                if (graphLogicalVolumeManager == null) continue;
                object = "lvm2lun:" + object3 + ',' + object4;
                graphAssociation = new GraphLogicalVolumeManager2Lun((String)object);
                ((GraphLogicalVolumeManager2Lun)graphAssociation).setLogicalVolumeManagerID(graphLogicalVolumeManager);
                ((GraphLogicalVolumeManager2Lun)graphAssociation).setLunID((GraphLun)object2);
                graphModel.put(graphAssociation);
                hashMap.put(object, graphAssociation);
            }
        }
        finally {
            block96: {
                block95: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block95;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block96;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_LUN2LOGICAL_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object4 = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                object3 = (Integer)resultSet.getObject("DISK_ID");
                string3 = "logvol:" + object4;
                string2 = "lun:" + object3;
                comparable = (GraphLogicalVolume)hashMap.get(string3);
                object2 = (GraphLun)hashMap.get(string2);
                object = "lun2logical:" + object3 + ',' + object4;
                graphAssociation = new GraphLogicalVolume2Lun((String)object);
                ((GraphLogicalVolume2Lun)graphAssociation).setLunID((GraphLun)object2);
                ((GraphLogicalVolume2Lun)graphAssociation).setLogicalVolumeID((GraphLogicalVolume)comparable);
                graphModel.put(graphAssociation);
                hashMap.put(object, graphAssociation);
            }
        }
        finally {
            block99: {
                block98: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block98;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block99;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }
    }

    public void getFilesystems(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("lvm...");
        }
        if (debug) {
            System.out.println("logical...");
        }
        if ("server:".equals(string)) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Integer n2;
            try {
                preparedStatement = connection.prepareStatement(SELECT_FILESYSTEM_FROM_HOST);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    object7 = "filesystem:" + n2;
                    object6 = (GraphFilesystem)hashMap.get(object7);
                    if (object6 != null) continue;
                    object6 = new GraphFilesystem((String)object7);
                    this.populator.populateFileSystem(resultSet, (GraphFilesystem)object6);
                    graphModel.put((GraphEntity)object6);
                    hashMap.put(object7, object6);
                }
            }
            finally {
                block50: {
                    block49: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block49;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block50;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
            if (debug) {
                System.out.println("lun totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
            }
            try {
                preparedStatement = connection.prepareStatement(SELECT_FILESYSTEM_SIMPLE_FROM_LUN);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    object7 = (Integer)resultSet.getObject("DEVICE_ID");
                    object6 = "lun:" + object7;
                    object5 = (GraphLun)hashMap.get(object6);
                    if (object5 == null || (object4 = (GraphFilesystem)hashMap.get(object3 = "filesystem:" + n2)) == null) continue;
                    object2 = "fs2lun:" + n2 + ',' + object7;
                    object = new GraphFilesystem2Lun((String)object2);
                    ((GraphFilesystem2Lun)object).setFilesystemID((GraphFilesystem)object4);
                    ((GraphFilesystem2Lun)object).setLunID((GraphLun)object5);
                    graphModel.put((GraphEntity)object);
                    hashMap.put(object2, object);
                }
            }
            finally {
                block53: {
                    block52: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block52;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block53;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
            if (debug) {
                System.out.println("lun totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
            }
            try {
                preparedStatement = connection.prepareStatement(SELECT_FILESYSTEM_COMPOUND_FROM_LUN_FROM_HOST);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    new Integer(n);
                    n2 = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    object7 = (Integer)resultSet.getObject("DISK_ID");
                    String cfr_ignored_0 = (String)resultSet.getObject("PATH");
                    object6 = (String)resultSet.getObject("MOUNT_POINT");
                    object5 = "logvol:" + object7;
                    object3 = (GraphLogicalVolume)hashMap.get(object5);
                    if (object3 == null) continue;
                    object4 = "filesystem:" + n2;
                    object2 = new GraphFilesystem((String)object4);
                    ((GraphEntity)object2).setDisplayName((String)object6);
                    graphModel.put((GraphEntity)object2);
                    hashMap.put(object4, object2);
                    object = "fs2lun:" + n2 + ',' + object7;
                    GraphFilesystem2LogicalVolume graphFilesystem2LogicalVolume = new GraphFilesystem2LogicalVolume((String)object);
                    graphFilesystem2LogicalVolume.setFilesystemID((GraphFilesystem)object2);
                    graphFilesystem2LogicalVolume.setLogicalVolumeID((GraphLogicalVolume)object3);
                    graphModel.put(graphFilesystem2LogicalVolume);
                    hashMap.put(object, graphFilesystem2LogicalVolume);
                }
            }
            finally {
                block56: {
                    block55: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block55;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block56;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
            if (debug) {
                System.out.println("lun totalTime: " + (double)(System.currentTimeMillis() - l) / 1000.0);
            }
        }
    }

    public void getDatabases(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("lvm...");
        }
        if (debug) {
            System.out.println("logical...");
        }
        if ("server:".equals(string)) {
            GraphAssociation graphAssociation;
            String string2;
            GraphEntity graphEntity;
            GraphEntity graphEntity2;
            String string3;
            Object object;
            Object object2;
            Integer n2;
            try {
                preparedStatement = connection.prepareStatement(SELECT_RDBMS_FROM_HOST);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = (Integer)resultSet.getObject("RDBMS_ID");
                    object2 = "rdbms:" + n2;
                    object = (GraphDatabaseGroup)hashMap.get(object2);
                    if (object != null) continue;
                    object = new GraphDatabaseGroup((String)object2);
                    this.populator.populateRDBMS(resultSet, (GraphDatabaseGroup)object);
                    graphModel.put((GraphEntity)object);
                    hashMap.put(object2, object);
                }
            }
            finally {
                block75: {
                    block74: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block74;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block75;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(SELECT_DATABASES_FROM_HOST);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = (Integer)resultSet.getObject("RDBMS_ID");
                    object2 = (Integer)resultSet.getObject("DATABASE_ID");
                    object = "rdbms:" + n2;
                    string3 = "database:" + object2;
                    graphEntity2 = (GraphDatabaseGroup)hashMap.get(object);
                    graphEntity = (GraphDatabase)hashMap.get(string3);
                    if (graphEntity2 == null || graphEntity != null) continue;
                    graphEntity = new GraphDatabase(string3);
                    this.populator.populateDatabase(resultSet, (GraphDatabase)graphEntity);
                    graphModel.put(graphEntity);
                    hashMap.put(string3, graphEntity);
                    string2 = "rdbms2database:" + n2 + ',' + object2;
                    graphAssociation = new GraphDatabaseGroup2Database(string2);
                    ((GraphDatabaseGroup2Database)graphAssociation).setDatabaseGroupID((GraphDatabaseGroup)graphEntity2);
                    ((GraphDatabaseGroup2Database)graphAssociation).setDatabaseID((GraphDatabase)graphEntity);
                    graphModel.put(graphAssociation);
                    hashMap.put(string2, graphAssociation);
                }
            }
            finally {
                block78: {
                    block77: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block77;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block78;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(SELECT_TABLESPACE_FROM_HOST);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = (Integer)resultSet.getObject("DATABASE_ID");
                    object2 = (Integer)resultSet.getObject("TABLESPACE_ID");
                    object = "tablespace:" + object2;
                    string3 = "database:" + n2;
                    graphEntity2 = (GraphTableSpace)hashMap.get(object);
                    graphEntity = (GraphDatabase)hashMap.get(string3);
                    if (graphEntity == null || graphEntity2 != null) continue;
                    graphEntity2 = new GraphTableSpace((String)object);
                    this.populator.populateTableSpace(resultSet, (GraphTableSpace)graphEntity2);
                    graphModel.put(graphEntity2);
                    hashMap.put(object, graphEntity2);
                    string2 = "database2tablespace:" + n2 + ',' + object2;
                    graphAssociation = new GraphDatabase2TableSpace(string2);
                    ((GraphDatabase2TableSpace)graphAssociation).setTableSpaceID((GraphTableSpace)graphEntity2);
                    ((GraphDatabase2TableSpace)graphAssociation).setDatabaseID((GraphDatabase)graphEntity);
                    graphModel.put(graphAssociation);
                    hashMap.put(string2, graphAssociation);
                }
            }
            finally {
                block81: {
                    block80: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block80;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block81;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(SELECT_TABLESPACE2LOGICAL_FROM_HOST);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                    object2 = (Integer)resultSet.getObject("TABLESPACE_ID");
                    object = "tablespace:" + object2;
                    string3 = "logvol:" + n2;
                    graphEntity2 = (GraphTableSpace)hashMap.get(object);
                    graphEntity = (GraphLogicalVolume)hashMap.get(string3);
                    if (graphEntity == null || graphEntity2 == null) continue;
                    string2 = "tablespace2logical:" + object2 + ',' + n2;
                    graphAssociation = new GraphTableSpace2LogicalVolume(string2);
                    ((GraphTableSpace2LogicalVolume)graphAssociation).setTableSpaceID((GraphTableSpace)graphEntity2);
                    ((GraphTableSpace2LogicalVolume)graphAssociation).setLogicalVolumeID((GraphLogicalVolume)graphEntity);
                    graphModel.put(graphAssociation);
                    hashMap.put(string2, graphAssociation);
                }
            }
            finally {
                block84: {
                    block83: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block83;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block84;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
            try {
                preparedStatement = connection.prepareStatement(SELECT_TABLESPACE2FILESYSTEM_FROM_HOST);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    n2 = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    object2 = (Integer)resultSet.getObject("TABLESPACE_ID");
                    object = "tablespace:" + object2;
                    string3 = "filesystem:" + n2;
                    graphEntity2 = (GraphTableSpace)hashMap.get(object);
                    graphEntity = (GraphFilesystem)hashMap.get(string3);
                    if (graphEntity == null || graphEntity2 == null) continue;
                    string2 = "tablespace2filesystem:" + object2 + ',' + n2;
                    graphAssociation = new GraphTableSpace2Filesystem(string2);
                    ((GraphTableSpace2Filesystem)graphAssociation).setTableSpaceID((GraphTableSpace)graphEntity2);
                    ((GraphTableSpace2Filesystem)graphAssociation).setFilesystemID((GraphFilesystem)graphEntity);
                    graphModel.put(graphAssociation);
                    hashMap.put(string2, graphAssociation);
                }
            }
            finally {
                block87: {
                    block86: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!TraceLogger.enableTrace) break block86;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                        }
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block87;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
            }
        }
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromHost(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FOR_HOST);
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelComputerL2 graphModelComputerL2 = null;
        String string = null;
        GraphComputer.ID iD = (GraphComputer.ID)viewerRequest.getModelID().getFocusEntityID();
        string = (String)iD.getID();
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        string = string.substring(n + 1);
        int n2 = Integer.parseInt(string);
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            graphModelComputerL2 = new GraphModelComputerL2((GraphModelComputerL2.ID)viewerRequest.getModelID());
            GraphComputer graphComputer = this.getHost(connection, null, hashMap, string2, n2);
            if (graphComputer != null) {
                graphModelComputerL2.put(graphComputer);
                if ("server:".equals(string2)) {
                    this.getHBAs(connection, graphModelComputerL2, hashMap, n2);
                }
                this.getHost2VolumeFromHost(connection, graphModelComputerL2, hashMap, string2, n2);
                this.getLUN(connection, graphModelComputerL2, hashMap, string2, n2);
                "server:".equals(string2);
                this.getPorts(connection, graphModelComputerL2, hashMap, string2, n2);
                this.getSubsystemFromHost(connection, graphModelComputerL2, hashMap, string2, n2);
                this.getSwitchFromHost(connection, graphModelComputerL2, hashMap, string2, n2);
                this.commit(connection);
                if (viewerRequest.getModelID().isNeedZoneData()) {
                    this.getZonesFromHost(connection, graphModelComputerL2, hashMap, string2, n2);
                    this.commit(connection);
                }
                graphModelComputerL2.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
                viewerResponse.addResponse(0, graphModelComputerL2);
            } else {
                viewerResponse.addResponse(0, graphModelComputerL2);
            }
        } else {
            viewerResponse.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }

    public void main(String[] stringArray) {
    }
}

