/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.lang.reflect.Method;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.ThreadPool;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.InvalidTokenException;
import org.eclipse.aperi.control.interfaces.JobInProgressException;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public abstract class Controller
implements IController {
    protected ThreadPool controllerThreadPool = null;
    protected static final int MAXTHREADS = 5;
    protected ControlEngine ce = null;
    protected Token token = null;
    protected boolean threadIsRunning = false;
    protected boolean shutdown = false;
    protected Method m = null;
    protected Object[] args = null;
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.Controller");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public abstract Controller createController(ControlEngine var1, Token var2, Method var3, Object[] var4);

    public abstract String[] getAsyncMethodNames();

    public abstract String[] getNonPersistedTopLevelJobAPIMethodNames();

    protected abstract Class getProxyInterfaceClass();

    protected Token getToken() {
        String string = "getToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        if (this.threadIsRunning) {
            return this.token;
        }
        return this.ce.getTokenForProxyThread(Thread.currentThread());
    }

    public ThreadPool getThreadPool() {
        String string = "getThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.controllerThreadPool;
    }

    public void shutdown() {
        String string;
        block6: {
            string = "shutdown";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
            }
            if (!this.threadIsRunning && this.controllerThreadPool != null) {
                this.controllerThreadPool.shutdown();
            } else {
                try {
                    this.shutdown = true;
                    Thread thread = new Thread((Runnable)((Object)this));
                    thread.interrupt();
                    thread.join(30000L);
                }
                catch (Exception exception) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public int startSubJob(String string, boolean bl) {
        int n;
        String string2;
        block4: {
            string2 = "startSubJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string2);
            }
            n = -1;
            try {
                n = this.ce.startSubJob(this.getToken(), string, bl);
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n;
    }

    public boolean endSubJob(int n, int n2, int n3, SRMMessage sRMMessage, Exception exception, Object[] objectArray) {
        boolean bl;
        String string;
        block4: {
            string = "endSubJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
            }
            bl = false;
            try {
                bl = this.ce.endSubJob(this.getToken(), n, n2, n3, sRMMessage, exception, objectArray);
            }
            catch (Exception exception2) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception2);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception2);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    protected ILogger getJobLogger() {
        String string = "getJobLogger";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.ce.getJobLogger(this.getToken());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block14: {
            var1_1 = "run";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)Controller.className, var1_1);
            }
            this.threadIsRunning = true;
            var2_2 = null;
            try {
                try {
                    var2_2 = this.m.invoke((Object)this, this.args);
                }
                catch (Exception var3_3) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var1_1, (Throwable)var3_3);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Controller.className, var1_1, (Throwable)var3_3);
                    }
                    var2_2 = new AsyncResult(-14, 0);
                    ((AsyncResult)var2_2).setReturnException(new Exception(var3_3));
                }
            }
            catch (Throwable var5_4) {
                block13: {
                    var4_5 = null;
                    var6_7 = this.ce.processReturnObj(this.getToken(), var2_2);
                    if (!this.shutdown) {
                        try {
                            this.ce.endJob(this.getToken(), var6_7.getRc(), var6_7.getStatus(), var6_7.getSRMMessage(), var6_7.getReturnException(), var6_7.getResults());
                        }
                        catch (Exception var7_9) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var1_1, (Throwable)var7_9);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block13;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Controller.className, var1_1, (Throwable)var7_9);
                        }
                    }
                }
                this.threadIsRunning = false;
                throw var5_4;
            }
            {
                var4_6 = null;
            }
            var6_8 = this.ce.processReturnObj(this.getToken(), var2_2);
            if (!this.shutdown) {
                ** try [egrp 2[TRYBLOCK] [3 : 173->213)] { 
lbl37:
                // 1 sources

                this.ce.endJob(this.getToken(), var6_8.getRc(), var6_8.getStatus(), var6_8.getSRMMessage(), var6_8.getReturnException(), var6_8.getResults());
                break block14;
lbl40:
                // 1 sources

                catch (Exception var7_10) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var1_1, (Throwable)var7_10);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block14;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)Controller.className, var1_1, (Throwable)var7_10);
                }
            }
        }
        this.threadIsRunning = false;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)Controller.className, var1_1);
        }
    }

    protected void checkToken(Token token) throws InvalidTokenException, JobInProgressException {
        this.ce.checkToken(token);
    }

    protected Token createToken(String string, String string2, String string3, int n, String string4) {
        return this.ce.createToken(string, string2, string3, n, string4);
    }

    protected Token getDBToken(String string, String string2, String string3, int n) {
        return this.ce.getDBToken(string, string2, string3, n);
    }

    protected void removeToken(String string, String string2) {
        this.ce.removeToken(string, string2);
    }

    protected void removeTokenFromJobs(Token token) {
        this.ce.removeTokenFromJobs(token);
    }

    protected void removeTokenFromValidTokens(Token token) {
        this.ce.removeTokenFromValidTokens(token);
    }

    public void setControlEngine(ControlEngine controlEngine) {
        this.ce = controlEngine;
    }
}

