/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class RaceConditionChecker
extends RepositoryAccessor {
    private long guiTimestamp;
    private String sqlText;
    private String objectType;
    private String creatorName;
    public String message;
    public boolean wasDeleted;

    public RaceConditionChecker(Connection connection, String string, String string2, CreateHeader createHeader, String string3) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RaceConditionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"RaceConditionChecker", (String)"dbc, pTableName, idColumnName, requestData, pObjectType");
        }
        this.tableName = string;
        this.guiTimestamp = createHeader.lastModified;
        this.objectType = string3;
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append(createHeader.creator);
        stringBuffer.append('.');
        stringBuffer.append(createHeader.getName());
        this.creatorName = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer.append("SELECT last_modified, last_mod_user FROM ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string2);
        stringBuffer.append(" = ");
        stringBuffer.append(Integer.toString(createHeader.ID));
        this.sqlText = stringBuffer.toString();
        this.message = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RaceConditionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"RaceConditionChecker");
        }
    }

    public void check() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RaceConditionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"check", (String)"");
        }
        String string = null;
        long l = 0L;
        this.selectStmt = this.prepareStmt(this.sqlText);
        this.stmtType = 0;
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 2;
            if (this.resultSet.next()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                l = this.getLong(this.resultSet);
                string = this.getString(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.RaceConditionChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"check", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        this.closeSelect();
        if (this.stmtPhase == 2) {
            Object[] objectArray = new Object[]{this.objectType, this.creatorName};
            this.message = MessageLog.getMessage((String)"SRV0093W", (Object[])objectArray);
            this.wasDeleted = true;
        } else if (l > this.guiTimestamp) {
            Object[] objectArray = new Object[]{this.objectType, this.creatorName, string};
            this.message = MessageLog.getMessage((String)"SRV0094W", (Object[])objectArray);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.RaceConditionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"check");
        }
    }
}

