/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class StatDeleter
extends RepositoryAccessor {
    public static final String DELETE_CLAUSE = "DELETE FROM ";
    public static final int N_PLACES = 10;

    public StatDeleter(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"StatDeleter", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"StatDeleter");
        }
    }

    public void deleteByStatID(String string, int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByStatID", (String)"pTableName, statisticID, statisticType");
        }
        this.deleteByStatID(string, n, s, false, -1, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByStatID");
        }
    }

    public void deleteByStatID(String string, int n, short s, boolean bl, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByStatID", (String)"pTableName, statisticID, statisticType, reportTypeCol, historyType");
        }
        this.deleteByStatID(string, n, s, bl, n2, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByStatID");
        }
    }

    public void deleteByStatID(String string, int n, short s, boolean bl, int n2, boolean bl2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByStatID", (String)"pTableName, statisticID, statisticType, reportTypeCol, historyType, deleteUnixOnly");
        }
        this.tableName = string;
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append(DELETE_CLAUSE);
        stringBuffer.append(this.tableName);
        stringBuffer.append(" WHERE statistic_id = ");
        stringBuffer.append(Integer.toString(n));
        if (s >= 0) {
            if (bl) {
                stringBuffer.append(" AND report_type = ");
            } else {
                stringBuffer.append(" AND statistic_type = ");
            }
            this.appendCharLiteral(stringBuffer, s);
        }
        if (n2 >= 0) {
            stringBuffer.append(" AND statistic_type in (");
            this.appendCharLiteral(stringBuffer, n2);
            if (n2 != 0) {
                stringBuffer.append(',');
                this.appendCharLiteral(stringBuffer, n2 + 2);
            }
            stringBuffer.append(')');
        }
        if (bl2) {
            stringBuffer.append(" AND filesystem_id in");
            stringBuffer.append(" (SELECT filesystem_id");
            stringBuffer.append(" FROM t_res_filesystem f, t_stat_computer c");
            stringBuffer.append(" WHERE f.scanning_comp_id = c.computer_id");
            stringBuffer.append(" AND c.os_type not in (");
            short s2 = 0;
            while (s2 < 28) {
                if (Constants.isWindows((short)s2)) {
                    stringBuffer.append(s2);
                    stringBuffer.append(',');
                }
                s2 = (short)(s2 + 1);
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("))");
        }
        this.deleteStmt = this.prepareStmt(stringBuffer.toString());
        try {
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByStatID", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByStatID");
        }
    }

    private void appendCharLiteral(StringBuffer stringBuffer, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendCharLiteral", (String)"buf, c");
        }
        stringBuffer.append('\'');
        stringBuffer.append(n);
        stringBuffer.append('\'');
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendCharLiteral");
        }
    }

    public void deleteStatByDirID(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteStatByDirID", (String)"pTableName, whereClause");
        }
        this.tableName = string;
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(DELETE_CLAUSE);
        stringBuffer.append(this.tableName);
        stringBuffer.append(" WHERE filesystem_id IN (SELECT directory_id");
        stringBuffer.append(" FROM t_stat_directory");
        stringBuffer.append(string2);
        stringBuffer.append(')');
        this.deleteStmt = this.prepareStmt(stringBuffer.toString());
        try {
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteStatByDirID", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteStatByDirID");
        }
    }

    public void prepDeleteByFSnStat(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByFSnStat", (String)"pTableName");
        }
        this.prepDeleteByIDnStat(string, "filesystem_id");
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByFSnStat");
        }
    }

    public void prepDeleteByIDnStat(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByIDnStat", (String)"pTableName, idColumnName");
        }
        this.tableName = string;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(DELETE_CLAUSE);
        stringBuffer.append(this.tableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string2);
        stringBuffer.append(" = ? AND statistic_id = ?");
        this.deleteStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByIDnStat");
        }
    }

    public void execDeleteByFSnStat(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"execDeleteByFSnStat", (String)"filesystemID, statisticID");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, n);
            this.setInt(this.deleteStmt, n2);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"execDeleteByFSnStat", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"execDeleteByFSnStat");
        }
    }

    private void prepDeleteBySomeKindOfID(String string, String string2, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteBySomeKindOfID", (String)"pTableName, what, byStatisticID");
        }
        this.tableName = string;
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append(DELETE_CLAUSE);
        stringBuffer.append(this.tableName);
        stringBuffer.append(" WHERE ");
        if (bl) {
            stringBuffer.append("statistic_id = ? AND ");
        }
        stringBuffer.append(string2);
        stringBuffer.append(" in (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.deleteStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteBySomeKindOfID");
        }
    }

    public void prepDeleteByText(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByText", (String)"text");
        }
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append(string);
        stringBuffer.append(" in (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.deleteStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByText");
        }
    }

    public void prepDeleteByID(String string, String string2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByID", (String)"pTableName, pColumnName");
        }
        this.prepDeleteBySomeKindOfID(string, string2, false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByID");
        }
    }

    public void prepDeleteByFilesystemID(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByFilesystemID", (String)"pTableName");
        }
        this.prepDeleteBySomeKindOfID(string, "filesystem_id", false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByFilesystemID");
        }
    }

    public void prepDeleteByDirectoryID(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByDirectoryID", (String)"pTableName");
        }
        this.prepDeleteBySomeKindOfID(string, "directory_id", false);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByDirectoryID");
        }
    }

    public LinkedInteger deleteByID(LinkedInteger linkedInteger) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"list");
        }
        int n = 0;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            while (n < 10 && linkedInteger != null) {
                this.setInt(this.deleteStmt, linkedInteger.value);
                linkedInteger = linkedInteger.next;
                ++n;
            }
            while (n < 10) {
                this.setInt(this.deleteStmt, -2147483647);
                ++n;
            }
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteByID", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        this.commit();
        if (linkedInteger == null) {
            this.closeDelete();
        }
        LinkedInteger linkedInteger2 = linkedInteger;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID", (Object)linkedInteger2);
        }
        return linkedInteger2;
    }

    public void prepDeleteByUserNStat(String string, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByUserNStat", (String)"pTableName, isUser");
        }
        this.prepDeleteBySomeKindOfID(string, bl ? "user_id" : "group_id", true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByUserNStat");
        }
    }

    public void deleteByIDnStat(int[] nArray, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByIDnStat", (String)"pIDArray, pStatisticID");
        }
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.deleteStmt, n);
                int n3 = 0;
                while (n3 < 10) {
                    if (n2 >= 0) {
                        this.setInt(this.deleteStmt, nArray[n2--]);
                    } else {
                        this.setInt(this.deleteStmt, -2147483647);
                    }
                    ++n3;
                }
                this.executeUpdate(this.deleteStmt);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"deleteByIDnStat", (Throwable)sQLException);
                }
                this.stmtType = 3;
                this.sqlError(sQLException);
            }
            this.commit();
        }
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.StatDeleter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByIDnStat");
        }
    }
}

