/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptLunWWN
extends RepositoryAccessor
implements GuiDataProvider {
    private static final String SELECT_ONE = "  (select distinct sv.svid as svid, sv.logical_disk_type as logical_disk_type, sv.capacity as capacity             , sv.use_count as use_count, sv.mirror_count as mirror_count, sv.is_swap as is_swap             , sv.snap_source_id as snap_source_id, sv.is_vcmdb as is_vcmdb, sv.replication_mode as replication_mode             , sv.not_exposed as not_exposed, sv.overhead as overhead, sv.lun_identity as lun_identity             , sv.format as format , ss.subsystem_id as subsystem_id, ss.last_probe_time as last_probe_time             , cimkey.device_id as device_id, sv.display_name as sv_display_name, vendor.vendor_name as vendor_name             , model.model_name as model_name             , case when ss.user_provided_name is not null                    and ss.user_provided_name not in ('')                    then ss.user_provided_name else ss.display_name end as                    ss_display_name             , ss.os_type as os_type, port.name as port_name , mask.host_element_name host_element_name             , sv.name as sv_name, sv.unique_id   from \tt_res_masking_info mask        \t, t_res_data_path dp        \t, t_res_port port        \t, t_res_storage_volume sv        \t, t_res_storage_subsystem ss        \t, t_res_cimkey_volume cimkey        \t, t_res_vendor vendor        \t, t_res_model model    where port.subsystem_id is null        \tand dp.initiator_port_id = port.port_id        \tand sv.svid = dp.volume_id        \tand sv.subsystem_id = ss.subsystem_id        \tand cimkey.volume_id = sv.svid         \tand mask.masking_info_id = dp.masking_info_id        \tand vendor.vendor_id = ss.vendor_id        \tand model.model_id = ss.model_id ";
    private static final String SELECT_TWO_FIRST_PART = " select lun2hba.svid, lun2hba.logical_disk_type, lun2hba.capacity       \t, lun2hba.use_count, lun2hba.mirror_count, lun2hba.is_swap       \t, lun2hba.snap_source_id, lun2hba.is_vcmdb, lun2hba.replication_mode       \t, lun2hba.not_exposed, lun2hba.overhead, lun2hba.lun_identity       \t, lun2hba.format , lun2hba.subsystem_id, lun2hba.last_probe_time       \t, lun2hba.device_id, lun2hba.sv_display_name, lun2hba.vendor_name       \t, lun2hba.model_name, lun2hba.ss_display_name       \t, lun2hba.os_type, lun2hba.port_name , lun2hba.host_element_name       \t, lun2hba.sv_name, sv2host.computer_id, sv2host.os_type         , sv2host.disk_id, sv2host.capacity disk_capacity  \t\t, sv2host.free_space, sv2host.path    from ";
    private static final String SELECT_TWO_SECOND_PART = "      \tas lun2hba left outer join \t\t(select distinct c.computer_id, c.os_type, ctl.wwn_str  \t\tfrom t_res_host c, t_res_controller ctl, t_res_port\t\twhere t_res_port.subsystem_id is null             and ctl.wwn_str = t_res_port.name  \t\t\tand ctl.computer_id = c.computer_id) as host \ton lun2hba.port_name = host.wwn_str left outer join         \t(select  distinct c.computer_id, c.os_type, sd_disk_id as disk_id         \t\t, sd_capacity as capacity, sdh_free_space as free_space, da_path as path, sv_unique_id         \tfrom \tt_res_comp2lun comp2lun        \t\t,  t_res_host c        \twhere \t         \t\tcomp2lun.computer_id = c.computer_id ";
    private static final String SELECT_TWO_THIRD_PART = "         ) as sv2host         \t\ton (sv2host.sv_unique_id = lun2hba.unique_id     \t    and host.computer_id = sv2host.computer_id) ";
    private static final String BY_SUBSYSTEM = " order by lun2hba.ss_display_name asc , lun2hba.device_id,  lun2hba.sv_display_name asc";
    private static final String BY_CAPACITY = " order by lun2hba.capacity desc";
    private static final String BY_PROBE_TIME = " order by s.scan_time ";
    private static final String GET_SRM_DISK = " select distinct c.computer_id, c.os_type,  sd.disk_id, sd.capacity, dh.free_space, da.path  from t_res_share sh, t_res_dev_access da,  t_stat_disk sd, t_stat_disk_hist dh, t_res_host c,  t_res_view_ssluncmp ssluncmp  where ssluncmp.svid = ?  and  ssluncmp.computer_id = c.computer_id  and  ssluncmp.physical_volume_id = sd.disk_id  and  sd.disk_id = da.device_id  and  sd.disk_id = dh.disk_id  and  dh.statistic_type = '3'";

    public RptLunWWN(Connection connection) {
        super(connection);
        this.tableName = "t_res_lun_wwn";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        Lun lun = null;
        Lun lun2 = new Lun();
        LogicalDisk logicalDisk = new LogicalDisk();
        boolean bl = true;
        ReportFilter reportFilter = null;
        if (guiReportReq.columnFilters != null) {
            reportFilter = new ReportFilter(guiReportReq, lun2);
        }
        int n = 0;
        try {
            try {
                this.selectStmt = this.prepareStmt(this.getSQLText(guiReportReq));
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                while (this.nextResult()) {
                    ++n;
                    bl = true;
                    this.getPhase();
                    this.colIndex = this.fetchLogicalDiskInfo(logicalDisk, this.resultSet);
                    lun2.lunLogicalDisk = logicalDisk;
                    lun2.lunID = logicalDisk.ldID;
                    lun2.lunDaID = this.getInt(this.resultSet);
                    lun2.lunProbeTime = this.getTimestamp(this.resultSet);
                    lun2.lunDeviceId = this.getString(this.resultSet);
                    lun2.lunName = this.getString(this.resultSet);
                    lun2.lunDaManufacturer = this.getString(this.resultSet);
                    lun2.lunDaModel = this.getString(this.resultSet);
                    lun2.lunDaAlias = this.getString(this.resultSet);
                    lun2.lunOSType = this.getShort(this.resultSet);
                    lun2.lunHBAWWN = this.getString(this.resultSet);
                    try {
                        lun2.lunWorkWWN = Long.parseLong(lun2.lunHBAWWN, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        lun2.lunWorkWWN = -2L;
                    }
                    lun2.lunSSHost = this.getString(this.resultSet);
                    lun2.lunWWN = this.getString(this.resultSet);
                    if (!Constants.hasLunWWN((short)lun2.lunOSType)) {
                        if (SQLUtil.isNullString(lun2.lunName)) {
                            lun2.lunName = lun2.lunWWN;
                        }
                        lun2.lunWWN = null;
                    } else if (lun2.lunOSType == 25 || lun2.lunOSType == 27) {
                        if (!SQLUtil.isNullString(lun2.lunName)) {
                            lun2.lunWWN = lun2.lunDeviceId;
                        } else {
                            lun2.lunName = lun2.lunDeviceId;
                            lun2.lunWWN = null;
                        }
                    }
                    int n2 = this.getInt(this.resultSet);
                    if (n2 > 0) {
                        lun2.lunLogicalDisk.ldIsSwap = true;
                        lun2.lunAgentID = n2;
                        lun2.lunAgentOSType = this.getShort(this.resultSet);
                        int n3 = this.getInt(this.resultSet);
                        if (n3 > 0) {
                            lun2.lunDiskID = n3;
                            lun2.lunDiskCapacity = this.getLong(this.resultSet);
                            lun2.lunDiskFreespace = this.getLong(this.resultSet);
                            lun2.lunDiskPath = this.getString(this.resultSet);
                        }
                    }
                    if (guiReportReq.reportSubtype == 89) {
                        if (lun2.lunAgentID > 0) {
                            bl = false;
                        }
                    } else if (guiReportReq.reportSubtype == 90) {
                        if (lun2.lunAgentID < 1) {
                            bl = false;
                        } else if (lun2.lunDiskID > 0) {
                            bl = false;
                        }
                    }
                    if (bl && reportFilter != null) {
                        bl = reportFilter.isSelected(lun2);
                    }
                    if (bl) {
                        lun2.lunNext = lun;
                        lun = lun2;
                    }
                    lun2 = new Lun();
                    logicalDisk = new LogicalDisk();
                }
            }
            catch (SQLException sQLException) {
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.close(this);
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.close(this);
            return (Serializable)Packer.pack(lun);
        }
    }

    private String getSQLText(GuiReportReq guiReportReq) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        StringBuffer stringBuffer3 = new StringBuffer(256);
        stringBuffer2.append(SELECT_ONE);
        stringBuffer3.append(SELECT_TWO_SECOND_PART);
        if (guiReportReq.selectedResources != null) {
            SQLUtil.appendInClause(stringBuffer2, "ss.subsystem_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
            SQLUtil.appendInClause(stringBuffer3, "comp2lun.subsystem_id", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        }
        stringBuffer2.append(") ");
        stringBuffer.append(SELECT_TWO_FIRST_PART + stringBuffer2 + stringBuffer3 + SELECT_TWO_THIRD_PART);
        switch (guiReportReq.reportSubtype) {
            case 77: 
            case 89: 
            case 90: {
                stringBuffer.append(BY_SUBSYSTEM);
                break;
            }
            case 78: {
                stringBuffer.append(BY_CAPACITY);
                break;
            }
            case 18: {
                stringBuffer.append(BY_PROBE_TIME);
                break;
            }
            default: {
                Object[] objectArray = new Object[]{new Integer(guiReportReq.reportType), new Integer(guiReportReq.reportSubtype)};
                String string = MessageLog.getMessage((String)"GEN0125E", (Object[])objectArray);
                throw new GeneralException(string);
            }
        }
        return stringBuffer.toString();
    }

    private void close(RepositoryAccessor repositoryAccessor) {
        try {
            repositoryAccessor.closeSelect();
        }
        catch (GeneralException generalException) {}
    }

    private int fetchLogicalDiskInfo(LogicalDisk logicalDisk, ResultSet resultSet) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchLogicalDiskInfo", (String)"ld, rs");
        }
        this.colIndex = 1;
        logicalDisk.ldID = this.getInt(resultSet);
        logicalDisk.ldType = this.getByte(resultSet);
        logicalDisk.ldCapacity = this.getLong(resultSet);
        logicalDisk.ldUseCount = this.getShort(resultSet);
        logicalDisk.ldMirrorCount = this.getByte(resultSet);
        logicalDisk.ldIsSwap = this.getBoolean(resultSet);
        logicalDisk.ldSnapSourceID = this.getInt(resultSet);
        boolean bl = this.getBoolean(resultSet);
        byte by = this.getByte(resultSet);
        boolean bl2 = this.getBoolean(resultSet);
        logicalDisk.setFlags((short)by, bl, bl2);
        logicalDisk.ldOverhead = this.getLong(resultSet);
        logicalDisk.lun_identity = this.getByte(resultSet);
        logicalDisk.ldStorageType = this.getShort(resultSet);
        int n = this.colIndex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchLogicalDiskInfo", (int)n);
        }
        return n;
    }
}

