/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.aperi.San.common.VDiskToVolume;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.report.filter.ReportFilter;

public class RptVolToBackendVol
extends RepositoryAccessor
implements GuiDataProvider {
    private static final String SELECT_VDISKS = "SELECT CASE WHEN SUBSYSTEMS.USER_PROVIDED_NAME IS NOT NULL AND  SUBSYSTEMS.USER_PROVIDED_NAME NOT IN ('') THEN SUBSYSTEMS.USER_PROVIDED_NAME ELSE SUBSYSTEMS.DISPLAY_NAME END   VDISK_SUBSYSTEMNAME, SUBSYSTEMS.TYPE as VDISK_SUBSYSTEMTYPE, VDISKS.NAME AS VDISK_LUNNAME, VDISKS.SVID AS VDISK_ID, VDISKS.DISPLAY_NAME as VDISK_NAME, VDISKS.CAPACITY as VDISK_CAPACITY FROM T_RES_STORAGE_SUBSYSTEM AS SUBSYSTEMS INNER JOIN T_RES_STORAGE_VOLUME AS VDISKS ON (VDISKS.SUBSYSTEM_ID=SUBSYSTEMS.SUBSYSTEM_ID) WHERE SUBSYSTEMS.TYPE='SVC'";
    private static String VIRTUAL_VOLUMES_SELECT_BOOKMARK = "INSERT_VDISKS_SELECT_HERE";
    private static String SELECT_REPORT2 = " SELECT VIRTUALVOLUME.VDISK_SUBSYSTEMNAME, VIRTUALVOLUME.VDISK_SUBSYSTEMTYPE,  VIRTUALVOLUME.VDISK_LUNNAME,  VIRTUALVOLUME.VDISK_NAME,  VIRTUALVOLUME.VDISK_ID,  (VIRTUALVOLUME.VDISK_CAPACITY*512)AS VDISK_CAPACITY, MDISKS.DISPLAY_NAME AS MDISK_DISPLAYNAME, (MDISKS.TOTAL_CAPACITY*512) AS MDISK_CAPACITY,  (MDISKS.FREE_SPACE*512) AS MDISK_FREESPACE, MDISKGRP.DISPLAY_NAME AS MDISKGROUP_NAME, VOLINFO.VOLUME_DISPLAYNAME AS VOLUME_DISPLAYNAME, CASE WHEN VOLINFO.VOLUME_CAPACITY IS NOT NULL THEN (VOLINFO.VOLUME_CAPACITY*512) ELSE -1 END  VOLUME_CAPACITY,  VOLINFO.VOLUME_SUBSYSTEMDISPLAYNAME AS VOLUME_SUBSYSTEMDISPLAYNAME, VOLINFO.VOLUME_SUBSYSTEMTYPE AS VOLUME_SUBSYSTEMTYPE  FROM  (" + VIRTUAL_VOLUMES_SELECT_BOOKMARK + " )" + " AS VIRTUALVOLUME" + " INNER JOIN " + " T_RES_VOLUME2EXTENT AS VDISK_MDISK" + " ON (VIRTUALVOLUME.VDISK_ID=VDISK_MDISK.VOLUME_ID)" + " INNER JOIN  " + " T_RES_STORAGE_EXTENT AS MDISKS" + " ON (VDISK_MDISK.STORAGE_EXTENT_ID=MDISKS.STORAGE_EXTENT_ID)" + " INNER JOIN  " + " T_RES_STORAGE_POOL AS MDISKGRP ON(MDISKS.POOL_ID=MDISKGRP.POOL_ID)" + " LEFT OUTER JOIN " + " (" + " SELECT" + " VOLUMES.MDISK_ID AS VOLMDISKID," + " VOLUMES.DISPLAY_NAME AS VOLUME_DISPLAYNAME, " + " VOLUMES.CAPACITY AS VOLUME_CAPACITY, " + " CASE WHEN VOLSUBSYSTEMS.USER_PROVIDED_NAME IS NOT NULL AND  VOLSUBSYSTEMS.USER_PROVIDED_NAME NOT IN ('') THEN VOLSUBSYSTEMS.USER_PROVIDED_NAME ELSE VOLSUBSYSTEMS.DISPLAY_NAME END VOLUME_SUBSYSTEMDISPLAYNAME, " + " VOLSUBSYSTEMS.TYPE AS VOLUME_SUBSYSTEMTYPE" + " FROM " + " T_RES_STORAGE_VOLUME AS VOLUMES " + " INNER JOIN " + " T_RES_STORAGE_SUBSYSTEM AS VOLSUBSYSTEMS " + " ON VOLUMES.SUBSYSTEM_ID=VOLSUBSYSTEMS.SUBSYSTEM_ID " + " )AS VOLINFO" + " ON VOLINFO.VOLMDISKID=MDISKS.STORAGE_EXTENT_ID";

    public RptVolToBackendVol(Connection connection) {
        super(connection);
        this.tableName = "t_res_storage_volume";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable getReportData(GuiReportReq guiReportReq) throws GeneralException {
        ReportFilter reportFilter = null;
        VDiskToVolume vDiskToVolume = new VDiskToVolume();
        if (guiReportReq.columnFilters != null) {
            reportFilter = new ReportFilter(guiReportReq, vDiskToVolume);
        }
        int n = 0;
        ArrayList<VDiskToVolume> arrayList = new ArrayList<VDiskToVolume>();
        VDiskToVolume[] vDiskToVolumeArray = null;
        try {
            try {
                this.selectStmt = this.prepareStmt(this.getSQLText(guiReportReq));
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                while (true) {
                    if (!this.nextResult()) {
                        vDiskToVolumeArray = new VDiskToVolume[arrayList.size()];
                        vDiskToVolumeArray = arrayList.toArray(vDiskToVolumeArray);
                    }
                    ++n;
                    this.getPhase();
                    VDiskToVolume vDiskToVolume2 = new VDiskToVolume();
                    this.fetchVDiskToVolumeInfo(vDiskToVolume2, this.resultSet);
                    if (reportFilter != null && !reportFilter.isSelected(vDiskToVolume2)) continue;
                    arrayList.add(vDiskToVolume2);
                }
            }
            catch (SQLException sQLException) {
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.close(this);
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.close(this);
            return (Serializable)vDiskToVolumeArray;
        }
    }

    private void fetchVDiskToVolumeInfo(VDiskToVolume vDiskToVolume, ResultSet resultSet) throws GeneralException {
        try {
            vDiskToVolume.vv_id = resultSet.getInt("VDISK_ID");
            vDiskToVolume.vv_capacity = resultSet.getLong("VDISK_CAPACITY");
            vDiskToVolume.vv_lunName = resultSet.getString("VDISK_LUNNAME");
            vDiskToVolume.vv_userDefinedName = resultSet.getString("VDISK_NAME");
            vDiskToVolume.vv_subsystemName = resultSet.getString("VDISK_SUBSYSTEMNAME");
            vDiskToVolume.vv_subsystemType = resultSet.getString("VDISK_SUBSYSTEMTYPE");
            vDiskToVolume.mg_name = resultSet.getString("MDISKGROUP_NAME");
            vDiskToVolume.md_capacity = resultSet.getLong("MDISK_CAPACITY");
            vDiskToVolume.md_freeSpace = resultSet.getLong("MDISK_FREESPACE");
            vDiskToVolume.md_name = resultSet.getString("MDISK_DISPLAYNAME");
            vDiskToVolume.bv_capacity = resultSet.getLong("VOLUME_CAPACITY");
            vDiskToVolume.bv_name = resultSet.getString("VOLUME_DISPLAYNAME");
            vDiskToVolume.bv_subsystemName = resultSet.getString("VOLUME_SUBSYSTEMDISPLAYNAME");
            vDiskToVolume.bv_subsystemType = resultSet.getString("VOLUME_SUBSYSTEMTYPE");
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
    }

    private void close(RepositoryAccessor repositoryAccessor) {
        try {
            repositoryAccessor.closeSelect();
        }
        catch (GeneralException generalException) {}
    }

    private String getSQLText(GuiReportReq guiReportReq) throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(SELECT_REPORT2);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        stringBuffer2.append(SELECT_VDISKS);
        if (guiReportReq.selectedResources != null) {
            SQLUtil.appendInClause(stringBuffer2, "VDISKS.SVID", guiReportReq.selectedResources, guiReportReq.isResourceInList, true);
        }
        int n = stringBuffer.indexOf(VIRTUAL_VOLUMES_SELECT_BOOKMARK);
        int n2 = VIRTUAL_VOLUMES_SELECT_BOOKMARK.length();
        stringBuffer.replace(n, n + n2, stringBuffer2.toString());
        return stringBuffer.toString();
    }
}

