/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResExport
extends StorageRepositoryAccessor {
    private long currentTime = 0L;
    private static final String SELECT = "select export_id, computer_id, protocol, path, export_name, discovered_time from t_res_export ";
    private static final String BY_COMPUTER = "where computer_id = ?";
    private static final String BY_PROTOCOL = " and protocol = ?";
    private static final String ORDER_BY_NAME = " order by export_name desc";
    private static final String ORDER_BY_COMPUTER = "order by computer_id desc, export_name desc";
    private static final String INSERT = "insert into t_res_export ( export_id, computer_id, protocol, export_name, path, discovered_time) values (?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_export set protocol = ?, export_name = ? where export_id = ?";
    private static final String DELETE = "delete from t_res_export where export_id = ?";

    public TResExport(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResExport", (String)"dbc");
        }
        try {
            this.currentTime = SQLUtil.getTimestamp(connection).getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"TResExport", (Throwable)exception);
            }
            return;
        }
        this.tableName = "t_res_export";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResExport");
        }
    }

    public Export selectByComputer(int n) throws GeneralException {
        return this.selectByComputer(n, (byte)-1);
    }

    public Export selectByComputer(int n, byte by) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectByComputer", (String)"computerID, protocol");
        }
        try {
            StringBuffer stringBuffer;
            if (n == -2) {
                this.selectStmt = this.prepareStmt("select export_id, computer_id, protocol, path, export_name, discovered_time from t_res_export order by computer_id desc, export_name desc");
            } else {
                stringBuffer = new StringBuffer(128);
                stringBuffer.append(SELECT);
                stringBuffer.append(BY_COMPUTER);
                if (by >= 0) {
                    stringBuffer.append(BY_PROTOCOL);
                }
                stringBuffer.append(ORDER_BY_NAME);
                this.selectStmt = this.prepareStmt(stringBuffer.toString());
                this.stmtPhase = 1;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                if (by >= 0) {
                    this.setByte(this.selectStmt, by);
                }
            }
            stringBuffer = this.getResultSet();
            this.closeSelect();
            StringBuffer stringBuffer2 = stringBuffer;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"selectByComputer", (Object)stringBuffer2);
            }
            return stringBuffer2;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectByComputer", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
            Export export = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"selectByComputer", export);
            }
            return export;
        }
    }

    private Export getResultSet() throws SQLException, GeneralException {
        Export export;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getResultSet", (String)"");
        }
        Export export2 = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        while (this.resultSet.next()) {
            export = new Export();
            this.stmtPhase = 1;
            this.colIndex = 1;
            export.xpExportID = this.getInt(this.resultSet);
            export.xpComputerID = this.getInt(this.resultSet);
            export.xpProtocol = this.getByte(this.resultSet);
            export.xpPath = this.getString(this.resultSet);
            export.xpExportName = this.getString(this.resultSet);
            export.xpDiscoveredTime = this.getTimestamp(this.resultSet);
            export.xpNext = export2;
            export2 = export;
        }
        this.closeResultSet();
        export = export2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getResultSet", (Object)export);
        }
        return export;
    }

    public void insert(Export export) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"exportList");
        }
        int n = 0;
        Export export2 = export;
        while (export2 != null) {
            ++n;
            export2 = export2.xpNext;
        }
        n = TResExport.getIdentifier(1, n, this.dbc);
        try {
            this.insertStmt = this.prepareStmt(INSERT);
            export2 = export;
            while (export2 != null) {
                this.stmtPhase = 0;
                export2.xpExportID = n++;
                this.colIndex = 1;
                this.setInt(this.insertStmt, export2.xpExportID);
                this.setInt(this.insertStmt, export2.xpComputerID);
                this.setByte(this.insertStmt, export2.xpProtocol);
                this.setString(this.insertStmt, export2.xpExportName);
                this.setString(this.insertStmt, export2.xpPath);
                this.setTimestamp(this.insertStmt, this.currentTime);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                export2 = export2.xpNext;
            }
            this.closeInsert();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void update(Export export) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"exportList");
        }
        try {
            this.updateStmt = this.prepareStmt(UPDATE);
            Export export2 = export;
            while (export2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setByte(this.updateStmt, export2.xpProtocol);
                this.setString(this.updateStmt, export2.xpExportName);
                this.setInt(this.updateStmt, export2.xpExportID);
                this.executeUpdate(this.updateStmt);
                this.dbc.commit();
                export2 = export2.xpNext;
            }
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update");
        }
    }

    public void delete(Export export) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"delete", (String)"exportList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE);
            Export export2 = export;
            while (export2 != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, export2.xpExportID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                export2 = export2.xpNext;
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"delete", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"delete");
        }
    }
}

