/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.LunWWN;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResLunWWN
extends StorageRepositoryAccessor {
    private static final String INSERT = "insert into t_res_lun_wwn (computer_id, lun_id, wwn, swwn, host) values (?,?,?,?,?)";
    private static final String DELETE_BY_COMPUTER = "delete from t_res_lun_wwn where computer_id = ";
    private static final String SELECT_BY_COMPUTER = "select lun_id, swwn from t_res_lun_wwn where computer_id = ?";

    public TResLunWWN(Connection connection) {
        super(connection);
        this.tableName = "t_res_lun_wwn";
    }

    public void deleteByComputer(int n) throws GeneralException {
        String string = DELETE_BY_COMPUTER + Integer.toString(n);
        this.deleteStmt = this.prepareStmt(string);
        try {
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        this.commit();
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
    }

    public void insert(int n, LogicalDisk logicalDisk) throws GeneralException {
        try {
            LunWWN lunWWN = logicalDisk.ldLunWWNs;
            while (lunWWN != null) {
                block5: {
                    long l;
                    try {
                        l = Long.parseLong(lunWWN.lwWWN, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageLog.logMessage((String)"BTM0573E", (Object)lunWWN.lwWWN, (Object)numberFormatException.toString());
                        break block5;
                    }
                    this.setPhase();
                    this.setInt(this.insertStmt, n);
                    this.setInt(this.insertStmt, logicalDisk.ldID);
                    this.setLong(this.insertStmt, l);
                    this.setString(this.insertStmt, lunWWN.lwWWN);
                    this.setString(this.insertStmt, lunWWN.lwHost);
                    this.executeUpdate(this.insertStmt);
                }
                lunWWN = lunWWN.lwNext;
            }
        }
        catch (SQLException sQLException) {
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
    }

    public LunWWN SelectByComputerId(int n) throws GeneralException {
        LunWWN lunWWN = null;
        this.selectStmt = this.prepareStmt(SELECT_BY_COMPUTER);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                LunWWN lunWWN2 = new LunWWN();
                lunWWN2.lwComputerID = n;
                this.fetchLunWWPN(lunWWN2, this.resultSet);
                lunWWN2.lwNext = lunWWN;
                lunWWN = lunWWN2;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectByComputerId", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        LunWWN lunWWN3 = lunWWN;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResEntityWWPN");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectByComputerId", lunWWN3);
        }
        return lunWWN3;
    }

    public int fetchLunWWPN(LunWWN lunWWN, ResultSet resultSet) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchLunWWPN", (String)"temp, resultSet");
        }
        this.colIndex = 1;
        lunWWN.lwLunID = this.getInt(resultSet);
        lunWWN.lwWWN = this.getString(resultSet);
        int n = this.colIndex;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchLunWWPN", (int)n);
        }
        return n;
    }
}

