/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.NasFilerAdmin;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.EnclosureAccessor;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.QueryBySchedule;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStatComputer
extends StorageRepositoryAccessor
implements NameListQueryable,
MissingAlertAccessible,
EnclosureAccessor {
    public static final String ID_COLUMN_NAME = "computer_id";
    public static final byte NETWARE = 1;
    public static final byte NO_NETWARE = 2;
    private QueryBySchedule queryBySchedule;
    private boolean diskArrayLicensed;
    private Timestamp tsProbe;
    private static final String SELECT = "select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id";
    private static final String UNIQUE = " from t_stat_computer s where s.computer_id = ?";
    private static final String GUI = " , r.discovered_time from t_stat_computer s, t_res_host r where s.computer_id = r.computer_id";
    public static String EXCLUDE_UNMANAGED_OSTYPES;
    private static final String GUI_UNIQUE = " and s.computer_id = ?";
    private static final String INSERT = "insert into t_stat_computer (computer_id, group_id, domain_id, manufacturer, model, serial_number, os_type, cpu_architecture, os_version, processor_type, processor_count, processor_speed, ram, swap_space, disk_capacity, disk_free_space, fs_free_space, last_boot_time, last_probe_time, probe_status, owned_disk_cap, owned_disk_free_sp, cluster_id, node_hosted_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_stat_computer set domain_id = ?, manufacturer = ?, model = ?, serial_number = ?, os_type = ?, cpu_architecture = ?, os_version = ?, processor_type = ?, processor_count = ?, processor_speed = ?, ram = ?, swap_space = ?, disk_capacity = ?, disk_free_space = ?, fs_free_space = ?, last_boot_time = ?, last_probe_time = ?, probe_status = ?, owned_disk_cap = ?, owned_disk_free_sp = ?, cluster_id = ?, node_hosted_id = ? where computer_id = ?";
    private static final String UPDATE_CLUSTER_MEMBERSHIP = "update t_stat_computer set cluster_id = ?, node_hosted_id = ? where computer_id = ?";
    private static final String UPDATE_DOMAIN = "update t_stat_computer set domain_id = ? where computer_id = ?";
    private static final String SELECT_NAMES = "select os_type, computer_id from t_stat_computer ";
    private static final String SELECT_VIRTUAL_SERVER = "select computer_id from t_stat_computer where computer_id = ? and os_type = ?";
    private static final String SELECT_CLUSTER_ID = "select cluster_id from t_stat_computer where computer_id = ?";
    private static final String SELECT_PING_CMP_GROUP = "select computer_id from t_stat_computer c where group_id = ? and not exists (select 1 from t_res_attribute where attribute_type = 17 and resource_type = 1 and resource_id = c.computer_id)";
    private static final String SELECT_BY_ATTR_TYPE_PT_I = "select distinct a.attribute_id, c.computer_id, a.exclude from t_stat_computer c, t_res_attribute a where a.attribute_type = ? and c.computer_id";
    private static final String SELECT_BY_ATTR_TYPE_PT_II;
    private static final String SELECT_DISCOVERY_COMPUTERS = "select distinct c.computer_id, c.domain_id, '1' from t_stat_computer c, t_res_ldap_tree t, t_res_pwd p where c.computer_id = t.computer_id and t.tree_id = p.resource_id and p.user_name <> ' ' union all select computer_id, domain_id, '2' from t_stat_computer c where c.os_type";
    private static final String SELECT_DOMAIN_DISCOVERY_COMPUTERS = "select distinct c.computer_id, c.domain_id, '2' from t_stat_computer c where c.os_type";
    private static final String SELECT_NETWARE_DISCOVERY_COMPUTERS = "select distinct c.computer_id, c.domain_id, '1' from t_stat_computer c, t_res_ldap_tree t, t_res_pwd p where c.computer_id = t.computer_id and t.tree_id = p.resource_id and p.user_name <> ' ' ";
    private static final String WHERE_WINDOWS = " in (4,5)";
    private static final String NETWARE_COUNT = "select count(*) from t_stat_computer c, t_res_ldap_tree t, t_res_pwd p where c.computer_id = t.computer_id and t.tree_id = p.resource_id and p.user_name <> ' ' ";
    public static String WHERE_DISCOVERY_OS_TYPE;
    public static String WHERE_NAS;
    private static final String ORDER_DISCOVERY_COMPUTERS = " order by 2, 1, 3";
    private static final String SELECT_GROUP_MEMBERS = "select computer_id from t_stat_computer where group_id = ?";
    private static final String SELECT_DOMAIN_SIZE = "select computer_id from t_stat_computer where domain_id = ? and computer_id <> ?";
    private static final String JOIN_1 = "select s.os_type, s.computer_id, r.host_name, s.cluster_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id";
    private static final String JOIN_2;
    private static final String JOIN_3 = "select s.computer_id, r.host_name, a.exclude, s.cluster_id from t_stat_computer s, t_res_host r, t_res_attribute a where a.attribute_id = ? and s.computer_id = a.resource_id and r.computer_id = s.computer_id and r.computer_id = a.resource_id order by 2, 3 desc";
    private static final String SELECT_WINDOWS_FILERS = "select distinct r.os_type, r.computer_id, d.domain_id, r.network_name, d.name from t_res_host r, t_res_domain d, t_res_share s where r.computer_id = s.resource_id and s.resource_type in (1,103) and s.computer_id = d.domain_id";
    private static final String SELECT_AGENTS = "select os_type, computer_id, domain_id from t_stat_computer where domain_id > 0";
    private static final String SELECT_AGENTS_IN_CLUSTER = "select r.host_name, s.computer_id, s.os_type, s.cluster_id, s.domain_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id and s.cluster_id = ? and s.os_type <> ? order by host_name desc";
    private static final String SELECT_VS_IN_CLUSTER = "select r.host_name, s.computer_id, s.os_type, s.cluster_id, s.domain_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id and s.cluster_id = ? and s.os_type = ? order by host_name desc";
    private static final String SELECT_CLUSTER_MEMBERS = "select r.host_name, s.computer_id, s.os_type, cluster_id from t_stat_computer s, t_res_host r where r.computer_id = s.computer_id and cluster_id = ? order by host_name desc";
    private static final String SELECT_FILERS_AND_DOMAINS = "select s.resource_id, d.domain_id, d.name from t_res_share s, t_res_domain d where s.computer_id = d.domain_id and s.resource_type in (1,103)";
    private static final String SELECT_DOMAIN_ID = "select domain_id from t_stat_computer where computer_id = ?";

    static {
        SELECT_BY_ATTR_TYPE_PT_II = " and (a.resource_id = c.computer_id or a.resource_id = c.group_id or a.resource_type = " + Short.toString((short)13) + " or a.resource_type = " + Short.toString((short)99) + ") order by 1, 2, 3 desc";
        JOIN_2 = "select distinct c.os_type, c.computer_id, a.exclude from t_stat_computer c, t_res_attribute a  where a.attribute_id = ? and (c.computer_id = a.resource_id or c.group_id = a.resource_id or   a.resource_id = c.cluster_id or a.resource_type = " + Short.toString((short)13) + ") order by 2, 3 desc";
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(" not in (");
        TStatComputer.appendNasAndVSOSTypes(stringBuffer, true, true, 29);
        stringBuffer.append(')');
        WHERE_DISCOVERY_OS_TYPE = stringBuffer.toString();
        stringBuffer = new StringBuffer(50);
        stringBuffer.append(" in (");
        TStatComputer.appendNasAndVSOSTypes(stringBuffer, true, false, 8);
        stringBuffer.append(')');
        WHERE_NAS = stringBuffer.toString();
    }

    public TStatComputer(Connection connection) {
        super(connection);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(" s.os_type not in (");
        short s = 0;
        while (s < 28) {
            if (Constants.isUnmanagedOS((short)s)) {
                stringBuffer.append(s);
                stringBuffer.append(',');
            }
            s = (short)(s + 1);
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        EXCLUDE_UNMANAGED_OSTYPES = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStatComputer", (String)"dbc");
        }
        this.tableName = "t_stat_computer";
        this.queryBySchedule = null;
        this.diskArrayLicensed = false;
        this.tsProbe = new Timestamp(0L);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStatComputer");
        }
    }

    public void setDiskArrayLicensed(boolean bl) {
        this.diskArrayLicensed = bl;
    }

    public static void appendNasAndVSOSTypes(StringBuffer stringBuffer, boolean bl, boolean bl2, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"appendNasAndVSOSTypes", (String)"buf, includeNas, includeVS, exclude");
        }
        boolean bl3 = true;
        short s = 0;
        while (s < 28) {
            if (s != n && (bl && Constants.isNasBox((short)s) || bl2 && Constants.isVirtualServer((int)s))) {
                if (!bl3) {
                    stringBuffer.append(',');
                }
                bl3 = false;
                stringBuffer.append(s);
            }
            s = (short)(s + 1);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"appendNasAndVSOSTypes");
        }
    }

    public boolean getComputerStats(Computer computer, MutableBoolean mutableBoolean) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerStats", (String)"c, beenProbed");
        }
        boolean bl = false;
        try {
            this.selectStmt = this.prepareStmt("select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id from t_stat_computer s where s.computer_id = ?");
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, computer.cmpID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            bl = this.fetchRow(computer);
            this.selectStmt.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getComputerStats", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        mutableBoolean.value = bl;
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerStats", (boolean)bl2);
        }
        return bl2;
    }

    public boolean getGuiComputerStats(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getGuiComputerStats", (String)"c");
        }
        boolean bl = false;
        boolean bl2 = computer.cmpID == -2;
        try {
            if (bl2) {
                this.selectStmt = this.prepareStmt("select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id , r.discovered_time from t_stat_computer s, t_res_host r where s.computer_id = r.computer_id and " + EXCLUDE_UNMANAGED_OSTYPES);
            } else {
                this.selectStmt = this.prepareStmt("select s.computer_id, s.group_id, s.domain_id, s.manufacturer, s.model, s.serial_number, s.os_type, s.cpu_architecture, s.os_version, s.processor_type, s.processor_speed, s.processor_count, s.ram, s.swap_space, s.disk_capacity, s.disk_free_space, s.fs_free_space, s.last_boot_time, s.last_probe_time, s.probe_status, s.owned_disk_cap, s.owned_disk_free_sp, s.cluster_id, s.node_hosted_id , r.discovered_time from t_stat_computer s, t_res_host r where s.computer_id = r.computer_id and s.computer_id = ?");
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, computer.cmpID);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            bl = this.fetchRow(computer);
            if (bl) {
                computer.cmpDiscoveredTime = this.getTimestamp(this.resultSet);
                if (bl2) {
                    computer.cmpNext = new Computer();
                    while (this.fetchRow(computer.cmpNext)) {
                        computer = computer.cmpNext;
                        computer.cmpDiscoveredTime = this.getTimestamp(this.resultSet);
                        computer.cmpNext = new Computer();
                    }
                    computer.cmpNext = null;
                }
            }
            this.selectStmt.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getGuiComputerStats", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        boolean bl3 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getGuiComputerStats", (boolean)bl3);
        }
        return bl3;
    }

    public void insert(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"c");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.executeInsert(computer);
        try {
            TGroup2Res tGroup2Res = new TGroup2Res(this.dbc);
            try {
                TComputer tComputer = TComputer.getComputer(null, null, computer.cmpID, null, this.dbc);
                TComputer.updateOSVersion(computer.cmpID, computer.cmpOSVersion, this.dbc);
                tGroup2Res.insertNewResources(computer.cmpID, computer.cmpGroupID, tComputer.tsName, false);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
                }
                tGroup2Res.insertNewResources(computer.cmpID, computer.cmpGroupID, null, false);
            }
            this.dbc.commit();
            this.insertStmt.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public boolean executeInsert(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"executeInsert", (String)"c");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.insertStmt, computer.cmpID);
            this.setInt(this.insertStmt, computer.cmpGroupID);
            this.setStatistics(this.insertStmt, computer);
            this.executeUpdate(this.insertStmt);
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"executeInsert", (boolean)bl);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"executeInsert", (Throwable)sQLException);
            }
            if (!SQLUtil.isDuplicateKeyViolation(sQLException)) {
                this.stmtType = 1;
                this.sqlError(sQLException);
            }
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"executeInsert", (boolean)bl);
            }
            return bl;
        }
    }

    public void prepSaveFiler() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSaveFiler", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.prepUpdateDomain();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSaveFiler");
        }
    }

    public boolean saveFiler(Computer computer) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveFiler", (String)"c");
        }
        if (!(bl = this.executeInsert(computer)) && computer.cmpDomainID > 0) {
            this.updateDomain(computer);
        }
        if (bl) {
            try {
                TGroup2Res tGroup2Res = new TGroup2Res(this.dbc);
                try {
                    TComputer tComputer = TComputer.getComputer(null, null, computer.cmpID, null, this.dbc);
                    tGroup2Res.insertNewResources(computer.cmpID, computer.cmpGroupID, tComputer.tsName, false);
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"saveFiler", (Throwable)sQLException);
                    }
                    tGroup2Res.insertNewResources(computer.cmpID, computer.cmpGroupID, null, false);
                }
                this.dbc.commit();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"saveFiler", (Throwable)sQLException);
                }
                this.stmtType = 1;
                this.sqlError(sQLException);
            }
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveFiler", (boolean)bl2);
        }
        return bl2;
    }

    public void prepUpdateDomain() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_DOMAIN);
    }

    public void updateDomain(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateDomain", (String)"c");
        }
        try {
            this.setPhase();
            this.setInt(this.updateStmt, computer.cmpDomainID);
            this.setInt(this.updateStmt, computer.cmpID);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateDomain", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDomain");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateClusterMembership(Computer computer) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateClusterMembership", (String)"c");
        }
        int n = 0;
        try {
            try {
                this.updateStmt = this.prepareStmt(UPDATE_CLUSTER_MEMBERSHIP);
                this.setPhase();
                this.setInt(this.updateStmt, computer.cmpClusterID);
                this.setInt(this.updateStmt, computer.cmpNodeHostedID);
                this.setInt(this.updateStmt, computer.cmpID);
                n = this.executeUpdate(this.updateStmt);
                this.dbc.commit();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"updateClusterMembership", (Throwable)sQLException);
                }
                this.stmtType = 2;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeUpdate();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeUpdate();
        boolean bl2 = bl = n > 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateClusterMembership", (boolean)bl);
        }
        return bl;
    }

    public boolean update(Computer computer) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"c");
        }
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setStatistics(this.updateStmt, computer);
            this.setInt(this.updateStmt, computer.cmpID);
            n = this.executeUpdate(this.updateStmt);
            this.dbc.commit();
            this.updateStmt.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        boolean bl2 = bl = n > 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update", (boolean)bl);
        }
        return bl;
    }

    private boolean fetchRow(Computer computer) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchRow", (String)"c");
        }
        if (!this.nextResult()) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchRow", (boolean)bl);
            }
            return bl;
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        computer.cmpID = this.getInt(this.resultSet);
        computer.cmpGroupID = this.getInt(this.resultSet);
        computer.cmpDomainID = this.getInt(this.resultSet);
        computer.cmpManufacturer = this.getString(this.resultSet);
        computer.cmpModel = this.getString(this.resultSet);
        computer.cmpSerialNumber = this.getString(this.resultSet);
        computer.cmpOSType = this.getShort(this.resultSet);
        computer.cmpCPUArchitecture = this.getShort(this.resultSet);
        computer.cmpOSVersion = this.getString(this.resultSet);
        computer.cmpProcessorType = this.getString(this.resultSet);
        computer.cmpProcessorSpeed = this.getShort(this.resultSet);
        computer.cmpProcessorCount = this.getShort(this.resultSet);
        computer.cmpRAM = this.getInt(this.resultSet);
        computer.cmpSwapSpace = this.getInt(this.resultSet);
        computer.cmpDiskCapacity = this.getLong(this.resultSet);
        computer.cmpDiskFreeSpace = this.getLong(this.resultSet);
        computer.cmpFilesystemFreeSpace = this.getLong(this.resultSet);
        computer.cmpLastBootTime = this.getTimestamp(this.resultSet);
        computer.cmpLastProbeTime = this.getTimestamp(this.resultSet);
        computer.cmpProbeStatus = this.getByte(this.resultSet);
        computer.cmpOwnedDiskCap = this.getLong(this.resultSet);
        computer.cmpOwnedDiskFreeSp = this.getLong(this.resultSet);
        computer.cmpClusterID = this.getInt(this.resultSet);
        computer.cmpNodeHostedID = this.getInt(this.resultSet);
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchRow", (boolean)bl);
        }
        return bl;
    }

    private void setStatistics(PreparedStatement preparedStatement, Computer computer) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setStatistics", (String)"stmt, c");
        }
        computer.cmpDomainID = computer.cmpDomain == null ? -1 : computer.cmpDomain.domID;
        this.setInt(preparedStatement, computer.cmpDomainID);
        this.setString(preparedStatement, computer.cmpManufacturer);
        this.setString(preparedStatement, computer.cmpModel);
        this.setString(preparedStatement, computer.cmpSerialNumber);
        this.setShort(preparedStatement, computer.cmpOSType);
        this.setShort(preparedStatement, computer.cmpCPUArchitecture);
        this.setString(preparedStatement, computer.cmpOSVersion);
        this.setString(preparedStatement, computer.cmpProcessorType);
        this.setShort(preparedStatement, computer.cmpProcessorCount);
        this.setShort(preparedStatement, computer.cmpProcessorSpeed);
        this.setInt(preparedStatement, computer.cmpRAM);
        this.setInt(preparedStatement, computer.cmpSwapSpace);
        this.setLong(preparedStatement, computer.cmpDiskCapacity);
        this.setLong(preparedStatement, computer.cmpDiskFreeSpace);
        this.setLong(preparedStatement, computer.cmpFilesystemFreeSpace);
        this.setTimestamp(preparedStatement, computer.cmpLastBootTime);
        this.setTimestamp(preparedStatement, computer.cmpLastProbeTime, this.tsProbe);
        this.setByte(preparedStatement, computer.cmpProbeStatus);
        this.setLong(preparedStatement, computer.cmpOwnedDiskCap);
        this.setLong(preparedStatement, computer.cmpOwnedDiskFreeSp);
        this.setInt(preparedStatement, computer.cmpClusterID);
        this.setInt(preparedStatement, computer.cmpNodeHostedID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setStatistics");
        }
    }

    public NameList getComputerNames(boolean bl) throws GeneralException {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerNames", (String)"excludeNAS");
        }
        NameList nameList2 = null;
        this.selectStmt = this.prepareStmt(SELECT_NAMES);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                short s = this.getShort(this.resultSet);
                if (Constants.isUnmanagedOS((short)s) || bl && Constants.isNasBox((short)s)) continue;
                int n = this.getInt(this.resultSet);
                nameList = new NameList();
                nameList.nlNext = nameList2;
                nameList2 = nameList;
                nameList.nlID = n;
            }
            this.selectStmt.close();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getComputerNames", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        nameList = nameList2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getComputerNames", nameList);
        }
        return nameList;
    }

    public NameList fetchNames() throws SQLException, GeneralException {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchNames", (String)"");
        }
        NameList nameList2 = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            nameList = new NameList();
            nameList.nlNext = nameList2;
            nameList2 = nameList;
            this.colIndex = 1;
            nameList.nlID = this.getInt(this.resultSet);
        }
        nameList = nameList2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchNames", (Object)nameList);
        }
        return nameList;
    }

    public void prepPingSelect() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_PING_CMP_GROUP);
    }

    public NameList getComputerGroup(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getComputerGroup", (String)"groupID");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            NameList nameList = this.fetchNames();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getComputerGroup", (Object)nameList);
            }
            return nameList;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getComputerGroup", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
            NameList nameList = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getComputerGroup", nameList);
            }
            return nameList;
        }
    }

    public void prepGroupSelect() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_GROUP_MEMBERS);
    }

    public NameList selectNames(GuiListReq guiListReq) throws GeneralException {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectNames", (String)"req");
        }
        NameList nameList = null;
        NameList nameList2 = null;
        boolean bl2 = guiListReq.excludeVS;
        boolean bl3 = bl = guiListReq.includeUnmanaged || guiListReq.listRequested == 1 && guiListReq.groupID > 0;
        short s = guiListReq.excludeNAS ? (short)-1 : (guiListReq.qualifierID == 0 && guiListReq.qualifier > 0 ? (short)guiListReq.qualifier : (short)0);
        StringBuffer stringBuffer = new StringBuffer();
        if (guiListReq.listRequested == 0) {
            stringBuffer.append("select s.os_type, s.computer_id, r.host_name, s.cluster_id from t_stat_computer s, t_res_host r, t_view_group2res gr ");
            int[] nArray = new int[]{guiListReq.groupID};
            stringBuffer.append(" where r.computer_id = s.computer_id ");
            Group2ResSqlUtil.appendG2RWhere(stringBuffer, nArray, true, true, 13, "gr");
            stringBuffer.append(" AND s.computer_id in (gr.resource_id)");
        } else {
            stringBuffer.append(JOIN_1);
        }
        if (guiListReq.groupID > 0) {
            if (guiListReq.listRequested != 0) {
                stringBuffer.append(" AND s.group_id = ");
                stringBuffer.append(Integer.toString(guiListReq.groupID));
            }
        } else if (guiListReq.qualifierID != 0) {
            stringBuffer.append(" AND s.domain_id = ");
            stringBuffer.append(Integer.toString(guiListReq.qualifierID));
        }
        stringBuffer.append(" ORDER BY 3");
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 0;
            while (this.nextResult()) {
                this.colIndex = 1;
                short s2 = this.getShort(this.resultSet);
                if (!bl && Constants.isUnmanagedOS((short)s2) || !this.isDesiredOSType(s2, s) || bl2 && Constants.isVirtualServer((int)s2)) continue;
                int n = this.getInt(this.resultSet);
                NameList nameList3 = new NameList();
                nameList3.nlInfo = 1;
                nameList3.nlID = n;
                nameList3.nlID2 = s2;
                nameList3.nlName = this.getString(this.resultSet);
                nameList3.nlClusterID = this.getInt(this.resultSet);
                if (nameList3.nlClusterID > 0) {
                    TResCluster tResCluster = new TResCluster(this.dbc);
                    tResCluster.fillInClusterDetails(nameList3);
                }
                if (nameList2 != null) {
                    nameList2.nlNext = nameList3;
                } else {
                    nameList = nameList3;
                }
                nameList2 = nameList3;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectNames", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        if (guiListReq.getVersions) {
            this.getVersions(nameList);
        }
        NameList nameList4 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectNames", nameList4);
        }
        return nameList4;
    }

    private boolean isDesiredOSType(short s, short s2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isDesiredOSType", (String)"osType, desiredOSType");
        }
        boolean bl = s2 == 0 ? true : (s2 < 0 ? !Constants.isNasBox((short)s) : s == s2);
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isDesiredOSType", (boolean)bl2);
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isVirtualServer(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isVirtualServer", (String)"computerID");
        }
        boolean bl = false;
        this.selectStmt = this.prepareStmt(SELECT_VIRTUAL_SERVER);
        try {
            block15: {
                try {
                    this.setPhase();
                    this.setInt(this.selectStmt, n);
                    this.setInt(this.selectStmt, 20);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    if (this.nextResult()) {
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"isVirtualServer", (Throwable)sQLException);
                    }
                    this.stmtType = 0;
                    this.sqlError(sQLException);
                }
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        this.closeResultSet();
        this.closeSelect();
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isVirtualServer", (boolean)bl2);
        }
        return bl2;
    }

    public void getVersions(NameList nameList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getVersions", (String)"list");
        }
        this.selectStmt = this.prepareStmt("select computer_id, product_versions from t_res_agent");
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                int n = this.getInt(this.resultSet);
                byte[] byArray = this.getBytes(this.resultSet);
                NameList nameList2 = nameList;
                while (nameList2 != null) {
                    if (nameList2.nlID == n) {
                        String string = " - (" + byArray[0] + "." + byArray[1] + "." + byArray[2] + ")";
                        nameList2.nlName = String.valueOf(nameList2.nlName) + string;
                    }
                    nameList2 = nameList2.nlNext;
                }
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getVersions", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getVersions");
        }
    }

    public void prepFetchByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepFetchByID", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(180);
        stringBuffer.append(JOIN_1);
        stringBuffer.append(GUI_UNIQUE);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepFetchByID");
        }
    }

    public boolean fetchByID(Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchByID", (String)"share");
        }
        boolean bl = false;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, share.shResourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                bl = true;
                this.getPhase();
                this.getShort(this.resultSet);
                share.shResourceID = this.getInt(this.resultSet);
                share.shPath = this.getString(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchByID", (boolean)bl2);
        }
        return bl2;
    }

    public void initQueryByAttrType(short s, HasID hasID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryByAttrType", (String)"attributeType, list");
        }
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(SELECT_BY_ATTR_TYPE_PT_I);
        SQLUtil.appendInClause(stringBuffer, hasID);
        stringBuffer.append(SELECT_BY_ATTR_TYPE_PT_II);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        this.setPhase();
        try {
            this.setShort(this.selectStmt, s);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initQueryByAttrType", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.queryBySchedule = new QueryBySchedule(this, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initQueryByAttrType");
        }
    }

    public NameList computersTiedTo(int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"computersTiedTo", (String)"objectID, excludeNonOS");
        }
        this.selectStmt = this.prepareStmt(JOIN_2);
        this.stmtType = 0;
        this.colIndex = 1;
        this.stmtPhase = 0;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"computersTiedTo", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        int n2 = -1;
        boolean bl2 = false;
        short s = 0;
        int n3 = -3;
        NameList nameList = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            this.colIndex = 1;
            try {
                s = this.getShort(this.resultSet);
                if (Constants.isUnmanagedOS((short)s) || bl && Constants.isNasBox((short)s)) continue;
                n2 = this.getInt(this.resultSet);
                bl2 = this.getBoolean(this.resultSet);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"computersTiedTo", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
            if (n2 == n3) continue;
            n3 = n2;
            if (bl2) continue;
            NameList nameList2 = new NameList();
            nameList2.nlID = n2;
            nameList2.nlInfo = s;
            nameList2.nlNext = nameList;
            nameList = nameList2;
        }
        this.closeSelect();
        NameList nameList3 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"computersTiedTo", nameList3);
        }
        return nameList3;
    }

    public NameList queryDependents(int n) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queryDependents", (String)"attributeID");
        }
        this.selectStmt = this.prepareStmt(JOIN_3);
        this.stmtType = 0;
        this.colIndex = 1;
        this.stmtPhase = 0;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"queryDependents", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        NameList nameList = null;
        NameList nameList2 = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            NameList nameList3 = new NameList();
            nameList3.nlInfo = 1;
            this.colIndex = 1;
            try {
                nameList3.nlID = this.getInt(this.resultSet);
                nameList3.nlName = this.getString(this.resultSet);
                if (this.getBoolean(this.resultSet)) {
                    nameList3.nlState = 1;
                }
                nameList3.nlClusterID = this.getInt(this.resultSet);
                if (nameList3.nlClusterID > 0) {
                    object = new TResCluster(this.dbc);
                    ((TResCluster)object).fillInClusterDetails(nameList3);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"queryDependents", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
            if (nameList2 == null) {
                nameList = nameList3;
            } else {
                nameList2.nlNext = nameList3;
            }
            nameList2 = nameList3;
        }
        this.closeSelect();
        object = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queryDependents", object);
        }
        return object;
    }

    public int getNetwareCount() throws GeneralException {
        int n = 0;
        this.selectStmt = this.prepareStmt(NETWARE_COUNT);
        try {
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                n = this.getInt(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            this.stmtType = 0;
            this.stmtPhase = 3;
            this.sqlError(sQLException);
        }
        return n;
    }

    public void initQueryBySchedule(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryBySchedule", (String)"scheduleID");
        }
        throw new GeneralException(MessageLog.getMessage((String)"STA0254I", null));
    }

    public void initQueryBySchedule(int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initQueryBySchedule", (String)"scheduleID, jobType");
        }
        this.prepareDiscovery(s);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initQueryBySchedule");
        }
    }

    private void prepareDiscovery(short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepareDiscoveryNoES", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(SELECT_DOMAIN_DISCOVERY_COMPUTERS);
        stringBuffer.append(WHERE_DISCOVERY_OS_TYPE);
        stringBuffer.append(ORDER_DISCOVERY_COMPUTERS);
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        try {
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"prepareDiscoveryNoES", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.stmtPhase = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepareDiscoveryNoES");
        }
    }

    public boolean fetchQueryBySchedule(NameList nameList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchQueryBySchedule", (String)"element");
        }
        if (this.queryBySchedule != null) {
            boolean bl = this.queryBySchedule.fetch(nameList);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchQueryBySchedule", (boolean)bl);
            }
            return bl;
        }
        boolean bl = false;
        try {
            bl = this.nextResult();
            if (!bl) {
                this.closeSelect();
            } else {
                this.getPhase();
                nameList.nlID2 = this.getInt(this.resultSet);
                nameList.nlID = this.getInt(this.resultSet);
                nameList.nlState = this.getByte(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchQueryBySchedule", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchQueryBySchedule", (boolean)bl2);
        }
        return bl2;
    }

    public NasFilerAdmin selectWindowsFilers() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectWindowsFilers", (String)"");
        }
        NasFilerAdmin nasFilerAdmin = null;
        NasFilerAdmin nasFilerAdmin2 = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_WINDOWS_FILERS);
            while (this.nextResult()) {
                boolean bl;
                this.getPhase();
                short s = this.getShort(this.resultSet);
                if (s == 8 || !(bl = Constants.isNasBox((short)s))) continue;
                NasFilerAdmin nasFilerAdmin3 = new NasFilerAdmin();
                nasFilerAdmin3.nfaFilerID = this.getInt(this.resultSet);
                nasFilerAdmin3.nfaDomainID = this.getInt(this.resultSet);
                nasFilerAdmin3.nfaNetworkName = this.getString(this.resultSet);
                nasFilerAdmin3.nfaDomainName = this.getString(this.resultSet);
                if (nasFilerAdmin2 != null) {
                    nasFilerAdmin2.nfaNext = nasFilerAdmin3;
                } else {
                    nasFilerAdmin = nasFilerAdmin3;
                }
                nasFilerAdmin2 = nasFilerAdmin3;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectWindowsFilers", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        NasFilerAdmin nasFilerAdmin4 = nasFilerAdmin;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectWindowsFilers", nasFilerAdmin4);
        }
        return nasFilerAdmin4;
    }

    public NameList selectAgents() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectAgents", (String)"");
        }
        NameList nameList = null;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_AGENTS);
            while (this.nextResult()) {
                this.getPhase();
                boolean bl = Constants.isWindows((short)this.getShort(this.resultSet));
                if (!bl) continue;
                int n = this.getInt(this.resultSet);
                NameList nameList2 = new NameList();
                nameList2.nlID2 = n;
                nameList2.nlID = this.getInt(this.resultSet);
                nameList2.nlNext = nameList;
                nameList = nameList2;
            }
            this.closeStaticStmt();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectAgents", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        NameList nameList3 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectAgents", nameList3);
        }
        return nameList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameList selectAgentsInCluster(int n) throws GeneralException {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectAgentsInCluster", (String)"cluster_id");
        }
        String string2 = null;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_AGENTS_IN_CLUSTER);
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.setInt(this.selectStmt, 20);
                this.resultSet = this.selectStmt.executeQuery();
                while (this.nextResult()) {
                    this.getPhase();
                    string = this.getString(this.resultSet);
                    int n2 = this.getInt(this.resultSet);
                    NameList nameList = new NameList();
                    nameList.nlName = string;
                    nameList.nlID = n2;
                    nameList.nlID2 = this.getShort(this.resultSet);
                    nameList.nlInfo = 1;
                    nameList.nlClusterID = this.getInt(this.resultSet);
                    nameList.nlID3 = this.getInt(this.resultSet);
                    if (nameList.nlClusterID > 0) {
                        TResCluster tResCluster = new TResCluster(this.dbc);
                        Cluster cluster = tResCluster.getClusterByID(nameList.nlClusterID);
                        nameList.nlClusterName = cluster.clusterName;
                        nameList.nlClusterDomain = cluster.domain_name;
                    }
                    nameList.nlNext = string2;
                    string2 = nameList;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectAgentsInCluster", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        string = string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectAgentsInCluster", string);
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameList selectVirtualServersInCluster(int n) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectVirtualServersInCluster", (String)"cluster_id");
        }
        NameList nameList = null;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_VS_IN_CLUSTER);
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.setInt(this.selectStmt, 20);
                this.resultSet = this.selectStmt.executeQuery();
                while (this.nextResult()) {
                    this.getPhase();
                    NameList nameList2 = new NameList();
                    nameList2.nlName = this.getString(this.resultSet);
                    nameList2.nlID = this.getInt(this.resultSet);
                    nameList2.nlID2 = this.getShort(this.resultSet);
                    nameList2.nlInfo = 1;
                    nameList2.nlClusterID = this.getInt(this.resultSet);
                    nameList2.nlID3 = this.getInt(this.resultSet);
                    if (nameList2.nlClusterID > 0) {
                        object = new TResCluster(this.dbc);
                        Cluster cluster = ((TResCluster)object).getClusterByID(nameList2.nlClusterID);
                        nameList2.nlClusterName = cluster.clusterName;
                        nameList2.nlClusterDomain = cluster.domain_name;
                    }
                    nameList2.nlNext = nameList;
                    nameList = nameList2;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectVirtualServersInCluster", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        object = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectVirtualServersInCluster", object);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameList selectComputersAndDomains() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectComputersAndDomains", (String)"");
        }
        NameList nameList = null;
        try {
            try {
                this.staticStmt = this.createStatement();
                this.resultSet = this.staticStmt.executeQuery(SELECT_FILERS_AND_DOMAINS);
                while (true) {
                    if (!this.nextResult()) {
                        this.closeStaticStmt();
                    }
                    this.getPhase();
                    NameList nameList2 = new NameList();
                    nameList2.nlID = this.getInt(this.resultSet);
                    nameList2.nlID2 = this.getInt(this.resultSet);
                    nameList2.nlName = this.getString(this.resultSet);
                    nameList2.nlNext = nameList;
                    nameList = nameList2;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"selectComputersAndDomains", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeResultSet();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeResultSet();
        NameList nameList3 = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectComputersAndDomains", nameList3);
        }
        return nameList3;
    }

    public boolean domainHasOtherOSAgents(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"domainHasOtherOSAgents", (String)"domainID, computerID");
        }
        boolean bl = false;
        this.selectStmt = this.prepareStmt(SELECT_DOMAIN_SIZE);
        try {
            this.setPhase();
            this.setInt(this.selectStmt, n);
            this.setInt(this.selectStmt, n2);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult(this.resultSet)) {
                this.getPhase();
                this.getInt(this.resultSet);
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"domainHasOtherOSAgents", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"domainHasOtherOSAgents", (boolean)bl2);
        }
        return bl2;
    }

    public void prepSelectDomainID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_DOMAIN_ID);
    }

    public int fetchDomainID(int n, MutableBoolean mutableBoolean) throws GeneralException {
        int n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchDomainID", (String)"computerID, pRowPresent");
        }
        int n3 = -1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            n2 = this.resultSet.next() ? 1 : 0;
            if (mutableBoolean != null) {
                mutableBoolean.value = n2;
            }
            if (n2 != 0) {
                this.getPhase();
                n3 = this.getInt(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchDomainID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        n2 = n3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchDomainID", (int)n2);
        }
        return n2;
    }

    public int fetchDomainID(int n) throws GeneralException {
        return this.fetchDomainID(n, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NameList getClusterMembers(int n) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getClusterMembers", (String)"clusterID");
        }
        NameList nameList = null;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_CLUSTER_MEMBERS);
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                while (this.nextResult()) {
                    this.getPhase();
                    NameList nameList2 = new NameList();
                    nameList2.nlName = this.getString(this.resultSet);
                    nameList2.nlID = this.getInt(this.resultSet);
                    nameList2.nlID2 = this.getInt(this.resultSet);
                    nameList2.nlClusterID = this.getInt(this.resultSet);
                    if (nameList2.nlClusterID > 0) {
                        object = new TResCluster(this.dbc);
                        ((TResCluster)object).fillInClusterDetails(nameList2);
                    }
                    nameList2.nlNext = nameList;
                    nameList = nameList2;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getClusterMembers", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        object = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getClusterMembers", object);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getClusterID(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getClusterID", (String)"c");
        }
        int n = -1;
        try {
            try {
                this.selectStmt = this.prepareStmt(SELECT_CLUSTER_ID);
                this.setPhase();
                this.setInt(this.selectStmt, computer.cmpID);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                if (this.nextResult()) {
                    n = this.getInt(this.resultSet);
                    if (this.resultSet.wasNull()) {
                        n = -1;
                    }
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getClusterID", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeResultSet();
            this.closeSelect();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.closeResultSet();
        this.closeSelect();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStatComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getClusterID", (int)n2);
        }
        return n2;
    }
}

