/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStormSettings
extends StorageRepositoryAccessor {
    private static final String UPDATE_REMOVED = "update t_storm_settings set keep_removed_comp = ?, keep_removed_fs = ?, keep_removed_dev = ?, keep_removed_filers = ?, keep_removed_subsystems = ?, keep_removed_fabric = ?, keep_removed_tape = ?";
    private static final String UPDATE_EMAIL_RULES = "update t_storm_settings set email_addr_rules = ?";
    private static final String UPDATE_DISCOVERY = "update t_storm_settings set no_wksta_discovery = ?";
    public static final int OS_HISTORY = 0;
    private static final String[] updateRemoved = new String[]{"update t_storm_settings set keep_removed_comp = ?, keep_removed_fs = ?, keep_removed_dev = ?, keep_removed_filers = ?, keep_removed_subsystems = ?, keep_removed_fabric = ?, keep_removed_tape = ?"};
    private static final String FETCH = "select keep_removed_comp, keep_removed_fs, keep_removed_dev, disk_daily_hist, disk_weekly_hist, disk_monthly_hist, ping_daily_hist, ping_weekly_hist, ping_monthly_hist, comp_daily_hist, comp_weekly_hist, comp_monthly_hist, fs_daily_hist, fs_weekly_hist, fs_monthly_hist, disk_awre, disk_arre, disk_noerrrcvry, email_addr_rules, no_wksta_discovery, keep_removed_filers, keep_removed_subsystems, keep_removed_fabric, keep_removed_tape from t_storm_settings";
    private static final String UPDATE_HIST = "update t_storm_settings set disk_daily_hist = ?, disk_weekly_hist = ?, disk_monthly_hist = ?, ping_daily_hist = ?, ping_weekly_hist = ?, ping_monthly_hist = ?, comp_daily_hist = ?, comp_weekly_hist = ?, comp_monthly_hist = ?, fs_daily_hist = ?, fs_weekly_hist = ?, fs_monthly_hist = ?";
    private static final String[] updateHist = new String[]{"update t_storm_settings set disk_daily_hist = ?, disk_weekly_hist = ?, disk_monthly_hist = ?, ping_daily_hist = ?, ping_weekly_hist = ?, ping_monthly_hist = ?, comp_daily_hist = ?, comp_weekly_hist = ?, comp_monthly_hist = ?, fs_daily_hist = ?, fs_weekly_hist = ?, fs_monthly_hist = ?"};
    private static final String INSERT = "insert into t_storm_settings ( keep_removed_comp, keep_removed_fs, keep_removed_filers,  keep_removed_subsystems, keep_removed_fabric, keep_removed_tape, disk_daily_hist, disk_weekly_hist, disk_monthly_hist, ping_daily_hist, ping_weekly_hist, ping_monthly_hist, comp_daily_hist, comp_weekly_hist, comp_monthly_hist, fs_daily_hist, fs_weekly_hist, fs_monthly_hist,  disk_awre, disk_arre, disk_noerrrcvry, email_addr_rules, no_wksta_discovery,  ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public TStormSettings(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TStormSettings", (String)"dbc");
        }
        this.tableName = "t_storm_settings";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TStormSettings");
        }
    }

    public Settings getSettings(boolean bl) throws GeneralException {
        Settings settings;
        block15: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getSettings", (String)"throwException");
            }
            settings = null;
            try {
                this.selectStmt = this.prepareStmt(FETCH);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                if (this.nextResult()) {
                    settings = new Settings();
                    this.colIndex = 1;
                    settings.seKeepRemovedComp = this.getShort(this.resultSet);
                    settings.seKeepRemovedFS = this.getShort(this.resultSet);
                    settings.seKeepRemovedDev = this.getShort(this.resultSet);
                    settings.seDiskDailyHist = this.getShort(this.resultSet);
                    settings.seDiskWeeklyHist = this.getShort(this.resultSet);
                    settings.seDiskMonthlyHist = this.getShort(this.resultSet);
                    settings.sePingDailyHist = this.getShort(this.resultSet);
                    settings.sePingWeeklyHist = this.getShort(this.resultSet);
                    settings.sePingMonthlyHist = this.getShort(this.resultSet);
                    settings.seCompDailyHist = this.getShort(this.resultSet);
                    settings.seCompWeeklyHist = this.getShort(this.resultSet);
                    settings.seCompMonthlyHist = this.getShort(this.resultSet);
                    settings.seFSDailyHist = this.getShort(this.resultSet);
                    settings.seFSWeeklyHist = this.getShort(this.resultSet);
                    settings.seFSMonthlyHist = this.getShort(this.resultSet);
                    settings.seDiskDesiredAWRE = this.getByte(this.resultSet);
                    settings.seDiskDesiredARRE = this.getByte(this.resultSet);
                    settings.seDiskDesiredNoErrRcvry = this.getByte(this.resultSet);
                    settings.seEmailAddrRules = this.getString(this.resultSet);
                    settings.seNoWkstaDiscovery = this.getBoolean(this.resultSet);
                    settings.seKeepRemovedFilers = this.getShort(this.resultSet);
                    settings.seKeepRemovedSubsystems = this.getShort(this.resultSet);
                    settings.seKeepRemovedFabric = this.getShort(this.resultSet);
                    settings.seKeepRemovedTape = this.getShort(this.resultSet);
                }
                this.closeSelect();
                if (settings != null || !bl) break block15;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getSettings");
                }
                throw new GeneralException(MessageLog.getMessage((String)"STS0029E", null));
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getSettings", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        Settings settings2 = settings;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSettings", settings2);
        }
        return settings2;
    }

    public Settings getSettings() throws GeneralException {
        return this.getSettings(true);
    }

    private void setHist(Settings settings, PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setHist", (String)"settings, stmt");
        }
        this.setShort(preparedStatement, settings.seDiskDailyHist);
        this.setShort(preparedStatement, settings.seDiskWeeklyHist);
        this.setShort(preparedStatement, settings.seDiskMonthlyHist);
        this.setShort(preparedStatement, settings.sePingDailyHist);
        this.setShort(preparedStatement, settings.sePingWeeklyHist);
        this.setShort(preparedStatement, settings.sePingMonthlyHist);
        this.setShort(preparedStatement, settings.seCompDailyHist);
        this.setShort(preparedStatement, settings.seCompWeeklyHist);
        this.setShort(preparedStatement, settings.seCompMonthlyHist);
        this.setShort(preparedStatement, settings.seFSDailyHist);
        this.setShort(preparedStatement, settings.seFSWeeklyHist);
        this.setShort(preparedStatement, settings.seFSMonthlyHist);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setHist");
        }
    }

    private void setRemoved(Settings settings, PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setRemoved", (String)"settings, stmt");
        }
        this.setShort(preparedStatement, settings.seKeepRemovedComp);
        this.setShort(preparedStatement, settings.seKeepRemovedFS);
        this.setShort(preparedStatement, settings.seKeepRemovedDev);
        this.setShort(preparedStatement, settings.seKeepRemovedFilers);
        this.setShort(preparedStatement, settings.seKeepRemovedSubsystems);
        this.setShort(preparedStatement, settings.seKeepRemovedFabric);
        this.setShort(preparedStatement, settings.seKeepRemovedTape);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setRemoved");
        }
    }

    private void setDiskBits(Settings settings, PreparedStatement preparedStatement) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setDiskBits", (String)"settings, stmt");
        }
        this.setByte(preparedStatement, settings.seDiskDesiredAWRE);
        this.setByte(preparedStatement, settings.seDiskDesiredARRE);
        this.setByte(preparedStatement, settings.seDiskDesiredNoErrRcvry);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setDiskBits");
        }
    }

    private void setEmailAddressRules(Settings settings, PreparedStatement preparedStatement) throws SQLException {
        this.setString(preparedStatement, settings.seEmailAddrRules);
    }

    private void setDiscovery(Settings settings, PreparedStatement preparedStatement) throws SQLException {
        this.setBoolean(preparedStatement, settings.seNoWkstaDiscovery);
    }

    public void insert(Settings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"settings");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setRemoved(settings, this.insertStmt);
            this.setHist(settings, this.insertStmt);
            this.setDiskBits(settings, this.insertStmt);
            this.setEmailAddressRules(settings, this.insertStmt);
            this.setDiscovery(settings, this.insertStmt);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public int updateHist(Settings settings, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateHist", (String)"settings, type");
        }
        int n2 = 0;
        this.updateStmt = this.prepareStmt(updateHist[n]);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setHist(settings, this.updateStmt);
            n2 = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateHist", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        int n3 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateHist", (int)n3);
        }
        return n3;
    }

    public int updateRemoved(Settings settings, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateRemoved", (String)"settings, type");
        }
        int n2 = 0;
        this.updateStmt = this.prepareStmt(updateRemoved[n]);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setRemoved(settings, this.updateStmt);
            n2 = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateRemoved", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        int n3 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateRemoved", (int)n3);
        }
        return n3;
    }

    public int updateEmailRules(Settings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateEmailRules", (String)"settings");
        }
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE_EMAIL_RULES);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setEmailAddressRules(settings, this.updateStmt);
            n = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateEmailRules", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateEmailRules", (int)n2);
        }
        return n2;
    }

    public int updateDiscovery(Settings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateDiscovery", (String)"settings");
        }
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE_DISCOVERY);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setDiscovery(settings, this.updateStmt);
            n = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateDiscovery", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        int n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TStormSettings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateDiscovery", (int)n2);
        }
        return n2;
    }
}

