/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAgent;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentLessManagedNode;
import org.eclipse.aperi.server.ComputerHashTable;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentManager {
    private static final int HASH_TABLE_SIZE = 53;
    private static final String UNKNOWN_COMPUTER = MessageLog.getMessageNoID((String)"SRV0121E");
    private ComputerHashTable agentTable;
    private Map<String, TimeZone> timezoneTable = new HashMap<String, TimeZone>();
    private Map<AgentLessManagedNode, AgentLessManagedNode> nasComputerMap = new HashMap<AgentLessManagedNode, AgentLessManagedNode>();
    private AgentLessManagedNode key = new AgentLessManagedNode();

    protected AgentManager() {
        this.agentTable = new ComputerHashTable(53);
    }

    protected boolean init() {
        Connection connection = Server.getConnection();
        if (connection == null) {
            return this.initError(connection);
        }
        TAgent tAgent = new TAgent();
        Iterator iterator = TAgent.getManagedAgents(tAgent, connection);
        if (iterator == null) {
            return this.initError(connection);
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        while (iterator.hasNext()) {
            try {
                iterator.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                return this.initError(connection);
            }
            stringBuffer.setLength(0);
            stringBuffer.append(tAgent.computer.networkName);
            if (!SQLUtil.isNullString(tAgent.computer.domainName)) {
                stringBuffer.append('.');
                stringBuffer.append(tAgent.computer.domainName);
            }
            short s = tAgent.computer.hwID.cpuArchitecture;
            AgentAddress agentAddress = new AgentAddress(tAgent.computer.computerID, stringBuffer.toString(), tAgent.port, tAgent.state, tAgent.timestamp, tAgent.computer.tsName, tAgent.computer.hwID.osType, s, tAgent.productVersions, tAgent.featureSet);
            agentAddress.timezone = this.getTimezone(tAgent.computer.timezoneID);
            this.agentTable.add(agentAddress);
        }
        Server.returnConnection(connection);
        return true;
    }

    private boolean initError(Connection connection) {
        MessageLog.logMessage((String)"SRV0037E");
        Server.returnConnection(connection);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(TAgent tAgent, Response response, SoftwareVersion[] softwareVersionArray, String string) {
        TAgent tAgent2;
        TComputer tComputer = tAgent.computer;
        String string2 = tComputer.networkName == null ? tComputer.ipAddress : (tComputer.domainName == null ? tComputer.networkName : String.valueOf(tComputer.networkName) + "." + tComputer.domainName);
        Connection connection = Server.getConnection();
        if (connection == null) {
            Server.setResponseError(response, "SRV0042E", tComputer.tsName, new Integer(tAgent.port));
            return false;
        }
        try {
            tAgent2 = TAgent.getAgent(Server.getServerID(), tComputer, connection);
        }
        catch (SQLException sQLException) {
            Server.returnConnection(connection);
            Server.setResponseError(response, "SRV0042E", tComputer.tsName, new Integer(tAgent.port));
            return false;
        }
        Server.returnConnection(connection);
        AgentAddress agentAddress = null;
        if (tAgent2 != null && (agentAddress = this.get(tAgent2.computer.computerID)) == null) {
            MessageLog.logMessage((String)"SRV0137W", (Object)tComputer.tsName, (Object)Integer.toString(tComputer.computerID));
        }
        if (agentAddress == null) {
            agentAddress = new AgentAddress(-1, string2, tAgent.port, 1, tAgent.timestamp, tComputer.tsName, tComputer.hwID.osType, tComputer.hwID.cpuArchitecture, tAgent.productVersions, tAgent.featureSet);
            agentAddress.timezone = this.getTimezoneSynchronized(tComputer.timezoneID);
        }
        AgentAddress agentAddress2 = agentAddress;
        synchronized (agentAddress2) {
            block12: {
                tAgent.state = 1;
                if (tAgent.registerAgent(tAgent2, string)) break block12;
                Server.setResponseError(response, "SRV0042E", tComputer.tsName, new Integer(tAgent.port));
                return false;
            }
            if (agentAddress.computerID == -1) {
                agentAddress.computerID = tComputer.computerID;
                agentAddress.state = tAgent.state;
                this.agentTable.add(agentAddress);
                if (tComputer.wasAgentLess) {
                    this.removeAgentLessManagedNode(tComputer.computerID);
                }
            } else {
                this.update(agentAddress, tAgent, string2, tAgent.state);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean update(AgentAddress agentAddress, TAgent tAgent, String string, byte by) {
        AgentAddress agentAddress2 = agentAddress;
        synchronized (agentAddress2) {
            TComputer tComputer = tAgent.computer;
            agentAddress.hostAddress = string;
            agentAddress.listenerPort = tAgent.port;
            agentAddress.state = by;
            if (by == 1) {
                agentAddress.consecutiveErrors = 0;
            }
            agentAddress.timestamp = tAgent.timestamp;
            agentAddress.tsName = tComputer.tsName;
            agentAddress.osType = tComputer.hwID.osType;
            agentAddress.softwareVersion = AgentManager.encodeSoftwareVersion(tAgent.productVersions);
            agentAddress.featureSet = tAgent.featureSet;
            if (!agentAddress.timezone.getID().equals(tComputer.timezoneID)) {
                agentAddress.timezone = this.getTimezoneSynchronized(tComputer.timezoneID);
            }
        }
        return true;
    }

    private static int encodeSoftwareVersion(byte[] byArray) {
        int n = 0;
        if (byArray != null && byArray.length >= 2) {
            n = SoftwareVersion.encode((int)byArray[0], (int)byArray[1], (int)byArray[2]);
        }
        return n;
    }

    private boolean updateRepository(AgentAddress agentAddress, boolean bl) {
        int n;
        Connection connection = Server.getConnection();
        if (connection == null) {
            n = 16;
        } else {
            try {
                agentAddress.timestamp = SQLUtil.getTimestamp(connection).getTime();
            }
            catch (Exception exception) {
                int n2;
                exception.printStackTrace();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.AgentManager$Iterate");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"updateRepository", (Throwable)exception);
                }
                return (n2 = 16) == 16;
            }
            n = TAgent.updateAgent(agentAddress.computerID, Server.getServerID(), agentAddress.listenerPort, agentAddress.state, agentAddress.timestamp, null, null, null, connection);
            Server.returnConnection(connection);
        }
        if (n == 16 && bl) {
            MessageLog.logMessage((String)"SRV0043E", (Object)agentAddress.hostAddress, (Object)new Integer(agentAddress.listenerPort));
        }
        return n != 16;
    }

    public boolean setState(int n, byte by) {
        Response response = Response.getResponse((short)0, null);
        boolean bl = this.setState(n, by, response);
        if (response.errorMessage != null) {
            Server.getLogWriter().println(response.errorMessage);
        }
        response.returnResponse();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setState(int n, byte by, Response response) {
        AgentAddress agentAddress = this.get(n);
        if (agentAddress == null) {
            Server.setResponseError(response, "SRV0040E", new Integer(n));
            return false;
        }
        boolean bl = true;
        AgentAddress agentAddress2 = agentAddress;
        synchronized (agentAddress2) {
            if (!(agentAddress.state == by || by == 0 && agentAddress.state == 3 || agentAddress.state == 2 && by != 1)) {
                agentAddress.state = by;
                if (by == 1) {
                    agentAddress.consecutiveErrors = 0;
                }
                if (!(bl = this.updateRepository(agentAddress, false))) {
                    Server.setResponseError(response, "SRV0043E", agentAddress.hostAddress, new Integer(agentAddress.listenerPort));
                }
            }
        }
        return bl;
    }

    public TimeZone getAgentTimezone(int n) {
        AgentAddress agentAddress = this.get(n);
        if (agentAddress == null) {
            MessageLog.logMessage((String)"SRV0040E", (Object)String.valueOf(n));
            return null;
        }
        return agentAddress.timezone;
    }

    public String getAgentHostAddress(int n) {
        AgentAddress agentAddress = this.get(n);
        if (agentAddress == null) {
            MessageLog.logMessage((String)"SRV0040E", (Object)String.valueOf(n));
            return null;
        }
        return agentAddress.hostAddress;
    }

    public String getAgentName(int n) {
        String string = null;
        AgentAddress agentAddress = this.get(n);
        if (agentAddress != null) {
            string = agentAddress.tsName;
        } else {
            string = this.getNasComputerName(n);
            if (string == null || string.equalsIgnoreCase(UNKNOWN_COMPUTER)) {
                string = this.getStorageSystemName(n);
            }
        }
        if (string == null) {
            string = UNKNOWN_COMPUTER;
        }
        return string;
    }

    public short getAgentOsType(int n) {
        AgentAddress agentAddress = this.get(n);
        if (agentAddress == null) {
            MessageLog.logMessage((String)"SRV0040E", (Object)String.valueOf(n));
            return 0;
        }
        return agentAddress.osType;
    }

    private String getNasComputerName(int n) {
        return this.getNasComputer((int)n).name;
    }

    private String getStorageSystemName(int n) {
        return this.getStorageSystem((int)n).name;
    }

    public boolean isNasComputerExpired(int n) {
        boolean bl = false;
        AgentAddress agentAddress = this.get(n);
        if (agentAddress != null) {
            return bl;
        }
        AgentLessManagedNode agentLessManagedNode = this.getNasComputer(n);
        if (agentLessManagedNode != null) {
            bl = agentLessManagedNode.expired;
        }
        return bl;
    }

    public String getHostAddress(int n) {
        String string = null;
        AgentAddress agentAddress = this.get(n);
        if (agentAddress != null) {
            string = agentAddress.hostAddress;
        }
        return string;
    }

    public short getOsType(int n) {
        AgentAddress agentAddress = this.get(n);
        if (agentAddress != null) {
            return agentAddress.osType;
        }
        return this.getNasComputer((int)n).osType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAgentLessManagedNode(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.AgentManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeAgentLessManagedNode", (String)"computerID");
        }
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            AgentLessManagedNode agentLessManagedNode = new AgentLessManagedNode(n, UNKNOWN_COMPUTER);
            this.nasComputerMap.remove(agentLessManagedNode);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.AgentManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeAgentLessManagedNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentLessManagedNode(TComputer tComputer) {
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            AgentLessManagedNode agentLessManagedNode = this.getNasComputer(tComputer.computerID);
            agentLessManagedNode.setAttributes(tComputer.hwID.osType, tComputer.tsName, tComputer.hwID.hostName, tComputer.networkName, tComputer.domainName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AgentLessManagedNode getNasComputer(int n) {
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            this.key.computerID = n;
            AgentLessManagedNode agentLessManagedNode = this.nasComputerMap.get(this.key);
            if (agentLessManagedNode != null) return agentLessManagedNode;
            Connection connection = Server.getConnection();
            if (connection == null) {
                MessageLog.logMessage((String)"SRV0102E", (Object)"AgentManager.getNasComputerName()");
                return null;
            }
            try {
                try {
                    LinkedInteger linkedInteger;
                    TResComputer tResComputer = new TResComputer(connection);
                    tResComputer.fillNodeMap(this.nasComputerMap);
                    TResShare tResShare = new TResShare(connection);
                    LinkedInteger linkedInteger2 = linkedInteger = tResShare.getExpiredVSs();
                    while (true) {
                        if (linkedInteger2 == null) {
                            agentLessManagedNode = this.nasComputerMap.get(this.key);
                            if (agentLessManagedNode == null) {
                                agentLessManagedNode = new AgentLessManagedNode(n, UNKNOWN_COMPUTER);
                                this.nasComputerMap.put(agentLessManagedNode, agentLessManagedNode);
                            }
                            break;
                        }
                        this.updateExpiration(linkedInteger2.value, true);
                        linkedInteger2 = linkedInteger2.next;
                    }
                }
                catch (GeneralException generalException) {
                    MessageLog.logException((String)"SRV0156E", (Exception)((Object)generalException), (Object)Integer.toString(n));
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                Server.returnConnection(connection);
                throw throwable;
            }
            Server.returnConnection(connection);
            return agentLessManagedNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AgentLessManagedNode getStorageSystem(int n) {
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            Connection connection;
            this.key.computerID = n;
            AgentLessManagedNode agentLessManagedNode = this.nasComputerMap.get(this.key);
            if (agentLessManagedNode != null) {
                if (!agentLessManagedNode.name.equalsIgnoreCase(UNKNOWN_COMPUTER)) return agentLessManagedNode;
            }
            if ((connection = Server.getConnection()) == null) {
                MessageLog.logMessage((String)"SRV0102E", (Object)"AgentManager.getNasComputerName()");
                return null;
            }
            try {
                try {
                    TComputer tComputer = new TComputer();
                    tComputer = TComputer.getSS(n, connection);
                    if (tComputer != null && agentLessManagedNode != null) {
                        this.updateStorageSystem(n, tComputer);
                    }
                }
                catch (SQLException sQLException) {
                    MessageLog.logException((String)"SRV0156E", (Exception)sQLException, (Object)Integer.toString(n));
                }
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Server.returnConnection(connection);
                throw throwable;
            }
            Server.returnConnection(connection);
            return agentLessManagedNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTransceiver(int n, boolean bl, RunReq runReq, int n2) {
        if (runReq instanceof JobRun) {
            JobRun cfr_ignored_0 = (JobRun)runReq;
        } else if (runReq instanceof RunScriptReq) {
            RunScriptReq cfr_ignored_1 = (RunScriptReq)runReq;
        }
        AgentAddress agentAddress = this.get(n);
        if (agentAddress == null) {
            Response response = Response.getResponse((short)34, null);
            response.errorMessage = MessageLog.getMessage((String)"SRV0040E", (Object)String.valueOf(n));
            MessageLog.getThreadLog().println(response.errorMessage);
            return response;
        }
        Socket socket = null;
        Exception exception = null;
        String string = null;
        int n3 = 0;
        short s = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        AgentAddress agentAddress2 = agentAddress;
        synchronized (agentAddress2) {
            string = agentAddress.hostAddress;
            n3 = agentAddress.listenerPort;
            if (agentAddress.state == 1 || bl) {
                bl5 = true;
                s = agentAddress.consecutiveErrors;
            }
        }
        if (bl5) {
            try {
                socket = AgentManager.connectToAgent(string, n3);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (exception != null || s != 0) {
                agentAddress2 = agentAddress;
                synchronized (agentAddress2) {
                    if (exception == null) {
                        agentAddress.consecutiveErrors = 0;
                    } else {
                        agentAddress.bumpConnectionError();
                        if (Server.agentErrorLimit > 0 && agentAddress.consecutiveErrors >= Server.agentErrorLimit && agentAddress.state == 1) {
                            this.setState(n, (byte)0);
                            bl2 = true;
                        }
                    }
                }
            }
        }
        if (socket == null) {
            agentAddress2 = Response.getResponse((short)12, null);
            if (bl3) {
                if (bl4) {
                    ((Response)agentAddress2).status = (short)28;
                    ((Response)agentAddress2).errorMessage = MessageLog.getMessage((String)"SRV0123E", (Object)string, (Object)String.valueOf(n3));
                } else {
                    ((Response)agentAddress2).status = (short)36;
                    ((Response)agentAddress2).errorMessage = MessageLog.getMessage((String)"SRV0158E", (Object)string);
                }
            } else if (exception == null) {
                ((Response)agentAddress2).status = (short)36;
                ((Response)agentAddress2).errorMessage = MessageLog.getMessage((String)"SRV0039E", (Object)string, (Object)String.valueOf(n3));
            } else {
                ((Response)agentAddress2).status = (short)36;
                ((Response)agentAddress2).errorMessage = MessageLog.getMessageWithException((String)"SRV0038E", (Exception)exception, (Object)string, (Object)String.valueOf(n3));
                if (bl2) {
                    MessageLog.logMessage((String)"SRV0041E", (Object)string, (Object)String.valueOf(n3));
                }
            }
            MessageLog.getThreadLog().println(((Response)agentAddress2).errorMessage);
            return agentAddress2;
        }
        agentAddress2 = n2 > 0 ? SocketTransceiver.getSocketTransceiver((Socket)socket, null, (int)n2) : SocketTransceiver.getSocketTransceiver((Socket)socket, null);
        return agentAddress2;
    }

    public Response transmitToAgent(Request request, Object object, int n, boolean bl) {
        return this.transmitToAgent(request, object, n, bl, 0);
    }

    public Response transmitToAgent(Request request, Object object, int n, boolean bl, int n2) {
        AgentRequestData agentRequestData;
        RunReq runReq = null;
        if (request.requestData instanceof JobRun) {
            runReq = (RunReq)request.requestData;
        } else if (request.requestData instanceof RunScriptReq) {
            runReq = (RunReq)request.requestData;
        }
        Object object2 = this.getTransceiver(n, bl, runReq, n2);
        if (object2 instanceof Response) {
            return (Response)object2;
        }
        Transceiver transceiver = (Transceiver)object2;
        if (request.requestData instanceof AgentRequestData) {
            agentRequestData = (AgentRequestData)request.requestData;
            agentRequestData.setServerToken(Server.getServerToken());
            agentRequestData.setServerPort(Server.getListenerPort());
            agentRequestData.setComputerID(n);
        }
        agentRequestData = transceiver.transmitRequest(request, object);
        transceiver.close();
        transceiver.returnTransceiver();
        if (agentRequestData != null && agentRequestData.status == 16) {
            this.setState(n, (byte)2);
        }
        return agentRequestData;
    }

    public Iterator listAgents(AgentAddress agentAddress) {
        return new Iterate(agentAddress);
    }

    public Iterator listAgents() {
        return new Iterate(null);
    }

    public void delete(int n) {
        this.agentTable.delete(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentAddress getAgent(int n) {
        AgentAddress agentAddress = null;
        AgentAddress agentAddress2 = (AgentAddress)this.agentTable.get(n);
        if (agentAddress2 != null) {
            agentAddress = new AgentAddress();
            AgentAddress agentAddress3 = agentAddress2;
            synchronized (agentAddress3) {
                agentAddress2.copyInto(agentAddress);
            }
        }
        return agentAddress;
    }

    public AgentAddress get(int n) {
        return (AgentAddress)this.agentTable.get(n);
    }

    private TimeZone getTimezone(String string) {
        TimeZone timeZone = this.timezoneTable.get(string);
        if (timeZone != null) {
            return timeZone;
        }
        timeZone = TimeZone.getTimeZone(string);
        if (timeZone.getID().indexOf("Custom") != -1) {
            timeZone.setID(timeZone.getDisplayName(timeZone.useDaylightTime(), 0));
        }
        this.timezoneTable.put(string, timeZone);
        return timeZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeZone getTimezoneSynchronized(String string) {
        Map<String, TimeZone> map = this.timezoneTable;
        synchronized (map) {
            return this.getTimezone(string);
        }
    }

    private void updateExpiration(int n, boolean bl) {
        AgentLessManagedNode agentLessManagedNode = this.getNasComputer(n);
        agentLessManagedNode.updateExpiredFlag(bl);
    }

    private void updateStorageSystem(int n, TComputer tComputer) {
        AgentLessManagedNode agentLessManagedNode = this.getNasComputer(n);
        agentLessManagedNode.name = tComputer.hwID.hostName;
        agentLessManagedNode.osType = tComputer.hwID.osType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExpirationOfAgentLessManagedNode(int n, boolean bl) {
        Map<AgentLessManagedNode, AgentLessManagedNode> map = this.nasComputerMap;
        synchronized (map) {
            this.updateExpiration(n, bl);
        }
    }

    public static Socket connectToAgent(String string, int n) throws Exception {
        return ConnectorClient.getSocket((String)string, (int)n, (String)"org.eclipse.aperi.agent.svp.SocketHandler");
    }

    public static class AgentAddress
    extends ComputerHashTable.HashedComputer {
        public int listenerPort;
        public short connectionErrors;
        public short consecutiveErrors;
        public byte state;
        public String hostAddress;
        public long timestamp;
        public TimeZone timezone;
        public short osType;
        public short cpuArchitecture;
        public String tsName;
        public byte upgradeRequired;
        public byte mustBeUpgraded;
        public int softwareVersion;
        public int featureSet;

        public AgentAddress(int n, String string, int n2, byte by, long l, String string2, short s, short s2, byte[] byArray, int n3) {
            this.computerID = n;
            this.listenerPort = n2;
            this.hostAddress = string;
            this.state = by;
            this.timestamp = l;
            this.tsName = string2;
            this.osType = s;
            this.cpuArchitecture = s2;
            this.softwareVersion = AgentManager.encodeSoftwareVersion(byArray);
            this.featureSet = n3;
        }

        public AgentAddress() {
            this(-1, null, -1, 0, 0L, null, -1, -1, null, 0);
        }

        public synchronized void copyInto(AgentAddress agentAddress) {
            agentAddress.computerID = this.computerID;
            agentAddress.listenerPort = this.listenerPort;
            agentAddress.connectionErrors = this.connectionErrors;
            agentAddress.consecutiveErrors = this.consecutiveErrors;
            agentAddress.state = this.state;
            agentAddress.hostAddress = this.hostAddress;
            agentAddress.timestamp = this.timestamp;
            agentAddress.timezone = this.timezone;
            agentAddress.tsName = this.tsName;
            agentAddress.osType = this.osType;
            agentAddress.cpuArchitecture = this.cpuArchitecture;
            agentAddress.upgradeRequired = this.upgradeRequired;
            agentAddress.mustBeUpgraded = this.mustBeUpgraded;
            agentAddress.softwareVersion = this.softwareVersion;
            agentAddress.featureSet = this.featureSet;
        }

        public void bumpConnectionError() {
            this.connectionErrors = (short)(this.connectionErrors + 1);
            this.consecutiveErrors = (short)(this.consecutiveErrors + 1);
        }
    }

    private class Iterate
    implements Iterator {
        AgentAddress returnArea;
        Iterator iterator;

        Iterate(AgentAddress agentAddress) {
            this.iterator = AgentManager.this.agentTable.getIterator();
            this.returnArea = agentAddress;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() throws NoSuchElementException {
            AgentAddress agentAddress = (AgentAddress)this.iterator.next();
            if (this.returnArea == null) {
                return agentAddress;
            }
            agentAddress.copyInto(this.returnArea);
            return this.returnArea;
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }
}

